/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ImportInfo {
    static final String defaultFile = "META-INF/imports/script.txt";
    static String importFile = "META-INF/imports/script.txt";
    static ImportInfo defaultImports;
    protected Set classes = new HashSet();
    protected Set packages = new HashSet();
    static final String classStr = "class";
    static final String packageStr = "package";

    public static ImportInfo getImports() {
        if (defaultImports == null) {
            defaultImports = ImportInfo.readImports();
        }
        return defaultImports;
    }

    static ImportInfo readImports() {
        Enumeration<URL> enumeration;
        ImportInfo importInfo = new ImportInfo();
        ClassLoader classLoader = ImportInfo.class.getClassLoader();
        if (classLoader == null) {
            return importInfo;
        }
        try {
            enumeration = classLoader.getResources(importFile);
        }
        catch (IOException iOException) {
            return importInfo;
        }
        while (enumeration.hasMoreElements()) {
            try {
                URL uRL = enumeration.nextElement();
                importInfo.addImports(uRL);
            }
            catch (Exception exception) {}
        }
        return importInfo;
    }

    public Iterator getClasses() {
        return Collections.unmodifiableSet(this.classes).iterator();
    }

    public Iterator getPackages() {
        return Collections.unmodifiableSet(this.packages).iterator();
    }

    public void addClass(String string) {
        this.classes.add(string);
    }

    public void addPackage(String string) {
        this.packages.add(string);
    }

    public boolean removeClass(String string) {
        return this.classes.remove(string);
    }

    public boolean removePackage(String string) {
        return this.packages.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImports(URL uRL) throws IOException {
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            inputStream = uRL.openStream();
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf(35);
                if (n != -1) {
                    string = string.substring(0, n);
                }
                if ((string = string.trim()).length() == 0 || (n = string.indexOf(32)) == -1) continue;
                String string2 = string.substring(0, n);
                string = string.substring(n + 1);
                boolean bl = packageStr.equals(string2);
                boolean bl2 = classStr.equals(string2);
                if (!bl && !bl2) continue;
                while (string.length() != 0) {
                    String string3;
                    n = string.indexOf(32);
                    if (n == -1) {
                        string3 = string;
                        string = "";
                    } else {
                        string3 = string.substring(0, n);
                        string = string.substring(n + 1);
                    }
                    if (string3.length() == 0) continue;
                    if (bl2) {
                        this.addClass(string3);
                        continue;
                    }
                    this.addPackage(string3);
                }
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                inputStream = null;
            }
            if (inputStreamReader != null) {
                try {
                    ((Reader)inputStreamReader).close();
                }
                catch (IOException iOException) {}
                inputStreamReader = null;
            }
            if (bufferedReader == null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
                bufferedReader = null;
            }
        }
    }

    static {
        try {
            importFile = System.getProperty("org.apache.batik.script.imports", defaultFile);
        }
        catch (SecurityException securityException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        defaultImports = null;
    }
}

