/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeInputStream
extends InputStream {
    protected final LinkedList<InputStream> queue;
    protected InputStream in;

    public CompositeInputStream(List<InputStream> list) {
        this.queue = new LinkedList<InputStream>(list);
        this.in = this.queue.poll();
    }

    public CompositeInputStream(InputStream ... inputStreamArray) {
        this(Arrays.asList(inputStreamArray));
    }

    protected void nextStream() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = this.queue.poll();
        }
    }

    @Override
    public int available() throws IOException {
        int n = this.in != null ? this.in.available() : 0;
        for (InputStream inputStream : this.queue) {
            n += Math.max(inputStream.available(), 0);
        }
        return n;
    }

    @Override
    public int read() throws IOException {
        if (this.in == null) {
            return -1;
        }
        int n = this.in.read();
        if (n != -1) {
            return n;
        }
        this.nextStream();
        return this.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.in.read(byArray, n, n2);
        if (n3 > 0) {
            return n3;
        }
        this.nextStream();
        return this.read(byArray, n, n2);
    }

    @Override
    public void close() throws IOException {
        while (this.in != null) {
            this.nextStream();
        }
    }
}

