/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.imageop.AbstractOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.ImageOpObserver;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTiledOpImpl
extends AbstractOpImpl {
    private static final Dimension DEFAULT_TILE_SIZE = new Dimension(256, 256);
    protected Dimension tileSize;
    protected int numXTiles;
    protected int numYTiles;
    protected ImageOp[] tiles;

    protected void fixTileSize() {
        if (this.size == null) {
            this.fixSize();
        }
        this.tileSize = DEFAULT_TILE_SIZE;
        this.numXTiles = (int)Math.ceil((double)this.size.width / (double)this.tileSize.width);
        this.numYTiles = (int)Math.ceil((double)this.size.height / (double)this.tileSize.height);
        this.tiles = new ImageOp[this.numXTiles * this.numYTiles];
    }

    @Override
    public Dimension getTileSize() {
        if (this.tileSize == null) {
            this.fixTileSize();
        }
        return new Dimension(this.tileSize);
    }

    @Override
    public int getTileHeight() {
        if (this.tileSize == null) {
            this.fixTileSize();
        }
        return this.tileSize.height;
    }

    @Override
    public int getTileWidth() {
        if (this.tileSize == null) {
            this.fixTileSize();
        }
        return this.tileSize.width;
    }

    @Override
    public int getNumXTiles() {
        if (this.tileSize == null) {
            this.fixTileSize();
        }
        return this.numXTiles;
    }

    @Override
    public int getNumYTiles() {
        if (this.tileSize == null) {
            this.fixTileSize();
        }
        return this.numYTiles;
    }

    @Override
    public ImageOp getTileOp(int n, int n2) {
        ImageOp imageOp = this.tiles[n2 * this.numXTiles + n];
        if (imageOp == null) {
            ImageOp imageOp2 = this.createTileOp(n, n2);
            this.tiles[n2 * this.numXTiles + n] = imageOp2;
            imageOp = imageOp2;
        }
        return imageOp;
    }

    protected abstract ImageOp createTileOp(int var1, int var2);

    @Override
    public BufferedImage getTile(int n, int n2, ImageOpObserver imageOpObserver) throws CancellationException, InterruptedException, ExecutionException {
        if (n < 0 || n >= this.numXTiles || n2 < 0 || n2 >= this.numYTiles) {
            throw new IndexOutOfBoundsException();
        }
        return this.getTileOp(n, n2).getImage(imageOpObserver);
    }

    @Override
    public Future<BufferedImage> getFutureTile(int n, int n2, ImageOpObserver imageOpObserver) throws ExecutionException {
        if (n < 0 || n >= this.numXTiles || n2 < 0 || n2 >= this.numYTiles) {
            throw new IndexOutOfBoundsException();
        }
        return this.getTileOp(n, n2).getFutureImage(imageOpObserver);
    }

    @Override
    public Point[] getTileIndices(Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException();
        }
        if (this.size == null || this.tileSize == null) {
            this.fixTileSize();
        }
        if ((rectangle = rectangle.intersection(new Rectangle(this.size))).isEmpty()) {
            return new Point[0];
        }
        int n = rectangle.x / this.tileSize.width;
        int n2 = rectangle.y / this.tileSize.height;
        int n3 = (rectangle.x + rectangle.width - 1) / this.tileSize.width;
        int n4 = (rectangle.y + rectangle.height - 1) / this.tileSize.height;
        Point[] pointArray = new Point[(n3 - n + 1) * (n4 - n2 + 1)];
        int n5 = 0;
        for (int i = n2; i <= n4; ++i) {
            for (int j = n; j <= n3; ++j) {
                pointArray[n5++] = new Point(j, i);
            }
        }
        return pointArray;
    }
}

