/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.ErrorDialog;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.ThrowableUtils;

public class RecursionLimiter {
    protected static final int RECURSION_LIMIT = 50;
    protected static int recursionDepth = 0;
    protected static boolean reporting = false;

    public static void startExecution(Loopable loopable) throws RecursionLimitException {
        if (++recursionDepth > 50) {
            throw new RecursionLimitException(loopable);
        }
    }

    public static void endExecution() {
        --recursionDepth;
    }

    public static void infiniteLoop(RecursionLimitException recursionLimitException) {
        reporting = true;
        ErrorDialog.showDetails(recursionLimitException, ThrowableUtils.getStackTrace(recursionLimitException), "Error.infinite_loop", recursionLimitException.getComponentTypeName(), recursionLimitException.getComponentName());
        reporting = false;
    }

    public static boolean isReportingInfiniteLoop() {
        return reporting;
    }

    public static interface Loopable {
        public String getComponentTypeName();

        public String getComponentName();
    }
}

