/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.SaveMetaData;
import VASSAL.configure.Configurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.LongConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslateVassalWindow;
import VASSAL.launch.Editor;
import VASSAL.launch.ExceptionHandler;
import VASSAL.launch.FirstTimeDialog;
import VASSAL.launch.LaunchRequest;
import VASSAL.launch.LaunchRequestException;
import VASSAL.launch.ModuleManagerMacOSXStartUp;
import VASSAL.launch.ModuleManagerWindow;
import VASSAL.launch.Player;
import VASSAL.launch.StartUp;
import VASSAL.launch.UpdateCheckRequest;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.io.ZipArchive;
import VASSAL.tools.logging.LoggedOutputStream;
import VASSAL.tools.menu.MacOSXMenuManager;
import VASSAL.tools.menu.MenuBarProxy;
import VASSAL.tools.menu.MenuManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleManager {
    private static final Logger logger = LoggerFactory.getLogger(ModuleManager.class);
    private static final String NEXT_VERSION_CHECK = "nextVersionCheck";
    public static final String MAXIMUM_HEAP = "maximumHeap";
    public static final String INITIAL_HEAP = "initialHeap";
    private static ModuleManager instance = null;
    private final long key;
    private FileOutputStream lout;
    private FileLock lock;
    private final ServerSocket serverSocket;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Closeable closeable;
        OutputStream outputStream;
        AutoCloseable autoCloseable;
        LaunchRequest launchRequest = null;
        try {
            launchRequest = LaunchRequest.parseArgs(stringArray);
        }
        catch (LaunchRequestException launchRequestException) {
            System.err.println("VASSAL: " + launchRequestException.getMessage());
            System.exit(1);
        }
        System.setProperty("swing.boldMetal", "false");
        if (launchRequest.mode == LaunchRequest.Mode.TRANSLATE) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    new TranslateVassalWindow(null).setVisible(true);
                }
            });
            return;
        }
        File file = new File(Info.getConfDir(), "key");
        File file2 = new File(Info.getConfDir(), "lock");
        int n = 0;
        long l = 0L;
        RandomAccessFile randomAccessFile = null;
        FileLock fileLock = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            try {
                fileLock = randomAccessFile.getChannel().lock();
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                throw (IOException)new IOException().initCause(overlappingFileLockException);
            }
            autoCloseable = null;
            outputStream = new FileOutputStream(file2);
            try {
                autoCloseable = ((FileOutputStream)outputStream).getChannel().tryLock();
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                throw (IOException)new IOException().initCause(overlappingFileLockException);
            }
            if (autoCloseable != null) {
                closeable = new ServerSocket(0, 0, InetAddress.getByName(null));
                n = closeable.getLocalPort();
                randomAccessFile.writeInt(n);
                l = (long)(Math.random() * 9.223372036854776E18);
                randomAccessFile.writeLong(l);
                new ModuleManager((ServerSocket)closeable, l, (FileOutputStream)outputStream, (FileLock)autoCloseable);
            } else {
                ((FileOutputStream)outputStream).close();
                n = randomAccessFile.readInt();
                l = randomAccessFile.readLong();
            }
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            try {
                System.err.println("VASSAL: IO error");
                iOException.printStackTrace();
                System.exit(1);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(randomAccessFile);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)randomAccessFile);
        }
        IOUtils.closeQuietly((Closeable)randomAccessFile);
        launchRequest.key = l;
        autoCloseable = null;
        outputStream = null;
        closeable = null;
        try {
            autoCloseable = new Socket((String)null, n);
            outputStream = new ObjectOutputStream(new BufferedOutputStream(((Socket)autoCloseable).getOutputStream()));
            ((ObjectOutputStream)outputStream).writeObject(launchRequest);
            ((ObjectOutputStream)outputStream).flush();
            closeable = ((Socket)autoCloseable).getInputStream();
            IOUtils.copy((InputStream)closeable, (OutputStream)System.err);
        }
        catch (IOException iOException) {
            try {
                System.err.println("VASSAL: Problem with socket on port " + n);
                iOException.printStackTrace();
                System.exit(1);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(closeable);
                IOUtils.closeQuietly((Closeable)outputStream);
                IOUtils.closeQuietly((Socket)autoCloseable);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)closeable);
            IOUtils.closeQuietly((Closeable)outputStream);
            IOUtils.closeQuietly((Socket)autoCloseable);
        }
        IOUtils.closeQuietly((InputStream)closeable);
        IOUtils.closeQuietly((Closeable)outputStream);
        IOUtils.closeQuietly((Socket)autoCloseable);
    }

    public static ModuleManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleManager(ServerSocket serverSocket, long l, FileOutputStream fileOutputStream, FileLock fileLock) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        block16: {
            if (instance != null) {
                throw new IllegalStateException();
            }
            instance = this;
            this.serverSocket = serverSocket;
            this.key = l;
            this.lout = fileOutputStream;
            this.lock = fileLock;
            File file = new File(Info.getHomeDir(), "errorLog");
            new FileOutputStream(file).close();
            StartUp startUp = SystemUtils.IS_OS_MAC_OSX ? new ModuleManagerMacOSXStartUp() : new StartUp();
            startUp.startErrorLog();
            System.setErr(new PrintStream(new LoggedOutputStream(), true));
            Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
            startUp.initSystemProperties();
            File file2 = Info.getPrefsDir();
            if (file2.exists()) break block16;
            object5 = new File(Info.getHomeDir(), "Preferences");
            if (!((File)object5).exists()) {
                object5 = new File(System.getProperty("user.home"), "VASSAL/Preferences");
            }
            if (!((File)object5).exists()) break block16;
            FileUtils.forceMkdir((File)file2);
            object4 = new byte[4096];
            try {
                object3 = new ZipArchive((File)object5);
                try {
                    for (String string : ((ZipArchive)object3).getFiles()) {
                        object2 = new File(file2, "VASSAL".equals(string) ? "V_Global" : Prefs.sanitize(string));
                        object = null;
                        try {
                            object = ((ZipArchive)object3).getInputStream(string);
                            FileOutputStream fileOutputStream2 = null;
                            try {
                                fileOutputStream2 = new FileOutputStream((File)object2);
                                IOUtils.copy((InputStream)object, fileOutputStream2, (byte[])object4);
                                ((OutputStream)fileOutputStream2).close();
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(fileOutputStream2);
                                throw throwable;
                            }
                            IOUtils.closeQuietly((OutputStream)fileOutputStream2);
                            ((InputStream)object).close();
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)object);
                        }
                    }
                    ((ZipArchive)object3).close();
                }
                finally {
                    IOUtils.closeQuietly((Closeable)object3);
                }
            }
            catch (IOException iOException) {
                logger.error("Failed to convert legacy preferences file.", (Throwable)iOException);
            }
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            new MacOSXMenuManager();
        } else {
            new ModuleManagerMenuManager();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ModuleManager.this.launch();
            }
        });
        object5 = new Thread((Runnable)new SocketListener(serverSocket), "socket listener");
        ((Thread)object5).setDaemon(true);
        ((Thread)object5).start();
        object4 = Prefs.getGlobalPrefs();
        object3 = new LongConfigurer(NEXT_VERSION_CHECK, null, -1L);
        ((Prefs)object4).addOption(null, (Configurer)object3);
        long l2 = ((LongConfigurer)object3).getLongValue(-1L);
        if (l2 < System.currentTimeMillis()) {
            new UpdateCheckRequest().execute();
        }
        l2 = l2 == -1L ? System.currentTimeMillis() + (long)(Math.random() * 10.0 * 8.64E7) : (l2 += 864000000L);
        ((LongConfigurer)object3).setValue(l2);
        object2 = new IntConfigurer(INITIAL_HEAP, Resources.getString("GlobalOptions.initial_heap"), (Integer)256);
        ((Prefs)object4).addOption("Importer", (Configurer)object2);
        object = new IntConfigurer(MAXIMUM_HEAP, Resources.getString("GlobalOptions.maximum_heap"), (Integer)512);
        ((Prefs)object4).addOption("Importer", (Configurer)object);
    }

    public void shutDown() throws IOException {
        this.lock.release();
        this.lout.close();
    }

    protected void launch() {
        boolean bl;
        logger.info("Manager");
        ModuleManagerWindow moduleManagerWindow = ModuleManagerWindow.getInstance();
        moduleManagerWindow.setVisible(true);
        boolean bl2 = bl = !Info.getPrefsDir().exists();
        if (bl) {
            new FirstTimeDialog(moduleManagerWindow).setVisible(true);
        }
    }

    protected String execute(Object object) {
        if (object instanceof LaunchRequest) {
            LaunchRequest launchRequest = (LaunchRequest)object;
            if (launchRequest.key != this.key) {
                return "incorrect key";
            }
            LaunchRequestHandler launchRequestHandler = new LaunchRequestHandler(launchRequest);
            try {
                SwingUtilities.invokeAndWait(launchRequestHandler);
            }
            catch (InterruptedException interruptedException) {
                return "interrupted";
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorDialog.bug(invocationTargetException);
                return null;
            }
            return launchRequestHandler.getResult();
        }
        return "unrecognized command";
    }

    private static class ModuleManagerMenuManager
    extends MenuManager {
        private final MenuBarProxy menuBar = new MenuBarProxy();

        private ModuleManagerMenuManager() {
        }

        public JMenuBar getMenuBarFor(JFrame jFrame) {
            return jFrame instanceof ModuleManagerWindow ? this.menuBar.createPeer() : null;
        }

        public MenuBarProxy getMenuBarProxyFor(JFrame jFrame) {
            return jFrame instanceof ModuleManagerWindow ? this.menuBar : null;
        }
    }

    private static class LaunchRequestHandler
    implements Runnable {
        private final LaunchRequest lr;
        private String result;

        public LaunchRequestHandler(LaunchRequest launchRequest) {
            this.lr = launchRequest;
        }

        public void run() {
            this.result = this.handle();
        }

        public String getResult() {
            return this.result;
        }

        private String handle() {
            ModuleManagerWindow moduleManagerWindow = ModuleManagerWindow.getInstance();
            switch (this.lr.mode) {
                case MANAGE: {
                    moduleManagerWindow.toFront();
                    break;
                }
                case LOAD: {
                    AbstractMetaData abstractMetaData;
                    if (Player.LaunchAction.isEditing(this.lr.module)) {
                        return "module open for editing";
                    }
                    if (this.lr.module == null && this.lr.game != null && (abstractMetaData = MetaDataFactory.buildMetaData(this.lr.game)) != null && abstractMetaData instanceof SaveMetaData) {
                        String string = ((SaveMetaData)abstractMetaData).getModuleName();
                        if (string != null && string.length() > 0) {
                            this.lr.module = moduleManagerWindow.getModuleByName(string);
                        } else {
                            return "cannot find module";
                        }
                    }
                    if (this.lr.module == null) {
                        return "cannot find module";
                    }
                    if (this.lr.game == null) {
                        new Player.LaunchAction(moduleManagerWindow, this.lr.module).actionPerformed(null);
                        break;
                    }
                    new Player.LaunchAction(moduleManagerWindow, this.lr.module, this.lr.game).actionPerformed(null);
                    break;
                }
                case EDIT: {
                    if (Editor.LaunchAction.isInUse(this.lr.module)) {
                        return "module open for play";
                    }
                    if (Editor.LaunchAction.isEditing(this.lr.module)) {
                        return "module open for editing";
                    }
                    new Editor.LaunchAction(moduleManagerWindow, this.lr.module).actionPerformed(null);
                    break;
                }
                case IMPORT: {
                    new Editor.ImportLaunchAction(moduleManagerWindow, this.lr.importFile).actionPerformed(null);
                    break;
                }
                case NEW: {
                    new Editor.NewModuleLaunchAction(moduleManagerWindow).actionPerformed(null);
                    break;
                }
                case EDIT_EXT: {
                    return "not yet implemented";
                }
                case NEW_EXT: {
                    return "not yet implemented";
                }
                default: {
                    return "unrecognized mode";
                }
            }
            return null;
        }
    }

    private class SocketListener
    implements Runnable {
        private final ServerSocket serverSocket;

        public SocketListener(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                ObjectInputStream objectInputStream = null;
                PrintStream printStream = null;
                Socket socket = null;
                while (true) {
                    try {
                        String string;
                        while (true) {
                            socket = this.serverSocket.accept();
                            objectInputStream = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
                            string = ModuleManager.this.execute(objectInputStream.readObject());
                            objectInputStream.close();
                            socket.close();
                            if (string != null && !socket.isClosed()) break;
                            IOUtils.closeQuietly((Closeable)objectInputStream);
                            IOUtils.closeQuietly(printStream);
                            IOUtils.closeQuietly((Socket)socket);
                        }
                        printStream = new PrintStream(new BufferedOutputStream(socket.getOutputStream()));
                        printStream.println(string);
                        printStream.close();
                        IOUtils.closeQuietly((Closeable)objectInputStream);
                    }
                    catch (IOException iOException) {
                        ErrorDialog.showDetails(iOException, ThrowableUtils.getStackTrace(iOException), "Error.socket_error", new Object[0]);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        IOUtils.closeQuietly((Closeable)objectInputStream);
                        IOUtils.closeQuietly(printStream);
                        IOUtils.closeQuietly((Socket)socket);
                        continue;
                        catch (ClassNotFoundException classNotFoundException) {
                            ErrorDialog.bug(classNotFoundException);
                            continue;
                        }
                    }
                    finally {
                        IOUtils.closeQuietly(objectInputStream);
                        IOUtils.closeQuietly(printStream);
                        IOUtils.closeQuietly((Socket)socket);
                        continue;
                    }
                    IOUtils.closeQuietly((OutputStream)printStream);
                    IOUtils.closeQuietly((Socket)socket);
                    continue;
                    break;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((ServerSocket)this.serverSocket);
                throw throwable;
            }
        }
    }
}

