/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.ExtensionMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.build.module.metadata.SaveMetaData;
import VASSAL.launch.LaunchRequestException;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LaunchRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Mode mode;
    public File module;
    public File game;
    public File extension;
    public File importFile;
    public boolean standalone = false;
    public boolean builtInModule;
    public List<String> autoext;
    public int port = -1;
    public long key;
    private static final String help = "Usage:\n  VASSAL -e [option]... module\n  VASSAL -i [option]... module\n  VASSAL -l [option]... module|save|log...\n  VASSAL -n [option]...\n  VASSAL -m\n  VASSAL -h\n  VASSAL --edit-extension [option]... module|extension...\n  VASSAL --new-extension [option]...\n\nOptions:\n  -a, --auto          TODO\n  -e, --edit          Edit a module\n  -h, --help          Display this help and exit\n  -i, --import        Import a non-VASSAL module\n  -l, --load          Load a module and saved game or log\n  -m, --manage        Use the module manager\n  -n, --new           Create a new module\n  -s, --standalone    Run in standalone mode\n  --auto-extensions   TODO\n  --edit-extension    Edit a module extension\n  --new-extension     Create a new module extension\n  --port              Set port for manager to listen on\n  --version           Display version information and exit\n  --                  Terminate the list of options\n\nVASSAL defaults to '-m' if no options are given.\n\n";

    public LaunchRequest() {
        this(null, null);
    }

    public LaunchRequest(Mode mode) {
        this(mode, null, null);
    }

    public LaunchRequest(Mode mode, File file) {
        this(mode, file, null);
    }

    public LaunchRequest(Mode mode, File file, File file2) {
        this.mode = mode;
        this.module = file;
        if (mode == Mode.EDIT_EXT) {
            this.extension = file2;
        } else {
            this.game = file2;
        }
    }

    public LaunchRequest(LaunchRequest launchRequest) {
        this.mode = launchRequest.mode;
        this.module = launchRequest.module;
        this.game = launchRequest.game;
        this.extension = launchRequest.extension;
        this.importFile = launchRequest.importFile;
        this.standalone = launchRequest.standalone;
        this.builtInModule = launchRequest.builtInModule;
        if (launchRequest.autoext != null) {
            this.autoext = new ArrayList<String>(launchRequest.autoext);
        }
    }

    public String[] toArgs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("--" + this.mode.toString());
        if (this.builtInModule) {
            arrayList.add("--auto");
        }
        if (this.port >= 0) {
            arrayList.add("--port=" + this.port);
        }
        if (this.autoext != null) {
            StringBuilder stringBuilder = new StringBuilder("--auto-extensions=");
            Iterator<String> iterator = this.autoext.iterator();
            stringBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(',').append(iterator.next());
            }
            arrayList.add(stringBuilder.toString().replace(' ', '_'));
        }
        arrayList.add("--");
        if (this.module != null) {
            arrayList.add(this.module.getPath());
            if (this.game != null) {
                arrayList.add(this.game.getPath());
            } else if (this.extension != null) {
                arrayList.add(this.extension.getPath());
            }
        } else if (this.importFile != null) {
            arrayList.add(this.importFile.getPath());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static LaunchRequest parseArgs(String[] stringArray) throws LaunchRequestException {
        int n;
        LaunchRequest launchRequest = new LaunchRequest();
        LongOpt[] longOptArray = new LongOpt[]{new LongOpt("auto", 0, null, 97), new LongOpt("edit", 0, null, 101), new LongOpt("help", 0, null, 104), new LongOpt("import", 0, null, 105), new LongOpt("load", 0, null, 108), new LongOpt("manage", 0, null, 109), new LongOpt("new", 0, null, 110), new LongOpt("standalone", 0, null, 115), new LongOpt("auto-extensions", 1, null, 2), new LongOpt("edit-extension", 0, null, 3), new LongOpt("new-extension", 0, null, 4), new LongOpt("port", 1, null, 5), new LongOpt("version", 0, null, 6), new LongOpt("translate", 0, null, 7)};
        Getopt getopt = new Getopt("VASSAL", stringArray, ":aehilmn", longOptArray);
        getopt.setOpterr(false);
        block27: while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 2: {
                    if (launchRequest.autoext == null) {
                        launchRequest.autoext = new ArrayList<String>();
                    }
                    for (String string : getopt.getOptarg().split(",")) {
                        launchRequest.autoext.add(string.replace("_", " "));
                    }
                    continue block27;
                }
                case 3: {
                    LaunchRequest.setMode(launchRequest, Mode.EDIT_EXT);
                    continue block27;
                }
                case 4: {
                    LaunchRequest.setMode(launchRequest, Mode.NEW_EXT);
                    continue block27;
                }
                case 5: {
                    try {
                        launchRequest.port = Integer.parseInt(getopt.getOptarg());
                    }
                    catch (NumberFormatException numberFormatException) {
                        LaunchRequest.die("LaunchRequest.bad_port", getopt.getOptarg());
                    }
                    if (launchRequest.port >= 49152 && launchRequest.port <= 65535) continue block27;
                    LaunchRequest.die("LaunchRequest.bad_port", getopt.getOptarg());
                    continue block27;
                }
                case 6: {
                    System.err.println("VASSAL " + Info.getVersion());
                    System.exit(0);
                    continue block27;
                }
                case 7: {
                    LaunchRequest.setMode(launchRequest, Mode.TRANSLATE);
                    continue block27;
                }
                case 97: {
                    launchRequest.builtInModule = true;
                    continue block27;
                }
                case 101: {
                    LaunchRequest.setMode(launchRequest, Mode.EDIT);
                    continue block27;
                }
                case 104: {
                    System.err.print(help);
                    System.exit(0);
                    continue block27;
                }
                case 105: {
                    LaunchRequest.setMode(launchRequest, Mode.IMPORT);
                    continue block27;
                }
                case 108: {
                    LaunchRequest.setMode(launchRequest, Mode.LOAD);
                    continue block27;
                }
                case 109: {
                    LaunchRequest.setMode(launchRequest, Mode.MANAGE);
                    continue block27;
                }
                case 110: {
                    LaunchRequest.setMode(launchRequest, Mode.NEW);
                    continue block27;
                }
                case 115: {
                    launchRequest.standalone = true;
                    continue block27;
                }
                case 58: {
                    LaunchRequest.die("LaunchRequest.missing_argument", stringArray[getopt.getOptind() - 1]);
                    continue block27;
                }
                case 63: {
                    LaunchRequest.die("LaunchRequest.unrecognized_option", getopt.getOptopt() == 0 ? stringArray[getopt.getOptind() - 1] : '-' + String.valueOf((char)getopt.getOptopt()));
                    continue block27;
                }
            }
            throw new IllegalStateException();
        }
        int n2 = getopt.getOptind();
        if (launchRequest.mode == null) {
            launchRequest.mode = n2 < stringArray.length ? Mode.LOAD : Mode.MANAGE;
        }
        switch (launchRequest.mode) {
            case MANAGE: {
                break;
            }
            case LOAD: {
                while (n2 < stringArray.length) {
                    File file;
                    AbstractMetaData abstractMetaData;
                    if ((abstractMetaData = MetaDataFactory.buildMetaData(file = new File(stringArray[n2++]))) instanceof ModuleMetaData) {
                        if (launchRequest.module != null) {
                            LaunchRequest.die("LaunchRequest.only_one", "module");
                        }
                        launchRequest.module = file;
                        continue;
                    }
                    if (abstractMetaData instanceof ExtensionMetaData) {
                        if (launchRequest.extension != null) {
                            LaunchRequest.die("", new String[0]);
                        }
                        launchRequest.extension = file;
                        continue;
                    }
                    if (abstractMetaData instanceof SaveMetaData) {
                        if (launchRequest.game != null) {
                            LaunchRequest.die("LaunchRequest.only_one", "saved game or log");
                        }
                        launchRequest.game = file;
                        continue;
                    }
                    LaunchRequest.die("LaunchRequest.unknown_file_type", file.toString());
                }
                if (launchRequest.builtInModule || launchRequest.module != null || launchRequest.game != null) break;
                LaunchRequest.die("LaunchRequest.missing_module", new String[0]);
                break;
            }
            case IMPORT: {
                if (n2 < stringArray.length) {
                    launchRequest.importFile = new File(stringArray[n2++]);
                    break;
                }
                LaunchRequest.die("LaunchRequest.missing_module", new String[0]);
                break;
            }
            case EDIT: 
            case NEW_EXT: {
                if (n2 < stringArray.length) {
                    File file;
                    AbstractMetaData abstractMetaData;
                    if ((abstractMetaData = MetaDataFactory.buildMetaData(file = new File(stringArray[n2++]))) instanceof ModuleMetaData) {
                        launchRequest.module = file;
                        break;
                    }
                    if (abstractMetaData instanceof ExtensionMetaData || abstractMetaData instanceof SaveMetaData) break;
                    LaunchRequest.die("LaunchRequest.unknown_file_type", file.toString());
                    break;
                }
                LaunchRequest.die("LaunchRequest.missing_module", new String[0]);
                break;
            }
            case EDIT_EXT: {
                while (n2 < stringArray.length) {
                    File file;
                    AbstractMetaData abstractMetaData;
                    if ((abstractMetaData = MetaDataFactory.buildMetaData(file = new File(stringArray[n2++]))) instanceof ModuleMetaData) {
                        if (launchRequest.module != null) {
                            LaunchRequest.die("LaunchRequest.only_one", "module");
                        }
                        launchRequest.module = file;
                        continue;
                    }
                    if (abstractMetaData instanceof ExtensionMetaData) {
                        if (launchRequest.extension != null) {
                            LaunchRequest.die("", new String[0]);
                        }
                        launchRequest.extension = file;
                        continue;
                    }
                    if (abstractMetaData instanceof SaveMetaData) continue;
                    LaunchRequest.die("LaunchRequest.unknown_file_type", file.toString());
                }
                if (launchRequest.module == null) {
                    LaunchRequest.die("LaunchRequest.missing_module", new String[0]);
                }
                if (launchRequest.extension != null) break;
                LaunchRequest.die("LaunchRequest.missing_extension", new String[0]);
                break;
            }
        }
        if (n2 < stringArray.length) {
            LaunchRequest.die("LaunchRequest.excess_args", stringArray[n2]);
        }
        if (launchRequest.builtInModule) {
            if (launchRequest.mode != Mode.LOAD) {
                LaunchRequest.die("LaunchRequest.only_in_mode", "--auto", Mode.LOAD.toString());
            }
            if (launchRequest.module != null) {
                LaunchRequest.die("LaunchRequest.excess_args", stringArray[n2]);
            }
        }
        if (launchRequest.autoext != null) {
            if (launchRequest.mode != Mode.LOAD) {
                LaunchRequest.die("LaunchRequest.only_in_mode", "--auto-extensions", Mode.LOAD.toString());
            }
            if (launchRequest.module != null) {
                LaunchRequest.die("LaunchRequest.excess_args", stringArray[n2]);
            }
        }
        return launchRequest;
    }

    protected static void setMode(LaunchRequest launchRequest, Mode mode) throws LaunchRequestException {
        if (launchRequest.mode != null) {
            LaunchRequest.die("LaunchRequest.only_one", "mode");
        }
        launchRequest.mode = mode;
    }

    protected static void die(String string, String ... stringArray) throws LaunchRequestException {
        throw new LaunchRequestException(string, stringArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        MANAGE{

            public String toString() {
                return "manage";
            }
        }
        ,
        LOAD{

            public String toString() {
                return "load";
            }
        }
        ,
        EDIT{

            public String toString() {
                return "edit";
            }
        }
        ,
        IMPORT{

            public String toString() {
                return "import";
            }
        }
        ,
        NEW{

            public String toString() {
                return "new";
            }
        }
        ,
        EDIT_EXT{

            public String toString() {
                return "edit-extension";
            }
        }
        ,
        NEW_EXT{

            public String toString() {
                return "new-extension";
            }
        }
        ,
        TRANSLATE{

            public String toString() {
                return "translate";
            }
        };

    }
}

