/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.ImportMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.i18n.Resources;
import VASSAL.launch.AbstractLaunchAction;
import VASSAL.launch.BasicModule;
import VASSAL.launch.CreateModuleAction;
import VASSAL.launch.EditExtensionAction;
import VASSAL.launch.EditModuleAction;
import VASSAL.launch.EditorWindow;
import VASSAL.launch.LaunchRequest;
import VASSAL.launch.Launcher;
import VASSAL.launch.ModuleManagerWindow;
import VASSAL.launch.NewExtensionAction;
import VASSAL.launch.PlayerWindow;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.WarningDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.imports.ImportAction;
import VASSAL.tools.menu.MacOSXMenuManager;
import VASSAL.tools.menu.MenuBarProxy;
import VASSAL.tools.menu.MenuManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Editor
extends Launcher {
    private static final Logger logger = LoggerFactory.getLogger(Editor.class);

    public static void main(String[] stringArray) {
        new Editor(stringArray);
    }

    protected Editor(String[] stringArray) {
        super(stringArray);
    }

    protected MenuManager createMenuManager() {
        return SystemUtils.IS_OS_MAC_OSX ? new MacOSXMenuManager() : new EditorMenuManager();
    }

    protected void launch() throws IOException {
        AbstractLaunchAction.LaunchRequestMessage launchRequestMessage = null;
        switch (this.lr.mode) {
            case EDIT: {
                new EditModuleAction(this.lr.module).loadModule(this.lr.module);
                launchRequestMessage = new AbstractLaunchAction.NotifyOpenModuleOk(this.lr);
                break;
            }
            case IMPORT: {
                new ImportAction(null).loadModule(this.lr.importFile);
                launchRequestMessage = new AbstractLaunchAction.NotifyImportModuleOk(this.lr);
                break;
            }
            case NEW: {
                new CreateModuleAction(null).performAction(null);
                launchRequestMessage = new AbstractLaunchAction.NotifyNewModuleOk(this.lr);
                break;
            }
            case EDIT_EXT: {
                GameModule.init(new BasicModule(new DataArchive(this.lr.module.getPath())));
                GameModule.getGameModule().getFrame().setVisible(true);
                new EditExtensionAction(this.lr.extension).performAction(null);
                launchRequestMessage = new AbstractLaunchAction.NotifyOpenModuleOk(this.lr);
                break;
            }
            case NEW_EXT: {
                GameModule.init(new BasicModule(new DataArchive(this.lr.module.getPath())));
                JFrame jFrame = GameModule.getGameModule().getFrame();
                jFrame.setVisible(true);
                new NewExtensionAction(jFrame).performAction(null);
                launchRequestMessage = new AbstractLaunchAction.NotifyOpenModuleOk(this.lr);
            }
        }
        if (this.ipc != null) {
            try {
                this.ipc.send(launchRequestMessage);
            }
            catch (IOException iOException) {
                ErrorDialog.showDetails(iOException, ThrowableUtils.getStackTrace(iOException), "Error.socket_error", new Object[0]);
            }
        }
    }

    private static class EditorMenuManager
    extends MenuManager {
        private final MenuBarProxy editorBar = new MenuBarProxy();
        private final MenuBarProxy playerBar = new MenuBarProxy();

        private EditorMenuManager() {
        }

        public JMenuBar getMenuBarFor(JFrame jFrame) {
            if (jFrame instanceof PlayerWindow) {
                return this.playerBar.createPeer();
            }
            if (jFrame instanceof EditorWindow) {
                return this.editorBar.createPeer();
            }
            return null;
        }

        public MenuBarProxy getMenuBarProxyFor(JFrame jFrame) {
            if (jFrame instanceof PlayerWindow) {
                return this.playerBar;
            }
            if (jFrame instanceof EditorWindow) {
                return this.editorBar;
            }
            return null;
        }
    }

    public static class PromptLaunchAction
    extends LaunchAction {
        private static final long serialVersionUID = 1L;

        public PromptLaunchAction(ModuleManagerWindow moduleManagerWindow) {
            super(moduleManagerWindow, null);
            this.putValue("Name", Resources.getString("Main.edit_module"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.promptForFile() == null) {
                return;
            }
            super.actionPerformed(actionEvent);
        }
    }

    public static class ListLaunchAction
    extends LaunchAction {
        private static final long serialVersionUID = 1L;

        public ListLaunchAction(ModuleManagerWindow moduleManagerWindow, File file) {
            super(moduleManagerWindow, file);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            this.setEnabled(false);
        }
    }

    public static class LaunchAction
    extends AbstractLaunchAction {
        private static final long serialVersionUID = 1L;

        public LaunchAction(ModuleManagerWindow moduleManagerWindow, File file) {
            super(Resources.getString("Main.edit_module_specific"), moduleManagerWindow, Editor.class.getName(), new LaunchRequest(LaunchRequest.Mode.EDIT, file));
            this.setEnabled(!editing.contains(file) && !using.containsKey(file));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractMetaData abstractMetaData = MetaDataFactory.buildMetaData(this.lr.module);
            if (abstractMetaData != null) {
                ModuleMetaData moduleMetaData;
                String string = abstractMetaData.getVassalVersion();
                if (Info.isModuleTooNew(string)) {
                    ErrorDialog.show("Error.module_too_new", this.lr.module.getPath(), string, Info.getVersion());
                    return;
                }
                if (abstractMetaData instanceof ModuleMetaData && Info.compareVersions((moduleMetaData = (ModuleMetaData)abstractMetaData).getVassalVersion(), "3.2.0") < 0) {
                    if ("VASL".equals(moduleMetaData.getName())) {
                        ErrorDialog.show("Error.VASL_too_old", Info.getVersion());
                        return;
                    }
                    if ("VSQL".equals(moduleMetaData.getName())) {
                        ErrorDialog.show("Error.VSQL_too_old", Info.getVersion());
                        return;
                    }
                }
                if (Info.hasOldFormat(string)) {
                    WarningDialog.show("Warning.module_will_be_updated", this.lr.module.getPath(), Info.getVersion(), "3.2");
                }
            }
            if (editing.contains(this.lr.module) || using.containsKey(this.lr.module)) {
                return;
            }
            editing.add(this.lr.module);
            super.actionPerformed(actionEvent);
        }

        protected AbstractLaunchAction.LaunchTask getLaunchTask() {
            return new AbstractLaunchAction.LaunchTask(){

                protected void done() {
                    super.done();
                    AbstractLaunchAction.editing.remove(this.lr.module);
                    LaunchAction.this.setEnabled(true);
                }
            };
        }
    }

    public static class PromptImportLaunchAction
    extends ImportLaunchAction {
        private static final long serialVersionUID = 1L;

        public PromptImportLaunchAction(ModuleManagerWindow moduleManagerWindow) {
            super(moduleManagerWindow, null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.promptForFile() == null) {
                return;
            }
            super.actionPerformed(actionEvent);
        }

        protected File promptForFile() {
            FileChooser fileChooser = ImportAction.getFileChooser(this.window);
            if (fileChooser.showOpenDialog() == 0) {
                this.lr.importFile = fileChooser.getSelectedFile();
                if (this.lr.importFile != null) {
                    if (this.lr.importFile.exists()) {
                        AbstractMetaData abstractMetaData = MetaDataFactory.buildMetaData(this.lr.importFile);
                        if (abstractMetaData == null || !(abstractMetaData instanceof ImportMetaData)) {
                            ErrorDialog.show("Error.invalid_import_file", this.lr.importFile.getAbsolutePath());
                            logger.error("Import of " + this.lr.importFile.getAbsolutePath() + " failed: unrecognized import type");
                            this.lr.importFile = null;
                        }
                    } else {
                        this.lr.importFile = null;
                    }
                }
            }
            return this.lr.importFile;
        }
    }

    public static class ImportLaunchAction
    extends AbstractLaunchAction {
        private static final long serialVersionUID = 1L;

        public ImportLaunchAction(ModuleManagerWindow moduleManagerWindow, File file) {
            super(Resources.getString("Main.import_module"), moduleManagerWindow, Editor.class.getName(), new LaunchRequest(LaunchRequest.Mode.IMPORT, file));
        }

        protected AbstractLaunchAction.LaunchTask getLaunchTask() {
            return new AbstractLaunchAction.LaunchTask(this);
        }
    }

    public static class NewModuleLaunchAction
    extends AbstractLaunchAction {
        private static final long serialVersionUID = 1L;

        public NewModuleLaunchAction(ModuleManagerWindow moduleManagerWindow) {
            super(Resources.getString("Main.new_module"), moduleManagerWindow, Editor.class.getName(), new LaunchRequest(LaunchRequest.Mode.NEW));
        }

        protected AbstractLaunchAction.LaunchTask getLaunchTask() {
            return new AbstractLaunchAction.LaunchTask(this);
        }
    }
}

