/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.BadDataReport;
import VASSAL.configure.Configurer;
import VASSAL.tools.ColorButton;
import VASSAL.tools.ErrorDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ColorConfigurer
extends Configurer {
    private JPanel p;
    private ColorButton cb;

    public ColorConfigurer(String string, String string2) {
        this(string, string2, Color.black);
    }

    public ColorConfigurer(String string, String string2, Color color) {
        super(string, string2, color);
    }

    public String getValueString() {
        return this.value == null ? "" : ColorConfigurer.colorToString(this.colorValue());
    }

    public void setValue(Object object) {
        super.setValue(object);
        if (this.cb != null) {
            this.cb.setColor((Color)object);
        }
    }

    public void setValue(String string) {
        this.setValue(ColorConfigurer.stringToColor(string));
    }

    public Component getControls() {
        if (this.p == null) {
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 0));
            this.p.add(new JLabel(this.getName()));
            this.cb = new ColorButton(this.colorValue());
            this.cb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColorConfigurer.this.setValue(JColorChooser.showDialog(null, ColorConfigurer.this.getName(), ColorConfigurer.this.colorValue()));
                }
            });
            this.p.add(this.cb);
        }
        return this.p;
    }

    private Color colorValue() {
        return (Color)this.value;
    }

    public static String colorToString(Color color) {
        return color == null ? null : color.getRed() + "," + color.getGreen() + "," + color.getBlue();
    }

    public static Color stringToColor(String string) {
        if (string == null || string.length() == 0 || "null".equals(string)) {
            return null;
        }
        try {
            if (string.startsWith("0X") || string.startsWith("0x")) {
                return Color.decode(string);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            return new Color(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
        }
        catch (NumberFormatException numberFormatException) {
            ErrorDialog.dataError(new BadDataReport("not an integer", string, numberFormatException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorDialog.dataError(new BadDataReport("bad color", string, illegalArgumentException));
        }
        catch (NoSuchElementException noSuchElementException) {
            ErrorDialog.dataError(new BadDataReport("bad color", string, noSuchElementException));
        }
        return Color.BLACK;
    }
}

