/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.DummyClient;
import VASSAL.chat.Player;
import VASSAL.chat.PlayerEncoder;
import VASSAL.chat.Room;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.command.Command;
import VASSAL.i18n.Resources;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;
import javax.swing.Icon;

public class HybridClient
implements ChatServerConnection,
PlayerEncoder,
ChatControlsInitializer {
    protected ChatServerConnection delegate;
    protected String defaultRoom = Resources.getString("Chat.main_room");
    protected PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    protected ChatServerControls controls;
    protected Icon currentIcon;
    protected String currentText;

    public HybridClient() {
        this.setDelegate(new DummyClient());
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propSupport.addPropertyChangeListener(string, propertyChangeListener);
        if (this.delegate != null) {
            this.delegate.addPropertyChangeListener(string, propertyChangeListener);
        }
    }

    public Room[] getAvailableRooms() {
        return this.delegate.getAvailableRooms();
    }

    public Room getRoom() {
        return this.delegate.getRoom();
    }

    public Player getUserInfo() {
        return this.delegate.getUserInfo();
    }

    public boolean isConnected() {
        return this.delegate.isConnected();
    }

    public void sendTo(Player player, Command command) {
        this.delegate.sendTo(player, command);
    }

    public void sendToOthers(Command command) {
        this.delegate.sendToOthers(command);
    }

    public void setConnected(boolean bl) {
        this.delegate.setConnected(bl);
    }

    public ChatServerConnection getDelegate() {
        return this.delegate;
    }

    public void setRoom(Room room) {
        this.delegate.setRoom(room);
    }

    public void setUserInfo(Player player) {
        this.delegate.setUserInfo(player);
    }

    public Player stringToPlayer(String string) {
        if (this.delegate instanceof PlayerEncoder) {
            return ((PlayerEncoder)((Object)this.delegate)).stringToPlayer(string);
        }
        return null;
    }

    public String playerToString(Player player) {
        if (this.delegate instanceof PlayerEncoder) {
            return ((PlayerEncoder)((Object)this.delegate)).playerToString(player);
        }
        return null;
    }

    protected void fireStatus(String string) {
        this.propSupport.firePropertyChange(new PropertyChangeEvent(this, "Status", null, string));
    }

    public void setDelegate(ChatServerConnection chatServerConnection) {
        if (this.delegate != null && this.delegate.isConnected()) {
            throw new IllegalStateException(Resources.getString("Server.error1"));
        }
        ChatServerConnection chatServerConnection2 = this.delegate;
        if (chatServerConnection2 != null) {
            chatServerConnection.setUserInfo(chatServerConnection2.getUserInfo());
        }
        PropertyChangeListener[] propertyChangeListenerArray = this.propSupport.getPropertyChangeListeners();
        for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
            chatServerConnection.addPropertyChangeListener(((PropertyChangeListenerProxy)propertyChangeListenerArray[i]).getPropertyName(), propertyChangeListenerArray[i]);
        }
        if (this.controls != null) {
            if (this.delegate instanceof ChatControlsInitializer) {
                ((ChatControlsInitializer)((Object)this.delegate)).uninitializeControls(this.controls);
            }
            if (chatServerConnection instanceof ChatControlsInitializer) {
                ((ChatControlsInitializer)((Object)chatServerConnection)).initializeControls(this.controls);
            }
        }
        this.delegate = chatServerConnection;
    }

    public void initializeControls(ChatServerControls chatServerControls) {
        this.controls = chatServerControls;
        if (this.delegate instanceof ChatControlsInitializer) {
            ((ChatControlsInitializer)((Object)this.delegate)).initializeControls(chatServerControls);
            chatServerControls.setRoomControlsVisible(true);
        }
        chatServerControls.updateClientDisplay(this.currentIcon, this.currentText);
    }

    public void uninitializeControls(ChatServerControls chatServerControls) {
        if (this.delegate instanceof ChatControlsInitializer) {
            ((ChatControlsInitializer)((Object)this.delegate)).uninitializeControls(chatServerControls);
        }
    }

    public void updateDisplayControls(Icon icon, String string) {
        if (this.controls != null) {
            this.controls.updateClientDisplay(icon, string);
        }
        this.currentIcon = icon;
        this.currentText = string;
    }
}

