/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.GamePieceLayout;
import VASSAL.build.module.gamepieceimage.ImageItemInstance;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.ArrayUtils;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.Op;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageItem
extends Item {
    public static final String TYPE = "Image";
    public static final String SRC_VARIABLE = "Specified in individual images";
    public static final String SRC_FIXED = "Fixed for this layout";
    protected static final String IMAGE = "image";
    public static final String SOURCE = "source";
    protected String imageSource = "Fixed for this layout";
    protected String imageName = "";
    @Deprecated
    protected Image image = null;
    protected ImageOp srcOp;
    protected Rectangle imageBounds = new Rectangle();
    private VisibilityCondition falseCond = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return false;
        }
    };
    private VisibilityCondition fixedCond = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return ImageItem.this.imageSource.equals(ImageItem.SRC_FIXED);
        }
    };

    public ImageItem() {
    }

    public ImageItem(GamePieceLayout gamePieceLayout) {
        super(gamePieceLayout);
    }

    public ImageItem(GamePieceLayout gamePieceLayout, String string) {
        this(gamePieceLayout);
        this.setConfigureName(string);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return ArrayUtils.insert(super.getAttributeDescriptions(), 2, "Image:  ", "Image is:  ");
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return ArrayUtils.insert(super.getAttributeTypes(), 2, Image.class, TextSource.class);
    }

    @Override
    public String[] getAttributeNames() {
        return ArrayUtils.insert(super.getAttributeNames(), 2, IMAGE, SOURCE);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (IMAGE.equals(string)) {
            this.imageName = object instanceof String ? (String)object : (object == null ? null : ((File)object).getName());
        } else if (SOURCE.equals(string)) {
            this.imageSource = (String)object;
        } else {
            super.setAttribute(string, object);
        }
        if (this.layout != null) {
            this.layout.refresh();
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (IMAGE.equals(string)) {
            return this.imageName;
        }
        if (SOURCE.equals(string)) {
            return this.imageSource;
        }
        return super.getAttributeValueString(string);
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if ("rotation".equals(string)) {
            return this.falseCond;
        }
        if (IMAGE.equals(string)) {
            return this.fixedCond;
        }
        return super.getAttributeVisibility(string);
    }

    @Override
    public void draw(Graphics graphics, GamePieceImage gamePieceImage) {
        BufferedImage bufferedImage;
        this.loadImage(gamePieceImage);
        Point point = this.layout.getPosition(this);
        if (this.isAntialias()) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.srcOp != null && (bufferedImage = this.srcOp.getImage()) != null) {
            graphics.drawImage(bufferedImage, point.x, point.y, null);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Dimension getSize() {
        return this.imageBounds.getSize();
    }

    public boolean isFixed() {
        return this.imageSource.equals(SRC_FIXED);
    }

    protected void loadImage(GamePieceImage gamePieceImage) {
        String string;
        ImageItemInstance imageItemInstance = null;
        if (gamePieceImage != null) {
            imageItemInstance = gamePieceImage.getImageInstance(this.getConfigureName());
        }
        if (imageItemInstance == null) {
            imageItemInstance = new ImageItemInstance();
        }
        if ((string = this.imageSource.equals(SRC_FIXED) ? this.imageName : imageItemInstance.getImageName()) != null) {
            this.srcOp = string.trim().length() == 0 ? BaseOp.op : Op.load(string);
            this.imageBounds = ImageUtils.getBounds(this.srcOp.getSize());
        } else {
            this.imageBounds = new Rectangle();
        }
    }

    public static Item decode(GamePieceLayout gamePieceLayout, String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        ImageItem imageItem = new ImageItem(gamePieceLayout);
        decoder.nextToken();
        imageItem.imageName = decoder.nextToken("");
        imageItem.imageSource = decoder.nextToken(SRC_FIXED);
        return imageItem;
    }

    @Override
    public String encode() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(TYPE, ';');
        sequenceEncoder.append(this.imageName).append(this.imageSource);
        SequenceEncoder sequenceEncoder2 = new SequenceEncoder(sequenceEncoder.getValue(), '|');
        sequenceEncoder2.append(super.encode());
        return sequenceEncoder2.getValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class BaseOp
    extends AbstractTileOpImpl {
        private static final BaseOp op = new BaseOp();

        private BaseOp() {
        }

        @Override
        public BufferedImage eval() throws Exception {
            BufferedImage bufferedImage = ImageUtils.createCompatibleTranslucentImage(10, 10);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(0, 0, 9, 9);
            graphics2D.drawLine(0, 0, 9, 9);
            graphics2D.drawLine(0, 9, 9, 0);
            graphics2D.dispose();
            return bufferedImage;
        }

        @Override
        protected void fixSize() {
        }

        @Override
        public Dimension getSize() {
            return new Dimension(10, 10);
        }

        @Override
        public int getWidth() {
            return 10;
        }

        @Override
        public int getHeight() {
            return 10;
        }

        @Override
        public List<VASSAL.tools.opcache.Op<?>> getSources() {
            return Collections.emptyList();
        }
    }

    public static class TextSource
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{ImageItem.SRC_VARIABLE, ImageItem.SRC_FIXED};
        }
    }
}

