/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.ColorManager;
import VASSAL.configure.ColorConfigurer;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorSwatch
extends AbstractConfigurable
implements Comparable<ColorSwatch> {
    protected static final String NAME = "name";
    protected static final String COLOR = "color";
    public static final String BLACK = "BLACK";
    public static final String WHITE = "WHITE";
    public static final String CLEAR = "CLEAR";
    public static final String RED = "RED";
    protected Color color;

    public ColorSwatch() {
        this.name = "";
        this.color = null;
    }

    public ColorSwatch(String string, Color color) {
        this();
        this.name = string;
        this.color = color;
    }

    public ColorSwatch(String string) {
        this();
        this.decode(string);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Color Name:  ", "Color:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Color.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, COLOR};
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
        } else if (COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.color = (Color)object;
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.color);
        }
        return null;
    }

    @Override
    public void removeFrom(Buildable buildable) {
    }

    @Override
    public HelpFile getHelpFile() {
        return null;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public static String getConfigureTypeName() {
        return "Named Color";
    }

    @Override
    public void addTo(Buildable buildable) {
        this.setAllAttributesUntranslatable();
    }

    public static ColorSwatch getBlack() {
        return new ColorSwatch(BLACK, Color.BLACK);
    }

    public static ColorSwatch getWhite() {
        return new ColorSwatch(WHITE, Color.WHITE);
    }

    public static ColorSwatch getRed() {
        return new ColorSwatch(RED, Color.RED);
    }

    public static ColorSwatch getClear() {
        return new ColorSwatch(CLEAR, null);
    }

    public String encode() {
        return this.getConfigureName();
    }

    public void decode(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.setConfigureName(decoder.nextToken());
        Color color = ColorManager.getColorManager().getColorByName(this.getConfigureName());
        if (color == null && !this.getConfigureName().equals(CLEAR)) {
            color = ColorManager.getColorManager().getColorByName(BLACK);
        }
        this.setColor(color);
    }

    public static ColorSwatch getDefaultSwatch() {
        return ColorManager.getColorManager().getColorSwatch(ColorManager.DEFAULT_COLOR);
    }

    @Override
    public int compareTo(ColorSwatch colorSwatch) {
        return this.name.compareTo(colorSwatch.name);
    }
}

