/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.dice;

import VASSAL.build.GameModule;
import VASSAL.build.module.DieRoll;
import VASSAL.build.module.dice.RollSet;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;
import VASSAL.tools.io.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import org.jdesktop.swingworker.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DieServer {
    private static final Logger logger = LoggerFactory.getLogger(DieServer.class);
    protected Random ran = GameModule.getGameModule().getRNG();
    protected String name;
    protected String description;
    protected boolean emailOnly;
    protected int maxRolls;
    protected int maxEmails;
    protected String serverURL;
    protected boolean passwdRequired = false;
    protected String password = "";
    protected boolean useEmail;
    protected String primaryEmail;
    protected String secondaryEmail;
    protected boolean canDoSeparateDice = false;

    public abstract String[] buildInternetRollString(RollSet var1);

    public abstract void parseInternetRollString(RollSet var1, Vector<String> var2);

    public abstract void roll(RollSet var1, FormattedString var2);

    public int[] getnDiceList() {
        return new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    }

    public int[] getnSideList() {
        return new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 20, 30, 50, 100, 1000};
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isPasswdRequired() {
        return this.passwdRequired;
    }

    public String getPasswd() {
        return this.password;
    }

    public void setPasswd(String string) {
        this.password = string;
    }

    public void setPrimaryEmail(String string) {
        this.primaryEmail = string;
    }

    public String getPrimaryEmail() {
        return this.primaryEmail;
    }

    public void setSecondaryEmail(String string) {
        this.secondaryEmail = string;
    }

    public String getSecondaryEmail() {
        return this.secondaryEmail;
    }

    public void setUseEmail(boolean bl) {
        this.useEmail = bl;
    }

    public boolean getUseEmail() {
        return this.useEmail;
    }

    public int getMaxEmails() {
        return this.maxEmails;
    }

    protected String getReportPrefix(String string) {
        return " *** " + string + " = ";
    }

    @Deprecated
    protected String getReportSuffix() {
        return " ***  <" + GameModule.getGameModule().getChatter().getHandle() + ">";
    }

    public void doInbuiltRoll(RollSet rollSet) {
        DieRoll[] dieRollArray = rollSet.getDieRolls();
        for (int i = 0; i < dieRollArray.length; ++i) {
            DieRoll dieRoll = dieRollArray[i];
            String string = dieRoll.getDescription();
            int n = dieRoll.getNumSides();
            int n2 = dieRoll.getNumDice();
            int n3 = dieRoll.getPlus();
            boolean bl = dieRoll.isReportTotal();
            String string2 = this.getReportPrefix(string);
            int n4 = 0;
            for (int j = 0; j < n2; ++j) {
                int n5 = this.ran.nextInt(n) + 1 + n3;
                if (bl) {
                    n4 += n5;
                } else {
                    string2 = string2 + n5;
                    if (j < n2 - 1) {
                        string2 = string2 + ",";
                    }
                }
                if (bl) {
                    string2 = string2 + n4;
                }
                string2 = string2 + this.getReportSuffix();
                GameModule.getGameModule().getChatter().send(string2);
            }
        }
    }

    public void doInternetRoll(final RollSet rollSet, final FormattedString formattedString) {
        new SwingWorker<Void, Void>(){

            public Void doInBackground() throws Exception {
                DieServer.this.doIRoll(rollSet);
                return null;
            }

            protected void done() {
                try {
                    this.get();
                    DieServer.this.reportResult(rollSet, formattedString);
                }
                catch (InterruptedException interruptedException) {
                    ErrorDialog.bug(interruptedException);
                }
                catch (ExecutionException executionException) {
                    logger.error("", (Throwable)executionException);
                    String string = "- Internet dice roll attempt " + rollSet.getDescription() + " failed.";
                    GameModule.getGameModule().getChatter().send(string);
                }
            }
        }.execute();
    }

    protected String formatResult(String string, String string2, FormattedString formattedString) {
        formattedString.setProperty("result", string2);
        formattedString.setProperty("rollDetails", string);
        String string3 = formattedString.getText();
        return string3.startsWith("*") ? "*" + string3 : "* " + string3;
    }

    public void reportResult(RollSet rollSet, FormattedString formattedString) {
        DieRoll[] dieRollArray = rollSet.getDieRolls();
        for (int i = 0; i < dieRollArray.length; ++i) {
            DieRoll dieRoll = dieRollArray[i];
            int n = dieRoll.getNumDice();
            boolean bl = dieRoll.isReportTotal();
            String string = "";
            int n2 = 0;
            for (int j = 0; j < n; ++j) {
                int n3 = dieRoll.getResult(j);
                if (bl) {
                    n2 += n3;
                    continue;
                }
                string = string + n3;
                if (j >= n - 1) continue;
                string = string + ",";
            }
            if (bl) {
                string = string + n2;
            }
            string = this.formatResult(dieRollArray[i].getDescription(), string, formattedString);
            GameModule.getGameModule().getChatter().send(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIRoll(RollSet rollSet) throws IOException {
        String[] stringArray = this.buildInternetRollString(rollSet);
        ArrayList<String> arrayList = new ArrayList<String>();
        URL uRL = new URL(this.serverURL);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(true);
        PrintWriter printWriter = new PrintWriter(uRLConnection.getOutputStream());
        try {
            for (String string : stringArray) {
                printWriter.println(string);
            }
            printWriter.close();
        }
        finally {
            IOUtils.closeQuietly((Writer)printWriter);
        }
        Object object = null;
        try {
            String string;
            object = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            while ((string = ((BufferedReader)object).readLine()) != null) {
                arrayList.add(string);
            }
            ((BufferedReader)object).close();
        }
        finally {
            IOUtils.closeQuietly((Reader)object);
        }
        this.parseInternetRollString(rollSet, new Vector<String>(arrayList));
    }

    public String extractEmail(String string) {
        int n = string.indexOf(60);
        int n2 = string.indexOf(62);
        if (n >= 0 && n2 >= 0 && n2 > n) {
            return string.substring(n + 1, n2);
        }
        return string;
    }
}

