/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.ConfigurerWindow;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiceButton
extends AbstractConfigurable {
    protected Random ran;
    protected int nSides = 6;
    protected int nDice = 2;
    protected int plus = 0;
    protected int addToTotal = 0;
    protected boolean reportTotal = false;
    protected boolean promptAlways = false;
    protected boolean sortDice = false;
    protected FormattedString reportFormat = new FormattedString("** $name$ = $result$ *** <$PlayerName$>");
    protected LaunchButton launch;
    protected String tooltip = "";
    protected MutableProperty.Impl property = new MutableProperty.Impl("", this);
    public static final String DEPRECATED_NAME = "label";
    public static final String BUTTON_TEXT = "text";
    public static final String TOOLTIP = "tooltip";
    public static final String NAME = "name";
    public static final String ICON = "icon";
    public static final String N_DICE = "nDice";
    public static final String N_SIDES = "nSides";
    public static final String PLUS = "plus";
    public static final String ADD_TO_TOTAL = "addToTotal";
    public static final String HOTKEY = "hotkey";
    public static final String REPORT_TOTAL = "reportTotal";
    public static final String PROMPT_ALWAYS = "prompt";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String SORT_DICE_RESULTS = "sortDice";
    public static final String RESULT = "result";
    public static final String REPORT_NAME = "name";
    private final VisibilityCondition cond = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return !DiceButton.this.promptAlways;
        }
    };
    private final VisibilityCondition canSort = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return !DiceButton.this.reportTotal;
        }
    };

    public DiceButton() {
        this.initLaunchButton();
    }

    protected void initLaunchButton() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DiceButton.this.promptAlways) {
                    DiceButton diceButton = new DiceButton(){

                        protected void initLaunchButton() {
                            this.launch = new LaunchButton(null, DiceButton.BUTTON_TEXT, DiceButton.HOTKEY, null);
                        }
                    };
                    List<String> list = Arrays.asList(DiceButton.N_DICE, DiceButton.N_SIDES, DiceButton.PLUS, DiceButton.ADD_TO_TOTAL);
                    for (String object2 : list) {
                        diceButton.setAttribute(object2, DiceButton.this.getAttributeValueString(object2));
                    }
                    AutoConfigurer autoConfigurer = new AutoConfigurer(diceButton);
                    ConfigurerWindow configurerWindow = new ConfigurerWindow(autoConfigurer, true);
                    for (String string : DiceButton.this.getAttributeNames()) {
                        if (list.contains(string)) continue;
                        Component component = autoConfigurer.getConfigurer(string).getControls();
                        component.getParent().remove(component);
                    }
                    configurerWindow.pack();
                    configurerWindow.setLocationRelativeTo(DiceButton.this.launch.getTopLevelAncestor());
                    configurerWindow.setVisible(true);
                    for (String string : list) {
                        DiceButton.this.setAttribute(string, diceButton.getAttributeValueString(string));
                    }
                    if (!configurerWindow.isCancelled()) {
                        DiceButton.this.DR();
                    }
                } else {
                    DiceButton.this.DR();
                }
            }
        };
        this.launch = new LaunchButton(null, TOOLTIP, BUTTON_TEXT, HOTKEY, ICON, actionListener);
        this.setAttribute("name", "2d6");
        this.setAttribute(BUTTON_TEXT, "2d6");
        this.launch.setAttribute(TOOLTIP, "2d6");
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.DiceButton.component_type");
    }

    @Deprecated
    protected String getReportPrefix() {
        return " *** " + this.getConfigureName() + " = ";
    }

    @Deprecated
    protected String getReportSuffix() {
        return " ***  <" + GameModule.getGameModule().getChatter().getHandle() + ">";
    }

    protected void DR() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.addToTotal;
        int[] nArray = null;
        if (!this.reportTotal && this.nDice > 1 && this.sortDice) {
            nArray = new int[this.nDice];
        }
        for (n = 0; n < this.nDice; ++n) {
            int n3 = this.ran.nextInt(this.nSides) + 1 + this.plus;
            if (nArray != null) {
                nArray[n] = n3;
                continue;
            }
            if (this.reportTotal) {
                n2 += n3;
                continue;
            }
            stringBuilder.append(n3);
            if (n >= this.nDice - 1) continue;
            stringBuilder.append(",");
        }
        if (this.reportTotal) {
            stringBuilder.append(n2);
        } else if (nArray != null) {
            Arrays.sort(nArray);
            for (n = 0; n < this.nDice; ++n) {
                stringBuilder.append(nArray[n]);
                if (n >= this.nDice - 1) continue;
                stringBuilder.append(",");
            }
        }
        String string = this.formatResult(stringBuilder.toString());
        Command command = string.length() == 0 ? new NullCommand() : new Chatter.DisplayText(GameModule.getGameModule().getChatter(), string);
        command.execute();
        command.append(this.property.setPropertyValue(stringBuilder.toString()));
        GameModule.getGameModule().sendAndLog(command);
    }

    protected String formatResult(String string) {
        String string2;
        this.reportFormat.setProperty("name", this.getLocalizedConfigureName());
        this.reportFormat.setProperty(RESULT, string);
        this.reportFormat.setProperty(N_DICE, Integer.toString(this.nDice));
        this.reportFormat.setProperty(N_SIDES, Integer.toString(this.nSides));
        this.reportFormat.setProperty(PLUS, Integer.toString(this.plus));
        this.reportFormat.setProperty(ADD_TO_TOTAL, Integer.toString(this.addToTotal));
        String string3 = string2 = this.reportFormat.getLocalizedText();
        if (string2.length() > 0) {
            string3 = string2.startsWith("*") ? "*" + string2 : "* " + string2;
        }
        return string3;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"name", BUTTON_TEXT, TOOLTIP, ICON, N_DICE, N_SIDES, PLUS, ADD_TO_TOTAL, REPORT_TOTAL, HOTKEY, PROMPT_ALWAYS, REPORT_FORMAT, SORT_DICE_RESULTS};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Dice.number_of_dice"), Resources.getString("Dice.number_of_sides"), Resources.getString("Dice.add_to_each_side"), Resources.getString("Dice.add_to_total"), Resources.getString("Editor.DiceButton.report_total"), Resources.getString("Editor.hotkey_label"), Resources.getString("Editor.DiceButton.prompt_value"), Resources.getString("Editor.report_format"), Resources.getString("Editor.DiceButton.sort_results")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, String.class, IconConfig.class, Integer.class, Integer.class, Integer.class, Integer.class, Boolean.class, NamedKeyStroke.class, Boolean.class, ReportFormatConfig.class, Boolean.class};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (N_DICE.equals(string) || N_SIDES.equals(string) || PLUS.equals(string) || ADD_TO_TOTAL.equals(string)) {
            return this.cond;
        }
        if (SORT_DICE_RESULTS.equals(string)) {
            return this.canSort;
        }
        return null;
    }

    @Override
    public void addTo(Buildable buildable) {
        this.ran = GameModule.getGameModule().getRNG();
        GameModule.getGameModule().getToolBar().add(this.getComponent());
        this.property.setPropertyValue("1");
        this.property.addTo((MutablePropertiesContainer)((Object)buildable));
    }

    protected Component getComponent() {
        return this.launch;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (DEPRECATED_NAME.equals(string)) {
            this.setAttribute("name", object);
            this.setAttribute(BUTTON_TEXT, object);
        } else if ("name".equals(string)) {
            this.setConfigureName((String)object);
            this.property.setPropertyName(this.getConfigureName() + "_result");
            this.launch.setToolTipText((String)object);
        } else if (N_DICE.equals(string)) {
            if (object instanceof Integer) {
                this.nDice = (Integer)object;
            } else if (object instanceof String) {
                this.nDice = Integer.parseInt((String)object);
            }
        } else if (N_SIDES.equals(string)) {
            if (object instanceof Integer) {
                this.nSides = (Integer)object;
            } else if (object instanceof String) {
                this.nSides = Integer.parseInt((String)object);
            }
        } else if (PLUS.equals(string)) {
            if (object instanceof Integer) {
                this.plus = (Integer)object;
            } else if (object instanceof String) {
                this.plus = Integer.parseInt((String)object);
            }
        } else if (ADD_TO_TOTAL.equals(string)) {
            if (object instanceof Integer) {
                this.addToTotal = (Integer)object;
            } else if (object instanceof String) {
                this.addToTotal = Integer.parseInt((String)object);
            }
        } else if (REPORT_TOTAL.equals(string)) {
            if (object instanceof Boolean) {
                this.reportTotal = (Boolean)object;
            } else if (object instanceof String) {
                this.reportTotal = "true".equals(object);
            }
        } else if (PROMPT_ALWAYS.equals(string)) {
            if (object instanceof Boolean) {
                this.promptAlways = (Boolean)object;
            } else if (object instanceof String) {
                this.promptAlways = "true".equals(object);
            }
        } else if (REPORT_FORMAT.equals(string)) {
            this.reportFormat.setFormat((String)object);
        } else if (TOOLTIP.equals(string)) {
            this.tooltip = (String)object;
            this.launch.setAttribute(string, object);
        } else if (SORT_DICE_RESULTS.equals(string)) {
            if (object instanceof Boolean) {
                this.sortDice = (Boolean)object;
            } else if (object instanceof String) {
                this.sortDice = "true".equals(object);
            }
        } else {
            this.launch.setAttribute(string, object);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if ("name".equals(string)) {
            return this.getConfigureName();
        }
        if (N_DICE.equals(string)) {
            return String.valueOf(this.nDice);
        }
        if (N_SIDES.equals(string)) {
            return String.valueOf(this.nSides);
        }
        if (PLUS.equals(string)) {
            return String.valueOf(this.plus);
        }
        if (ADD_TO_TOTAL.equals(string)) {
            return String.valueOf(this.addToTotal);
        }
        if (REPORT_TOTAL.equals(string)) {
            return String.valueOf(this.reportTotal);
        }
        if (PROMPT_ALWAYS.equals(string)) {
            return String.valueOf(this.promptAlways);
        }
        if (REPORT_FORMAT.equals(string)) {
            return this.reportFormat.getFormat();
        }
        if (TOOLTIP.equals(string)) {
            return this.tooltip.length() == 0 ? this.launch.getAttributeValueString(BUTTON_TEXT) : this.tooltip;
        }
        if (SORT_DICE_RESULTS.equals(string)) {
            return String.valueOf(this.sortDice);
        }
        return this.launch.getAttributeValueString(string);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void removeFrom(Buildable buildable) {
        GameModule.getGameModule().getToolBar().remove(this.getComponent());
        GameModule.getGameModule().getToolBar().revalidate();
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "DiceButton");
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getConfigureName() + "_result");
        return arrayList;
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[]{"name", DiceButton.RESULT, DiceButton.N_DICE, DiceButton.N_SIDES, DiceButton.PLUS, DiceButton.ADD_TO_TOTAL});
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, "/images/die.gif");
        }
    }
}

