/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.build.module.ExtensionsLoader;
import VASSAL.build.module.ModuleExtension;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.launch.AbstractLaunchAction;
import VASSAL.launch.BasicModule;
import VASSAL.launch.LaunchRequest;
import VASSAL.launch.Launcher;
import VASSAL.launch.ModuleManagerWindow;
import VASSAL.launch.PlayerWindow;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.JarArchive;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.menu.MacOSXMenuManager;
import VASSAL.tools.menu.MenuBarProxy;
import VASSAL.tools.menu.MenuManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import org.apache.commons.lang.SystemUtils;

public class Player
extends Launcher {
    public static void main(String[] stringArray) {
        new Player(stringArray);
    }

    protected Player(String[] stringArray) {
        super(stringArray);
    }

    protected MenuManager createMenuManager() {
        return SystemUtils.IS_OS_MAC_OSX ? new MacOSXMenuManager() : new PlayerMenuManager();
    }

    protected void launch() throws IOException {
        if (this.lr.builtInModule) {
            GameModule.init(this.createModule(this.createDataArchive()));
            if (this.lr.autoext != null) {
                for (String string : this.lr.autoext) {
                    this.createExtension(string).build();
                }
            }
            this.createExtensionsLoader().addTo(GameModule.getGameModule());
            Localization.getInstance().translate();
            GameModule.getGameModule().getWizardSupport().showWelcomeWizard();
        } else {
            GameModule.init(this.createModule(this.createDataArchive()));
            this.createExtensionsLoader().addTo(GameModule.getGameModule());
            Localization.getInstance().translate();
            GameModule gameModule = GameModule.getGameModule();
            if (this.lr.game != null) {
                gameModule.getFrame().setVisible(true);
                gameModule.getGameState().loadGameInBackground(this.lr.game);
            } else {
                gameModule.getWizardSupport().showWelcomeWizard();
            }
        }
        if (this.ipc != null) {
            try {
                this.ipc.send(new AbstractLaunchAction.NotifyOpenModuleOk(this.lr));
            }
            catch (IOException iOException) {
                ErrorDialog.showDetails(iOException, ThrowableUtils.getStackTrace(iOException), "Error.socket_error", new Object[0]);
            }
        }
    }

    protected ExtensionsLoader createExtensionsLoader() {
        return new ExtensionsLoader();
    }

    protected ModuleExtension createExtension(String string) {
        return new ModuleExtension(new JarArchive(string));
    }

    protected DataArchive createDataArchive() throws IOException {
        if (this.lr.builtInModule) {
            return new JarArchive();
        }
        return new DataArchive(this.lr.module.getPath());
    }

    protected GameModule createModule(DataArchive dataArchive) {
        return new BasicModule(dataArchive);
    }

    private static class PlayerMenuManager
    extends MenuManager {
        private final MenuBarProxy menuBar = new MenuBarProxy();

        private PlayerMenuManager() {
        }

        public JMenuBar getMenuBarFor(JFrame jFrame) {
            return jFrame instanceof PlayerWindow ? this.menuBar.createPeer() : null;
        }

        public MenuBarProxy getMenuBarProxyFor(JFrame jFrame) {
            return jFrame instanceof PlayerWindow ? this.menuBar : null;
        }
    }

    public static class PromptLaunchAction
    extends LaunchAction {
        private static final long serialVersionUID = 1L;

        public PromptLaunchAction(ModuleManagerWindow moduleManagerWindow) {
            super(moduleManagerWindow, null);
            this.putValue("Name", Resources.getString("Main.play_module"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.promptForFile() == null) {
                return;
            }
            AbstractMetaData abstractMetaData = MetaDataFactory.buildMetaData(this.lr.module);
            if (abstractMetaData != null && Info.isModuleTooNew(abstractMetaData.getVassalVersion())) {
                ErrorDialog.show("Error.module_too_new", this.lr.module.getPath(), abstractMetaData.getVassalVersion(), Info.getVersion());
                return;
            }
            super.actionPerformed(actionEvent);
        }
    }

    public static class LaunchAction
    extends AbstractLaunchAction {
        private static final long serialVersionUID = 1L;

        public LaunchAction(ModuleManagerWindow moduleManagerWindow, File file) {
            super(Resources.getString("Main.play_module_specific"), moduleManagerWindow, Player.class.getName(), new LaunchRequest(LaunchRequest.Mode.LOAD, file));
            this.setEnabled(!editing.contains(file));
        }

        public LaunchAction(ModuleManagerWindow moduleManagerWindow, File file, File file2) {
            super(Resources.getString("General.open"), moduleManagerWindow, Player.class.getName(), new LaunchRequest(LaunchRequest.Mode.LOAD, file, file2));
            this.setEnabled(!editing.contains(file));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Object object;
            AbstractMetaData abstractMetaData = MetaDataFactory.buildMetaData(this.lr.module);
            if (abstractMetaData != null && abstractMetaData instanceof ModuleMetaData && Info.compareVersions(((AbstractMetaData)(object = (ModuleMetaData)abstractMetaData)).getVassalVersion(), "3.2.0") < 0) {
                if ("VASL".equals(((ModuleMetaData)object).getName())) {
                    ErrorDialog.show("Error.VASL_too_old", Info.getVersion());
                    return;
                }
                if ("VSQL".equals(((ModuleMetaData)object).getName())) {
                    ErrorDialog.show("Error.VSQL_too_old", Info.getVersion());
                    return;
                }
            }
            if (editing.contains(this.lr.module)) {
                return;
            }
            object = (Integer)using.get(this.lr.module);
            File file = this.lr.module;
            if (object == null) {
                n = 1;
            } else {
                object = (Integer)object + 1;
                n = (Integer)object;
            }
            using.put(file, n);
            super.actionPerformed(actionEvent);
        }

        protected AbstractLaunchAction.LaunchTask getLaunchTask() {
            return new AbstractLaunchAction.LaunchTask(){

                protected void done() {
                    super.done();
                    Integer n = AbstractLaunchAction.using.get(this.lr.module);
                    if (n == 1) {
                        AbstractLaunchAction.using.remove(this.lr.module);
                    } else {
                        n = n - 1;
                        AbstractLaunchAction.using.put(this.lr.module, n);
                    }
                }
            };
        }
    }
}

