/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.counters.GamePiece;
import VASSAL.counters.Highlighter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;

public class ColoredBorder
implements Highlighter {
    protected Color c;
    protected int thickness;
    protected List<Highlighter> highlighters = new ArrayList<Highlighter>();

    public ColoredBorder() {
        this(Color.black, 3);
    }

    public ColoredBorder(Color color, int n) {
        this.c = color;
        this.thickness = n;
    }

    public void addHighlighter(Highlighter highlighter) {
        this.highlighters.add(highlighter);
    }

    public void removeHighlighter(Highlighter highlighter) {
        this.highlighters.remove(highlighter);
    }

    public void draw(GamePiece gamePiece, Graphics graphics, int n, int n2, Component component, double d) {
        if (this.thickness > 0) {
            if (this.c != null) {
                Shape shape = gamePiece.getShape();
                Rectangle object = shape.getBounds();
                if (!object.isEmpty()) {
                    double d2 = (object.getWidth() + 1.0) / object.getWidth();
                    double d3 = (object.getHeight() + 1.0) / object.getHeight();
                    AffineTransform affineTransform = AffineTransform.getTranslateInstance(n, n2);
                    affineTransform.scale(d2 * d, d3 * d);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Stroke stroke = graphics2D.getStroke();
                    graphics2D.setStroke(new BasicStroke(Math.max(1L, Math.round(d * (double)this.thickness))));
                    graphics2D.setColor(this.c);
                    graphics2D.draw(affineTransform.createTransformedShape(shape));
                    graphics2D.setStroke(stroke);
                }
            } else {
                this.highlightSelectionBounds(gamePiece, graphics, n, n2, component, d);
            }
        }
        for (Highlighter highlighter : this.highlighters) {
            highlighter.draw(gamePiece, graphics, n, n2, component, d);
        }
    }

    protected void highlightSelectionBounds(GamePiece gamePiece, Graphics graphics, int n, int n2, Component component, double d) {
        Rectangle rectangle = gamePiece.getShape().getBounds();
        graphics.setColor(this.c);
        for (int i = 1; i < this.thickness; ++i) {
            graphics.drawRect(n + (int)(d * (double)rectangle.x) - i, n2 + (int)(d * (double)rectangle.y) - i, (int)(d * (double)rectangle.width) + 2 * i - 1, (int)(d * (double)rectangle.height) + 2 * i - 1);
        }
    }

    public Rectangle boundingBox(GamePiece gamePiece) {
        Rectangle rectangle = gamePiece.getShape().getBounds();
        rectangle.translate(-this.thickness, -this.thickness);
        rectangle.setSize(rectangle.width + 2 * this.thickness, rectangle.height + 2 * this.thickness);
        for (Highlighter highlighter : this.highlighters) {
            rectangle.add(highlighter.boundingBox(gamePiece));
        }
        return rectangle;
    }

    public void setColor(Color color) {
        this.c = color;
    }

    public Color getColor() {
        return this.c;
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int n) {
        this.thickness = n;
    }
}

