/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.command;

import VASSAL.command.NullCommand;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ThrowableUtils;
import java.util.LinkedList;
import java.util.ListIterator;

public abstract class Command {
    private LinkedList<Command> seq = new LinkedList();
    private Command undo;

    public Command[] getSubCommands() {
        return this.seq.toArray(new Command[this.seq.size()]);
    }

    public void execute() {
        try {
            this.executeCommand();
        }
        catch (Throwable throwable) {
            this.handleFailure(throwable);
            LinkedList<Command> object = this.seq;
            this.stripSubCommands();
            this.seq = object;
        }
        for (Command command : this.seq) {
            try {
                command.execute();
            }
            catch (Throwable throwable) {
                this.handleFailure(throwable);
            }
        }
    }

    private void handleFailure(Throwable throwable) {
        ThrowableUtils.throwRecent(OutOfMemoryError.class, throwable);
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        ErrorDialog.bug(throwable);
    }

    protected abstract void executeCommand();

    protected abstract Command myUndoCommand();

    public void stripSubCommands() {
        this.seq = new LinkedList();
    }

    public boolean isNull() {
        return false;
    }

    public boolean isLoggable() {
        return !this.isNull();
    }

    @Deprecated
    protected boolean hasNullSubcommands() {
        return this.isAtomic();
    }

    protected boolean isAtomic() {
        for (Command command : this.seq) {
            if (command.isNull()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        String string = this.getDetails();
        if (string != null) {
            stringBuilder.append("[").append(string).append("]");
        }
        for (Command command : this.seq) {
            stringBuilder.append("+").append(command.toString());
        }
        return stringBuilder.toString();
    }

    public String getDetails() {
        return null;
    }

    public Command append(Command command) {
        Command command2 = this;
        if (command != null && !command.isNull()) {
            if (this.isNull()) {
                command2 = command;
            }
            this.seq.add(command);
        }
        return command2;
    }

    public Command getUndoCommand() {
        if (this.undo == null) {
            this.undo = new NullCommand();
            ListIterator<Command> listIterator = this.seq.listIterator(this.seq.size());
            while (listIterator.hasPrevious()) {
                this.undo = this.undo.append(listIterator.previous().getUndoCommand());
            }
            this.undo = this.undo.append(this.myUndoCommand());
        }
        return this.undo;
    }
}

