/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.LockableChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SoundEncoder;
import VASSAL.chat.ui.PlayerActionFactory;
import VASSAL.configure.SoundConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTree;

public class SendSoundAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static Room lastRoom;
    private static Player lastPlayer;
    private static long lastSound;
    private ChatServerConnection client;
    private Player target;
    private String soundKey;

    public SendSoundAction(String string, ChatServerConnection chatServerConnection, String string2, Player player) {
        super(string);
        this.client = chatServerConnection;
        this.soundKey = string2;
        this.target = player;
        Room room = null;
        for (Room room2 : chatServerConnection.getAvailableRooms()) {
            if (!room2.getPlayerList().contains(player)) continue;
            room = room2;
        }
        if (!(player == null || GameModule.getGameModule() == null || player.equals(chatServerConnection.getUserInfo()) || chatServerConnection.getRoom() == null || !chatServerConnection.getRoom().equals(room) || room.equals(lastRoom) && player.equals(lastPlayer) && System.currentTimeMillis() - lastSound <= 10000L)) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.client.sendTo(this.target, new SoundEncoder.Cmd(this.soundKey, this.client.getUserInfo()));
        lastPlayer = this.target;
        lastRoom = this.client.getRoom();
        lastSound = System.currentTimeMillis();
    }

    public static PlayerActionFactory factory(final ChatServerConnection chatServerConnection, final String string, final String string2, String string3) {
        if (GameModule.getGameModule() != null) {
            Prefs.getGlobalPrefs().addOption(Resources.getString("Prefs.sounds_tab"), new SoundConfigurer(string2, string, string3));
        }
        return new PlayerActionFactory(){

            public Action getAction(SimplePlayer simplePlayer, JTree jTree) {
                Room room = chatServerConnection.getRoom();
                if (chatServerConnection instanceof LockableChatServerConnection && ((LockableChatServerConnection)chatServerConnection).isDefaultRoom(room)) {
                    return null;
                }
                return new SendSoundAction(string, chatServerConnection, string2, simplePlayer);
            }
        };
    }

    static {
        lastSound = System.currentTimeMillis();
    }
}

