/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.tree.AttributeCollection;
import javax.xml.transform.TransformerConfigurationException;

public class XSLNamespaceAlias
extends StyleElement {
    private short stylesheetURICode;
    private short resultURICode;

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        String string2 = null;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            int n2 = n & 0xFFFFF;
            if (n2 == standardNames.STYLESHEET_PREFIX) {
                string = attributeCollection.getValue(i);
                continue;
            }
            if (n2 == standardNames.RESULT_PREFIX) {
                string2 = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string == null) {
            this.reportAbsence("stylesheet-prefix");
            return;
        }
        if (string.equals("#default")) {
            string = "";
        }
        if (string2 == null) {
            this.reportAbsence("result-prefix");
            return;
        }
        if (string2.equals("#default")) {
            string2 = "";
        }
        try {
            this.stylesheetURICode = this.getURICodeForPrefix(string);
            this.resultURICode = this.getURICodeForPrefix(string2);
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage());
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
    }

    @Override
    public void preprocess() throws TransformerConfigurationException {
    }

    @Override
    public void process(Context context) {
    }

    public short getStylesheetURICode() {
        return this.stylesheetURICode;
    }

    public short getResultURICode() {
        return this.resultURICode;
    }
}

