/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;

public class StringFn
extends Function {
    @Override
    public String getName() {
        return "string";
    }

    @Override
    public int getDataType() {
        return 3;
    }

    @Override
    public Expression simplify() throws XPathException {
        int n = this.checkArgumentCount(0, 1);
        if (n == 1) {
            this.argument[0] = this.argument[0].simplify();
            if (this.argument[0].getDataType() == 3) {
                return this.argument[0];
            }
            if (this.argument[0] instanceof Value) {
                return new StringValue(((Value)this.argument[0]).asString());
            }
        }
        return this;
    }

    @Override
    public String evaluateAsString(Context context) throws XPathException {
        if (this.getNumberOfArguments() == 1) {
            return this.argument[0].evaluateAsString(context);
        }
        return context.getContextNodeInfo().getStringValue();
    }

    @Override
    public Value evaluate(Context context) throws XPathException {
        return new StringValue(this.evaluateAsString(context));
    }

    @Override
    public int getDependencies() {
        if (this.getNumberOfArguments() == 1) {
            return this.argument[0].getDependencies();
        }
        return 8;
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        if (this.getNumberOfArguments() == 1) {
            StringFn stringFn = new StringFn();
            stringFn.addArgument(this.argument[0].reduce(n, context));
            stringFn.setStaticContext(this.getStaticContext());
            return stringFn.simplify();
        }
        if ((n & 8) != 0) {
            return this.evaluate(context);
        }
        return this;
    }
}

