/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeInfo;

public class Lang
extends Function {
    @Override
    public String getName() {
        return "lang";
    }

    @Override
    public int getDataType() {
        return 1;
    }

    @Override
    public Expression simplify() throws XPathException {
        this.checkArgumentCount(1, 1);
        this.argument[0] = this.argument[0].simplify();
        return this;
    }

    @Override
    public boolean evaluateAsBoolean(Context context) throws XPathException {
        return Lang.isLang(this.argument[0].evaluateAsString(context), context);
    }

    @Override
    public Value evaluate(Context context) throws XPathException {
        return new BooleanValue(this.evaluateAsBoolean(context));
    }

    @Override
    public int getDependencies() {
        return 8 | this.argument[0].getDependencies();
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        Lang lang = new Lang();
        lang.addArgument(this.argument[0].reduce(n, context));
        lang.setStaticContext(this.getStaticContext());
        return lang.simplify();
    }

    private static boolean isLang(String string, Context context) throws XPathException {
        String string2 = null;
        for (NodeInfo nodeInfo = context.getContextNodeInfo(); nodeInfo != null && (string2 = nodeInfo.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang")) == null; nodeInfo = nodeInfo.getParent()) {
        }
        if (string2 == null) {
            return false;
        }
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        int n = string2.indexOf("-");
        if (n < 0) {
            return false;
        }
        return string.equalsIgnoreCase(string2 = string2.substring(0, n));
    }
}

