/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.measurement;

import org.osgi.util.measurement.Unit;

public class Measurement
implements Comparable {
    private final double value;
    private final double error;
    private final long time;
    private final Unit unit;
    private transient String name;
    private transient int hashCode;

    public Measurement(double d, double d2, Unit unit, long l) {
        this.value = d;
        this.error = Math.abs(d2);
        this.unit = unit != null ? unit : Unit.unity;
        this.time = l;
        this.name = null;
        this.hashCode = 0;
    }

    public Measurement(double d, double d2, Unit unit) {
        this(d, d2, unit, 0L);
    }

    public Measurement(double d, Unit unit) {
        this(d, 0.0, unit, 0L);
    }

    public Measurement(double d) {
        this(d, 0.0, null, 0L);
    }

    public final double getValue() {
        return this.value;
    }

    public final double getError() {
        return this.error;
    }

    public final Unit getUnit() {
        return this.unit;
    }

    public final long getTime() {
        return this.time;
    }

    public Measurement mul(Measurement measurement) {
        double d = measurement.value;
        return new Measurement(this.value * d, Math.abs(this.value) * measurement.error + this.error * Math.abs(d), this.unit.mul(measurement.unit), this.time);
    }

    public Measurement mul(double d, Unit unit) {
        return new Measurement(this.value * d, this.error * Math.abs(d), this.unit.mul(unit), this.time);
    }

    public Measurement mul(double d) {
        return new Measurement(this.value * d, this.error * Math.abs(d), this.unit, this.time);
    }

    public Measurement div(Measurement measurement) {
        double d = measurement.value;
        return new Measurement(this.value / d, (Math.abs(this.value) * measurement.error + this.error * Math.abs(d)) / (d * d), this.unit.div(measurement.unit), this.time);
    }

    public Measurement div(double d, Unit unit) {
        return new Measurement(this.value / d, this.error / Math.abs(d), this.unit.div(unit), this.time);
    }

    public Measurement div(double d) {
        return new Measurement(this.value / d, this.error / Math.abs(d), this.unit, this.time);
    }

    public Measurement add(Measurement measurement) {
        return new Measurement(this.value + measurement.value, this.error + measurement.error, this.unit.add(measurement.unit), this.time);
    }

    public Measurement add(double d, Unit unit) {
        return new Measurement(this.value + d, this.error, this.unit.add(unit), this.time);
    }

    public Measurement add(double d) {
        return new Measurement(this.value + d, this.error, this.unit, this.time);
    }

    public Measurement sub(Measurement measurement) {
        return new Measurement(this.value - measurement.value, this.error + measurement.error, this.unit.sub(measurement.unit), this.time);
    }

    public Measurement sub(double d, Unit unit) {
        return new Measurement(this.value - d, this.error, this.unit.sub(unit), this.time);
    }

    public Measurement sub(double d) {
        return new Measurement(this.value - d, this.error, this.unit, this.time);
    }

    public String toString() {
        String string = this.name;
        if (string == null) {
            String string2;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.value);
            if (this.error != 0.0) {
                stringBuffer.append(" +/- ");
                stringBuffer.append(this.error);
            }
            if ((string2 = this.unit.toString()).length() > 0) {
                stringBuffer.append(" ");
                stringBuffer.append(string2);
            }
            this.name = string = stringBuffer.toString();
        }
        return string;
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        Measurement measurement = (Measurement)object;
        if (!this.unit.equals(measurement.unit)) {
            throw new ArithmeticException("Cannot compare " + this + " and " + measurement);
        }
        int n = Double.compare(this.value, measurement.value);
        if (n == 0) {
            return 0;
        }
        if (n < 0) {
            if (Double.compare(this.value + this.error, measurement.value - measurement.error) >= 0) {
                return 0;
            }
            return -1;
        }
        if (Double.compare(this.value - this.error, measurement.value + measurement.error) <= 0) {
            return 0;
        }
        return 1;
    }

    public int hashCode() {
        int n = this.hashCode;
        if (n == 0) {
            long l = Double.doubleToLongBits(this.value);
            n = 527 + (int)(l ^ l >>> 32);
            l = Double.doubleToLongBits(this.error);
            n = 31 * n + (int)(l ^ l >>> 32);
            this.hashCode = n = 31 * n + this.unit.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Measurement)) {
            return false;
        }
        Measurement measurement = (Measurement)object;
        return Double.compare(this.value, measurement.value) == 0 && Double.compare(this.error, measurement.error) == 0 && this.unit.equals(measurement.unit);
    }
}

