/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.dmt;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.osgi.service.dmt.DmtIllegalStateException;

public final class DmtData {
    public static final int FORMAT_INTEGER = 1;
    public static final int FORMAT_FLOAT = 2;
    public static final int FORMAT_STRING = 4;
    public static final int FORMAT_BOOLEAN = 8;
    public static final int FORMAT_DATE = 16;
    public static final int FORMAT_TIME = 32;
    public static final int FORMAT_BINARY = 64;
    public static final int FORMAT_BASE64 = 128;
    public static final int FORMAT_XML = 256;
    public static final int FORMAT_NULL = 512;
    public static final int FORMAT_NODE = 1024;
    public static final int FORMAT_RAW_STRING = 2048;
    public static final int FORMAT_RAW_BINARY = 4096;
    public static final int FORMAT_LONG = 8192;
    public static final int FORMAT_DATE_TIME = 16384;
    private static final Map FORMAT_NAMES = new HashMap();
    public static final DmtData NULL_VALUE;
    public static final DmtData TRUE_VALUE;
    public static final DmtData FALSE_VALUE;
    private final int format;
    private final Object value;
    private String formatName;
    private static char[] hex;

    private DmtData() {
        this(null, 512, null);
    }

    public DmtData(String string) {
        this(string, 4, null);
    }

    public DmtData(Date date) {
        if (date == null) {
            throw new NullPointerException("The date argument is null.");
        }
        this.format = 16384;
        this.value = date;
    }

    public DmtData(Object object) {
        if (object == null) {
            throw new NullPointerException("Complex data argument is null.");
        }
        this.format = 1024;
        this.value = object;
    }

    public DmtData(String string, int n) {
        this(string, n, null);
        if (n == 4 || n == 256 || n == 16 || n == 32) {
            return;
        }
        throw new IllegalArgumentException("Wrong format for DmtData(String,int), format must be one of FORMAT_STRING, FORMAT_XML, FORMAT_DATE, or FORMAT_TIME");
    }

    public DmtData(int n) {
        this(new Integer(n), 1, null);
    }

    public DmtData(float f) {
        this(new Float(f), 2, null);
    }

    public DmtData(long l) {
        this(new Long(l), 8192, null);
    }

    public DmtData(boolean bl) {
        this(bl, 8, null);
    }

    public DmtData(byte[] byArray) {
        this(byArray, 64, null);
    }

    public DmtData(byte[] byArray, boolean bl) {
        this(byArray, bl ? 128 : 64, null);
    }

    public DmtData(byte[] byArray, int n) {
        this(byArray, n, null);
        if (n == 64 || n == 128) {
            return;
        }
        throw new IllegalArgumentException("Invalid format for DmtDate(byte[],format), only FORMAT_BINARY and FORMAT_BASE64 are allowed");
    }

    public DmtData(String string, String string2) {
        this(string2.toString(), 2048, string.toString());
    }

    private DmtData(Object object, int n, String string) {
        this.value = object;
        this.format = n;
        this.formatName = string;
        this.validate();
    }

    public DmtData(String string, byte[] byArray) {
        this(byArray, 4096, string);
        if (string == null) {
            throw new NullPointerException("Format name argument is null.");
        }
    }

    private void validate() {
        Class clazz;
        switch (this.format) {
            case 1: {
                clazz = Integer.class;
                break;
            }
            case 2: {
                clazz = Float.class;
                break;
            }
            case 32: {
                DmtData.checkTimeFormat((String)this.value);
                clazz = String.class;
                break;
            }
            case 16: {
                DmtData.checkDateFormat((String)this.value);
                clazz = String.class;
                break;
            }
            case 4: 
            case 256: {
                clazz = String.class;
                if (this.value != null) break;
                return;
            }
            case 2048: {
                clazz = String.class;
                break;
            }
            case 8: {
                clazz = Boolean.class;
                break;
            }
            case 64: 
            case 128: 
            case 4096: {
                if (this.value != null) {
                    clazz = byte[].class;
                    break;
                }
                throw new NullPointerException("The bytes argument is null.");
            }
            case 512: {
                if (this.value != null) {
                    throw new IllegalArgumentException("Format is null but value is not ");
                }
                return;
            }
            case 1024: {
                clazz = Object.class;
                break;
            }
            case 8192: {
                clazz = Long.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid format number for DmtData " + this.format);
            }
        }
        if (!clazz.isInstance(this.value)) {
            throw new IllegalArgumentException("Invalid type type for DmtData, expected " + clazz.getClass() + " but have " + this.value.getClass());
        }
    }

    public String getString() {
        if (this.format == 4) {
            return (String)this.value;
        }
        throw new DmtIllegalStateException("DmtData value is not string.");
    }

    public String getDate() {
        if (this.format == 16) {
            return (String)this.value;
        }
        throw new DmtIllegalStateException("DmtData value is not date.");
    }

    public String getTime() {
        if (this.format == 32) {
            return (String)this.value;
        }
        throw new DmtIllegalStateException("DmtData value is not time.");
    }

    public Date getDateTime() {
        if (this.format == 16384) {
            return (Date)this.value;
        }
        throw new DmtIllegalStateException("DmtData value is not dateTime.");
    }

    public String getXml() {
        if (this.format == 256) {
            return (String)this.value;
        }
        throw new DmtIllegalStateException("DmtData value is not XML.");
    }

    public int getInt() {
        if (this.format == 1) {
            return (Integer)this.value;
        }
        throw new DmtIllegalStateException("DmtData value is not integer.");
    }

    public long getLong() {
        if (this.format == 8192) {
            return (Long)this.value;
        }
        throw new DmtIllegalStateException("DmtData value is not long.");
    }

    public float getFloat() {
        if (this.format == 2) {
            return ((Float)this.value).floatValue();
        }
        throw new DmtIllegalStateException("DmtData value is not float.");
    }

    public boolean getBoolean() {
        if (this.format == 8) {
            return (Boolean)this.value;
        }
        throw new DmtIllegalStateException("DmtData value is not boolean.");
    }

    public byte[] getBinary() {
        if (this.format == 64) {
            return this.copyBytes();
        }
        throw new DmtIllegalStateException("DmtData value is not a byte array.");
    }

    private byte[] copyBytes() {
        byte[] byArray = (byte[])this.value;
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public byte[] getRawBinary() {
        if (this.format == 4096) {
            return this.copyBytes();
        }
        throw new DmtIllegalStateException("DmtData value is not in raw binary format.");
    }

    public String getRawString() {
        if (this.format == 2048) {
            return (String)this.value;
        }
        throw new DmtIllegalStateException("DmtData value is not in raw string format.");
    }

    public byte[] getBase64() {
        if (this.format == 128) {
            return this.copyBytes();
        }
        throw new DmtIllegalStateException("DmtData value is not in base 64 format.");
    }

    public Object getNode() {
        if (this.format == 1024) {
            return this.value;
        }
        throw new DmtIllegalStateException("DmtData does not contain interior node data.");
    }

    public int getFormat() {
        return this.format;
    }

    public String getFormatName() {
        if (this.formatName == null) {
            return DmtData.getFormatName(this.format);
        }
        return this.formatName;
    }

    public int getSize() {
        switch (this.format) {
            case 4: 
            case 16: 
            case 32: 
            case 256: 
            case 2048: {
                if (this.value != null) {
                    return ((String)this.value).length();
                }
                return 0;
            }
            case 64: 
            case 128: 
            case 4096: {
                return ((byte[])this.value).length;
            }
            case 1: 
            case 2: {
                return 4;
            }
            case 8: {
                return 1;
            }
            case 1024: {
                return -1;
            }
            case 8192: 
            case 16384: {
                return 8;
            }
            case 512: {
                return 0;
            }
        }
        return 0;
    }

    public String toString() {
        switch (this.format) {
            case 4: 
            case 16: 
            case 32: 
            case 256: 
            case 2048: {
                if (this.value != null) {
                    return (String)this.value;
                }
                return "";
            }
            case 1: 
            case 2: 
            case 8: 
            case 1024: 
            case 8192: {
                return this.value.toString();
            }
            case 64: 
            case 128: 
            case 4096: {
                return DmtData.getHexDump((byte[])this.value);
            }
            case 512: {
                return "null";
            }
            case 16384: {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:SS'Z'");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                return simpleDateFormat.format(this.value);
            }
        }
        throw new IllegalStateException("Invalid format " + this.format);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DmtData)) {
            return false;
        }
        DmtData dmtData = (DmtData)object;
        if (this.format != dmtData.format) {
            return false;
        }
        if (this.formatName != null && !this.formatName.equals(dmtData.formatName)) {
            return false;
        }
        if (this.value == null) {
            return dmtData.value == null;
        }
        if (this.value.equals(dmtData.value)) {
            return true;
        }
        switch (this.format) {
            case 64: 
            case 128: 
            case 4096: {
                return Arrays.equals((byte[])this.value, (byte[])dmtData.value);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.value == null) {
            return 42;
        }
        return this.value.hashCode();
    }

    private static void checkDateFormat(String string) {
        if (string.length() != 8) {
            throw new IllegalArgumentException("Date string '" + string + "' does not follow the format 'CCYYMMDD'.");
        }
        int n = DmtData.checkNumber(string, "Date", 0, 4, 0, 9999);
        int n2 = DmtData.checkNumber(string, "Date", 4, 2, 1, 12);
        int n3 = DmtData.checkNumber(string, "Date", 6, 2, 1, 31);
        if ((n2 == 4 || n2 == 6 || n2 == 9 || n2 == 11) && n3 == 31) {
            throw new IllegalArgumentException("Date string '" + string + "' contains an invalid date.");
        }
        if (n2 == 2 && n3 > 28 && (n3 != 29 || n % 4 != 0 || n % 100 == 0 && n % 400 != 0)) {
            throw new IllegalArgumentException("Date string '" + string + "' contains an invalid date.");
        }
    }

    private static void checkTimeFormat(String string) {
        if (string.length() > 0 && string.charAt(string.length() - 1) == 'Z') {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() != 6) {
            throw new IllegalArgumentException("Time string '" + string + "' does not follow the format 'hhmmss' or 'hhmmssZ'.");
        }
        DmtData.checkNumber(string, "Time", 0, 2, 0, 24);
        DmtData.checkNumber(string, "Time", 2, 2, 0, 59);
        DmtData.checkNumber(string, "Time", 4, 2, 0, 59);
        if (string.startsWith("24") && !string.startsWith("240000")) {
            throw new IllegalArgumentException("Time string is out of range.");
        }
    }

    private static int checkNumber(String string, String string2, int n, int n2, int n3, int n4) {
        int n5;
        String string3 = string.substring(n, n + n2);
        try {
            n5 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(string2 + " string '" + string + "' contains a non-numeric part.");
        }
        if (n5 < n3 || n5 > n4) {
            throw new IllegalArgumentException("A segment of the " + string2 + " string '" + string + "' is out of range.");
        }
        return n5;
    }

    private static String getHexDump(byte[] byArray) {
        if (byArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            DmtData.appendHexByte(stringBuffer.append(string), byArray[i]);
            string = " ";
        }
        return stringBuffer.toString();
    }

    private static void appendHexByte(StringBuffer stringBuffer, byte by) {
        stringBuffer.append(hex[(by & 0xF0) >> 4]).append(hex[by & 0xF]);
    }

    private static String getFormatName(int n) {
        return (String)FORMAT_NAMES.get(new Integer(n));
    }

    static {
        FORMAT_NAMES.put(new Integer(128), "base64");
        FORMAT_NAMES.put(new Integer(64), "binary");
        FORMAT_NAMES.put(new Integer(8), "boolean");
        FORMAT_NAMES.put(new Integer(16), "date");
        FORMAT_NAMES.put(new Integer(2), "float");
        FORMAT_NAMES.put(new Integer(1), "integer");
        FORMAT_NAMES.put(new Integer(1024), "NODE");
        FORMAT_NAMES.put(new Integer(512), "null");
        FORMAT_NAMES.put(new Integer(4), "string");
        FORMAT_NAMES.put(new Integer(32), "time");
        FORMAT_NAMES.put(new Integer(256), "xml");
        FORMAT_NAMES.put(new Integer(8192), "long");
        FORMAT_NAMES.put(new Integer(16384), "dateTime");
        NULL_VALUE = new DmtData();
        TRUE_VALUE = new DmtData(true);
        FALSE_VALUE = new DmtData(false);
        hex = "0123456789ABCDEF".toCharArray();
    }
}

