/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.coordinator;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.coordinator.CoordinationPermission;

final class CoordinationPermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = -3350758995234427603L;
    private Map<String, CoordinationPermission> permissions = new HashMap<String, CoordinationPermission>();
    private boolean all_allowed = false;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", HashMap.class), new ObjectStreamField("all_allowed", Boolean.TYPE)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof CoordinationPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        CoordinationPermission coordinationPermission = (CoordinationPermission)permission;
        if (coordinationPermission.bundle != null) {
            throw new IllegalArgumentException("cannot add to collection: " + coordinationPermission);
        }
        String string = coordinationPermission.getName();
        CoordinationPermissionCollection coordinationPermissionCollection = this;
        synchronized (coordinationPermissionCollection) {
            Map<String, CoordinationPermission> map = this.permissions;
            CoordinationPermission coordinationPermission2 = map.get(string);
            if (coordinationPermission2 != null) {
                int n = coordinationPermission2.action_mask;
                int n2 = coordinationPermission.action_mask;
                if (n != n2) {
                    map.put(string, new CoordinationPermission(coordinationPermission2.filter, n | n2));
                }
            } else {
                map.put(string, coordinationPermission);
            }
            if (!this.all_allowed && string.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        Collection<CoordinationPermission> collection;
        if (!(permission instanceof CoordinationPermission)) {
            return false;
        }
        CoordinationPermission coordinationPermission = (CoordinationPermission)permission;
        if (coordinationPermission.filter != null) {
            return false;
        }
        int n = 0;
        CoordinationPermissionCollection coordinationPermissionCollection = this;
        synchronized (coordinationPermissionCollection) {
            int n2;
            CoordinationPermission coordinationPermission2;
            Map<String, CoordinationPermission> object = this.permissions;
            if (this.all_allowed && (coordinationPermission2 = object.get("*")) != null && ((n |= coordinationPermission2.action_mask) & (n2 = coordinationPermission.action_mask)) == n2) {
                return true;
            }
            collection = object.values();
        }
        for (CoordinationPermission coordinationPermission3 : collection) {
            if (!coordinationPermission3.implies0(coordinationPermission, n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Enumeration<Permission> elements() {
        ArrayList<CoordinationPermission> arrayList = new ArrayList<CoordinationPermission>(this.permissions.values());
        return Collections.enumeration(arrayList);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("permissions", this.permissions);
        putField.put("all_allowed", this.all_allowed);
        objectOutputStream.writeFields();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        HashMap hashMap;
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.permissions = hashMap = (HashMap)getField.get("permissions", null);
        this.all_allowed = getField.get("all_allowed", false);
    }
}

