/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification.checkers;

import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.invocation.InvocationMarker;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.reporting.Discrepancy;
import org.mockito.internal.verification.api.InOrderContext;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;

public class NumberOfInvocationsInOrderChecker {
    private final Reporter reporter;
    private final InvocationsFinder finder;
    private final InvocationMarker invocationMarker = new InvocationMarker();

    public NumberOfInvocationsInOrderChecker() {
        this(new InvocationsFinder(), new Reporter());
    }

    NumberOfInvocationsInOrderChecker(InvocationsFinder invocationsFinder, Reporter reporter) {
        this.finder = invocationsFinder;
        this.reporter = reporter;
    }

    public void check(List<Invocation> list, InvocationMatcher invocationMatcher, int n, InOrderContext inOrderContext) {
        List<Invocation> list2 = this.finder.findMatchingChunk(list, invocationMatcher, n, inOrderContext);
        int n2 = list2.size();
        if (n > n2) {
            Location location = this.finder.getLastLocation(list2);
            this.reporter.tooLittleActualInvocationsInOrder(new Discrepancy(n, n2), invocationMatcher, location);
        } else if (n < n2) {
            Location location = list2.get(n).getLocation();
            this.reporter.tooManyActualInvocationsInOrder(n, n2, invocationMatcher, location);
        }
        this.invocationMarker.markVerifiedInOrder(list2, invocationMatcher, inOrderContext);
    }
}

