/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification;

import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.invocation.CapturesArgumensFromInvocation;
import org.mockito.internal.invocation.InvocationMarker;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.invocation.Invocation;
import org.mockito.verification.VerificationMode;

public class AtMost
implements VerificationMode {
    private final int maxNumberOfInvocations;
    private final InvocationMarker invocationMarker = new InvocationMarker();

    public AtMost(int n) {
        if (n < 0) {
            throw new MockitoException("Negative value is not allowed here");
        }
        this.maxNumberOfInvocations = n;
    }

    @Override
    public void verify(VerificationData verificationData) {
        InvocationMatcher invocationMatcher;
        InvocationsFinder invocationsFinder = new InvocationsFinder();
        List<Invocation> list = verificationData.getAllInvocations();
        List<Invocation> list2 = invocationsFinder.findInvocations(list, invocationMatcher = verificationData.getWanted());
        int n = list2.size();
        if (n > this.maxNumberOfInvocations) {
            new Reporter().wantedAtMostX(this.maxNumberOfInvocations, n);
        }
        this.invocationMarker.markVerified(list2, (CapturesArgumensFromInvocation)invocationMatcher);
    }
}

