/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util;

import java.io.Serializable;
import java.util.Collection;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.reflection.Constructors;
import org.mockito.mock.SerializableMode;

public class MockCreationValidator {
    private final MockUtil mockUtil = new MockUtil();

    public void validateType(Class clazz) {
        if (!this.mockUtil.isTypeMockable(clazz)) {
            new Reporter().cannotMockFinalClass(clazz);
        }
    }

    public void validateExtraInterfaces(Class clazz, Collection<Class> collection) {
        if (collection == null) {
            return;
        }
        for (Class clazz2 : collection) {
            if (clazz != clazz2) continue;
            new Reporter().extraInterfacesCannotContainMockedType(clazz);
        }
    }

    public void validateMockedType(Class clazz, Object object) {
        if (clazz == null || object == null) {
            return;
        }
        if (!clazz.equals(object.getClass())) {
            new Reporter().mockedTypeIsInconsistentWithSpiedInstanceType(clazz, object);
        }
    }

    public void validateDelegatedInstance(Class clazz, Object object) {
        if (clazz == null || object == null) {
            return;
        }
        if (object.getClass().isAssignableFrom(clazz)) {
            new Reporter().mockedTypeIsInconsistentWithDelegatedInstanceType(clazz, object);
        }
    }

    public void validateSerializable(Class clazz, boolean bl) {
        if (bl && !clazz.isInterface() && !Serializable.class.isAssignableFrom(clazz) && Constructors.noArgConstructorOf(clazz) == null) {
            new Reporter().serializableWontWorkForObjectsThatDontImplementSerializable(clazz);
        }
    }

    public void validateConstructorUse(boolean bl, SerializableMode serializableMode) {
        if (bl && serializableMode == SerializableMode.ACROSS_CLASSLOADERS) {
            new Reporter().usingConstructorWithFancySerializable(serializableMode);
        }
    }
}

