/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.cglib;

import java.io.Serializable;
import net.sf.cglib.proxy.MethodProxy;
import org.mockito.internal.creation.util.MockitoMethodProxy;
import org.mockito.internal.util.reflection.Whitebox;

class SerializableMockitoMethodProxy
implements MockitoMethodProxy,
Serializable {
    private static final long serialVersionUID = -5337859962876770632L;
    private final Class<?> c1;
    private final Class<?> c2;
    private final String desc;
    private final String name;
    private final String superName;
    transient MethodProxy methodProxy;

    public SerializableMockitoMethodProxy(MethodProxy methodProxy) {
        assert (methodProxy != null);
        Object object = Whitebox.getInternalState(methodProxy, "createInfo");
        this.c1 = (Class)Whitebox.getInternalState(object, "c1");
        this.c2 = (Class)Whitebox.getInternalState(object, "c2");
        this.desc = methodProxy.getSignature().getDescriptor();
        this.name = methodProxy.getSignature().getName();
        this.superName = methodProxy.getSuperName();
        this.methodProxy = methodProxy;
    }

    private MethodProxy getMethodProxy() {
        if (this.methodProxy == null) {
            this.methodProxy = MethodProxy.create(this.c1, this.c2, (String)this.desc, (String)this.name, (String)this.superName);
        }
        return this.methodProxy;
    }

    @Override
    public Object invokeSuper(Object object, Object[] objectArray) throws Throwable {
        return this.getMethodProxy().invokeSuper(object, objectArray);
    }
}

