/*
 * Decompiled with CFR 0.152.
 */
package org.mockito;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.configuration.DefaultMockitoConfiguration;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.GlobalConfiguration;
import org.mockito.internal.util.reflection.FieldSetter;

public class MockitoAnnotations {
    public static void initMocks(Object object) {
        if (object == null) {
            throw new MockitoException("testClass cannot be null. For info how to use @Mock annotations see examples in javadoc for MockitoAnnotations class");
        }
        AnnotationEngine annotationEngine = new GlobalConfiguration().getAnnotationEngine();
        if (annotationEngine.getClass() != new DefaultMockitoConfiguration().getAnnotationEngine().getClass()) {
            for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                MockitoAnnotations.scanDeprecatedWay(annotationEngine, object, clazz);
            }
        }
        annotationEngine.process(object.getClass(), object);
    }

    static void scanDeprecatedWay(AnnotationEngine annotationEngine, Object object, Class<?> clazz) {
        Field[] fieldArray;
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            MockitoAnnotations.processAnnotationDeprecatedWay(annotationEngine, object, field);
        }
    }

    static void processAnnotationDeprecatedWay(AnnotationEngine annotationEngine, Object object, Field field) {
        boolean bl = false;
        for (Annotation annotation : field.getAnnotations()) {
            Object object2 = annotationEngine.createMockFor(annotation, field);
            if (object2 == null) continue;
            MockitoAnnotations.throwIfAlreadyAssigned(field, bl);
            bl = true;
            try {
                new FieldSetter(object, field).set(object2);
            }
            catch (Exception exception) {
                throw new MockitoException("Problems setting field " + field.getName() + " annotated with " + annotation, exception);
            }
        }
    }

    static void throwIfAlreadyAssigned(Field field, boolean bl) {
        if (bl) {
            new Reporter().moreThanOneAnnotationNotAllowed(field.getName());
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Deprecated
    public static @interface Mock {
    }
}

