/*
 * Decompiled with CFR 0.152.
 */
package vncviewer;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import rfb.LogWriter;
import rfb.PixelBuffer;
import rfb.PixelFormat;

public class PixelBufferImage
extends PixelBuffer
implements ImageProducer {
    Image image;
    Graphics graphics;
    ImageConsumer ic;
    ColorModel cm;
    byte[] reds;
    byte[] greens;
    byte[] blues;
    static LogWriter vlog = new LogWriter("PixelBufferImage");

    public PixelBufferImage(int w, int h, Component win) {
        this.setPF(new PixelFormat(8, 8, false, false, 0, 0, 0, 0, 0, 0));
        this.resize(w, h, win);
        this.reds = new byte[256];
        this.greens = new byte[256];
        this.blues = new byte[256];
        for (int i = 0; i < 256; ++i) {
            this.reds[i] = (byte)(((i & 7) * 255 + 3) / 7);
            this.greens[i] = (byte)(((i >> 3 & 7) * 255 + 3) / 7);
            this.blues[i] = (byte)(((i >> 6 & 3) * 255 + 1) / 3);
        }
        this.cm = new IndexColorModel(8, 256, this.reds, this.greens, this.blues);
    }

    public void resize(int w, int h, Component win) {
        if (w == this.width() && h == this.height()) {
            return;
        }
        this.ic = null;
        int oldStrideBytes = this.getStride() * (this.format.bpp / 8);
        int rowsToCopy = h < this.height() ? h : this.height();
        int bytesPerRow = (w < this.width() ? w : this.width()) * (this.format.bpp / 8);
        byte[] oldData = this.data;
        this.width_ = w;
        this.height_ = h;
        this.image = win.createImage(this);
        this.data = new byte[this.width() * this.height() * (this.format.bpp / 8)];
        int newStrideBytes = this.getStride() * (this.format.bpp / 8);
        for (int i = 0; i < rowsToCopy; ++i) {
            System.arraycopy(oldData, oldStrideBytes * i, this.data, newStrideBytes * i, bytesPerRow);
        }
    }

    public void put(int x, int y, int w, int h, Graphics g) {
        if (this.ic == null) {
            return;
        }
        this.ic.setPixels(x, y, w, h, this.cm, this.data, this.width() * y + x, this.width());
        this.ic.imageComplete(2);
        g.setClip(x, y, w, h);
        g.drawImage(this.image, 0, 0, null);
    }

    @Override
    public void copyRect(int x, int y, int w, int h, int srcX, int srcY) {
        super.copyRect(x, y, w, h, srcX, srcY);
        if (this.ic == null) {
            return;
        }
        this.ic.setPixels(x, y, w, h, this.cm, this.data, this.width() * y + x, this.width());
        this.ic.imageComplete(2);
    }

    public void setColourMapEntries(int firstColour, int nColours, int[] rgbs) {
        for (int i = 0; i < nColours; ++i) {
            this.reds[firstColour + i] = (byte)(rgbs[i * 3] >> 8);
            this.greens[firstColour + i] = (byte)(rgbs[i * 3 + 1] >> 8);
            this.blues[firstColour + i] = (byte)(rgbs[i * 3 + 2] >> 8);
        }
    }

    public void updateColourMap() {
        this.cm = new IndexColorModel(8, 256, this.reds, this.greens, this.blues);
    }

    @Override
    public void addConsumer(ImageConsumer c) {
        vlog.debug("adding consumer " + c);
        this.ic = c;
        this.ic.setDimensions(this.width(), this.height());
        this.ic.setHints(1);
        this.ic.setPixels(0, 0, this.width(), this.height(), this.cm, this.data, 0, this.width());
        this.ic.imageComplete(2);
    }

    @Override
    public void removeConsumer(ImageConsumer c) {
        System.err.println("removeConsumer " + c);
        if (this.ic == c) {
            this.ic = null;
        }
    }

    @Override
    public boolean isConsumer(ImageConsumer c) {
        return this.ic == c;
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer c) {
    }

    @Override
    public void startProduction(ImageConsumer c) {
        this.addConsumer(c);
    }
}

