/*
 * Decompiled with CFR 0.152.
 */
package tightvnc;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.zip.Deflater;
import tightvnc.CapabilityInfo;
import tightvnc.CapsContainer;
import tightvnc.DesCipher;
import tightvnc.SessionRecorder;
import tightvnc.SocketFactory;
import tightvnc.VncViewer;

class RfbProto {
    static final String versionMsg_3_3 = "RFB 003.003\n";
    static final String versionMsg_3_7 = "RFB 003.007\n";
    static final String versionMsg_3_8 = "RFB 003.008\n";
    static final String StandardVendor = "STDV";
    static final String TridiaVncVendor = "TRDV";
    static final String TightVncVendor = "TGHT";
    static final int SecTypeInvalid = 0;
    static final int SecTypeNone = 1;
    static final int SecTypeVncAuth = 2;
    static final int SecTypeTight = 16;
    static final int NoTunneling = 0;
    static final String SigNoTunneling = "NOTUNNEL";
    static final int AuthNone = 1;
    static final int AuthVNC = 2;
    static final int AuthUnixLogin = 129;
    static final String SigAuthNone = "NOAUTH__";
    static final String SigAuthVNC = "VNCAUTH_";
    static final String SigAuthUnixLogin = "ULGNAUTH";
    static final int VncAuthOK = 0;
    static final int VncAuthFailed = 1;
    static final int VncAuthTooMany = 2;
    static final int FramebufferUpdate = 0;
    static final int SetColourMapEntries = 1;
    static final int Bell = 2;
    static final int ServerCutText = 3;
    static final int EndOfContinuousUpdates = 150;
    static final String SigEndOfContinuousUpdates = "CUS_EOCU";
    static final int SetPixelFormat = 0;
    static final int FixColourMapEntries = 1;
    static final int SetEncodings = 2;
    static final int FramebufferUpdateRequest = 3;
    static final int KeyboardEvent = 4;
    static final int PointerEvent = 5;
    static final int ClientCutText = 6;
    static final int EnableContinuousUpdates = 150;
    static final String SigEnableContinuousUpdates = "CUC_ENCU";
    static final int EncodingRaw = 0;
    static final int EncodingCopyRect = 1;
    static final int EncodingRRE = 2;
    static final int EncodingCoRRE = 4;
    static final int EncodingHextile = 5;
    static final int EncodingZlib = 6;
    static final int EncodingTight = 7;
    static final int EncodingZRLE = 16;
    static final int EncodingCompressLevel0 = -256;
    static final int EncodingQualityLevel0 = -32;
    static final int EncodingXCursor = -240;
    static final int EncodingRichCursor = -239;
    static final int EncodingPointerPos = -232;
    static final int EncodingLastRect = -224;
    static final int EncodingNewFBSize = -223;
    static final String SigEncodingRaw = "RAW_____";
    static final String SigEncodingCopyRect = "COPYRECT";
    static final String SigEncodingRRE = "RRE_____";
    static final String SigEncodingCoRRE = "CORRE___";
    static final String SigEncodingHextile = "HEXTILE_";
    static final String SigEncodingZlib = "ZLIB____";
    static final String SigEncodingTight = "TIGHT___";
    static final String SigEncodingZRLE = "ZRLE____";
    static final String SigEncodingCompressLevel0 = "COMPRLVL";
    static final String SigEncodingQualityLevel0 = "JPEGQLVL";
    static final String SigEncodingXCursor = "X11CURSR";
    static final String SigEncodingRichCursor = "RCHCURSR";
    static final String SigEncodingPointerPos = "POINTPOS";
    static final String SigEncodingLastRect = "LASTRECT";
    static final String SigEncodingNewFBSize = "NEWFBSIZ";
    static final int MaxNormalEncoding = 255;
    static final int HextileRaw = 1;
    static final int HextileBackgroundSpecified = 2;
    static final int HextileForegroundSpecified = 4;
    static final int HextileAnySubrects = 8;
    static final int HextileSubrectsColoured = 16;
    static final int TightMinToCompress = 12;
    static final int TightExplicitFilter = 4;
    static final int TightFill = 8;
    static final int TightJpeg = 9;
    static final int TightMaxSubencoding = 9;
    static final int TightFilterCopy = 0;
    static final int TightFilterPalette = 1;
    static final int TightFilterGradient = 2;
    String host;
    int port;
    Socket sock;
    OutputStream os;
    SessionRecorder rec;
    boolean inNormalProtocol = false;
    VncViewer viewer;
    private DataInputStream is;
    private long numBytesRead = 0L;
    boolean brokenKeyPressed = false;
    boolean wereZlibUpdates = false;
    boolean recordFromBeginning = true;
    boolean zlibWarningShown;
    boolean tightWarningShown;
    int numUpdatesInSession;
    boolean timing;
    long timeWaitedIn100us;
    long timedKbits;
    int serverMajor;
    int serverMinor;
    int clientMajor;
    int clientMinor;
    boolean protocolTightVNC;
    CapsContainer tunnelCaps;
    CapsContainer authCaps;
    CapsContainer serverMsgCaps;
    CapsContainer clientMsgCaps;
    CapsContainer encodingCaps;
    private boolean closed;
    String desktopName;
    int framebufferWidth;
    int framebufferHeight;
    int bitsPerPixel;
    int depth;
    boolean bigEndian;
    boolean trueColour;
    int redMax;
    int greenMax;
    int blueMax;
    int redShift;
    int greenShift;
    int blueShift;
    int updateNRects;
    int updateRectX;
    int updateRectY;
    int updateRectW;
    int updateRectH;
    int updateRectEncoding;
    int copyRectSrcX;
    int copyRectSrcY;
    byte[] eventBuf = new byte[72];
    int eventBufLen;
    static final int CTRL_MASK = 2;
    static final int SHIFT_MASK = 1;
    static final int META_MASK = 4;
    static final int ALT_MASK = 8;
    int pointerMask = 0;
    int oldModifiers = 0;

    public long getNumBytesRead() {
        return this.numBytesRead;
    }

    RfbProto(String h, int p, VncViewer v) throws IOException {
        this.viewer = v;
        this.host = h;
        this.port = p;
        if (this.viewer.socketFactory == null) {
            this.sock = new Socket(this.host, this.port);
        } else {
            try {
                Class<?> factoryClass = Class.forName(this.viewer.socketFactory);
                SocketFactory factory = (SocketFactory)factoryClass.newInstance();
                this.sock = this.viewer.inAnApplet ? factory.createSocket(this.host, this.port, this.viewer) : factory.createSocket(this.host, this.port, this.viewer.mainArgs);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
        this.is = new DataInputStream(new BufferedInputStream(this.sock.getInputStream(), 16384));
        this.os = this.sock.getOutputStream();
        this.timing = false;
        this.timeWaitedIn100us = 5L;
        this.timedKbits = 0L;
    }

    synchronized void close() {
        try {
            this.sock.close();
            this.closed = true;
            System.out.println("RFB socket closed");
            if (this.rec != null) {
                this.rec.close();
                this.rec = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    synchronized boolean closed() {
        return this.closed;
    }

    void readVersionMsg() throws Exception {
        byte[] b = new byte[12];
        this.readFully(b);
        if (b[0] != 82 || b[1] != 70 || b[2] != 66 || b[3] != 32 || b[4] < 48 || b[4] > 57 || b[5] < 48 || b[5] > 57 || b[6] < 48 || b[6] > 57 || b[7] != 46 || b[8] < 48 || b[8] > 57 || b[9] < 48 || b[9] > 57 || b[10] < 48 || b[10] > 57 || b[11] != 10) {
            throw new Exception("Host " + this.host + " port " + this.port + " is not an RFB server");
        }
        this.serverMajor = (b[4] - 48) * 100 + (b[5] - 48) * 10 + (b[6] - 48);
        this.serverMinor = (b[8] - 48) * 100 + (b[9] - 48) * 10 + (b[10] - 48);
        if (this.serverMajor < 3) {
            throw new Exception("RFB server does not support protocol version 3");
        }
    }

    void writeVersionMsg() throws IOException {
        this.clientMajor = 3;
        if (this.serverMajor > 3 || this.serverMinor >= 8) {
            this.clientMinor = 8;
            this.os.write(versionMsg_3_8.getBytes());
        } else if (this.serverMinor >= 7) {
            this.clientMinor = 7;
            this.os.write(versionMsg_3_7.getBytes());
        } else {
            this.clientMinor = 3;
            this.os.write(versionMsg_3_3.getBytes());
        }
        this.protocolTightVNC = false;
        this.initCapabilities();
    }

    int negotiateSecurity() throws Exception {
        return this.clientMinor >= 7 ? this.selectSecurityType() : this.readSecurityType();
    }

    int readSecurityType() throws Exception {
        int secType = this.readU32();
        switch (secType) {
            case 0: {
                this.readConnFailedReason();
                return 0;
            }
            case 1: 
            case 2: {
                return secType;
            }
        }
        throw new Exception("Unknown security type from RFB server: " + secType);
    }

    int selectSecurityType() throws Exception {
        int i;
        int secType = 0;
        int nSecTypes = this.readU8();
        if (nSecTypes == 0) {
            this.readConnFailedReason();
            return 0;
        }
        byte[] secTypes = new byte[nSecTypes];
        this.readFully(secTypes);
        for (i = 0; i < nSecTypes; ++i) {
            if (secTypes[i] != 16) continue;
            this.protocolTightVNC = true;
            this.os.write(16);
            return 16;
        }
        for (i = 0; i < nSecTypes; ++i) {
            if (secTypes[i] != 1 && secTypes[i] != 2) continue;
            secType = secTypes[i];
            break;
        }
        if (secType == 0) {
            throw new Exception("Server did not offer supported security type");
        }
        this.os.write(secType);
        return secType;
    }

    void authenticateNone() throws Exception {
        if (this.clientMinor >= 8) {
            this.readSecurityResult("No authentication");
        }
    }

    void authenticateVNC(String pw) throws Exception {
        int firstZero;
        byte[] challenge = new byte[16];
        this.readFully(challenge);
        if (pw.length() > 8) {
            pw = pw.substring(0, 8);
        }
        if ((firstZero = pw.indexOf(0)) != -1) {
            pw = pw.substring(0, firstZero);
        }
        byte[] key = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        System.arraycopy(pw.getBytes(), 0, key, 0, pw.length());
        DesCipher des = new DesCipher(key);
        des.encrypt(challenge, 0, challenge, 0);
        des.encrypt(challenge, 8, challenge, 8);
        this.os.write(challenge);
        this.readSecurityResult("VNC authentication");
    }

    void readSecurityResult(String authType) throws Exception {
        int securityResult = this.readU32();
        switch (securityResult) {
            case 0: {
                System.out.println(authType + ": success");
                break;
            }
            case 1: {
                if (this.clientMinor >= 8) {
                    this.readConnFailedReason();
                }
                throw new Exception(authType + ": failed");
            }
            case 2: {
                throw new Exception(authType + ": failed, too many tries");
            }
            default: {
                throw new Exception(authType + ": unknown result " + securityResult);
            }
        }
    }

    void readConnFailedReason() throws Exception {
        int reasonLen = this.readU32();
        byte[] reason = new byte[reasonLen];
        this.readFully(reason);
        throw new Exception(new String(reason));
    }

    void initCapabilities() {
        this.tunnelCaps = new CapsContainer();
        this.authCaps = new CapsContainer();
        this.serverMsgCaps = new CapsContainer();
        this.clientMsgCaps = new CapsContainer();
        this.encodingCaps = new CapsContainer();
        this.authCaps.add(1, StandardVendor, SigAuthNone, "No authentication");
        this.authCaps.add(2, StandardVendor, SigAuthVNC, "Standard VNC password authentication");
        this.encodingCaps.add(1, StandardVendor, SigEncodingCopyRect, "Standard CopyRect encoding");
        this.encodingCaps.add(2, StandardVendor, SigEncodingRRE, "Standard RRE encoding");
        this.encodingCaps.add(4, StandardVendor, SigEncodingCoRRE, "Standard CoRRE encoding");
        this.encodingCaps.add(5, StandardVendor, SigEncodingHextile, "Standard Hextile encoding");
        this.encodingCaps.add(16, StandardVendor, SigEncodingZRLE, "Standard ZRLE encoding");
        this.encodingCaps.add(6, TridiaVncVendor, SigEncodingZlib, "Zlib encoding");
        this.encodingCaps.add(7, TightVncVendor, SigEncodingTight, "Tight encoding");
        this.encodingCaps.add(-256, TightVncVendor, SigEncodingCompressLevel0, "Compression level");
        this.encodingCaps.add(-32, TightVncVendor, SigEncodingQualityLevel0, "JPEG quality level");
        this.encodingCaps.add(-240, TightVncVendor, SigEncodingXCursor, "X-style cursor shape update");
        this.encodingCaps.add(-239, TightVncVendor, SigEncodingRichCursor, "Rich-color cursor shape update");
        this.encodingCaps.add(-232, TightVncVendor, SigEncodingPointerPos, "Pointer position update");
        this.encodingCaps.add(-224, TightVncVendor, SigEncodingLastRect, "LastRect protocol extension");
        this.encodingCaps.add(-223, TightVncVendor, SigEncodingNewFBSize, "Framebuffer size change");
    }

    void setupTunneling() throws IOException {
        int nTunnelTypes = this.readU32();
        if (nTunnelTypes != 0) {
            this.readCapabilityList(this.tunnelCaps, nTunnelTypes);
            this.writeInt(0);
        }
    }

    int negotiateAuthenticationTight() throws Exception {
        int nAuthTypes = this.readU32();
        if (nAuthTypes == 0) {
            return 1;
        }
        this.readCapabilityList(this.authCaps, nAuthTypes);
        for (int i = 0; i < this.authCaps.numEnabled(); ++i) {
            int authType = this.authCaps.getByOrder(i);
            if (authType != 1 && authType != 2) continue;
            this.writeInt(authType);
            return authType;
        }
        throw new Exception("No suitable authentication scheme found");
    }

    void readCapabilityList(CapsContainer caps, int count) throws IOException {
        byte[] vendor = new byte[4];
        byte[] name = new byte[8];
        for (int i = 0; i < count; ++i) {
            int code = this.readU32();
            this.readFully(vendor);
            this.readFully(name);
            caps.enable(new CapabilityInfo(code, vendor, name));
        }
    }

    void writeInt(int value) throws IOException {
        byte[] b = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        this.os.write(b);
    }

    void writeClientInit() throws IOException {
        if (this.viewer.options.shareDesktop) {
            this.os.write(1);
        } else {
            this.os.write(0);
        }
        this.viewer.options.disableShareDesktop();
    }

    void readServerInit() throws IOException {
        this.framebufferWidth = this.readU16();
        this.framebufferHeight = this.readU16();
        this.bitsPerPixel = this.readU8();
        this.depth = this.readU8();
        this.bigEndian = this.readU8() != 0;
        this.trueColour = this.readU8() != 0;
        this.redMax = this.readU16();
        this.greenMax = this.readU16();
        this.blueMax = this.readU16();
        this.redShift = this.readU8();
        this.greenShift = this.readU8();
        this.blueShift = this.readU8();
        byte[] pad = new byte[3];
        this.readFully(pad);
        int nameLength = this.readU32();
        byte[] name = new byte[nameLength];
        this.readFully(name);
        this.desktopName = new String(name);
        if (this.protocolTightVNC) {
            int nServerMessageTypes = this.readU16();
            int nClientMessageTypes = this.readU16();
            int nEncodingTypes = this.readU16();
            this.readU16();
            this.readCapabilityList(this.serverMsgCaps, nServerMessageTypes);
            this.readCapabilityList(this.clientMsgCaps, nClientMessageTypes);
            this.readCapabilityList(this.encodingCaps, nEncodingTypes);
        }
        this.inNormalProtocol = true;
    }

    void startSession(String fname) throws IOException {
        this.rec = new SessionRecorder(fname);
        this.rec.writeHeader();
        this.rec.write(versionMsg_3_3.getBytes());
        this.rec.writeIntBE(1);
        this.rec.writeShortBE(this.framebufferWidth);
        this.rec.writeShortBE(this.framebufferHeight);
        byte[] fbsServerInitMsg = new byte[]{32, 24, 0, 1, 0, -1, 0, -1, 0, -1, 16, 8, 0, 0, 0, 0};
        this.rec.write(fbsServerInitMsg);
        this.rec.writeIntBE(this.desktopName.length());
        this.rec.write(this.desktopName.getBytes());
        this.numUpdatesInSession = 0;
        if (this.wereZlibUpdates) {
            this.recordFromBeginning = false;
        }
        this.zlibWarningShown = false;
        this.tightWarningShown = false;
    }

    void closeSession() throws IOException {
        if (this.rec != null) {
            this.rec.close();
            this.rec = null;
        }
    }

    void setFramebufferSize(int width, int height) {
        this.framebufferWidth = width;
        this.framebufferHeight = height;
    }

    int readServerMessageType() throws IOException {
        int msgType = this.readU8();
        if (this.rec != null && msgType == 2) {
            this.rec.writeByte(msgType);
            if (this.numUpdatesInSession > 0) {
                this.rec.flush();
            }
        }
        return msgType;
    }

    void readFramebufferUpdate() throws IOException {
        this.skipBytes(1);
        this.updateNRects = this.readU16();
        if (this.rec != null) {
            this.rec.writeByte(0);
            this.rec.writeByte(0);
            this.rec.writeShortBE(this.updateNRects);
        }
        ++this.numUpdatesInSession;
    }

    void readFramebufferUpdateRectHdr() throws Exception {
        this.updateRectX = this.readU16();
        this.updateRectY = this.readU16();
        this.updateRectW = this.readU16();
        this.updateRectH = this.readU16();
        this.updateRectEncoding = this.readU32();
        if (this.updateRectEncoding == 6 || this.updateRectEncoding == 16 || this.updateRectEncoding == 7) {
            this.wereZlibUpdates = true;
        }
        if (this.rec != null) {
            if (this.numUpdatesInSession > 1) {
                this.rec.flush();
            }
            this.rec.writeShortBE(this.updateRectX);
            this.rec.writeShortBE(this.updateRectY);
            this.rec.writeShortBE(this.updateRectW);
            this.rec.writeShortBE(this.updateRectH);
            if (this.updateRectEncoding == 6 && !this.recordFromBeginning) {
                if (!this.zlibWarningShown) {
                    System.out.println("Warning: Raw encoding will be used instead of Zlib in recorded session.");
                    this.zlibWarningShown = true;
                }
                this.rec.writeIntBE(0);
            } else {
                this.rec.writeIntBE(this.updateRectEncoding);
                if (this.updateRectEncoding == 7 && !this.recordFromBeginning && !this.tightWarningShown) {
                    System.out.println("Warning: Re-compressing Tight-encoded updates for session recording.");
                    this.tightWarningShown = true;
                }
            }
        }
        if (this.updateRectEncoding < 0 || this.updateRectEncoding > 255) {
            return;
        }
        if (this.updateRectX + this.updateRectW > this.framebufferWidth || this.updateRectY + this.updateRectH > this.framebufferHeight) {
            throw new Exception("Framebuffer update rectangle too large: " + this.updateRectW + "x" + this.updateRectH + " at (" + this.updateRectX + "," + this.updateRectY + ")");
        }
    }

    void readCopyRect() throws IOException {
        this.copyRectSrcX = this.readU16();
        this.copyRectSrcY = this.readU16();
        if (this.rec != null) {
            this.rec.writeShortBE(this.copyRectSrcX);
            this.rec.writeShortBE(this.copyRectSrcY);
        }
    }

    String readServerCutText() throws IOException {
        this.skipBytes(3);
        int len = this.readU32();
        byte[] text = new byte[len];
        this.readFully(text);
        return new String(text);
    }

    int readCompactLen() throws IOException {
        int[] portion = new int[3];
        portion[0] = this.readU8();
        int byteCount = 1;
        int len = portion[0] & 0x7F;
        if ((portion[0] & 0x80) != 0) {
            portion[1] = this.readU8();
            ++byteCount;
            len |= (portion[1] & 0x7F) << 7;
            if ((portion[1] & 0x80) != 0) {
                portion[2] = this.readU8();
                ++byteCount;
                len |= (portion[2] & 0xFF) << 14;
            }
        }
        if (this.rec != null && this.recordFromBeginning) {
            for (int i = 0; i < byteCount; ++i) {
                this.rec.writeByte(portion[i]);
            }
        }
        return len;
    }

    void writeFramebufferUpdateRequest(int x, int y, int w, int h, boolean incremental) throws IOException {
        byte[] b = new byte[]{3, (byte)(incremental ? 1 : 0), (byte)(x >> 8 & 0xFF), (byte)(x & 0xFF), (byte)(y >> 8 & 0xFF), (byte)(y & 0xFF), (byte)(w >> 8 & 0xFF), (byte)(w & 0xFF), (byte)(h >> 8 & 0xFF), (byte)(h & 0xFF)};
        this.os.write(b);
    }

    void writeSetPixelFormat(int bitsPerPixel, int depth, boolean bigEndian, boolean trueColour, int redMax, int greenMax, int blueMax, int redShift, int greenShift, int blueShift) throws IOException {
        byte[] b = new byte[20];
        b[0] = 0;
        b[4] = (byte)bitsPerPixel;
        b[5] = (byte)depth;
        b[6] = (byte)(bigEndian ? 1 : 0);
        b[7] = (byte)(trueColour ? 1 : 0);
        b[8] = (byte)(redMax >> 8 & 0xFF);
        b[9] = (byte)(redMax & 0xFF);
        b[10] = (byte)(greenMax >> 8 & 0xFF);
        b[11] = (byte)(greenMax & 0xFF);
        b[12] = (byte)(blueMax >> 8 & 0xFF);
        b[13] = (byte)(blueMax & 0xFF);
        b[14] = (byte)redShift;
        b[15] = (byte)greenShift;
        b[16] = (byte)blueShift;
        this.os.write(b);
    }

    void writeFixColourMapEntries(int firstColour, int nColours, int[] red, int[] green, int[] blue) throws IOException {
        byte[] b = new byte[6 + nColours * 6];
        b[0] = 1;
        b[2] = (byte)(firstColour >> 8 & 0xFF);
        b[3] = (byte)(firstColour & 0xFF);
        b[4] = (byte)(nColours >> 8 & 0xFF);
        b[5] = (byte)(nColours & 0xFF);
        for (int i = 0; i < nColours; ++i) {
            b[6 + i * 6] = (byte)(red[i] >> 8 & 0xFF);
            b[6 + i * 6 + 1] = (byte)(red[i] & 0xFF);
            b[6 + i * 6 + 2] = (byte)(green[i] >> 8 & 0xFF);
            b[6 + i * 6 + 3] = (byte)(green[i] & 0xFF);
            b[6 + i * 6 + 4] = (byte)(blue[i] >> 8 & 0xFF);
            b[6 + i * 6 + 5] = (byte)(blue[i] & 0xFF);
        }
        this.os.write(b);
    }

    void writeSetEncodings(int[] encs, int len) throws IOException {
        byte[] b = new byte[4 + 4 * len];
        b[0] = 2;
        b[2] = (byte)(len >> 8 & 0xFF);
        b[3] = (byte)(len & 0xFF);
        for (int i = 0; i < len; ++i) {
            b[4 + 4 * i] = (byte)(encs[i] >> 24 & 0xFF);
            b[5 + 4 * i] = (byte)(encs[i] >> 16 & 0xFF);
            b[6 + 4 * i] = (byte)(encs[i] >> 8 & 0xFF);
            b[7 + 4 * i] = (byte)(encs[i] & 0xFF);
        }
        this.os.write(b);
    }

    void writeClientCutText(String text) throws IOException {
        byte[] b = new byte[8 + text.length()];
        b[0] = 6;
        b[4] = (byte)(text.length() >> 24 & 0xFF);
        b[5] = (byte)(text.length() >> 16 & 0xFF);
        b[6] = (byte)(text.length() >> 8 & 0xFF);
        b[7] = (byte)(text.length() & 0xFF);
        System.arraycopy(text.getBytes(), 0, b, 8, text.length());
        this.os.write(b);
    }

    void writePointerEvent(MouseEvent evt) throws IOException {
        int modifiers = evt.getModifiers();
        int mask2 = 2;
        int mask3 = 4;
        if (this.viewer.options.reverseMouseButtons2And3) {
            mask2 = 4;
            mask3 = 2;
        }
        if (evt.getID() == 501) {
            if ((modifiers & 8) != 0) {
                this.pointerMask = mask2;
                modifiers &= 0xFFFFFFF7;
            } else if ((modifiers & 4) != 0) {
                this.pointerMask = mask3;
                modifiers &= 0xFFFFFFFB;
            } else {
                this.pointerMask = 1;
            }
        } else if (evt.getID() == 502) {
            this.pointerMask = 0;
            if ((modifiers & 8) != 0) {
                modifiers &= 0xFFFFFFF7;
            } else if ((modifiers & 4) != 0) {
                modifiers &= 0xFFFFFFFB;
            }
        }
        this.eventBufLen = 0;
        this.writeModifierKeyEvents(modifiers);
        int x = evt.getX();
        int y = evt.getY();
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.eventBuf[this.eventBufLen++] = 5;
        this.eventBuf[this.eventBufLen++] = (byte)this.pointerMask;
        this.eventBuf[this.eventBufLen++] = (byte)(x >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(x & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(y >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(y & 0xFF);
        if (this.pointerMask == 0) {
            this.writeModifierKeyEvents(0);
        }
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    void writeKeyEvent(KeyEvent evt) throws IOException {
        int key;
        boolean down;
        block44: {
            int keyChar;
            block43: {
                int code;
                keyChar = evt.getKeyChar();
                if (keyChar == 0) {
                    keyChar = 65535;
                }
                if (keyChar == 65535 && ((code = evt.getKeyCode()) == 17 || code == 16 || code == 157 || code == 18)) {
                    return;
                }
                boolean bl = down = evt.getID() == 401;
                if (!evt.isActionKey()) break block43;
                switch (evt.getKeyCode()) {
                    case 36: {
                        key = 65360;
                        break block44;
                    }
                    case 37: {
                        key = 65361;
                        break block44;
                    }
                    case 38: {
                        key = 65362;
                        break block44;
                    }
                    case 39: {
                        key = 65363;
                        break block44;
                    }
                    case 40: {
                        key = 65364;
                        break block44;
                    }
                    case 33: {
                        key = 65365;
                        break block44;
                    }
                    case 34: {
                        key = 65366;
                        break block44;
                    }
                    case 35: {
                        key = 65367;
                        break block44;
                    }
                    case 155: {
                        key = 65379;
                        break block44;
                    }
                    case 112: {
                        key = 65470;
                        break block44;
                    }
                    case 113: {
                        key = 65471;
                        break block44;
                    }
                    case 114: {
                        key = 65472;
                        break block44;
                    }
                    case 115: {
                        key = 65473;
                        break block44;
                    }
                    case 116: {
                        key = 65474;
                        break block44;
                    }
                    case 117: {
                        key = 65475;
                        break block44;
                    }
                    case 118: {
                        key = 65476;
                        break block44;
                    }
                    case 119: {
                        key = 65477;
                        break block44;
                    }
                    case 120: {
                        key = 65478;
                        break block44;
                    }
                    case 121: {
                        key = 65479;
                        break block44;
                    }
                    case 122: {
                        key = 65480;
                        break block44;
                    }
                    case 123: {
                        key = 65481;
                        break block44;
                    }
                    default: {
                        return;
                    }
                }
            }
            key = keyChar;
            if (key < 32) {
                if (evt.isControlDown()) {
                    key += 96;
                } else {
                    switch (key) {
                        case 8: {
                            key = 65288;
                            break;
                        }
                        case 9: {
                            key = 65289;
                            break;
                        }
                        case 10: {
                            key = 65293;
                            break;
                        }
                        case 27: {
                            key = 65307;
                        }
                    }
                }
            } else if (key == 127) {
                key = 65535;
            } else if (!(key <= 255 || key >= 65280 && key <= 65535 || key >= 8352 && key <= 8367)) {
                return;
            }
        }
        if (key == 229 || key == 197 || key == 228 || key == 196 || key == 246 || key == 214 || key == 167 || key == 189 || key == 163) {
            if (down) {
                this.brokenKeyPressed = true;
            }
            if (!down && !this.brokenKeyPressed) {
                this.eventBufLen = 0;
                this.writeModifierKeyEvents(evt.getModifiers());
                this.writeKeyEvent(key, true);
                this.os.write(this.eventBuf, 0, this.eventBufLen);
            }
            if (!down) {
                this.brokenKeyPressed = false;
            }
        }
        this.eventBufLen = 0;
        this.writeModifierKeyEvents(evt.getModifiers());
        this.writeKeyEvent(key, down);
        if (!down) {
            this.writeModifierKeyEvents(0);
        }
        this.os.write(this.eventBuf, 0, this.eventBufLen);
    }

    void writeKeyEvent(int keysym, boolean down) {
        this.eventBuf[this.eventBufLen++] = 4;
        this.eventBuf[this.eventBufLen++] = (byte)(down ? 1 : 0);
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = 0;
        this.eventBuf[this.eventBufLen++] = (byte)(keysym >> 24 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(keysym >> 16 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(keysym >> 8 & 0xFF);
        this.eventBuf[this.eventBufLen++] = (byte)(keysym & 0xFF);
    }

    void writeModifierKeyEvents(int newModifiers) {
        if ((newModifiers & 2) != (this.oldModifiers & 2)) {
            this.writeKeyEvent(65507, (newModifiers & 2) != 0);
        }
        if ((newModifiers & 1) != (this.oldModifiers & 1)) {
            this.writeKeyEvent(65505, (newModifiers & 1) != 0);
        }
        if ((newModifiers & 4) != (this.oldModifiers & 4)) {
            this.writeKeyEvent(65511, (newModifiers & 4) != 0);
        }
        if ((newModifiers & 8) != (this.oldModifiers & 8)) {
            this.writeKeyEvent(65513, (newModifiers & 8) != 0);
        }
        this.oldModifiers = newModifiers;
    }

    void recordCompressedData(byte[] data, int off, int len) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setInput(data, off, len);
        int bufSize = len + len / 100 + 12;
        byte[] buf = new byte[bufSize];
        deflater.finish();
        int compressedSize = deflater.deflate(buf);
        this.recordCompactLen(compressedSize);
        this.rec.write(buf, 0, compressedSize);
    }

    void recordCompressedData(byte[] data) throws IOException {
        this.recordCompressedData(data, 0, data.length);
    }

    void recordCompactLen(int len) throws IOException {
        byte[] buf = new byte[3];
        int bytes = 0;
        buf[bytes++] = (byte)(len & 0x7F);
        if (len > 127) {
            int n = bytes - 1;
            buf[n] = (byte)(buf[n] | 0x80);
            buf[bytes++] = (byte)(len >> 7 & 0x7F);
            if (len > 16383) {
                int n2 = bytes - 1;
                buf[n2] = (byte)(buf[n2] | 0x80);
                buf[bytes++] = (byte)(len >> 14 & 0xFF);
            }
        }
        this.rec.write(buf, 0, bytes);
    }

    public void startTiming() {
        this.timing = true;
        if (this.timeWaitedIn100us > 10000L) {
            this.timedKbits = this.timedKbits * 10000L / this.timeWaitedIn100us;
            this.timeWaitedIn100us = 10000L;
        }
    }

    public void stopTiming() {
        this.timing = false;
        if (this.timeWaitedIn100us < this.timedKbits / 2L) {
            this.timeWaitedIn100us = this.timedKbits / 2L;
        }
    }

    public long kbitsPerSecond() {
        return this.timedKbits * 10000L / this.timeWaitedIn100us;
    }

    public long timeWaited() {
        return this.timeWaitedIn100us;
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        long before = 0L;
        if (this.timing) {
            before = System.currentTimeMillis();
        }
        this.is.readFully(b, off, len);
        if (this.timing) {
            int newKbits;
            long after = System.currentTimeMillis();
            long newTimeWaited = (after - before) * 10L;
            if (newTimeWaited > (long)((newKbits = len * 8 / 1000) * 1000)) {
                newTimeWaited = newKbits * 1000;
            }
            if (newTimeWaited < (long)(newKbits / 4)) {
                newTimeWaited = newKbits / 4;
            }
            this.timeWaitedIn100us += newTimeWaited;
            this.timedKbits += (long)newKbits;
        }
        this.numBytesRead += (long)len;
    }

    final int available() throws IOException {
        return this.is.available();
    }

    final int skipBytes(int n) throws IOException {
        int r = this.is.skipBytes(n);
        this.numBytesRead += (long)r;
        return r;
    }

    final int readU8() throws IOException {
        int r = this.is.readUnsignedByte();
        ++this.numBytesRead;
        return r;
    }

    final int readU16() throws IOException {
        int r = this.is.readUnsignedShort();
        this.numBytesRead += 2L;
        return r;
    }

    final int readU32() throws IOException {
        int r = this.is.readInt();
        this.numBytesRead += 4L;
        return r;
    }
}

