/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.iterators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections15.iterators.EmptyIterator;
import org.apache.commons.collections15.list.UnmodifiableList;

public class IteratorChain<E>
implements Iterator<E> {
    protected final List<Iterator<? extends E>> iteratorChain = new ArrayList<Iterator<? extends E>>();
    protected int currentIteratorIndex = 0;
    protected Iterator<? extends E> currentIterator = null;
    protected Iterator<? extends E> lastUsedIterator = null;
    protected boolean isLocked = false;

    public IteratorChain() {
    }

    public IteratorChain(Iterator<? extends E> iterator) {
        this.addIterator(iterator);
    }

    public IteratorChain(Iterator<? extends E> a, Iterator<? extends E> b) {
        this.addIterator(a);
        this.addIterator(b);
    }

    public IteratorChain(Iterator<? extends E>[] iterators) {
        for (int i = 0; i < iterators.length; ++i) {
            this.addIterator(iterators[i]);
        }
    }

    public IteratorChain(Collection<Iterator<? extends E>> iterators) {
        for (Iterator<E> iterator : iterators) {
            this.addIterator(iterator);
        }
    }

    public void addIterator(Iterator<? extends E> iterator) {
        this.checkLocked();
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iteratorChain.add(iterator);
    }

    public void setIterator(int index, Iterator<? extends E> iterator) throws IndexOutOfBoundsException {
        this.checkLocked();
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iteratorChain.set(index, iterator);
    }

    public List<Iterator<? extends E>> getIterators() {
        return UnmodifiableList.decorate(this.iteratorChain);
    }

    public int size() {
        return this.iteratorChain.size();
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    private void checkLocked() {
        if (this.isLocked) {
            throw new UnsupportedOperationException("IteratorChain cannot be changed after the first use of a method from the Iterator interface");
        }
    }

    private void lockChain() {
        if (!this.isLocked) {
            this.isLocked = true;
        }
    }

    protected void updateCurrentIterator() {
        if (this.currentIterator == null) {
            this.currentIterator = this.iteratorChain.isEmpty() ? EmptyIterator.INSTANCE : this.iteratorChain.get(0);
            this.lastUsedIterator = this.currentIterator;
        }
        while (!this.currentIterator.hasNext() && this.currentIteratorIndex < this.iteratorChain.size() - 1) {
            ++this.currentIteratorIndex;
            this.currentIterator = this.iteratorChain.get(this.currentIteratorIndex);
        }
    }

    @Override
    public boolean hasNext() {
        this.lockChain();
        this.updateCurrentIterator();
        this.lastUsedIterator = this.currentIterator;
        return this.currentIterator.hasNext();
    }

    @Override
    public E next() {
        this.lockChain();
        this.updateCurrentIterator();
        this.lastUsedIterator = this.currentIterator;
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
        this.lockChain();
        this.updateCurrentIterator();
        this.lastUsedIterator.remove();
    }
}

