/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.comparators;

import java.io.Serializable;
import java.util.Comparator;

public class NullComparator<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = -5820772575483504339L;
    private Comparator<T> nonNullComparator;
    private boolean nullsAreHigh;

    public NullComparator(Comparator<T> nonNullComparator) {
        this(nonNullComparator, true);
    }

    public NullComparator(Comparator<T> nonNullComparator, boolean nullsAreHigh) {
        this.nonNullComparator = nonNullComparator;
        this.nullsAreHigh = nullsAreHigh;
        if (nonNullComparator == null) {
            throw new NullPointerException("null nonNullComparator");
        }
    }

    @Override
    public int compare(T o1, T o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return this.nullsAreHigh ? 1 : -1;
        }
        if (o2 == null) {
            return this.nullsAreHigh ? -1 : 1;
        }
        return this.nonNullComparator.compare(o1, o2);
    }

    public int hashCode() {
        return (this.nullsAreHigh ? -1 : 1) * this.nonNullComparator.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        NullComparator other = (NullComparator)obj;
        return this.nullsAreHigh == other.nullsAreHigh && this.nonNullComparator.equals(other.nonNullComparator);
    }
}

