/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.bag;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections15.Bag;
import org.apache.commons.collections15.Unmodifiable;
import org.apache.commons.collections15.bag.AbstractBagDecorator;
import org.apache.commons.collections15.iterators.UnmodifiableIterator;
import org.apache.commons.collections15.set.UnmodifiableSet;

public final class UnmodifiableBag<E>
extends AbstractBagDecorator<E>
implements Unmodifiable,
Serializable {
    private static final long serialVersionUID = -1873799975157099624L;

    public static <E> Bag<E> decorate(Bag<E> bag) {
        if (bag instanceof Unmodifiable) {
            return bag;
        }
        return new UnmodifiableBag<E>(bag);
    }

    private UnmodifiableBag(Bag<E> bag) {
        super(bag);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.collection);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.collection = (Collection)in.readObject();
    }

    @Override
    public Iterator<E> iterator() {
        return UnmodifiableIterator.decorate(this.getCollection().iterator());
    }

    @Override
    public boolean add(E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E object, int count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(E object, int count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<E> uniqueSet() {
        Set set = this.getBag().uniqueSet();
        return UnmodifiableSet.decorate(set);
    }
}

