/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.list.FixedSizeList;
import org.apache.commons.collections15.list.LazyList;
import org.apache.commons.collections15.list.PredicatedList;
import org.apache.commons.collections15.list.SynchronizedList;
import org.apache.commons.collections15.list.TransformedList;
import org.apache.commons.collections15.list.TypedList;
import org.apache.commons.collections15.list.UnmodifiableList;

public class ListUtils {
    public static final List EMPTY_LIST = Collections.EMPTY_LIST;

    public static <E> List<E> intersection(List<? extends E> list1, List<? extends E> list2) {
        ArrayList<E> result = new ArrayList<E>();
        for (E o : list2) {
            if (!list1.contains(o)) continue;
            result.add(o);
        }
        return result;
    }

    public static <E> List<E> subtract(List<? extends E> list1, List<? extends E> list2) {
        ArrayList<E> result = new ArrayList<E>(list1);
        Iterator<E> iterator = list2.iterator();
        while (iterator.hasNext()) {
            result.remove(iterator.next());
        }
        return result;
    }

    public static <E> List<E> sum(List<? extends E> list1, List<? extends E> list2) {
        return ListUtils.subtract(ListUtils.union(list1, list2), ListUtils.intersection(list1, list2));
    }

    public static <E> List<E> union(List<? extends E> list1, List<? extends E> list2) {
        ArrayList<? extends E> result = new ArrayList<E>(list1);
        result.addAll(list2);
        return result;
    }

    public static <E> boolean isEqualList(Collection<? extends E> list1, Collection<? extends E> list2) {
        if (list1 == list2) {
            return true;
        }
        if (list1 == null || list2 == null || list1.size() != list2.size()) {
            return false;
        }
        Iterator<E> it1 = list1.iterator();
        Iterator<E> it2 = list2.iterator();
        Object obj1 = null;
        Object obj2 = null;
        while (it1.hasNext() && it2.hasNext()) {
            obj1 = it1.next();
            obj2 = it2.next();
            if (obj1 != null ? obj1.equals(obj2) : obj2 == null) continue;
            return false;
        }
        return !it1.hasNext() && !it2.hasNext();
    }

    public static int hashCodeForList(Collection list) {
        if (list == null) {
            return 0;
        }
        int hashCode = 1;
        Iterator it = list.iterator();
        Object obj = null;
        while (it.hasNext()) {
            obj = it.next();
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    public static <E> List<E> synchronizedList(List<E> list) {
        return SynchronizedList.decorate(list);
    }

    public static <E> List<E> unmodifiableList(List<E> list) {
        return UnmodifiableList.decorate(list);
    }

    public static <E> List<E> predicatedList(List<E> list, Predicate<? super E> predicate) {
        return PredicatedList.decorate(list, predicate);
    }

    public static <E> List<E> typedList(List<E> list, Class<E> type) {
        return TypedList.decorate(list, type);
    }

    public static <I, O> List<O> transformedList(List<I> list, Transformer<? super I, ? extends O> transformer) {
        return TransformedList.decorate(list, transformer);
    }

    public static <E> List<E> lazyList(List<E> list, Factory<? extends E> factory) {
        return LazyList.decorate(list, factory);
    }

    public static <E> List<E> fixedSizeList(List<E> list) {
        return FixedSizeList.decorate(list);
    }
}

