/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import lcmc.data.AccessMode;
import lcmc.gui.SpringUtilities;
import lcmc.gui.resources.Info;
import lcmc.gui.widget.ComboBox;
import lcmc.gui.widget.Widget;
import lcmc.utilities.MyButton;
import lcmc.utilities.PatternDocument;
import lcmc.utilities.Tools;
import lcmc.utilities.Unit;
import lcmc.utilities.WidgetListener;

public final class TextfieldWithUnit
extends Widget {
    private static final long serialVersionUID = 1L;
    private final Unit[] units;
    private final JTextField textFieldPart;
    private final Widget.MComboBox<Object> unitComboBox;
    private final Pattern unitPattern = Pattern.compile("^(\\d+)(\\D*)$");
    private boolean unitEnabled = true;

    public TextfieldWithUnit(String selectedValue, Unit[] units, String regexp, int width, Map<String, String> abbreviations, AccessMode enableAccessMode, MyButton fieldButton) {
        super(regexp, enableAccessMode, fieldButton);
        Matcher m;
        this.units = units;
        JPanel newComp = new JPanel();
        newComp.setLayout(new SpringLayout());
        String number = "";
        String unit = "";
        if (selectedValue != null && (m = this.unitPattern.matcher(selectedValue)).matches()) {
            number = m.group(1);
            String parsedUnit = m.group(2);
            if (!"".equals(parsedUnit)) {
                unit = parsedUnit;
            }
        }
        this.textFieldPart = (JTextField)this.getTextField(number, regexp, abbreviations);
        newComp.add(this.textFieldPart);
        this.unitComboBox = this.getComboBox(unit, units, regexp, abbreviations);
        newComp.add(this.unitComboBox);
        SpringUtilities.makeCompactGrid(newComp, 1, 2, 0, 0, 0, 0);
        this.addComponent(newComp, width);
        this.textFieldPart.setPreferredSize(new Dimension(width / 3, 28));
        this.textFieldPart.setMinimumSize(this.textFieldPart.getPreferredSize());
        this.textFieldPart.setMaximumSize(this.textFieldPart.getPreferredSize());
        this.unitComboBox.setPreferredSize(new Dimension(width / 3 * 2, 28));
        this.unitComboBox.setMinimumSize(this.unitComboBox.getPreferredSize());
        this.unitComboBox.setMaximumSize(this.unitComboBox.getPreferredSize());
    }

    private JComponent getTextField(String value, String regexp, Map<String, String> abbreviations) {
        Widget.MTextField tf = regexp == null ? new Widget.MTextField(value) : new Widget.MTextField(new PatternDocument(regexp, abbreviations), value, 0);
        return tf;
    }

    private Widget.MComboBox<Object> getComboBox(String selectedValue, Object[] items, String regexp, Map<String, String> abbreviations) {
        ArrayList<Object> comboList = new ArrayList<Object>();
        Object selectedValueInfo = ComboBox.addItems(comboList, selectedValue, items);
        Widget.MComboBox<Object> cb = new Widget.MComboBox<Object>((Widget)this, comboList.toArray(new Object[comboList.size()]));
        final JTextComponent editor = (JTextComponent)cb.getEditor().getEditorComponent();
        if (regexp != null) {
            editor.setDocument(new PatternDocument(regexp, abbreviations));
        }
        cb.setMaximumRowCount(10);
        if (selectedValueInfo != null) {
            cb.setSelectedItem(selectedValueInfo);
        }
        editor.addKeyListener(new Widget.ActivateDefaultButtonListener(cb));
        editor.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Object o = TextfieldWithUnit.this.getValue();
                if (o != null && !Tools.isStringClass(o) && ((Info)o).getInternalValue() == null) {
                    o = null;
                }
                if (o == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            editor.setText("");
                        }
                    });
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        return cb;
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.textFieldPart.setToolTipText("<html>" + text + "</html>");
        this.unitComboBox.setToolTipText("<html>" + text + "</html>");
    }

    @Override
    public String getStringValue() {
        Object o = this.getValue();
        if (o == null) {
            return "";
        }
        Object o0 = ((Object[])o)[0];
        Object o1 = ((Object[])o)[1];
        String v = o0.toString();
        if (v != null && !"".equals(v) && o1 != null && o1 instanceof Unit) {
            v = v + ((Unit)o1).getShortName();
        }
        return v;
    }

    @Override
    protected Object getValueInternal() {
        Object[] value;
        Object unit;
        String text = this.textFieldPart.getText();
        if (text == null) {
            text = "";
        }
        if (!Tools.isStringClass(unit = this.unitComboBox.getSelectedItem())) {
            Unit u = (Unit)unit;
            if (u.isPlural() == "1".equals(text)) {
                u.setPlural(!"1".equals(text));
                this.unitComboBox.repaint();
            }
            final boolean accessible = Tools.getConfigData().isAccessible(this.getEnableAccessMode());
            if ("".equals(text)) {
                if (!u.isEmpty()) {
                    u.setEmpty(true);
                    this.unitEnabled = false;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TextfieldWithUnit.this.unitComboBox.repaint();
                            TextfieldWithUnit.this.unitComboBox.setEnabled(false);
                        }
                    });
                }
            } else if (u.isEmpty()) {
                u.setEmpty(false);
                if (this.textFieldPart.isEnabled()) {
                    this.unitEnabled = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TextfieldWithUnit.this.unitComboBox.repaint();
                            TextfieldWithUnit.this.unitComboBox.setEnabled(accessible);
                        }
                    });
                }
            }
        }
        if (NOTHING_SELECTED_DISPLAY.equals(value = new Object[]{text, unit})) {
            return null;
        }
        return value;
    }

    @Override
    protected void setComponentsVisible(final boolean visible) {
        super.setComponentsEnabled(visible);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextfieldWithUnit.this.textFieldPart.setVisible(visible);
                TextfieldWithUnit.this.unitComboBox.setVisible(visible);
                TextfieldWithUnit.this.repaint();
            }
        });
    }

    @Override
    protected void setComponentsEnabled(boolean enabled) {
        super.setComponentsEnabled(enabled);
        this.textFieldPart.setEnabled(enabled);
        this.unitComboBox.setEnabled(enabled && this.unitEnabled);
    }

    @Override
    boolean isEditable() {
        return false;
    }

    @Override
    protected void setValueAndWait0(Object item) {
        Matcher m = null;
        if (item != null) {
            m = this.unitPattern.matcher((String)item);
        }
        String number = "";
        String unit = "";
        if (m != null && m.matches()) {
            number = m.group(1);
            String parsedUnit = m.group(2);
            if (!"".equals(parsedUnit)) {
                unit = parsedUnit;
            }
        }
        this.textFieldPart.setText(number);
        Unit selectedUnitInfo = null;
        for (Unit u : this.units) {
            if (!u.equals(unit)) continue;
            selectedUnitInfo = u;
        }
        this.unitComboBox.setSelectedItem(selectedUnitInfo);
    }

    @Override
    public Document getDocument() {
        return null;
    }

    @Override
    public void addListeners(WidgetListener wl) {
        super.addListeners(wl);
        this.addDocumentListener(this.textFieldPart.getDocument(), wl);
        this.unitComboBox.addItemListener(this.getItemListener(wl));
    }

    @Override
    protected void setComponentBackground(Color backgroundColor, Color compColor) {
        this.textFieldPart.setBackground(Color.WHITE);
    }

    @Override
    public void requestFocus() {
        this.textFieldPart.requestFocus();
    }

    @Override
    void selectAll() {
        this.textFieldPart.selectAll();
    }

    @Override
    public void setBackgroundColor(final Color bg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextfieldWithUnit.this.setBackground(bg);
                TextfieldWithUnit.this.textFieldPart.setBackground(bg);
            }
        });
    }

    @Override
    Object getItemAt(int i) {
        return this.getComponent();
    }

    @Override
    public void cleanup() {
        this.getWidgetListeners().clear();
        AbstractDocument dtfp = (AbstractDocument)this.textFieldPart.getDocument();
        for (DocumentListener documentListener : dtfp.getDocumentListeners()) {
            dtfp.removeDocumentListener(documentListener);
        }
        for (EventListener eventListener : this.unitComboBox.getItemListeners()) {
            this.unitComboBox.removeItemListener((ItemListener)eventListener);
        }
    }
}

