/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.widget;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import lcmc.data.AccessMode;
import lcmc.gui.resources.Info;
import lcmc.gui.widget.Widget;
import lcmc.utilities.MyButton;
import lcmc.utilities.PatternDocument;
import lcmc.utilities.Tools;
import lcmc.utilities.Unit;
import lcmc.utilities.WidgetListener;

public final class ComboBox
extends Widget {
    private static final long serialVersionUID = 1L;
    private static final int SCROLLBAR_MAX_ROWS = 10;

    public ComboBox(String selectedValue, Object[] items, String regexp, int width, Map<String, String> abbreviations, AccessMode enableAccessMode, MyButton fieldButton) {
        super(regexp, enableAccessMode, fieldButton);
        this.addComponent(this.getComboBox(selectedValue, items, regexp, abbreviations), width);
    }

    private Widget.MComboBox getComboBox(String selectedValue, Object[] items, String regexp, Map<String, String> abbreviations) {
        ArrayList<Object> comboList = new ArrayList<Object>();
        Object selectedValueInfo = ComboBox.addItems(comboList, selectedValue, items);
        Widget.MComboBox<Object> cb = new Widget.MComboBox<Object>((Widget)this, comboList.toArray(new Object[comboList.size()]));
        final JTextComponent editor = (JTextComponent)cb.getEditor().getEditorComponent();
        if (regexp != null) {
            editor.setDocument(new PatternDocument(regexp, abbreviations));
        }
        cb.setMaximumRowCount(10);
        if (selectedValueInfo != null) {
            cb.setSelectedItem(selectedValueInfo);
        }
        editor.addKeyListener(new Widget.ActivateDefaultButtonListener(cb));
        editor.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Object o = ComboBox.this.getValue();
                if (o != null && !Tools.isStringClass(o) && ((Info)o).getInternalValue() == null) {
                    o = null;
                }
                if (o == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            editor.setText("");
                        }
                    });
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        return cb;
    }

    private boolean comboBoxChanged(Object[] items) {
        Widget.MComboBox cb = (Widget.MComboBox)this.getComponent();
        if (items.length != cb.getItemCount()) {
            return true;
        }
        for (int i = 0; i < items.length; ++i) {
            Object item = items[i] == null ? Widget.NOTHING_SELECTED_DISPLAY : items[i];
            if (Tools.areEqual(item, cb.getItemAt(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reloadComboBox(final String selectedValue, final Object[] items) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Widget.MComboBox cb = (Widget.MComboBox)ComboBox.this.getComponent();
                Object selectedItem = cb.getSelectedItem();
                boolean selectedChanged = false;
                if (selectedValue == null && selectedItem != null && selectedItem != Widget.NOTHING_SELECTED_DISPLAY) {
                    selectedChanged = true;
                } else if (selectedValue != null && !selectedValue.equals(selectedItem)) {
                    selectedChanged = true;
                }
                boolean itemsChanged = ComboBox.this.comboBoxChanged(items);
                if (!selectedChanged && !itemsChanged) {
                    return;
                }
                cb.setPreferredSize(null);
                ArrayList<Object> comboList = new ArrayList<Object>();
                Object selectedValueInfo = ComboBox.addItems(comboList, selectedValue, items);
                if (itemsChanged) {
                    HashSet<String> itemCache = new HashSet<String>();
                    cb.setSelectedIndex(-1);
                    cb.removeAllItems();
                    for (Object e : comboList) {
                        if (itemCache.contains(e.toString())) continue;
                        cb.addItem(e);
                        itemCache.add(e.toString());
                    }
                }
                if (selectedValueInfo != null) {
                    cb.setSelectedItem(selectedValueInfo);
                }
            }
        });
    }

    protected static Object addItems(List<Object> comboList, String selectedValue, Object[] items) {
        Object selectedValueInfo = null;
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == null) {
                    items[i] = Widget.NOTHING_SELECTED_DISPLAY;
                }
                if (items[i] instanceof Info && ((Info)items[i]).getInternalValue() != null && ((Info)items[i]).getInternalValue().equals(selectedValue)) {
                    selectedValueInfo = items[i];
                } else if (items[i] instanceof Unit && ((Unit)items[i]).equals(selectedValue)) {
                    selectedValueInfo = items[i];
                } else if (items[i].toString().equals(selectedValue) || items[i].equals(selectedValue)) {
                    selectedValueInfo = items[i];
                }
                comboList.add(items[i]);
            }
            if (selectedValueInfo == null && selectedValue != null) {
                comboList.add(selectedValue);
                selectedValueInfo = selectedValue;
            }
        }
        return selectedValueInfo;
    }

    @Override
    public void setEditable(final boolean editable) {
        super.setEditable(editable);
        final JComponent comp = this.getComponent();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object o = ComboBox.this.getValue();
                if (o != null && !Tools.isStringClass(o) && ((Info)o).getInternalValue() == null) {
                    o = null;
                }
                if (ComboBox.this.isAlwaysEditable()) {
                    ((Widget.MComboBox)comp).setEditable(true);
                    JTextComponent editor = ComboBox.this.getTextComponent();
                    if (o == null) {
                        editor.selectAll();
                    }
                } else if (o == null) {
                    ((Widget.MComboBox)comp).setEditable(false);
                } else {
                    ((Widget.MComboBox)comp).setEditable(editable);
                }
            }
        });
    }

    @Override
    public String getStringValue() {
        Object o = this.getValue();
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    @Override
    protected Object getValueInternal() {
        Object value;
        Widget.MComboBox cb = (Widget.MComboBox)this.getComponent();
        if (cb.isEditable()) {
            JTextComponent editor = (JTextComponent)cb.getEditor().getEditorComponent();
            String text = editor.getText();
            if (text == null) {
                text = "";
            }
            if ((value = cb.getSelectedItem()) == null || !text.equals(value.toString())) {
                value = text;
            }
            if ("".equals(value)) {
                return "";
            }
        } else {
            value = cb.getSelectedItem();
        }
        if (NOTHING_SELECTED_DISPLAY.equals(value)) {
            return null;
        }
        return value;
    }

    @Override
    public void clear() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((Widget.MComboBox)ComboBox.this.getComponent()).removeAllItems();
            }
        });
    }

    @Override
    boolean isEditable() {
        return ((Widget.MComboBox)this.getComponent()).isEditable();
    }

    @Override
    protected void setValueAndWait0(Object item) {
        Widget.MComboBox cb = (Widget.MComboBox)this.getComponent();
        cb.setSelectedItem(item);
        if (Tools.isStringClass(item)) {
            Object selectedObject = null;
            for (int i = 0; i < cb.getItemCount(); ++i) {
                Object it = cb.getItemAt(i);
                if (it != item && !it.toString().equals(item) && !it.equals(item) && (!(it instanceof Info) || !Tools.areEqual(((Info)it).getInternalValue(), item)) && (!NOTHING_SELECTED_DISPLAY.equals(it) || item != null)) continue;
                selectedObject = it;
                cb.setSelectedItem(it);
                break;
            }
            if (selectedObject == null) {
                cb.addItem(item);
                cb.setSelectedItem(item);
            }
        }
    }

    @Override
    public void setSelectedIndex(int index) {
        Widget.MComboBox cb = (Widget.MComboBox)this.getComponent();
        cb.setSelectedIndex(index);
    }

    @Override
    public Document getDocument() {
        JTextComponent tc = this.getTextComponent();
        return tc.getDocument();
    }

    @Override
    public void selectSubnet() {
        int p;
        final JTextComponent tc = this.getTextComponent();
        final String ip = tc.getText();
        for (p = ip.length() - 2; p >= 0 && Tools.isIp(ip) && ".0".equals(ip.substring(p, p + 2)); p -= 2) {
        }
        final int pos = p + 3;
        if (pos >= 0 && pos < ip.length()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    tc.select(pos, ip.length());
                }
            });
        }
    }

    @Override
    public void addListeners(WidgetListener wl) {
        this.getWidgetListeners().add(wl);
        this.addDocumentListener(this.getDocument(), wl);
        ((Widget.MComboBox)this.getComponent()).addItemListener(this.getItemListener(wl));
    }

    @Override
    protected void setComponentBackground(Color backgroundColor, Color compColor) {
        this.setBackground(Color.WHITE);
    }

    @Override
    public void setBackgroundColor(final Color bg) {
        JComponent comp = this.getComponent();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComboBox.this.setBackground(bg);
            }
        });
    }

    @Override
    Object getItemAt(int i) {
        return ((Widget.MComboBox)this.getComponent()).getItemAt(i);
    }

    @Override
    public void cleanup() {
        this.getWidgetListeners().clear();
        Widget.MComboBox thisCB = (Widget.MComboBox)this.getComponent();
        AbstractDocument dc = (AbstractDocument)this.getDocument();
        for (DocumentListener documentListener : dc.getDocumentListeners()) {
            dc.removeDocumentListener(documentListener);
        }
        for (EventListener eventListener : thisCB.getItemListeners()) {
            thisCB.removeItemListener((ItemListener)eventListener);
        }
    }

    private JTextComponent getTextComponent() {
        JComponent comp = this.getComponent();
        ComboBoxEditor editor = ((Widget.MComboBox)comp).getEditor();
        return (JTextComponent)editor.getEditorComponent();
    }

    @Override
    public void select(int selectionStart, int selectionEnd) {
        this.getTextComponent().select(selectionStart, selectionEnd);
    }
}

