/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.CRMXML;
import lcmc.data.ClusterStatus;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.Subtext;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.resources.HbConnectionInfo;
import lcmc.gui.resources.PcmkRscSetsInfo;
import lcmc.gui.resources.ServiceInfo;
import lcmc.utilities.CRM;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Tools;
import lcmc.utilities.UpdatableItem;

public final class ConstraintPHInfo
extends ServiceInfo {
    static final String NAME = "Placeholder";
    private CRMXML.RscSetConnectionData rscSetConnectionDataCol = null;
    private CRMXML.RscSetConnectionData rscSetConnectionDataOrd = null;
    private boolean reverseCol = false;
    private boolean reverseOrd = false;
    private boolean reversedCol = false;
    private boolean reversedOrd = false;
    private volatile PcmkRscSetsInfo pcmkRscSetsInfo = null;
    private static final String CONSTRAINT_PLACEHOLDER_AND = Tools.getString("ConstraintPHInfo.And");
    private static final String CONSTRAINT_PLACEHOLDER_OR = Tools.getString("ConstraintPHInfo.Or");
    private final Preference preference;

    ConstraintPHInfo(Browser browser, CRMXML.RscSetConnectionData rscSetConnectionData, Preference preference) {
        super(NAME, null, browser);
        this.preference = preference;
        if (rscSetConnectionData != null) {
            if (rscSetConnectionData.isColocation()) {
                this.rscSetConnectionDataCol = rscSetConnectionData;
            } else {
                this.rscSetConnectionDataOrd = rscSetConnectionData;
            }
        }
    }

    CRMXML.RscSetConnectionData getRscSetConnectionDataCol() {
        return this.rscSetConnectionDataCol;
    }

    CRMXML.RscSetConnectionData getRscSetConnectionDataOrd() {
        return this.rscSetConnectionDataOrd;
    }

    public void resetRscSetConnectionData() {
        CRMXML.RscSetConnectionData rcdata;
        CRMXML.RscSetConnectionData rodata = this.rscSetConnectionDataOrd;
        if (rodata != null && rodata.isEmpty()) {
            this.rscSetConnectionDataOrd = null;
        }
        if ((rcdata = this.rscSetConnectionDataCol) != null && rcdata.isEmpty()) {
            this.rscSetConnectionDataCol = null;
        }
    }

    void setRscSetConnectionData(CRMXML.RscSetConnectionData rscSetConnectionData) {
        if (rscSetConnectionData.isColocation()) {
            if (this.reverseCol) {
                if (rscSetConnectionData.getRscSet2() == null && rscSetConnectionData.getRscSet1() != null) {
                    this.reversedCol = true;
                    rscSetConnectionData.reverse();
                    this.reverseCol = false;
                }
            } else if (this.rscSetConnectionDataCol != null) {
                if (rscSetConnectionData.getRscSet2() == null && rscSetConnectionData.getRscSet1() != null && this.rscSetConnectionDataCol.getRscSet2() != null && (rscSetConnectionData.getRscSet1().isSubsetOf(this.rscSetConnectionDataCol.getRscSet2()) || this.rscSetConnectionDataCol.getRscSet2().isSubsetOf(rscSetConnectionData.getRscSet1()))) {
                    this.reversedCol = true;
                    rscSetConnectionData.reverse();
                }
            } else {
                this.reversedCol = false;
            }
            this.rscSetConnectionDataCol = rscSetConnectionData;
        } else {
            if (this.reverseOrd) {
                if (rscSetConnectionData.getRscSet2() == null && rscSetConnectionData.getRscSet1() != null) {
                    Tools.debug(this, "force reverse ord", 3);
                    Tools.debug(this, " data rscset1: " + rscSetConnectionData.getRscSet1().getRscIds(), 3);
                    this.reversedOrd = true;
                    rscSetConnectionData.reverse();
                    this.reverseOrd = false;
                }
            } else if (this.rscSetConnectionDataOrd != null) {
                if (rscSetConnectionData.getRscSet2() == null && rscSetConnectionData.getRscSet1() != null && this.rscSetConnectionDataOrd.getRscSet2() != null && (rscSetConnectionData.getRscSet1().isSubsetOf(this.rscSetConnectionDataOrd.getRscSet2()) || this.rscSetConnectionDataOrd.getRscSet2().isSubsetOf(rscSetConnectionData.getRscSet1()))) {
                    Tools.debug(this, "data rscset1: " + rscSetConnectionData.getRscSet1(), 3);
                    if (rscSetConnectionData.getRscSet1() != null) {
                        Tools.debug(this, "data rscset1 ids: " + rscSetConnectionData.getRscSet1().getRscIds(), 3);
                    }
                    Tools.debug(this, "data rscset2: " + rscSetConnectionData.getRscSet2(), 3);
                    if (rscSetConnectionData.getRscSet2() != null) {
                        Tools.debug(this, "data rscset2 ids: " + rscSetConnectionData.getRscSet2().getRscIds(), 3);
                    }
                    Tools.debug(this, "ord rscset1: " + this.rscSetConnectionDataOrd.getRscSet1(), 3);
                    if (this.rscSetConnectionDataOrd.getRscSet1() != null) {
                        Tools.debug(this, "ord rscset1 ids: " + this.rscSetConnectionDataOrd.getRscSet1().getRscIds(), 3);
                    }
                    Tools.debug(this, "ord rscset2: " + this.rscSetConnectionDataOrd.getRscSet2(), 3);
                    if (this.rscSetConnectionDataOrd.getRscSet2() != null) {
                        Tools.debug(this, "ord rscset2 ids: " + this.rscSetConnectionDataOrd.getRscSet2().getRscIds(), 3);
                    }
                    Tools.debug(this, "reverse ord", 3);
                    this.reversedOrd = true;
                    rscSetConnectionData.reverse();
                }
            } else {
                this.reversedOrd = false;
            }
            this.rscSetConnectionDataOrd = rscSetConnectionData;
        }
    }

    @Override
    protected String getParamLongDesc(String param) {
        return null;
    }

    @Override
    protected String getParamShortDesc(String param) {
        return null;
    }

    @Override
    protected boolean checkParam(String param, String newValue) {
        return true;
    }

    @Override
    public String getParamDefault(String param) {
        return "default";
    }

    @Override
    protected String getParamPreferred(String param) {
        return null;
    }

    @Override
    public String[] getParametersFromXML() {
        return new String[0];
    }

    @Override
    protected Object[] getParamPossibleChoices(String param) {
        return null;
    }

    @Override
    protected String getParamType(String param) {
        return null;
    }

    @Override
    protected String getSection(String param) {
        return null;
    }

    @Override
    protected boolean isCheckBox(String param) {
        return false;
    }

    @Override
    protected boolean isTimeType(String param) {
        return false;
    }

    @Override
    protected boolean isInteger(String param) {
        return false;
    }

    @Override
    protected boolean isRequired(String param) {
        return true;
    }

    @Override
    void apply(Host dcHost, boolean testOnly) {
    }

    @Override
    protected boolean isAdvanced(String param) {
        return true;
    }

    @Override
    protected ConfigData.AccessType getAccessType(String param) {
        return ConfigData.AccessType.ADMIN;
    }

    @Override
    public String toString() {
        return this.getName() + " (" + this.getService().getId() + ")";
    }

    @Override
    public String getId() {
        CRMXML.RscSetConnectionData rcdata;
        String ordId = "";
        String colId = "";
        CRMXML.RscSetConnectionData rodata = this.rscSetConnectionDataOrd;
        if (rodata != null) {
            ordId = rodata.getConstraintId() + "-" + rodata.getConnectionPos();
        }
        if ((rcdata = this.rscSetConnectionDataCol) != null) {
            colId = rcdata.getConstraintId() + "-" + rcdata.getConnectionPos();
        }
        return "ph_" + ordId + "_" + colId;
    }

    @Override
    public JComponent getInfoPanel() {
        PcmkRscSetsInfo prsi = this.pcmkRscSetsInfo;
        return prsi.getInfoPanel(this);
    }

    @Override
    public String getToolTipText(boolean testOnly) {
        return Tools.getString("ConstraintPHInfo.ToolTip");
    }

    @Override
    public List<UpdatableItem> createPopup() {
        ArrayList<UpdatableItem> items = new ArrayList<UpdatableItem>();
        boolean testOnly = false;
        this.addDependencyMenuItems(items, true, false);
        MyMenuItem removeMenuItem = new MyMenuItem(Tools.getString("ConstraintPHInfo.Remove"), ClusterBrowser.REMOVE_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (ConstraintPHInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                if (ConstraintPHInfo.this.getService().isRemoved()) {
                    return "it is being removed";
                }
                return null;
            }

            @Override
            public void action() {
                ConstraintPHInfo.this.hidePopup();
                ConstraintPHInfo.this.removeMyself(false);
                ConstraintPHInfo.this.getBrowser().getCRMGraph().repaint();
            }
        };
        ClusterBrowser clusterBrowser = this.getBrowser();
        clusterBrowser.getClass();
        ClusterBrowser.ClMenuItemCallback removeItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser, removeMenuItem, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && !ConstraintPHInfo.this.getService().isNew();
            }

            @Override
            public void action(Host dcHost) {
                ConstraintPHInfo.this.removeMyselfNoConfirm(dcHost, true);
            }
        };
        this.addMouseOverListener(removeMenuItem, removeItemCallback);
        items.add(removeMenuItem);
        return items;
    }

    @Override
    protected void removeMyselfNoConfirm(Host dcHost, boolean testOnly) {
        if (this.getService().isNew()) {
            if (!testOnly) {
                HbConnectionInfo[] hbcis;
                this.setUpdated(true);
                this.getService().setRemoved(true);
                for (HbConnectionInfo hbci : hbcis = this.getBrowser().getCRMGraph().getHbConnections(this)) {
                    this.getBrowser().getCRMGraph().removeConnection(hbci, dcHost, testOnly);
                }
                this.getService().setNew(false);
                this.getBrowser().removeFromServiceInfoHash(this);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConstraintPHInfo.this.getBrowser().getCRMGraph().killRemovedVertices();
                        ConstraintPHInfo.this.getService().doneRemoving();
                    }
                });
            }
        } else {
            String colId;
            String ordId;
            if (this.rscSetConnectionDataOrd != null && (ordId = this.rscSetConnectionDataOrd.getConstraintId()) != null) {
                CRM.removeOrder(dcHost, ordId, testOnly);
            }
            if (this.rscSetConnectionDataCol != null && (colId = this.rscSetConnectionDataCol.getConstraintId()) != null) {
                CRM.removeColocation(dcHost, colId, testOnly);
            }
            if (!testOnly) {
                this.setUpdated(true);
                this.getService().setRemoved(true);
            }
        }
    }

    @Override
    public void removeMyself(boolean testOnly) {
        if (this.getService().isNew()) {
            this.removeMyselfNoConfirm(this.getBrowser().getDCHost(), testOnly);
            this.getService().setNew(false);
            return;
        }
        String desc = Tools.getString("ConstraintPHInfo.confirmRemove.Description");
        if (Tools.confirmDialog(Tools.getString("ConstraintPHInfo.confirmRemove.Title"), desc, Tools.getString("ConstraintPHInfo.confirmRemove.Yes"), Tools.getString("ConstraintPHInfo.confirmRemove.No"))) {
            this.removeMyselfNoConfirm(this.getBrowser().getDCHost(), testOnly);
            this.getService().setNew(false);
        }
    }

    @Override
    public void setUpdated(boolean updated) {
        if (updated && !this.isUpdated()) {
            this.getBrowser().getCRMGraph().startAnimation(this);
        } else if (!updated) {
            this.getBrowser().getCRMGraph().stopAnimation(this);
        }
        super.setUpdated(updated);
    }

    @Override
    public boolean isConstraintPH() {
        return true;
    }

    void reverseOrder() {
        this.reverseOrd = true;
    }

    void reverseColocation() {
        this.reverseCol = true;
    }

    boolean isReversedCol() {
        return this.reversedCol;
    }

    boolean isReversedOrd() {
        return this.reversedOrd;
    }

    protected List<CRMXML.RscSet> addConstraintWithPlaceholder(Set<ServiceInfo> servicesAll, Set<ServiceInfo> servicesFrom, boolean colocation, boolean order, Host dcHost, boolean force, boolean testOnly) {
        boolean createCol = false;
        boolean createOrd = false;
        String colId = null;
        String ordId = null;
        CRMXML.RscSetConnectionData rdataCol = this.getRscSetConnectionDataCol();
        CRMXML.RscSetConnectionData rdataOrd = this.getRscSetConnectionDataOrd();
        CRMXML.RscSet colRscSet1 = null;
        CRMXML.RscSet colRscSet2 = null;
        CRMXML.RscSet ordRscSet1 = null;
        CRMXML.RscSet ordRscSet2 = null;
        if (rdataCol != null) {
            if (colocation) {
                colId = rdataCol.getConstraintId();
            }
            colRscSet1 = rdataCol.getRscSet1();
            colRscSet2 = rdataCol.getRscSet2();
        }
        if (rdataOrd != null) {
            if (order) {
                ordId = rdataOrd.getConstraintId();
            }
            ordRscSet1 = rdataOrd.getRscSet1();
            ordRscSet2 = rdataOrd.getRscSet2();
        }
        if (servicesFrom.isEmpty()) {
            if (!testOnly && order) {
                this.reverseOrder();
            }
            if (!testOnly && colocation) {
                this.reverseColocation();
            }
        }
        CRMXML.RscSet outOrdRscSet1 = null;
        CRMXML.RscSet outOrdRscSet2 = null;
        CRMXML.RscSet outColRscSet1 = null;
        CRMXML.RscSet outColRscSet2 = null;
        String requireAll = this.preference == Preference.AND ? "true" : "false";
        for (ServiceInfo serviceInfo : servicesAll) {
            CRMXML.RscSet newRscSet;
            ArrayList<String> newRscIds;
            CRMXML.RscSet newRscSet2;
            ArrayList<String> newRscIds2;
            ArrayList<String> rscIds;
            ClusterStatus clStatus;
            boolean isFrom = servicesFrom.contains(serviceInfo);
            String idToAdd = serviceInfo.getService().getHeartbeatId();
            if (colocation) {
                clStatus = this.getBrowser().getClusterStatus();
                if (colId == null) {
                    rscIds = new ArrayList<String>();
                    rscIds.add(idToAdd);
                    int colIdInt = Integer.parseInt(this.getService().getId());
                    colId = "c" + colIdInt;
                    while (clStatus.getRscSetsCol(colId) != null) {
                        colId = "c" + ++colIdInt;
                    }
                    createCol = true;
                    if (isFrom) {
                        colRscSet2 = new CRMXML.RscSet(colId, new ArrayList<String>(), "false", requireAll, null, null);
                        outColRscSet1 = colRscSet1 = new CRMXML.RscSet(colId, rscIds, "false", "true", null, null);
                    } else {
                        colRscSet2 = new CRMXML.RscSet(colId, rscIds, "false", "true", null, null);
                        colRscSet1 = new CRMXML.RscSet(colId, new ArrayList<String>(), "false", requireAll, null, null);
                        outColRscSet2 = colRscSet2;
                    }
                } else {
                    boolean colRscSetAdded = false;
                    CRMXML.RscSet toRscSet = isFrom ? (outColRscSet1 == null ? colRscSet1 : outColRscSet1) : (outColRscSet2 == null ? colRscSet2 : outColRscSet2);
                    List<CRMXML.RscSet> rscSetsColList = clStatus.getRscSetsCol(colId);
                    if (rscSetsColList != null) {
                        for (CRMXML.RscSet rscSet : rscSetsColList) {
                            if (rscSet.equals((Object)toRscSet)) {
                                newRscIds2 = new ArrayList<String>();
                                newRscIds2.addAll(rscSet.getRscIds());
                                newRscIds2.add(0, idToAdd);
                                newRscSet2 = new CRMXML.RscSet(rscSet.getId(), newRscIds2, rscSet.getSequential(), rscSet.getRequireAll(), rscSet.getOrderAction(), rscSet.getColocationRole());
                                if (isFrom) {
                                    outColRscSet1 = newRscSet2;
                                } else {
                                    outColRscSet2 = newRscSet2;
                                }
                                colRscSetAdded = true;
                                continue;
                            }
                            if (isFrom) {
                                outColRscSet2 = rscSet;
                                continue;
                            }
                            outColRscSet1 = rscSet;
                        }
                    }
                    if (!colRscSetAdded) {
                        newRscIds = new ArrayList<String>();
                        if (toRscSet == null) {
                            newRscSet = new CRMXML.RscSet(colId, newRscIds, "false", requireAll, null, null);
                        } else {
                            newRscIds.addAll(toRscSet.getRscIds());
                            newRscSet = new CRMXML.RscSet(toRscSet.getId(), newRscIds, toRscSet.getSequential(), toRscSet.getRequireAll(), toRscSet.getOrderAction(), toRscSet.getColocationRole());
                        }
                        newRscSet.addRscId(idToAdd);
                        if (isFrom) {
                            outColRscSet1 = newRscSet;
                        } else {
                            outColRscSet2 = newRscSet;
                        }
                    }
                }
            }
            if (!order) continue;
            clStatus = this.getBrowser().getClusterStatus();
            if (ordId == null) {
                rscIds = new ArrayList();
                rscIds.add(idToAdd);
                int ordIdInt = Integer.parseInt(this.getService().getId());
                ordId = "o" + ordIdInt;
                while (clStatus.getRscSetsOrd(ordId) != null) {
                    ordId = "o" + ++ordIdInt;
                }
                createOrd = true;
                if (isFrom) {
                    ordRscSet1 = new CRMXML.RscSet(ordId, rscIds, "false", "true", null, null);
                    ordRscSet2 = new CRMXML.RscSet(ordId, new ArrayList<String>(), "false", requireAll, null, null);
                    outOrdRscSet1 = ordRscSet1;
                    continue;
                }
                ordRscSet1 = new CRMXML.RscSet(ordId, new ArrayList<String>(), "false", requireAll, null, null);
                outOrdRscSet2 = ordRscSet2 = new CRMXML.RscSet(ordId, rscIds, "false", "true", null, null);
                continue;
            }
            boolean ordRscSetAdded = false;
            CRMXML.RscSet toRscSet = isFrom ? (outOrdRscSet1 == null ? ordRscSet1 : outOrdRscSet1) : (outOrdRscSet2 == null ? ordRscSet2 : outOrdRscSet2);
            List<CRMXML.RscSet> rscSetsOrdList = clStatus.getRscSetsOrd(ordId);
            if (rscSetsOrdList != null) {
                for (CRMXML.RscSet rscSet : rscSetsOrdList) {
                    if (rscSet.equals((Object)toRscSet)) {
                        newRscIds2 = new ArrayList();
                        newRscIds2.addAll(rscSet.getRscIds());
                        newRscIds2.add(idToAdd);
                        newRscSet2 = new CRMXML.RscSet(rscSet.getId(), newRscIds2, rscSet.getSequential(), rscSet.getRequireAll(), rscSet.getOrderAction(), rscSet.getColocationRole());
                        if (isFrom) {
                            outOrdRscSet1 = newRscSet2;
                        } else {
                            outOrdRscSet2 = newRscSet2;
                        }
                        ordRscSetAdded = true;
                        continue;
                    }
                    if (isFrom) {
                        outOrdRscSet2 = rscSet;
                        continue;
                    }
                    outOrdRscSet1 = rscSet;
                }
            }
            if (ordRscSetAdded) continue;
            newRscIds = new ArrayList();
            if (toRscSet == null) {
                newRscSet = new CRMXML.RscSet(ordId, newRscIds, "false", requireAll, null, null);
            } else {
                newRscIds.addAll(toRscSet.getRscIds());
                newRscSet = new CRMXML.RscSet(toRscSet.getId(), newRscIds, toRscSet.getSequential(), toRscSet.getRequireAll(), toRscSet.getOrderAction(), toRscSet.getColocationRole());
            }
            newRscSet.addRscId(idToAdd);
            if (isFrom) {
                outOrdRscSet1 = newRscSet;
                continue;
            }
            outOrdRscSet2 = newRscSet;
        }
        if (!testOnly) {
            this.setUpdated(false);
        }
        ArrayList<CRMXML.RscSet> sets = new ArrayList<CRMXML.RscSet>();
        sets.add(outColRscSet2);
        sets.add(outColRscSet1);
        sets.add(outOrdRscSet1);
        sets.add(outOrdRscSet2);
        if (force) {
            LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
            attrs.put("score", "INFINITY");
            LinkedHashMap<CRMXML.RscSet, Map<String, String>> rscSetsColAttrs = new LinkedHashMap<CRMXML.RscSet, Map<String, String>>();
            LinkedHashMap<CRMXML.RscSet, Map<String, String>> rscSetsOrdAttrs = new LinkedHashMap<CRMXML.RscSet, Map<String, String>>();
            rscSetsColAttrs.put(outColRscSet2, null);
            rscSetsColAttrs.put(outColRscSet1, null);
            rscSetsOrdAttrs.put(outOrdRscSet1, null);
            rscSetsOrdAttrs.put(outOrdRscSet2, null);
            CRM.setRscSet(dcHost, colId, createCol, ordId, createOrd, rscSetsColAttrs, rscSetsOrdAttrs, attrs, testOnly);
        }
        return sets;
    }

    boolean sameConstraintId(CRMXML.RscSetConnectionData otherRdata) {
        if (otherRdata.isColocation()) {
            CRMXML.RscSetConnectionData rdataCol = this.rscSetConnectionDataCol;
            return rdataCol == null || rdataCol.getConstraintId() == null || rdataCol.getConstraintId().equals(otherRdata.getConstraintId());
        }
        CRMXML.RscSetConnectionData rdataOrd = this.rscSetConnectionDataOrd;
        return rdataOrd == null || rdataOrd.getConstraintId() == null || rdataOrd.getConstraintId().equals(otherRdata.getConstraintId());
    }

    void setPcmkRscSetsInfo(PcmkRscSetsInfo pcmkRscSetsInfo) {
        this.pcmkRscSetsInfo = pcmkRscSetsInfo;
    }

    PcmkRscSetsInfo getPcmkRscSetsInfo() {
        return this.pcmkRscSetsInfo;
    }

    @Override
    public void updateAdvancedPanels() {
        super.updateAdvancedPanels();
        PcmkRscSetsInfo prsi = this.pcmkRscSetsInfo;
        if (prsi != null) {
            prsi.updateAdvancedPanels();
        }
    }

    boolean isEmpty() {
        CRMXML.RscSetConnectionData rdataOrd = this.getRscSetConnectionDataOrd();
        CRMXML.RscSetConnectionData rdataCol = this.getRscSetConnectionDataCol();
        return !(rdataOrd != null && !rdataOrd.isEmpty() || rdataCol != null && !rdataCol.isEmpty());
    }

    void getAttributes(boolean isCol, boolean first, Map<CRMXML.RscSet, Map<String, String>> rscSetsAttrs) {
        CRMXML.RscSetConnectionData rscd = isCol ? this.rscSetConnectionDataCol : this.rscSetConnectionDataOrd;
        if (rscd == null) {
            return;
        }
        CRMXML.RscSet rscSet = first ? rscd.getRscSet1() : rscd.getRscSet2();
        rscSetsAttrs.put(rscSet, null);
    }

    public ServiceInfo nextInSequence(ServiceInfo si, boolean isCol) {
        CRMXML.RscSetConnectionData rscd = isCol ? this.rscSetConnectionDataCol : this.rscSetConnectionDataOrd;
        if (rscd == null) {
            return null;
        }
        for (CRMXML.RscSet rscSet : new CRMXML.RscSet[]{rscd.getRscSet1(), rscd.getRscSet2()}) {
            if (rscSet == null || !rscSet.isSequential()) continue;
            List<String> ids = rscSet.getRscIds();
            for (int i = 0; i < ids.size(); ++i) {
                if (i >= ids.size() - 1 || !ids.get(i).equals(si.getHeartbeatId(true))) continue;
                return this.getBrowser().getServiceInfoFromCRMId(ids.get(i + 1));
            }
        }
        return null;
    }

    public ServiceInfo prevInSequence(ServiceInfo si, boolean isCol) {
        CRMXML.RscSetConnectionData rscd = isCol ? this.rscSetConnectionDataCol : this.rscSetConnectionDataOrd;
        if (rscd == null) {
            return null;
        }
        for (CRMXML.RscSet rscSet : new CRMXML.RscSet[]{rscd.getRscSet1(), rscd.getRscSet2()}) {
            if (rscSet == null || !rscSet.isSequential()) continue;
            List<String> ids = rscSet.getRscIds();
            for (int i = ids.size() - 1; i >= 0; --i) {
                if (i <= 0 || !ids.get(i).equals(si.getHeartbeatId(true))) continue;
                return this.getBrowser().getServiceInfoFromCRMId(ids.get(i - 1));
            }
        }
        return null;
    }

    @Override
    public String getMainTextForGraph() {
        CRMXML.RscSetConnectionData rscd = this.rscSetConnectionDataOrd;
        if (this.getService().isNew()) {
            return this.preference == Preference.AND ? CONSTRAINT_PLACEHOLDER_AND : CONSTRAINT_PLACEHOLDER_OR;
        }
        if (rscd == null || rscd.isColocation()) {
            return CONSTRAINT_PLACEHOLDER_AND;
        }
        CRMXML.RscSet rscSet = rscd.getRscSet1();
        if (rscSet != null && !rscSet.isRequireAll()) {
            return CONSTRAINT_PLACEHOLDER_OR;
        }
        return CONSTRAINT_PLACEHOLDER_AND;
    }

    @Override
    public String getIconTextForGraph(boolean testOnly) {
        return "   " + this.getService().getId();
    }

    @Override
    public Subtext[] getSubtextsForGraph(boolean testOnly) {
        return null;
    }

    @Override
    void stopResource(Host dcHost, boolean testOnly) {
    }

    public static enum Preference {
        AND,
        OR;

    }
}

