/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import lcmc.data.AccessMode;
import lcmc.data.CRMXML;
import lcmc.data.ClusterStatus;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.HostLocation;
import lcmc.data.ResourceAgent;
import lcmc.data.Subtext;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.resources.ServiceInfo;
import lcmc.utilities.CRM;
import lcmc.utilities.MyMenu;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Tools;
import lcmc.utilities.UpdatableItem;

final class CloneInfo
extends ServiceInfo {
    private ServiceInfo containedService = null;

    CloneInfo(ResourceAgent ra, String name, boolean master, Browser browser) {
        super(name, ra, browser);
        this.getService().setMaster(master);
    }

    void addCloneServicePanel(final ServiceInfo newServiceInfo) {
        this.containedService = newServiceInfo;
        newServiceInfo.getService().setResourceClass(newServiceInfo.getResourceAgent().getResourceClass());
        newServiceInfo.setCloneInfo(this);
        this.getBrowser().addToHeartbeatIdList(newServiceInfo);
        this.getBrowser().addNameToServiceInfoHash(newServiceInfo);
        final DefaultMutableTreeNode newServiceNode = new DefaultMutableTreeNode(newServiceInfo);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                newServiceInfo.setNode(newServiceNode);
                DefaultMutableTreeNode node = CloneInfo.this.getNode();
                if (node != null) {
                    CloneInfo.this.getBrowser().reloadAndWait(node, false);
                    node.add(newServiceNode);
                }
                CloneInfo.this.getBrowser().reloadAndWait(newServiceNode, true);
            }
        });
    }

    void setCloneServicePanel(ServiceInfo newServiceInfo) {
        this.containedService = newServiceInfo;
        this.getBrowser().addNameToServiceInfoHash(this);
        this.getBrowser().addToHeartbeatIdList(this);
        newServiceInfo.setCloneInfo(this);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(this);
        this.setNode(node);
        this.getBrowser().getServicesNode().add(node);
        node.add(newServiceInfo.getNode());
        this.getBrowser().reloadAndWait(node, true);
    }

    @Override
    public JComponent getInfoPanel() {
        ServiceInfo cs = this.containedService;
        if (cs == null) {
            return new JPanel();
        }
        return cs.getInfoPanel();
    }

    @Override
    public boolean isFailed(boolean testOnly) {
        ServiceInfo ci = this.containedService;
        return ci != null && ci.isFailed(testOnly);
    }

    @Override
    protected String getFailCount(String hostName, boolean testOnly) {
        ServiceInfo ci = this.containedService;
        if (ci != null) {
            return ci.getFailCount(hostName, testOnly);
        }
        return "";
    }

    @Override
    public String getMainTextForGraph() {
        ServiceInfo cs = this.containedService;
        if (cs == null) {
            return super.getMainTextForGraph();
        }
        return cs.getMainTextForGraph();
    }

    @Override
    String getNameForLog() {
        ServiceInfo cs = this.containedService;
        if (cs == null) {
            return super.getName();
        }
        return cs.getName();
    }

    List<String> getSlaveOnNodes(boolean testOnly) {
        ServiceInfo cs = this.containedService;
        if (cs == null) {
            return null;
        }
        ClusterStatus clStatus = this.getBrowser().getClusterStatus();
        if (clStatus == null) {
            return null;
        }
        if (cs.getResourceAgent().isGroup()) {
            List<String> resources = clStatus.getGroupResources(cs.getHeartbeatId(testOnly), testOnly);
            if (resources == null) {
                return null;
            }
            TreeSet<String> slaves = new TreeSet<String>();
            for (String hbId : resources) {
                List<String> slNodes = clStatus.getSlaveOnNodes(hbId, testOnly);
                if (slNodes == null) continue;
                slaves.addAll(slNodes);
            }
            return new ArrayList<String>(slaves);
        }
        return clStatus.getSlaveOnNodes(cs.getHeartbeatId(testOnly), testOnly);
    }

    @Override
    List<String> getRunningOnNodes(boolean testOnly) {
        ServiceInfo cs = this.containedService;
        if (cs != null) {
            ClusterStatus clStatus = this.getBrowser().getClusterStatus();
            if (this.getService().isMaster()) {
                return cs.getMasterOnNodes(testOnly);
            }
            return cs.getRunningOnNodes(testOnly);
        }
        return null;
    }

    @Override
    protected boolean isSlaveOnAllNodes(boolean testOnly) {
        List<String> slaves = this.getSlaveOnNodes(testOnly);
        return slaves != null && slaves.size() == this.getBrowser().getClusterHosts().length;
    }

    @Override
    public List<Color> getHostColors(boolean testOnly) {
        List<String> nodes = this.getRunningOnNodes(testOnly);
        List<String> slaves = this.getSlaveOnNodes(testOnly);
        int nodesCount = 0;
        if (nodes == null) {
            nodes = new ArrayList<String>();
        } else {
            nodesCount = nodes.size();
        }
        int slavesCount = 0;
        if (slaves != null) {
            slavesCount = slaves.size();
        }
        if (nodesCount + slavesCount < this.getBrowser().getClusterHosts().length) {
            ArrayList<Color> colors = new ArrayList<Color>();
            colors.add(ClusterBrowser.FILL_PAINT_STOPPED);
            return colors;
        }
        return this.getBrowser().getCluster().getHostColors(nodes);
    }

    private String getFailCountString(String hostName, boolean testOnly) {
        String failCount;
        String fcString = "";
        ServiceInfo cs = this.containedService;
        if (cs != null && (failCount = cs.getFailCount(hostName, testOnly)) != null) {
            fcString = "INFINITY".equals(failCount) ? " failed" : " failed: " + failCount;
        }
        return fcString;
    }

    @Override
    public Subtext[] getSubtextsForGraph(boolean testOnly) {
        List<String> slaveOnNodes;
        Color color;
        ClusterStatus clStatus;
        List<String> resources;
        ArrayList<Subtext> texts = new ArrayList<Subtext>();
        LinkedHashMap<String, String> notRunningOnNodes = new LinkedHashMap<String, String>();
        for (Host h : this.getBrowser().getClusterHosts()) {
            notRunningOnNodes.put(h.getName().toLowerCase(Locale.US), h.getName());
        }
        texts.add(new Subtext(this.toString(), null, Color.BLACK));
        ServiceInfo cs = this.getContainedService();
        if (cs != null && cs.getResourceAgent().isGroup() && (resources = (clStatus = this.getBrowser().getClusterStatus()).getGroupResources(cs.getHeartbeatId(testOnly), testOnly)) != null) {
            for (String hbId : resources) {
                ServiceInfo si = this.getBrowser().getServiceInfoFromCRMId(hbId);
                if (si == null) {
                    texts.add(new Subtext("   unknown", null, Color.BLACK));
                    continue;
                }
                texts.add(new Subtext("   " + si.toString(), null, Color.BLACK));
            }
        }
        if (this.getBrowser().allHostsDown()) {
            return texts.toArray(new Subtext[texts.size()]);
        }
        Host dcHost = this.getBrowser().getDCHost();
        List<String> runningOnNodes = this.getRunningOnNodes(testOnly);
        if (runningOnNodes != null && !runningOnNodes.isEmpty()) {
            if (cs != null && cs.getResourceAgent().isLinbitDrbd()) {
                texts.add(new Subtext("primary on:", null, Color.BLACK));
            } else if (this.getService().isMaster()) {
                texts.add(new Subtext("master on:", null, Color.BLACK));
            } else {
                texts.add(new Subtext("running on:", null, Color.BLACK));
            }
            List<Color> colors = this.getBrowser().getCluster().getHostColors(runningOnNodes);
            int i = 0;
            for (String n : runningOnNodes) {
                color = i < colors.size() ? colors.get(i) : Color.GRAY;
                texts.add(new Subtext("    " + n + this.getPingCountString(n, testOnly) + this.getFailCountString(n, testOnly), color, Color.BLACK));
                notRunningOnNodes.remove(n.toLowerCase(Locale.US));
                ++i;
            }
        }
        if (this.getService().isMaster() && (slaveOnNodes = this.getSlaveOnNodes(testOnly)) != null && !slaveOnNodes.isEmpty()) {
            List<Color> colors = this.getBrowser().getCluster().getHostColors(slaveOnNodes);
            int i = 0;
            if (cs != null && cs.getResourceAgent().isLinbitDrbd()) {
                texts.add(new Subtext("secondary on:", null, Color.BLACK));
            } else {
                texts.add(new Subtext("slave on:", null, Color.BLACK));
            }
            for (String n : slaveOnNodes) {
                Color color2 = i < colors.size() ? colors.get(i) : Color.GRAY;
                texts.add(new Subtext("    " + n + this.getFailCountString(n, testOnly), color2, Color.BLACK));
                notRunningOnNodes.remove(n.toLowerCase(Locale.US));
                ++i;
            }
        }
        if (!notRunningOnNodes.isEmpty()) {
            Color nColor = ClusterBrowser.FILL_PAINT_STOPPED;
            if (this.isStopped(testOnly)) {
                texts.add(new Subtext("stopped", nColor, Color.BLACK));
            } else {
                texts.add(new Subtext("not running on:", nColor, Color.BLACK));
                for (String n : notRunningOnNodes.keySet()) {
                    String hostName = (String)notRunningOnNodes.get(n);
                    color = nColor;
                    if (this.failedOnHost(hostName, testOnly)) {
                        color = null;
                    }
                    texts.add(new Subtext("    " + hostName + this.getFailCountString(hostName, testOnly), color, Color.BLACK));
                }
            }
        }
        return texts.toArray(new Subtext[texts.size()]);
    }

    @Override
    protected String getPingCountString(String hostName, boolean testOnly) {
        ServiceInfo cs = this.getContainedService();
        if (cs != null) {
            return cs.getPingCountString(hostName, testOnly);
        }
        return "";
    }

    @Override
    public ServiceInfo getContainedService() {
        return this.containedService;
    }

    @Override
    public void removeMyself(boolean testOnly) {
        if (this.getService().isNew()) {
            this.removeMyselfNoConfirm(this.getBrowser().getDCHost(), testOnly);
            this.getService().setNew(false);
            this.containedService.removeInfo();
            this.removeInfo();
            this.getService().doneRemoving();
            return;
        }
        this.containedService.removeMyself(testOnly);
        this.getBrowser().selectServices();
    }

    @Override
    protected void removeMyselfNoConfirm(Host dcHost, boolean testOnly) {
        super.removeMyselfNoConfirm(dcHost, testOnly);
        this.setUpdated(false);
    }

    @Override
    boolean checkResourceFieldsCorrect(String param, String[] params) {
        return this.checkResourceFieldsCorrect(param, params, false);
    }

    boolean checkResourceFieldsCorrect(String param, String[] params, boolean fromServicesInfo) {
        ServiceInfo cs = this.containedService;
        if (cs == null) {
            return false;
        }
        boolean cor = super.checkResourceFieldsCorrect(param, params, fromServicesInfo, true, false);
        boolean ccor = cs.checkResourceFieldsCorrect(param, cs.getParametersFromXML(), fromServicesInfo, true, false);
        return cor && ccor;
    }

    @Override
    public boolean checkResourceFieldsChanged(String param, String[] params) {
        return this.checkResourceFieldsChanged(param, params, false);
    }

    boolean checkResourceFieldsChanged(String param, String[] params, boolean fromServicesInfo) {
        ServiceInfo cs = this.containedService;
        if (cs == null) {
            return false;
        }
        boolean ch = super.checkResourceFieldsChanged(param, params, fromServicesInfo, true, false);
        boolean cch = cs.checkResourceFieldsChanged(param, cs.getParametersFromXML(), fromServicesInfo, true, false);
        return ch || cch;
    }

    @Override
    boolean isStarted(boolean testOnly) {
        Host dcHost = this.getBrowser().getDCHost();
        if (Tools.versionBeforePacemaker(dcHost)) {
            return super.isStarted(testOnly);
        }
        ServiceInfo cs = this.containedService;
        if (cs != null) {
            return cs.isStarted(testOnly) && super.isStarted(testOnly);
        }
        return false;
    }

    @Override
    public boolean isEnslaved(boolean testOnly) {
        Host dcHost = this.getBrowser().getDCHost();
        if (Tools.versionBeforePacemaker(dcHost)) {
            return super.isEnslaved(testOnly);
        }
        ServiceInfo cs = this.containedService;
        if (cs != null) {
            return cs.isEnslaved(testOnly) || super.isEnslaved(testOnly);
        }
        return false;
    }

    @Override
    public boolean isStopped(boolean testOnly) {
        Host dcHost = this.getBrowser().getDCHost();
        if (Tools.versionBeforePacemaker(dcHost)) {
            return super.isStopped(testOnly);
        }
        ServiceInfo cs = this.containedService;
        if (cs != null) {
            return cs.isStopped(testOnly) || super.isStopped(testOnly);
        }
        return false;
    }

    @Override
    public boolean isManaged(boolean testOnly) {
        Host dcHost = this.getBrowser().getDCHost();
        if (Tools.versionBeforePacemaker(dcHost)) {
            return super.isManaged(testOnly);
        }
        ServiceInfo cs = this.containedService;
        if (cs != null) {
            return cs.isManaged(testOnly);
        }
        return false;
    }

    @Override
    void cleanupResource(Host dcHost, boolean testOnly) {
        ServiceInfo cs;
        if (!testOnly) {
            this.setUpdated(true);
        }
        if ((cs = this.containedService) != null) {
            if (Tools.versionBeforePacemaker(dcHost)) {
                for (int i = 0; i < this.getBrowser().getClusterHosts().length; ++i) {
                    CRM.cleanupResource(dcHost, cs.getHeartbeatId(testOnly) + ":" + Integer.toString(i), this.getBrowser().getClusterHosts(), testOnly);
                }
            } else {
                super.cleanupResource(dcHost, testOnly);
            }
        }
    }

    @Override
    void startResource(Host dcHost, boolean testOnly) {
        if (!testOnly) {
            this.setUpdated(true);
        }
        if (Tools.versionBeforePacemaker(dcHost)) {
            super.startResource(dcHost, testOnly);
        } else {
            ServiceInfo cs = this.containedService;
            if (cs != null) {
                cs.startResource(dcHost, testOnly);
            }
        }
    }

    @Override
    protected void addMigrateMenuItems(List<UpdatableItem> items) {
        super.addMigrateMenuItems(items);
        if (!this.getService().isMaster()) {
            return;
        }
        boolean testOnly = false;
        CloneInfo thisClass = this;
        for (final Host host : this.getBrowser().getClusterHosts()) {
            final String hostName = host.getName();
            MyMenuItem migrateFromMenuItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.MigrateFromResource") + " " + hostName + " (stop)", MIGRATE_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, Tools.getString("ClusterBrowser.Hb.MigrateFromResource") + " " + hostName + " (stop) (offline)", MIGRATE_ICON, ClusterBrowser.STARTING_PTEST_TOOLTIP, new AccessMode(ConfigData.AccessType.OP, false), new AccessMode(ConfigData.AccessType.OP, false)){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean predicate() {
                    return host.isClStatus();
                }

                @Override
                public boolean visiblePredicate() {
                    return !host.isClStatus() || this.enablePredicate() == null;
                }

                @Override
                public String enablePredicate() {
                    List<String> runningOnNodes = CloneInfo.this.getRunningOnNodes(false);
                    if (runningOnNodes == null || runningOnNodes.size() < 1) {
                        return "must run";
                    }
                    boolean runningOnNode = false;
                    for (String ron : runningOnNodes) {
                        if (!hostName.toLowerCase(Locale.US).equals(ron.toLowerCase(Locale.US))) continue;
                        runningOnNode = true;
                        break;
                    }
                    if (!CloneInfo.this.getBrowser().clStatusFailed() && CloneInfo.this.getService().isAvailable() && runningOnNode && host.isClStatus()) {
                        return null;
                    }
                    return "";
                }

                @Override
                public void action() {
                    CloneInfo.this.hidePopup();
                    if (CloneInfo.this.getService().isMaster()) {
                        CloneInfo.this.superMigrateFromResource(CloneInfo.this.getBrowser().getDCHost(), hostName, false);
                    } else {
                        CloneInfo.this.migrateFromResource(CloneInfo.this.getBrowser().getDCHost(), hostName, false);
                    }
                }
            };
            ClusterBrowser clusterBrowser = this.getBrowser();
            clusterBrowser.getClass();
            ClusterBrowser.ClMenuItemCallback migrateItemCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser, migrateFromMenuItem, null){
                {
                    ClusterBrowser clusterBrowser = x0;
                    clusterBrowser.getClass();
                    super(x1, x2);
                }

                @Override
                public void action(Host dcHost) {
                    if (CloneInfo.this.getService().isMaster()) {
                        CloneInfo.this.superMigrateFromResource(dcHost, hostName, true);
                    } else {
                        CloneInfo.this.migrateFromResource(dcHost, hostName, true);
                    }
                }
            };
            this.addMouseOverListener(migrateFromMenuItem, migrateItemCallback);
            items.add(migrateFromMenuItem);
        }
    }

    @Override
    void stopResource(Host dcHost, boolean testOnly) {
        if (!testOnly) {
            this.setUpdated(true);
        }
        if (Tools.versionBeforePacemaker(dcHost)) {
            super.stopResource(dcHost, testOnly);
        } else {
            ServiceInfo cs = this.containedService;
            if (cs != null) {
                cs.stopResource(dcHost, testOnly);
            }
        }
    }

    private void superMigrateFromResource(Host dcHost, String fromHost, boolean testOnly) {
        super.migrateFromResource(dcHost, fromHost, testOnly);
    }

    @Override
    void migrateFromResource(Host dcHost, String fromHost, boolean testOnly) {
        String role = null;
        if (this.getService().isMaster()) {
            role = "Master";
        }
        HostLocation hostLoc = new HostLocation("-INFINITY", "eq", null, role);
        String action = this.getMigratedFrom(testOnly) == null ? "migration" : "remigration";
        CRM.setLocation(dcHost, this.getHeartbeatId(testOnly), fromHost, hostLoc, action, testOnly);
    }

    @Override
    void setManaged(boolean isManaged, Host dcHost, boolean testOnly) {
        if (!testOnly) {
            this.setUpdated(true);
        }
        if (Tools.versionBeforePacemaker(dcHost)) {
            super.setManaged(isManaged, dcHost, testOnly);
        } else {
            ServiceInfo cs = this.containedService;
            if (cs != null) {
                cs.setManaged(isManaged, dcHost, testOnly);
            }
        }
    }

    @Override
    protected void addMoreMigrateMenuItems(MyMenu submenu) {
    }

    @Override
    public List<UpdatableItem> createPopup() {
        List<UpdatableItem> items = super.createPopup();
        ServiceInfo cs = this.containedService;
        if (cs == null) {
            return items;
        }
        MyMenu csMenu = new MyMenu(cs.toString(), new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;
            private final Lock mUpdateLock;
            {
                this.mUpdateLock = new ReentrantLock();
            }

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void update() {
                Thread t = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (mUpdateLock.tryLock()) {
                            try {
                                this.updateThread();
                            }
                            finally {
                                mUpdateLock.unlock();
                            }
                        }
                    }
                });
                t.start();
            }

            private void updateThread() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.setEnabled(false);
                    }
                });
                Tools.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        this.removeAll();
                    }
                });
                ServiceInfo cs0 = CloneInfo.this.containedService;
                if (cs0 != null) {
                    for (final UpdatableItem u : cs0.createPopup()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                this.add((JMenuItem)((Object)u));
                                u.update();
                            }
                        });
                    }
                }
                super.update();
            }
        };
        items.add(csMenu);
        return items;
    }

    @Override
    boolean isInfoPanelOk() {
        ServiceInfo cs = this.containedService;
        if (cs != null) {
            return cs.isInfoPanelOk();
        }
        return false;
    }

    @Override
    void updateMenus(Point2D pos) {
        super.updateMenus(pos);
        ServiceInfo cs = this.containedService;
        if (cs != null) {
            cs.updateMenus(pos);
        }
    }

    @Override
    protected String getSection(String param) {
        ServiceInfo cs = this.containedService;
        if (cs != null) {
            String name = this.getService().isMaster() ? "Master/Slave" : "Clone";
            return name + " " + super.getSection(param);
        }
        return super.getSection(param);
    }

    @Override
    protected Object[] getParamPossibleChoices(String param) {
        CRMXML crmXML = this.getBrowser().getCRMXML();
        if (this.isCheckBox(param)) {
            return crmXML.getCheckBoxChoices(this.getResourceAgent(), param);
        }
        return crmXML.getParamPossibleChoices(this.getResourceAgent(), param, this.getService().isMaster());
    }

    @Override
    public ImageIcon getCategoryIcon(boolean testOnly) {
        return this.getMenuIcon(testOnly);
    }
}

