/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.vm;

import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.vm.Network;
import lcmc.gui.dialog.vm.VMConfig;
import lcmc.gui.resources.VMSFilesystemInfo;
import lcmc.gui.resources.VMSVirtualDomainInfo;
import lcmc.utilities.Tools;

final class Filesystem
extends VMConfig {
    private static final long serialVersionUID = 1L;
    private JComponent inputPane = null;
    private static final String[] PARAMS = new String[]{"type", "source_dir", "source_name", "target_dir"};
    private VMSFilesystemInfo vmsfi = null;
    private WizardDialog nextDialogObject = null;

    Filesystem(WizardDialog previousDialog, VMSVirtualDomainInfo vmsVirtualDomainInfo) {
        super(previousDialog, vmsVirtualDomainInfo);
    }

    @Override
    public WizardDialog nextDialog() {
        if (this.nextDialogObject == null) {
            this.nextDialogObject = new Network(this, this.getVMSVirtualDomainInfo());
        }
        return this.nextDialogObject;
    }

    @Override
    protected String getDialogTitle() {
        return Tools.getString("Dialog.vm.Filesystem.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.vm.Filesystem.Description");
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        this.enableComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean enable = Filesystem.this.vmsfi.checkResourceFieldsCorrect(null, Filesystem.this.vmsfi.getRealParametersFromXML());
                Filesystem.this.buttonClass(Filesystem.this.nextButton()).setEnabled(enable);
            }
        });
    }

    @Override
    protected JComponent getInputPane() {
        if (this.vmsfi != null) {
            this.vmsfi.selectMyself();
        }
        if (this.inputPane != null) {
            return this.inputPane;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.setAlignmentY(0.0f);
        if (this.vmsfi == null) {
            this.vmsfi = this.getVMSVirtualDomainInfo().addFilesystemPanel();
        }
        this.vmsfi.waitForInfoPanel();
        this.vmsfi.savePreferredValues();
        this.vmsfi.getResource().setValue("type", "mount");
        this.vmsfi.addWizardParams(optionsPanel, PARAMS, this.buttonClass(this.nextButton()), Tools.getDefaultSize("Dialog.vm.Resource.LabelWidth"), Tools.getDefaultSize("Dialog.vm.Resource.FieldWidth"), null);
        panel.add(optionsPanel);
        JScrollPane sp = new JScrollPane(panel);
        sp.setMaximumSize(new Dimension(Short.MAX_VALUE, 200));
        sp.setPreferredSize(new Dimension(Short.MAX_VALUE, 200));
        this.inputPane = sp;
        return sp;
    }
}

