/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.host;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.host.CheckInstallation;
import lcmc.gui.dialog.host.DialogHost;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

public class DrbdLinbitInst
extends DialogHost {
    private static final long serialVersionUID = 1L;
    private WizardDialog nextDialogObject = null;

    public DrbdLinbitInst(WizardDialog previousDialog, Host host) {
        super(previousDialog, host);
    }

    @Override
    protected final void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        this.getProgressBar().start(50000);
        this.getHost().execCommand("DrbdInst.mkdir", this.getProgressBar(), new ExecCallback(){

            @Override
            public void done(String ans) {
                DrbdLinbitInst.this.checkFile(ans);
            }

            @Override
            public void doneError(String ans, int exitCode) {
                DrbdLinbitInst.this.printErrorAndRetry(Tools.getString("Dialog.Host.DrbdLinbitInst.MkdirError"), ans, exitCode);
            }
        }, null, true, SSH.DEFAULT_COMMAND_TIMEOUT);
    }

    final void checkFile(String ans) {
        this.answerPaneSetText(Tools.getString("Dialog.Host.DrbdLinbitInst.CheckingFile"));
        this.getHost().execCommand("DrbdInst.test", this.getProgressBar(), new ExecCallback(){

            @Override
            public void done(String ans) {
                DrbdLinbitInst.this.answerPaneSetText(Tools.getString("Dialog.Host.DrbdLinbitInst.FileExists"));
                DrbdLinbitInst.this.installDrbd();
            }

            @Override
            public void doneError(String ans, int exitCode) {
                DrbdLinbitInst.this.downloadDrbd();
            }
        }, null, true, SSH.DEFAULT_COMMAND_TIMEOUT);
    }

    final void downloadDrbd() {
        this.answerPaneSetText(Tools.getString("Dialog.Host.DrbdLinbitInst.Downloading"));
        this.getHost().execCommand("DrbdInst.wget", this.getProgressBar(), new ExecCallback(){

            @Override
            public void done(String ans) {
                DrbdLinbitInst.this.installDrbd();
            }

            @Override
            public void doneError(String ans, int exitCode) {
                DrbdLinbitInst.this.printErrorAndRetry(Tools.getString("Dialog.Host.DrbdLinbitInst.WgetError"), ans, exitCode);
            }
        }, null, true, SSH.DEFAULT_COMMAND_TIMEOUT);
    }

    final void installDrbd() {
        this.getHost().setDrbdWasInstalled(true);
        Tools.getConfigData().setLastDrbdInstalledMethod(this.getHost().getDrbdInstallMethod());
        Tools.getConfigData().setLastDrbdInstalledMethod(this.getHost().getDistString("DrbdInst.install.text." + this.getHost().getDrbdInstallMethod()));
        this.answerPaneSetText(Tools.getString("Dialog.Host.DrbdLinbitInst.Installing"));
        this.getHost().execCommandInBash("DrbdInst.install;;;DRBD.load", this.getProgressBar(), new ExecCallback(){

            @Override
            public void done(String ans) {
                DrbdLinbitInst.this.installationDone();
            }

            @Override
            public void doneError(String ans, int exitCode) {
                DrbdLinbitInst.this.printErrorAndRetry(Tools.getString("Dialog.Host.DrbdLinbitInst.InstallationFailed"), ans, exitCode);
            }
        }, null, true, SSH.DEFAULT_COMMAND_TIMEOUT_LONG);
    }

    final void installationDone() {
        this.nextDialogObject = new CheckInstallation(this.getPreviousDialog().getPreviousDialog().getPreviousDialog().getPreviousDialog().getPreviousDialog(), this.getHost());
        this.progressBarDone();
        this.answerPaneSetText(Tools.getString("Dialog.Host.DrbdLinbitInst.InstallationDone"));
        this.enableComponents(new JComponent[]{this.buttonClass(this.backButton())});
        if (Tools.getConfigData().getAutoOptionHost("drbdinst") != null) {
            Tools.sleep(1000);
            this.pressNextButton();
        }
    }

    @Override
    public WizardDialog nextDialog() {
        return this.nextDialogObject;
    }

    @Override
    protected final String getHostDialogTitle() {
        return Tools.getString("Dialog.Host.DrbdLinbitInst.Title");
    }

    @Override
    protected final String getDescription() {
        return Tools.getString("Dialog.Host.DrbdLinbitInst.Description");
    }

    @Override
    protected final JComponent getInputPane() {
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(this.getProgressBarPane());
        pane.add(this.getAnswerPane(Tools.getString("Dialog.Host.DrbdLinbitInst.Executing")));
        SpringUtilities.makeCompactGrid(pane, 2, 1, 0, 0, 0, 0);
        return pane;
    }
}

