/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.host;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.host.DialogHost;
import lcmc.gui.dialog.host.DrbdAvailSourceFiles;
import lcmc.gui.dialog.host.DrbdCommandInst;
import lcmc.gui.dialog.host.DrbdLinbitAvailPackages;
import lcmc.gui.dialog.host.Finish;
import lcmc.gui.dialog.host.HeartbeatInst;
import lcmc.gui.dialog.host.LinbitLogin;
import lcmc.gui.dialog.host.PacemakerInst;
import lcmc.gui.widget.Widget;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.MyButton;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

final class CheckInstallation
extends DialogHost {
    private static final long serialVersionUID = 1L;
    private WizardDialog nextDialogObject = null;
    private final JLabel drbdLabel = new JLabel(": " + Tools.getString("Dialog.Host.CheckInstallation.CheckingDrbd"));
    private final JLabel pmLabel = new JLabel(": " + Tools.getString("Dialog.Host.CheckInstallation.CheckingPm"));
    private final JLabel hbPmLabel = new JLabel(": " + Tools.getString("Dialog.Host.CheckInstallation.CheckingHbPm"));
    private final MyButton drbdButton = new MyButton(Tools.getString("Dialog.Host.CheckInstallation.DrbdInstallButton"));
    private final MyButton pmButton = new MyButton(Tools.getString("Dialog.Host.CheckInstallation.PmInstallButton"));
    private final MyButton hbPmButton = new MyButton(Tools.getString("Dialog.Host.CheckInstallation.HbPmInstallButton"));
    private Widget pmInstMethodWi;
    private Widget hbPmInstMethodWi;
    private Widget drbdInstMethodWi;
    private static final ImageIcon CHECKING_ICON = Tools.createImageIcon(Tools.getDefault("Dialog.Host.CheckInstallation.CheckingIcon"));
    private static final ImageIcon NOT_INSTALLED_ICON = Tools.createImageIcon(Tools.getDefault("Dialog.Host.CheckInstallation.NotInstalledIcon"));
    private static final ImageIcon INSTALLED_ICON = Tools.createImageIcon(Tools.getDefault("Dialog.Host.CheckInstallation.InstalledIcon"));
    private static final ImageIcon UPGR_AVAIL_ICON = Tools.createImageIcon(Tools.getDefault("Dialog.Host.CheckInstallation.UpgrAvailIcon"));
    private static final String PM_PREFIX = "PmInst";
    private static final String HBPM_PREFIX = "HbPmInst";
    private static final String DRBD_PREFIX = "DrbdInst";
    private static final String PM_AUTO_OPTION = "pminst";
    private static final String HBPM_AUTO_OPTION = "hbinst";
    private static final String DRBD_AUTO_OPTION = "drbdinst";
    private final JLabel drbdIcon = new JLabel(CHECKING_ICON);
    private final JLabel pmIcon = new JLabel(CHECKING_ICON);
    private final JLabel hbPmIcon = new JLabel(CHECKING_ICON);
    private boolean drbdOk = false;
    private boolean pmOk = false;
    private boolean hbPmOk = false;
    private final JLabel hbPmJLabel = new JLabel("Pcmk/Heartbeat");
    private final JLabel pmJLabel = new JLabel("Pcmk/Corosync");

    CheckInstallation(WizardDialog previousDialog, Host host) {
        super(previousDialog, host);
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[0]);
    }

    @Override
    protected void initDialogAfterVisible() {
        this.drbdOk = false;
        this.pmOk = false;
        this.hbPmOk = false;
        this.nextDialogObject = new Finish(this, this.getHost());
        final CheckInstallation thisClass = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CheckInstallation.this.drbdButton.setBackgroundColor(Tools.getDefaultColor("ConfigDialog.Button"));
                CheckInstallation.this.drbdButton.setEnabled(false);
                CheckInstallation.this.drbdInstMethodWi.setEnabled(false);
                CheckInstallation.this.pmButton.setEnabled(false);
                CheckInstallation.this.pmInstMethodWi.setEnabled(false);
                CheckInstallation.this.hbPmButton.setEnabled(false);
                CheckInstallation.this.hbPmInstMethodWi.setEnabled(false);
            }
        });
        this.drbdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CheckInstallation.this.drbdOk) {
                    CheckInstallation.this.getHost().setDrbdWillBeUpgraded(true);
                }
                DialogHost.InstallMethods im = (DialogHost.InstallMethods)CheckInstallation.this.drbdInstMethodWi.getValue();
                CheckInstallation.this.getHost().setDrbdInstallMethod(im.getIndex());
                String button = e.getActionCommand();
                if (!CheckInstallation.this.drbdOk || button.equals(Tools.getString("Dialog.Host.CheckInstallation.DrbdCheckForUpgradeButton"))) {
                    if (im.isLinbitMethod()) {
                        CheckInstallation.this.nextDialogObject = new DrbdLinbitAvailPackages(thisClass, CheckInstallation.this.getHost());
                    } else if (im.isSourceMethod()) {
                        CheckInstallation.this.nextDialogObject = new DrbdAvailSourceFiles(thisClass, CheckInstallation.this.getHost());
                    } else {
                        CheckInstallation.this.nextDialogObject = new DrbdCommandInst(thisClass, CheckInstallation.this.getHost());
                        CheckInstallation.this.getHost().setDrbdInstallMethod(im.getIndex());
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CheckInstallation.this.buttonClass(CheckInstallation.this.nextButton()).pressButton();
                        }
                    });
                } else {
                    CheckInstallation.this.nextDialogObject = new LinbitLogin(thisClass, CheckInstallation.this.getHost());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CheckInstallation.this.buttonClass(CheckInstallation.this.nextButton()).pressButton();
                        }
                    });
                }
            }
        });
        this.hbPmButton.setBackgroundColor(Tools.getDefaultColor("ConfigDialog.Button"));
        this.hbPmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckInstallation.this.nextDialogObject = new HeartbeatInst(thisClass, CheckInstallation.this.getHost());
                DialogHost.InstallMethods im = (DialogHost.InstallMethods)CheckInstallation.this.hbPmInstMethodWi.getValue();
                CheckInstallation.this.getHost().setHbPmInstallMethod(im.getIndex());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CheckInstallation.this.buttonClass(CheckInstallation.this.nextButton()).pressButton();
                    }
                });
            }
        });
        this.pmButton.setBackgroundColor(Tools.getDefaultColor("ConfigDialog.Button"));
        this.pmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckInstallation.this.nextDialogObject = new PacemakerInst(thisClass, CheckInstallation.this.getHost());
                DialogHost.InstallMethods im = (DialogHost.InstallMethods)CheckInstallation.this.pmInstMethodWi.getValue();
                CheckInstallation.this.getHost().setPmInstallMethod(im.getIndex());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CheckInstallation.this.buttonClass(CheckInstallation.this.nextButton()).pressButton();
                    }
                });
            }
        });
        this.getHost().execCommand("DrbdCheck.version", this.getProgressBar(), new ExecCallback(){

            @Override
            public void done(String ans) {
                CheckInstallation.this.checkDrbd(ans);
            }

            @Override
            public void doneError(String ans, int exitCode) {
                CheckInstallation.this.checkDrbd("");
            }
        }, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
    }

    void checkDrbd(final String ans) {
        if ("".equals(ans) || "\n".equals(ans)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CheckInstallation.this.drbdLabel.setText(": " + Tools.getString("Dialog.Host.CheckInstallation.DrbdNotInstalled"));
                    CheckInstallation.this.drbdIcon.setIcon(NOT_INSTALLED_ICON);
                    String toolTip = CheckInstallation.this.getInstToolTip(CheckInstallation.DRBD_PREFIX, "1");
                    CheckInstallation.this.drbdInstMethodWi.setToolTipText(toolTip);
                    CheckInstallation.this.drbdButton.setToolTipText(toolTip);
                    CheckInstallation.this.drbdButton.setEnabled(true);
                    CheckInstallation.this.drbdInstMethodWi.setEnabled(true);
                }
            });
        } else {
            this.drbdOk = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CheckInstallation.this.drbdLabel.setText(": " + ans.trim());
                    if (CheckInstallation.this.getHost().isDrbdUpgradeAvailable(ans.trim())) {
                        CheckInstallation.this.drbdIcon.setIcon(UPGR_AVAIL_ICON);
                        CheckInstallation.this.drbdButton.setText(Tools.getString("Dialog.Host.CheckInstallation.DrbdUpgradeButton"));
                        CheckInstallation.this.drbdButton.setEnabled(true);
                        CheckInstallation.this.drbdInstMethodWi.setEnabled(true);
                    } else {
                        CheckInstallation.this.drbdButton.setText(Tools.getString("Dialog.Host.CheckInstallation.DrbdCheckForUpgradeButton"));
                        CheckInstallation.this.drbdIcon.setIcon(INSTALLED_ICON);
                    }
                }
            });
        }
        this.getHost().execCommand("HbCheck.version", this.getProgressBar(), new ExecCallback(){

            @Override
            public void done(String ans) {
                Tools.debug(this, "ans: " + ans, 2);
                CheckInstallation.this.checkAisHbPm(ans);
            }

            @Override
            public void doneError(String ans, int exitCode) {
                this.done("");
            }
        }, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
    }

    void checkAisHbPm(String ans) {
        this.getHost().setPacemakerVersion(null);
        this.getHost().setOpenaisVersion(null);
        this.getHost().setHeartbeatVersion(null);
        this.getHost().setCorosyncVersion(null);
        if (!"".equals(ans) && !"\n".equals(ans)) {
            for (String line : ans.split("\n")) {
                this.getHost().parseInstallationInfo(line);
            }
        }
        final String aisVersion = this.getHost().getOpenaisVersion();
        final String corosyncVersion = this.getHost().getCorosyncVersion();
        String hbVersion = this.getHost().getHeartbeatVersion();
        if (hbVersion == null && (this.getHost().getPacemakerVersion() == null || corosyncVersion == null && aisVersion == null)) {
            DialogHost.InstallMethods pmim;
            DialogHost.InstallMethods hbim = (DialogHost.InstallMethods)this.hbPmInstMethodWi.getValue();
            if (hbim != null) {
                this.hbPmButton.setEnabled(true);
                this.hbPmInstMethodWi.setEnabled(true);
                String toolTip = this.getInstToolTip(HBPM_PREFIX, hbim.getIndex());
                this.hbPmInstMethodWi.setToolTipText(toolTip);
                this.hbPmButton.setToolTipText(toolTip);
            }
            if ((pmim = (DialogHost.InstallMethods)this.pmInstMethodWi.getValue()) != null) {
                this.pmButton.setEnabled(true);
                this.pmInstMethodWi.setEnabled(true);
                String aisToolTip = this.getInstToolTip(PM_PREFIX, pmim.getIndex());
                this.pmInstMethodWi.setToolTipText(aisToolTip);
                this.pmButton.setToolTipText(aisToolTip);
            }
        }
        if (hbVersion == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CheckInstallation.this.hbPmIcon.setIcon(NOT_INSTALLED_ICON);
                    CheckInstallation.this.hbPmLabel.setText(": " + Tools.getString("Dialog.Host.CheckInstallation.HbPmNotInstalled"));
                }
            });
        } else {
            String text;
            this.hbPmOk = true;
            if ("2.1.3".equals(hbVersion) && "sles10".equals(this.getHost().getDistVersion())) {
                hbVersion = "2.1.4";
                text = "2.1.3 (2.1.4)";
            } else {
                text = hbVersion;
            }
            final String hbVersionText = text;
            this.getHost().setHeartbeatVersion(hbVersion);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (CheckInstallation.this.getHost().getPacemakerVersion() == null || CheckInstallation.this.getHost().getHeartbeatVersion().equals(CheckInstallation.this.getHost().getPacemakerVersion())) {
                        CheckInstallation.this.hbPmJLabel.setText("Heartbeat");
                        CheckInstallation.this.hbPmLabel.setText(": " + hbVersionText);
                    } else {
                        CheckInstallation.this.hbPmLabel.setText(": " + CheckInstallation.this.getHost().getPacemakerVersion() + "/" + hbVersionText);
                    }
                    CheckInstallation.this.hbPmIcon.setIcon(INSTALLED_ICON);
                }
            });
        }
        if (this.getHost().getPacemakerVersion() == null || aisVersion == null && corosyncVersion == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CheckInstallation.this.pmIcon.setIcon(NOT_INSTALLED_ICON);
                    CheckInstallation.this.pmLabel.setText(": " + Tools.getString("Dialog.Host.CheckInstallation.PmNotInstalled"));
                    CheckInstallation.this.pmJLabel.setText("Pcmk/Corosync");
                }
            });
        } else {
            this.pmOk = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String coroAisVersion = "no";
                    CheckInstallation.this.pmIcon.setIcon(INSTALLED_ICON);
                    if (corosyncVersion != null) {
                        CheckInstallation.this.pmJLabel.setText("Pcmk/Corosync");
                        coroAisVersion = corosyncVersion;
                    } else if (aisVersion != null) {
                        CheckInstallation.this.pmJLabel.setText("Pcmk/AIS");
                        coroAisVersion = aisVersion;
                    }
                    CheckInstallation.this.pmJLabel.repaint();
                    CheckInstallation.this.pmLabel.setText(": " + CheckInstallation.this.getHost().getPacemakerVersion() + "/" + coroAisVersion);
                }
            });
        }
        if (this.drbdOk && (this.hbPmOk || this.pmOk)) {
            this.progressBarDone();
            this.nextButtonSetEnabled(true);
            this.enableComponents();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CheckInstallation.this.answerPaneSetText(Tools.getString("Dialog.Host.CheckInstallation.AllOk"));
                }
            });
            if (Tools.getConfigData().getAutoOptionHost(DRBD_AUTO_OPTION) != null || Tools.getConfigData().getAutoOptionHost(HBPM_AUTO_OPTION) != null || Tools.getConfigData().getAutoOptionHost(PM_AUTO_OPTION) != null) {
                Tools.sleep(1000);
                this.pressNextButton();
            }
        } else {
            this.progressBarDoneError();
            Tools.debug(this, "drbd: " + this.drbdOk + ", ais/pm: " + this.pmOk + ", hb/pm: " + this.hbPmOk, 2);
            this.printErrorAndRetry(Tools.getString("Dialog.Host.CheckInstallation.SomeFailed"));
        }
        if (!this.drbdOk && Tools.getConfigData().getAutoOptionHost(DRBD_AUTO_OPTION) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Tools.sleep(1000);
                    CheckInstallation.this.drbdButton.pressButton();
                }
            });
        } else if (!this.hbPmOk && Tools.getConfigData().getAutoOptionHost(HBPM_AUTO_OPTION) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Tools.sleep(1000);
                    CheckInstallation.this.hbPmButton.pressButton();
                }
            });
        } else if (!this.pmOk && Tools.getConfigData().getAutoOptionHost(PM_AUTO_OPTION) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Tools.sleep(1000);
                    CheckInstallation.this.pmButton.pressButton();
                }
            });
        }
    }

    @Override
    public WizardDialog nextDialog() {
        return this.nextDialogObject;
    }

    @Override
    protected String getHostDialogTitle() {
        return Tools.getString("Dialog.Host.CheckInstallation.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Host.CheckInstallation.Description");
    }

    private JPanel getInstallationPane() {
        JPanel pane = new JPanel(new SpringLayout());
        this.pmInstMethodWi = this.getInstallationMethods(PM_PREFIX, Tools.getConfigData().isStagingPacemaker(), Tools.getConfigData().getLastHbPmInstalledMethod(), PM_AUTO_OPTION, this.pmButton);
        this.hbPmInstMethodWi = this.getInstallationMethods(HBPM_PREFIX, Tools.getConfigData().isStagingPacemaker(), Tools.getConfigData().getLastHbPmInstalledMethod(), HBPM_AUTO_OPTION, this.hbPmButton);
        this.drbdInstMethodWi = this.getInstallationMethods(DRBD_PREFIX, Tools.getConfigData().isStagingDrbd(), Tools.getConfigData().getLastDrbdInstalledMethod(), DRBD_AUTO_OPTION, this.drbdButton);
        String lastInstalled = Tools.getConfigData().getLastInstalledClusterStack();
        if (lastInstalled != null) {
            if ("Heartbeat".equals(lastInstalled)) {
                this.pmJLabel.setForeground(Color.LIGHT_GRAY);
                this.pmLabel.setForeground(Color.LIGHT_GRAY);
            } else if ("Corosync/OpenAIS".equals(lastInstalled)) {
                this.hbPmJLabel.setForeground(Color.LIGHT_GRAY);
                this.hbPmLabel.setForeground(Color.LIGHT_GRAY);
            }
        }
        pane.add(this.hbPmJLabel);
        pane.add(this.hbPmLabel);
        pane.add(this.hbPmIcon);
        pane.add(this.hbPmInstMethodWi);
        pane.add(this.hbPmButton);
        pane.add(this.pmJLabel);
        pane.add(this.pmLabel);
        pane.add(this.pmIcon);
        pane.add(this.pmInstMethodWi);
        pane.add(this.pmButton);
        pane.add(new JLabel("Drbd"));
        pane.add(this.drbdLabel);
        pane.add(this.drbdIcon);
        pane.add(this.drbdInstMethodWi);
        pane.add(this.drbdButton);
        SpringUtilities.makeCompactGrid(pane, 3, 5, 1, 1, 1, 1);
        return pane;
    }

    @Override
    protected JComponent getInputPane() {
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(this.getInstallationPane());
        pane.add(this.getProgressBarPane());
        pane.add(this.getAnswerPane(Tools.getString("Dialog.Host.CheckInstallation.Checking")));
        SpringUtilities.makeCompactGrid(pane, 3, 1, 0, 0, 0, 0);
        return pane;
    }

    @Override
    protected boolean skipButtonEnabled() {
        return true;
    }
}

