/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.cluster;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.Cluster;
import lcmc.data.ConfigData;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.cluster.ClusterHosts;
import lcmc.gui.dialog.cluster.DialogCluster;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.Tools;

public final class Name
extends DialogCluster {
    private static final long serialVersionUID = 1L;
    private Widget nameField;
    private static final int NAME_FIELD_WIDTH = 120;

    public Name(WizardDialog previousDialog, Cluster cluster) {
        super(previousDialog, cluster);
    }

    @Override
    protected void finishDialog() {
        this.getCluster().setName(this.nameField.getStringValue().trim());
    }

    @Override
    public WizardDialog nextDialog() {
        return new ClusterHosts(this, this.getCluster());
    }

    @Override
    protected void checkFields(Widget field) {
        final boolean isValid = this.nameField.getStringValue().trim().length() > 0;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Name.this.buttonClass(Name.this.nextButton()).setEnabled(isValid);
            }
        });
        Tools.getGUIData().renameSelectedClusterTab(this.nameField.getStringValue().trim());
    }

    @Override
    protected String getClusterDialogTitle() {
        return Tools.getString("Dialog.Cluster.Name.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Cluster.Name.Description");
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        JComponent[] c = new JComponent[]{this.buttonClass(this.nextButton())};
        this.enableComponentsLater(c);
        this.enableComponents();
        if (!Tools.getConfigData().existsCluster(this.getCluster())) {
            Tools.getConfigData().addClusterToClusters(this.getCluster());
            Tools.getGUIData().addClusterTab(this.getCluster());
        }
    }

    @Override
    protected void initDialogAfterVisible() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Name.this.nameField.requestFocus();
            }
        });
        if (!Tools.getConfigData().getAutoClusters().isEmpty()) {
            final String name = Tools.getConfigData().getAutoClusters().get(0);
            if (!".".equals(name)) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Name.this.nameField.setValue(name);
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Name.this.pressNextButton();
                }
            });
        }
    }

    @Override
    protected JComponent getInputPane() {
        JPanel p = new JPanel(new BorderLayout());
        JPanel pane = new JPanel(new SpringLayout());
        JLabel nameLabel = new JLabel(Tools.getString("Dialog.Cluster.Name.EnterName"));
        pane.add(nameLabel);
        String name = this.getCluster().getName();
        if (name == null) {
            name = Tools.getConfigData().getClusters().getDefaultClusterName();
        }
        this.getCluster().setName(name);
        String regexp = "^[ ,\\w.-]+$";
        this.nameField = WidgetFactory.createInstance(Widget.GUESS_TYPE, this.getCluster().getName(), Widget.NO_ITEMS, "^[ ,\\w.-]+$", 120, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        this.addCheckField(this.nameField);
        nameLabel.setLabelFor(this.nameField);
        pane.add(this.nameField);
        SpringUtilities.makeCompactGrid(pane, 1, 2, 1, 1, 1, 1);
        p.add((Component)pane, "South");
        return p;
    }
}

