/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.cluster;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.Exceptions;
import lcmc.data.AccessMode;
import lcmc.data.CastAddress;
import lcmc.data.Cluster;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.resources.NetInterface;
import lcmc.data.resources.Resource;
import lcmc.data.resources.UcastLink;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.cluster.DialogCluster;
import lcmc.gui.dialog.cluster.Init;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.Heartbeat;
import lcmc.utilities.MyButton;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;
import lcmc.utilities.WidgetListener;

final class HbConfig
extends DialogCluster {
    private static final long serialVersionUID = 1L;
    private static final String KEEPALIVE = "keepalive";
    private static final String WARNTIME = "warntime";
    private static final String DEADTIME = "deadtime";
    private static final String INITDEAD = "initdead";
    private static final String CRM = "crm";
    private static final String COMPRESSION = "compression";
    private static final String COMPRESSION_THRESHOLD = "compression_threshold";
    private static final String TRADITIONAL_COMPRESSION = "traditional_compression";
    private static final String LOGFACILITY = "logfacility";
    private static final String USE_LOGD = "use_logd";
    private static final String AUTOJOIN = "autojoin";
    private static final String NODE = "node";
    private static final String[] OPTIONS = new String[]{"keepalive", "warntime", "deadtime", "initdead", "crm", "compression", "compression_threshold", "traditional_compression", "logfacility", "use_logd", "autojoin", "node"};
    private static final Map<String, Widget.Type> OPTION_TYPES = new HashMap<String, Widget.Type>();
    private static final Map<String, String> OPTION_REGEXPS = new HashMap<String, String>();
    private static final Map<String, String> OPTION_DEFAULTS = new HashMap<String, String>();
    private static final Map<String, Integer> OPTION_SIZES = new HashMap<String, Integer>();
    private final Map<String, String[]> optionValues = new HashMap<String, String[]>();
    private final Map<String, Widget> optionsW = new HashMap<String, Widget>();
    private JCheckBox dopdW = null;
    private JCheckBox mgmtdW = null;
    private JPanel mcast;
    private final Set<CastAddress> castAddresses = new LinkedHashSet<CastAddress>();
    private final JLabel configStatus = new JLabel("");
    private final MyButton makeConfigButton = new MyButton(Tools.getString("Dialog.Cluster.HbConfig.CreateHbConfig"));
    private Widget typeW;
    private Widget ifaceW;
    private Widget serialW;
    private Widget ucastLink1W;
    private Widget ucastLink2W;
    private Widget addrW;
    private MyButton addButton;
    private String[] configs;
    private JPanel statusPanel;
    private JCheckBox configCheckbox;
    private final JPanel configPanel = new JPanel();
    private boolean configChanged = false;
    private static final String MCAST_TYPE = "mcast";
    private static final String BCAST_TYPE = "bcast";
    private static final String UCAST_TYPE = "ucast";
    private static final String SERIAL_TYPE = "serial";
    private static final int ADDR_COMBOBOX_WIDTH = 160;
    private static final int LINK_COMBOBOX_WIDTH = 130;
    private static final int TYPE_COMBOBOX_WIDTH = 80;
    private static final int INTF_COMBOBOX_WIDTH = 80;
    private static final int REMOVE_BUTTON_WIDTH = 100;
    private static final int REMOVE_BUTTON_HEIGHT = 14;
    private static final String EDIT_CONFIG_STRING;
    private static final String SEE_EXISTING_STRING;
    private static final String HA_CF_ERROR_STRING = "error: read error";
    private static final String NEWLINE = "\\r?\\n";
    private volatile JScrollPane configScrollPane = null;
    private volatile boolean alreadyMoved = false;
    private CountDownLatch fieldCheckLatch = new CountDownLatch(1);

    HbConfig(WizardDialog previousDialog, Cluster cluster) {
        super(previousDialog, cluster);
        final Host[] hosts = this.getCluster().getHostsArray();
        StringBuilder config = new StringBuilder();
        boolean first = true;
        for (Host host : hosts) {
            if (!first) {
                config.append(' ');
            }
            first = false;
            config.append(host.getHostname());
        }
        this.optionValues.put(NODE, new String[]{config.toString(), ""});
        this.optionValues.put(CRM, new String[]{"respawn", "on", "off"});
        this.optionValues.put(COMPRESSION, new String[]{"", "zlib", "bz2"});
        this.optionValues.put(TRADITIONAL_COMPRESSION, new String[]{"", "on", "off"});
        this.optionValues.put(LOGFACILITY, new String[]{"local0", "local1", "local2", "local3", "local4", "local5", "local6", "local7", "none"});
        this.optionValues.put(USE_LOGD, new String[]{"", "on", "off"});
        this.optionValues.put(AUTOJOIN, new String[]{"", "any", "other", "none"});
        this.configs = new String[hosts.length];
        this.makeConfigButton.setBackgroundColor(Tools.getDefaultColor("ConfigDialog.Button"));
        this.makeConfigButton.setEnabled(false);
        this.makeConfigButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        HbConfig.this.fieldCheckLatch = new CountDownLatch(1);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HbConfig.this.makeConfigButton.setEnabled(false);
                            }
                        });
                        HbConfig.this.disableComponents();
                        StringBuilder config = HbConfig.this.hbConfigHead(false);
                        config.append((CharSequence)HbConfig.this.hbConfigOptions());
                        config.append('\n');
                        config.append((CharSequence)HbConfig.this.hbConfigAddr());
                        config.append((CharSequence)HbConfig.this.hbConfigDopd(HbConfig.this.dopdW.isSelected()));
                        config.append((CharSequence)HbConfig.this.hbConfigMgmtd(HbConfig.this.mgmtdW.isSelected()));
                        Heartbeat.createHBConfig(hosts, config);
                        boolean configOk = HbConfig.this.updateOldHbConfig();
                        if (HbConfig.this.dopdW.isSelected()) {
                            for (Host h : hosts) {
                                String hbV = h.getHeartbeatVersion();
                                boolean wa = false;
                                try {
                                    if (hbV != null && Tools.compareVersions(hbV, "3.0.2") <= 0) {
                                        wa = true;
                                    }
                                }
                                catch (Exceptions.IllegalVersionException e) {
                                    Tools.appWarning(e.getMessage(), e);
                                }
                                Heartbeat.enableDopd(h, wa);
                            }
                        }
                        Heartbeat.reloadHeartbeats(hosts);
                        HbConfig.this.enableComponents();
                        if (configOk) {
                            HbConfig.this.hideRetryButton();
                            HbConfig.this.nextButtonSetEnabled(true);
                            if (!Tools.getConfigData().getAutoClusters().isEmpty()) {
                                Tools.sleep(1000);
                                HbConfig.this.pressNextButton();
                            }
                        }
                    }
                });
                thread.start();
            }
        });
    }

    @Override
    public WizardDialog nextDialog() {
        return new Init(this, this.getCluster());
    }

    @Override
    protected String getClusterDialogTitle() {
        return Tools.getString("Dialog.Cluster.HbConfig.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Cluster.HbConfig.Description");
    }

    @Override
    public String nextButton() {
        return Tools.getString("Dialog.Cluster.HbConfig.NextButton");
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.configPanel.setLayout(new BoxLayout(this.configPanel, 1));
        this.configPanel.setBackground(Tools.getDefaultColor("ConfigDialog.Background"));
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean configOk = HbConfig.this.updateOldHbConfig();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HbConfig.this.makeConfigButton.setEnabled(false);
                    }
                });
                HbConfig.this.enableComponents();
                if (configOk) {
                    HbConfig.this.nextButtonSetEnabled(true);
                    if (!Tools.getConfigData().getAutoClusters().isEmpty()) {
                        Tools.sleep(1000);
                        HbConfig.this.pressNextButton();
                    }
                }
            }
        });
        thread.start();
    }

    private void setNewConfig(String oldConfig) {
        String[] config = oldConfig.split(NEWLINE);
        Pattern bcastP = Pattern.compile("(bcast) (\\w+)");
        Pattern mcastP = Pattern.compile("(mcast) (\\w+) (.*)");
        Pattern serialP = Pattern.compile("(serial) (.*)");
        Pattern ucastP = Pattern.compile("(ucast) (\\w+) (.*)");
        HashMap<String, Pattern> optionPatterns = new HashMap<String, Pattern>();
        for (String option : OPTIONS) {
            optionPatterns.put(option, Pattern.compile("^\\s*" + option + "\\s+(" + OPTION_REGEXPS.get(option) + ")\\s*$"));
        }
        Pattern dopdP = Pattern.compile("^\\s*respawn hacluster .*\\/dopd$");
        Pattern mgmtdP = Pattern.compile("^\\s*respawn root .*\\/mgmtd -v$");
        this.castAddresses.clear();
        HashMap<String, String> optionValues = new HashMap<String, String>();
        for (String line : config) {
            Matcher bcastM = bcastP.matcher(line);
            Matcher mcastM = mcastP.matcher(line);
            Matcher ucastM = ucastP.matcher(line);
            Matcher serialM = serialP.matcher(line);
            Matcher dopdM = dopdP.matcher(line);
            Matcher mgmtdM = mgmtdP.matcher(line);
            String type = this.typeW.getStringValue();
            String iface = "";
            String addr = "";
            String serial = "";
            if (bcastM.matches()) {
                type = bcastM.group(1);
                iface = bcastM.group(2);
            } else if (mcastM.matches()) {
                type = mcastM.group(1);
                iface = mcastM.group(2);
                addr = mcastM.group(3);
            } else if (serialM.matches()) {
                type = serialM.group(1);
                serial = serialM.group(2);
            } else if (ucastM.matches()) {
                type = ucastM.group(1);
                iface = ucastM.group(2);
                addr = ucastM.group(3);
            } else {
                if (dopdM.matches()) {
                    this.dopdW.setSelected(true);
                    continue;
                }
                if (mgmtdM.matches()) {
                    this.mgmtdW.setSelected(true);
                    continue;
                }
                for (String option : OPTIONS) {
                    Matcher m = ((Pattern)optionPatterns.get(option)).matcher(line);
                    if (!m.matches()) continue;
                    optionValues.put(option, m.group(1).trim());
                }
                continue;
            }
            if ("".equals(type)) continue;
            this.castAddresses.add(new CastAddress(type, iface, addr, serial));
        }
        for (String option : OPTIONS) {
            if (optionValues.containsKey(option)) {
                this.optionsW.get(option).setValue(optionValues.get(option));
                continue;
            }
            this.optionsW.get(option).setValue("");
        }
    }

    private boolean updateOldHbConfig() {
        final Host[] hosts = this.getCluster().getHostsArray();
        boolean configOk = false;
        boolean noConfigs = true;
        SSH.ExecCommandThread[] ts = new SSH.ExecCommandThread[hosts.length];
        this.configStatus.setText(Tools.getString("Dialog.Cluster.HbConfig.Loading"));
        int i = 0;
        for (Host h : hosts) {
            final int index = i;
            ts[i] = h.execCommand("Heartbeat.getHbConfig", null, new ExecCallback(){

                @Override
                public void done(String ans) {
                    ((HbConfig)HbConfig.this).configs[index] = ans;
                }

                @Override
                public void doneError(String ans, int exitCode) {
                    ((HbConfig)HbConfig.this).configs[index] = HbConfig.HA_CF_ERROR_STRING;
                }
            }, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
            ++i;
        }
        for (SSH.ExecCommandThread t : ts) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.configs[0].equals(HA_CF_ERROR_STRING)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HbConfig.this.configStatus.setText(hosts[0] + ": " + Tools.getString("Dialog.Cluster.HbConfig.NoConfigFound"));
                }
            });
            this.retry();
            if (!Tools.getConfigData().getAutoClusters().isEmpty()) {
                Tools.sleep(1000);
                this.addButton.pressButton();
            }
        } else {
            int j;
            noConfigs = false;
            for (j = 1; j < this.configs.length; ++j) {
                final Host host = hosts[j];
                if (this.configs[j].equals(HA_CF_ERROR_STRING)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HbConfig.this.configStatus.setText(host + ": " + Tools.getString("Dialog.Cluster.HbConfig.NoConfigFound"));
                        }
                    });
                    break;
                }
                if (this.configs[0].equals(this.configs[j])) continue;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HbConfig.this.configStatus.setText(Tools.getString("Dialog.Cluster.HbConfig.ConfigsNotTheSame"));
                    }
                });
                break;
            }
            if (j < this.configs.length) {
                this.retry();
            } else {
                boolean generated = false;
                Pattern p = Pattern.compile("## generated by (drbd-gui|LCMC).*", 32);
                Matcher m = p.matcher(this.configs[0]);
                if (m.matches()) {
                    generated = true;
                }
                final boolean editableConfig = generated;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HbConfig.this.configStatus.setText(Tools.getString("Dialog.Cluster.HbConfig.ha.cf.ok"));
                        HbConfig.this.configCheckbox.setSelected(false);
                        if (editableConfig) {
                            HbConfig.this.configCheckbox.setText(SEE_EXISTING_STRING);
                        } else {
                            HbConfig.this.configCheckbox.setText(EDIT_CONFIG_STRING);
                        }
                        HbConfig.this.statusPanel.setMaximumSize(HbConfig.this.statusPanel.getPreferredSize());
                    }
                });
                this.setNewConfig(this.configs[0]);
                if (editableConfig) {
                    this.updateConfigPanelEditable(false);
                } else {
                    this.updateConfigPanelExisting();
                }
                this.hideRetryButton();
                configOk = true;
            }
        }
        if (!configOk) {
            final boolean noConfigsF = noConfigs;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (noConfigsF) {
                        HbConfig.this.configCheckbox.setText(SEE_EXISTING_STRING);
                        HbConfig.this.configCheckbox.setSelected(false);
                        HbConfig.this.statusPanel.setMaximumSize(HbConfig.this.statusPanel.getPreferredSize());
                    } else {
                        HbConfig.this.configCheckbox.setText(EDIT_CONFIG_STRING);
                        HbConfig.this.configCheckbox.setSelected(false);
                        HbConfig.this.statusPanel.setMaximumSize(HbConfig.this.statusPanel.getPreferredSize());
                    }
                }
            });
            if (noConfigs) {
                this.updateConfigPanelEditable(false);
            } else {
                this.updateConfigPanelExisting();
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HbConfig.this.fieldCheckLatch.countDown();
            }
        });
        return configOk;
    }

    private void updateConfigPanelExisting() {
        final Host[] hosts = this.getCluster().getHostsArray();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HbConfig.this.makeConfigButton.setEnabled(false);
                HbConfig.this.configPanel.removeAll();
                JPanel insideConfigPanel = new JPanel(new SpringLayout());
                int cols = 0;
                for (int i = 0; i < hosts.length; ++i) {
                    if (HbConfig.HA_CF_ERROR_STRING.equals(HbConfig.this.configs[i])) {
                        ((HbConfig)HbConfig.this).configs[i] = Tools.getString("Dialog.Cluster.HbConfig.NoConfigFound");
                    }
                    JLabel l = new JLabel(hosts[i].getName() + ":");
                    l.setBackground(Color.WHITE);
                    JPanel labelP = new JPanel();
                    labelP.setBackground(Tools.getDefaultColor("ConfigDialog.Background"));
                    labelP.setLayout(new BoxLayout(labelP, 1));
                    labelP.setAlignmentX(0.0f);
                    labelP.add(l);
                    insideConfigPanel.add(labelP);
                    JTextArea ta = new JTextArea(HbConfig.this.configs[i]);
                    ta.setEditable(false);
                    insideConfigPanel.add(ta);
                    cols += 2;
                }
                if (cols > 0) {
                    SpringUtilities.makeCompactGrid(insideConfigPanel, 1, cols, 1, 1, 1, 1);
                    HbConfig.this.configPanel.add(insideConfigPanel);
                }
                HbConfig.this.configPanel.revalidate();
                HbConfig.this.configPanel.repaint();
            }
        });
    }

    private void updateConfigPanelEditable(final boolean configChanged) {
        if (configChanged && this.fieldCheckLatch.getCount() > 0L) {
            return;
        }
        this.configChanged = configChanged;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String[] head;
                if (!configChanged) {
                    HbConfig.this.makeConfigButton.setEnabled(false);
                }
                HbConfig.this.configPanel.removeAll();
                for (String line : head = HbConfig.this.hbConfigHead(true).toString().split(HbConfig.NEWLINE)) {
                    HbConfig.this.configPanel.add(new JLabel(line));
                }
                for (String option : OPTIONS) {
                    HbConfig.this.configPanel.add(HbConfig.this.getComponentPanel(option, (JComponent)HbConfig.this.optionsW.get(option)));
                }
                HbConfig.this.configPanel.add(new JLabel(" "));
                if (HbConfig.this.castAddresses.size() < 2) {
                    JLabel l = HbConfig.this.castAddresses.size() < 1 ? new JLabel(Tools.getString("Dialog.Cluster.HbConfig.WarningAtLeastTwoInt")) : new JLabel(Tools.getString("Dialog.Cluster.HbConfig.WarningAtLeastTwoInt.OneMore"));
                    l.setForeground(Color.RED);
                    HbConfig.this.configPanel.add(l);
                    final JLabel label = l;
                    label.addComponentListener(new ComponentListener(){

                        @Override
                        public void componentHidden(ComponentEvent e) {
                        }

                        @Override
                        public void componentMoved(ComponentEvent e) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (HbConfig.this.alreadyMoved) {
                                        return;
                                    }
                                    HbConfig.this.alreadyMoved = true;
                                    HbConfig.this.configScrollPane.getViewport().setViewPosition(label.getBounds().getLocation());
                                }
                            });
                        }

                        @Override
                        public void componentResized(ComponentEvent e) {
                        }

                        @Override
                        public void componentShown(ComponentEvent e) {
                        }
                    });
                }
                for (CastAddress c : HbConfig.this.castAddresses) {
                    HbConfig.this.configPanel.add(HbConfig.this.getComponentPanel(c.getConfigString(), HbConfig.this.getRemoveButton(c)));
                }
                HbConfig.this.configPanel.add(new JLabel(" "));
                HbConfig.this.configPanel.add(HbConfig.this.mcast);
                String[] dopdLines = HbConfig.this.hbConfigDopd(HbConfig.this.dopdW.isSelected()).toString().split(HbConfig.NEWLINE);
                boolean checkboxDone = false;
                for (String line : dopdLines) {
                    if (checkboxDone) {
                        HbConfig.this.configPanel.add(new JLabel(line));
                        continue;
                    }
                    HbConfig.this.configPanel.add(HbConfig.this.getComponentPanel(line, HbConfig.this.dopdW));
                    checkboxDone = true;
                }
                String[] mgmtdLines = HbConfig.this.hbConfigMgmtd(HbConfig.this.mgmtdW.isSelected()).toString().split(HbConfig.NEWLINE);
                checkboxDone = false;
                for (String line : mgmtdLines) {
                    if (checkboxDone) {
                        HbConfig.this.configPanel.add(new JLabel(line));
                        continue;
                    }
                    HbConfig.this.configPanel.add(HbConfig.this.getComponentPanel(line, HbConfig.this.mgmtdW));
                    checkboxDone = true;
                }
                HbConfig.this.configPanel.revalidate();
                HbConfig.this.configPanel.repaint();
                if (configChanged) {
                    if (HbConfig.this.castAddresses.isEmpty()) {
                        HbConfig.this.makeConfigButton.setEnabled(false);
                    } else {
                        Tools.getGUIData().setAccessible(HbConfig.this.makeConfigButton, ConfigData.AccessType.ADMIN);
                    }
                    if (!Tools.getConfigData().getAutoClusters().isEmpty() && !HbConfig.this.castAddresses.isEmpty()) {
                        Tools.sleep(1000);
                        HbConfig.this.makeConfigButton.pressButton();
                    }
                }
            }
        });
    }

    private MyButton getRemoveButton(final CastAddress c) {
        MyButton removeButton = new MyButton(Tools.getString("Dialog.Cluster.HbConfig.RemoveIntButton"));
        removeButton.setBackgroundColor(Tools.getDefaultColor("ConfigDialog.Button"));
        removeButton.setMaximumSize(new Dimension(100, 14));
        removeButton.setPreferredSize(new Dimension(100, 14));
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        HbConfig.this.castAddresses.remove(c);
                        HbConfig.this.updateConfigPanelEditable(true);
                        HbConfig.this.checkInterface();
                    }
                });
                t.start();
            }
        });
        return removeButton;
    }

    private void checkInterface() {
        String type = this.typeW.getStringValue();
        String addr = "";
        String iface = "";
        String serial = "";
        UcastLink ucastLink1 = null;
        UcastLink ucastLink2 = null;
        if (BCAST_TYPE.equals(type)) {
            iface = this.ifaceW.getStringValue();
        } else if (MCAST_TYPE.equals(type)) {
            iface = this.ifaceW.getStringValue();
            addr = this.addrW.getStringValue();
        } else if (SERIAL_TYPE.equals(type)) {
            serial = this.serialW.getStringValue();
        } else if (UCAST_TYPE.equals(type)) {
            ucastLink1 = (UcastLink)this.ucastLink1W.getValue();
            ucastLink2 = (UcastLink)this.ucastLink2W.getValue();
            if (ucastLink1.getHost() == ucastLink2.getHost()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HbConfig.this.addButton.setEnabled(false);
                    }
                });
                return;
            }
            iface = ucastLink1.getInterface();
            addr = ucastLink2.getIp();
        }
        for (CastAddress c : this.castAddresses) {
            if (!c.equals(type, iface, addr, serial)) continue;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HbConfig.this.addButton.setEnabled(false);
                }
            });
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HbConfig.this.addButton.setEnabled(true);
            }
        });
    }

    private StringBuilder hbConfigHead(boolean fake) {
        StringBuilder config = new StringBuilder(130);
        if (fake) {
            config.append("## to be generated by LCMC ");
        } else {
            config.append("## generated by LCMC ");
        }
        return config;
    }

    private StringBuilder hbConfigOptions() {
        StringBuilder config = new StringBuilder(130);
        config.append(Tools.getRelease());
        config.append("\n\n");
        for (String option : OPTIONS) {
            String value = this.optionsW.get(option).getStringValue();
            if (value == null || "".equals(value)) continue;
            config.append(option);
            config.append(' ');
            config.append(this.optionsW.get(option).getStringValue());
            config.append('\n');
        }
        return config;
    }

    private StringBuilder hbConfigAddr() {
        StringBuilder config = new StringBuilder(80);
        for (CastAddress ca : this.castAddresses) {
            config.append(ca.getConfigString());
            config.append('\n');
        }
        return config;
    }

    private StringBuilder hbConfigDopd(boolean useDopd) {
        StringBuilder config = new StringBuilder(120);
        if (!useDopd) {
            config.append("# ");
        }
        config.append("respawn hacluster ");
        Host[] hosts = this.getCluster().getHostsArray();
        config.append(hosts[0].getHeartbeatLibPath());
        config.append("/dopd\n");
        if (!useDopd) {
            config.append("# ");
        }
        config.append("apiauth dopd gid=haclient uid=hacluster\n");
        return config;
    }

    private StringBuilder hbConfigMgmtd(boolean useMgmt) {
        StringBuilder config = new StringBuilder(120);
        if (!useMgmt) {
            config.append("# ");
        }
        config.append("respawn root ");
        Host[] hosts = this.getCluster().getHostsArray();
        config.append(hosts[0].getHeartbeatLibPath());
        config.append("/mgmtd -v\n");
        if (!useMgmt) {
            config.append("# ");
        }
        config.append("apiauth mgmtd uid=root\n");
        return config;
    }

    private void addInterface(String type) {
        String iface = "";
        String addr = "";
        String serial = "";
        if (MCAST_TYPE.equals(type)) {
            iface = this.ifaceW.getStringValue();
            addr = this.addrW.getStringValue();
        } else if (BCAST_TYPE.equals(type)) {
            iface = this.ifaceW.getStringValue();
        } else if (UCAST_TYPE.equals(type)) {
            iface = ((UcastLink)this.ucastLink1W.getValue()).getInterface();
            addr = ((UcastLink)this.ucastLink2W.getValue()).getIp();
        } else if (SERIAL_TYPE.equals(type)) {
            serial = this.serialW.getStringValue();
        }
        this.castAddresses.add(new CastAddress(type, iface, addr, serial));
        this.updateConfigPanelEditable(true);
        this.checkInterface();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected JComponent getInputPane() {
        void var9_13;
        this.optionsW.clear();
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        Host[] hosts = this.getCluster().getHostsArray();
        Object[] types = new String[]{MCAST_TYPE, BCAST_TYPE, UCAST_TYPE, SERIAL_TYPE};
        this.typeW = WidgetFactory.createInstance(Widget.GUESS_TYPE, MCAST_TYPE, types, Widget.NO_REGEXP, 80, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        Object[] ni = hosts[0].getNetInterfaces();
        Resource defaultNi = null;
        for (NetInterface netInterface : ni) {
            if (netInterface.isLocalHost()) continue;
            defaultNi = netInterface;
            break;
        }
        this.ifaceW = WidgetFactory.createInstance(Widget.GUESS_TYPE, defaultNi.toString(), ni, Widget.NO_REGEXP, 80, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        ArrayList<UcastLink> ulList = new ArrayList<UcastLink>();
        Host[] arr$ = hosts;
        int len$ = arr$.length;
        boolean bl = false;
        while (var9_13 < len$) {
            NetInterface[] netInterfaces;
            Host host = arr$[var9_13];
            for (NetInterface n : netInterfaces = host.getNetInterfaces()) {
                ulList.add(new UcastLink(host, n));
            }
            ++var9_13;
        }
        Object[] ucastLinks = ulList.toArray(new UcastLink[ulList.size()]);
        this.ucastLink1W = WidgetFactory.createInstance(Widget.GUESS_TYPE, Widget.NO_DEFAULT, ucastLinks, Widget.NO_REGEXP, 130, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        this.ucastLink2W = WidgetFactory.createInstance(Widget.GUESS_TYPE, Widget.NO_DEFAULT, ucastLinks, Widget.NO_REGEXP, 130, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        Object[] serialDevs = new String[]{"/dev/ttyS0", "/dev/ttyS1", "/dev/ttyS2", "/dev/ttyS3"};
        this.serialW = WidgetFactory.createInstance(Widget.GUESS_TYPE, Widget.NO_DEFAULT, serialDevs, Widget.NO_REGEXP, 130, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        String string = "^\\d{1,3}(\\.\\d{0,3}(\\d\\.\\d{0,3}(\\d\\.\\d{0,3})( \\d{0,3}(\\d \\d{0,3}(\\d \\d{0,3})?)?)?)?)?$";
        this.addrW = WidgetFactory.createInstance(Widget.GUESS_TYPE, "239.192.0.0 694 1 0", Widget.NO_ITEMS, "^\\d{1,3}(\\.\\d{0,3}(\\d\\.\\d{0,3}(\\d\\.\\d{0,3})( \\d{0,3}(\\d \\d{0,3}(\\d \\d{0,3})?)?)?)?)?$", 160, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        this.typeW.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                String type = HbConfig.this.typeW.getStringValue();
                if (type != null) {
                    if (HbConfig.MCAST_TYPE.equals(type) || HbConfig.BCAST_TYPE.equals(type)) {
                        HbConfig.this.ifaceW.setVisible(true);
                    } else {
                        HbConfig.this.ifaceW.setVisible(false);
                    }
                    if (HbConfig.MCAST_TYPE.equals(type)) {
                        HbConfig.this.addrW.setVisible(true);
                    } else {
                        HbConfig.this.addrW.setVisible(false);
                    }
                    if (HbConfig.SERIAL_TYPE.equals(type)) {
                        HbConfig.this.serialW.setVisible(true);
                    } else {
                        HbConfig.this.serialW.setVisible(false);
                    }
                    if (HbConfig.UCAST_TYPE.equals(type)) {
                        HbConfig.this.ucastLink1W.setVisible(true);
                        HbConfig.this.ucastLink2W.setVisible(true);
                    } else {
                        HbConfig.this.ucastLink1W.setVisible(false);
                        HbConfig.this.ucastLink2W.setVisible(false);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HbConfig.this.mcast.setMaximumSize(HbConfig.this.mcast.getPreferredSize());
                        }
                    });
                    HbConfig.this.checkInterface();
                }
            }
        });
        this.ifaceW.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                HbConfig.this.checkInterface();
            }
        });
        this.serialW.setVisible(false);
        this.serialW.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                HbConfig.this.checkInterface();
            }
        });
        this.ucastLink1W.setVisible(false);
        this.ucastLink2W.setVisible(false);
        this.ucastLink1W.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                HbConfig.this.checkInterface();
            }
        });
        this.ucastLink2W.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                HbConfig.this.checkInterface();
            }
        });
        this.addrW.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                HbConfig.this.checkInterface();
            }
        });
        this.addButton = new MyButton(Tools.getString("Dialog.Cluster.HbConfig.AddIntButton"));
        this.addButton.setBackgroundColor(Tools.getDefaultColor("ConfigDialog.Button"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String type = HbConfig.this.typeW.getStringValue();
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        HbConfig.this.addInterface(type);
                    }
                });
                thread.start();
            }
        });
        this.configScrollPane = new JScrollPane(this.configPanel, 22, 30);
        this.configScrollPane.setPreferredSize(new Dimension(Short.MAX_VALUE, 150));
        this.statusPanel = new JPanel();
        this.statusPanel.add(this.configStatus);
        this.configCheckbox = new JCheckBox("-----", true);
        this.configCheckbox.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Light"));
        Tools.getGUIData().setAccessible(this.configCheckbox, ConfigData.AccessType.ADMIN);
        this.configCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                final String text = HbConfig.this.configCheckbox.getText();
                if (e.getStateChange() == 1) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (EDIT_CONFIG_STRING.equals(text)) {
                                HbConfig.this.updateConfigPanelEditable(HbConfig.this.configChanged);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        HbConfig.this.configCheckbox.setText(SEE_EXISTING_STRING);
                                        HbConfig.this.configCheckbox.setSelected(false);
                                        HbConfig.this.statusPanel.setMaximumSize(HbConfig.this.statusPanel.getPreferredSize());
                                    }
                                });
                            } else if (SEE_EXISTING_STRING.equals(text)) {
                                HbConfig.this.updateConfigPanelExisting();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        HbConfig.this.configCheckbox.setText(EDIT_CONFIG_STRING);
                                        HbConfig.this.configCheckbox.setSelected(false);
                                        HbConfig.this.statusPanel.setMaximumSize(HbConfig.this.statusPanel.getPreferredSize());
                                    }
                                });
                            }
                        }
                    });
                    thread.start();
                }
            }
        });
        this.statusPanel.add(this.configCheckbox);
        this.statusPanel.setAlignmentX(0.0f);
        pane.add(this.statusPanel);
        pane.add(this.configScrollPane);
        this.configScrollPane.setAlignmentX(0.0f);
        this.mcast = new JPanel(new FlowLayout(0));
        this.mcast.setBackground(Tools.getDefaultColor("ConfigDialog.Background"));
        this.mcast.add(new JLabel("# "));
        this.mcast.add(this.typeW);
        this.mcast.add(this.ifaceW);
        this.mcast.add(this.addrW);
        this.mcast.add(this.serialW);
        this.mcast.add(this.ucastLink1W);
        this.mcast.add(this.ucastLink2W);
        this.mcast.add(this.addButton);
        this.mcast.setMaximumSize(this.mcast.getPreferredSize());
        this.mcast.setAlignmentX(0.0f);
        for (String option : OPTIONS) {
            int size = OPTION_SIZES.containsKey(option) ? OPTION_SIZES.get(option) : 40;
            Widget w = WidgetFactory.createInstance(OPTION_TYPES.get(option), OPTION_DEFAULTS.get(option), this.optionValues.get(option), "^" + OPTION_REGEXPS.get(option) + "\\s*$", size, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.ADMIN, false), Widget.NO_BUTTON);
            this.optionsW.put(option, w);
            w.setAlwaysEditable(true);
            w.addListeners(this.getOptionListener());
        }
        this.dopdW = new JCheckBox(Tools.getString("Dialog.Cluster.HbConfig.UseDopdCheckBox"), null, false);
        this.dopdW.setBackground(Tools.getDefaultColor("ConfigDialog.Background"));
        this.dopdW.setToolTipText(Tools.getString("Dialog.Cluster.HbConfig.UseDopdCheckBox.ToolTip"));
        this.dopdW.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        HbConfig.this.updateConfigPanelEditable(true);
                    }
                });
                thread.start();
            }
        });
        this.mgmtdW = new JCheckBox(Tools.getString("Dialog.Cluster.HbConfig.UseMgmtdCheckBox"), null, false);
        this.mgmtdW.setBackground(Tools.getDefaultColor("ConfigDialog.Background"));
        this.mgmtdW.setToolTipText(Tools.getString("Dialog.Cluster.HbConfig.UseMgmtdCheckBox.ToolTip"));
        this.mgmtdW.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        HbConfig.this.updateConfigPanelEditable(true);
                    }
                });
                thread.start();
            }
        });
        this.makeConfigButton.setAlignmentX(0.0f);
        pane.add(this.makeConfigButton);
        return pane;
    }

    @Override
    protected boolean skipButtonEnabled() {
        return true;
    }

    private WidgetListener getOptionListener() {
        return new WidgetListener(){

            @Override
            public void check(Object value) {
                if (HbConfig.this.fieldCheckLatch.getCount() > 0L) {
                    return;
                }
                for (String option : OPTIONS) {
                    Widget w = (Widget)HbConfig.this.optionsW.get(option);
                    if (w == null) continue;
                    if (HbConfig.this.checkRegexp(w.getRegexp(), w.getStringValue())) {
                        w.setBackground(null, null, true);
                        continue;
                    }
                    w.wrongValue();
                }
                Tools.getGUIData().setAccessible(HbConfig.this.makeConfigButton, ConfigData.AccessType.ADMIN);
            }
        };
    }

    private boolean checkRegexp(String regexp, String value) {
        if (regexp != null) {
            Pattern p = Pattern.compile(regexp);
            Matcher m = p.matcher(value);
            return m.matches();
        }
        return true;
    }

    static {
        OPTION_REGEXPS.put(KEEPALIVE, "\\d*");
        OPTION_REGEXPS.put(WARNTIME, "\\d*");
        OPTION_REGEXPS.put(DEADTIME, "\\d*");
        OPTION_REGEXPS.put(INITDEAD, "\\d*");
        OPTION_REGEXPS.put(CRM, "\\w*");
        OPTION_REGEXPS.put(COMPRESSION, "\\w*");
        OPTION_REGEXPS.put(COMPRESSION_THRESHOLD, "\\d*");
        OPTION_REGEXPS.put(TRADITIONAL_COMPRESSION, "\\w*");
        OPTION_REGEXPS.put(LOGFACILITY, "\\w*");
        OPTION_REGEXPS.put(USE_LOGD, "\\w*");
        OPTION_REGEXPS.put(AUTOJOIN, "\\w*");
        OPTION_REGEXPS.put(NODE, ".*?");
        OPTION_DEFAULTS.put(KEEPALIVE, "2");
        OPTION_DEFAULTS.put(WARNTIME, "20");
        OPTION_DEFAULTS.put(DEADTIME, "30");
        OPTION_DEFAULTS.put(INITDEAD, "30");
        OPTION_DEFAULTS.put(CRM, "respawn");
        OPTION_DEFAULTS.put(COMPRESSION, "bz2");
        OPTION_DEFAULTS.put(COMPRESSION_THRESHOLD, "20");
        OPTION_DEFAULTS.put(TRADITIONAL_COMPRESSION, "on");
        OPTION_SIZES.put(CRM, 100);
        OPTION_SIZES.put(COMPRESSION, 80);
        OPTION_SIZES.put(LOGFACILITY, 80);
        OPTION_SIZES.put(USE_LOGD, 50);
        OPTION_SIZES.put(AUTOJOIN, 80);
        OPTION_SIZES.put(NODE, 300);
        EDIT_CONFIG_STRING = Tools.getString("Dialog.Cluster.HbConfig.Checkbox.EditConfig");
        SEE_EXISTING_STRING = Tools.getString("Dialog.Cluster.HbConfig.Checkbox.SeeExisting");
    }
}

