/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.cluster;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.Exceptions;
import lcmc.data.AccessMode;
import lcmc.data.AisCastAddress;
import lcmc.data.Cluster;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.resources.NetInterface;
import lcmc.data.resources.Resource;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.cluster.DialogCluster;
import lcmc.gui.dialog.cluster.Init;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.Corosync;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.MyButton;
import lcmc.utilities.Openais;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;
import lcmc.utilities.WidgetListener;

final class CoroConfig
extends DialogCluster {
    private static final long serialVersionUID = 1L;
    private JPanel mcast;
    private final Set<AisCastAddress> aisCastAddresses = new LinkedHashSet<AisCastAddress>();
    private final JLabel configStatus = new JLabel("");
    private final MyButton makeConfigButton = new MyButton(Tools.getString("Dialog.Cluster.CoroConfig.CreateAisConfig"));
    private Widget typeW;
    private Widget ifaceW;
    private Widget addrW;
    private Widget portW;
    private MyButton addButton;
    private String[] configs;
    private JPanel statusPanel;
    private JCheckBox configCheckbox;
    private final JPanel configPanel = new JPanel();
    private boolean configChanged = false;
    private static final String MCAST_TYPE = "mcast";
    private static final int ADDR_COMBOBOX_WIDTH = 100;
    private static final int PORT_COMBOBOX_WIDTH = 60;
    private static final int TYPE_COMBOBOX_WIDTH = 80;
    private static final int INTF_COMBOBOX_WIDTH = 80;
    private static final int REMOVE_BUTTON_WIDTH = 100;
    private static final int REMOVE_BUTTON_HEIGHT = 14;
    private static final String EDIT_CONFIG_STRING = Tools.getString("Dialog.Cluster.CoroConfig.Checkbox.EditConfig");
    private static final String SEE_EXISTING_STRING = Tools.getString("Dialog.Cluster.CoroConfig.Checkbox.SeeExisting");
    private static final String AIS_CONF_ERROR_STRING = "error: read error";
    private static final String NEWLINE = "\\r?\\n";
    private static final String SPACE_TAB = "        ";
    private volatile JScrollPane configScrollPane = null;
    private volatile boolean alreadyMoved = false;

    CoroConfig(WizardDialog previousDialog, Cluster cluster) {
        super(previousDialog, cluster);
        final Host[] hosts = this.getCluster().getHostsArray();
        this.configs = new String[hosts.length];
        this.makeConfigButton.setBackgroundColor(Tools.getDefaultColor("ConfigDialog.Button"));
        this.makeConfigButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CoroConfig.this.makeConfigButton.setEnabled(false);
                            }
                        });
                        CoroConfig.this.disableComponents();
                        StringBuilder config = CoroConfig.this.aisConfigHead(false);
                        int ringnumber = 0;
                        for (AisCastAddress ca : CoroConfig.this.aisCastAddresses) {
                            config.append('\n');
                            config.append(ca.getConfigString(ringnumber++, "\t"));
                            config.append('\n');
                        }
                        config.append("}\n");
                        String serviceVersion = hosts[0].getDistString("Pacemaker.Service.Ver");
                        config.append((CharSequence)CoroConfig.this.aisConfigPacemaker("\t", serviceVersion));
                        if (hosts[0].isCorosync()) {
                            Corosync.createCorosyncConfig(hosts, config);
                        } else {
                            Openais.createAISConfig(hosts, config);
                        }
                        boolean configOk = CoroConfig.this.updateOldAisConfig();
                        if (hosts[0].isCorosync() && !hosts[0].isOpenaisWrapper()) {
                            Corosync.reloadCorosyncs(hosts);
                        } else {
                            Openais.reloadOpenaises(hosts);
                        }
                        CoroConfig.this.enableComponents();
                        if (configOk) {
                            CoroConfig.this.hideRetryButton();
                            CoroConfig.this.nextButtonSetEnabled(true);
                            if (!Tools.getConfigData().getAutoClusters().isEmpty()) {
                                Tools.sleep(1000);
                                CoroConfig.this.pressNextButton();
                            }
                        }
                    }
                });
                thread.start();
            }
        });
    }

    @Override
    public WizardDialog nextDialog() {
        return new Init(this, this.getCluster());
    }

    @Override
    protected String getClusterDialogTitle() {
        return Tools.getString("Dialog.Cluster.CoroConfig.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Cluster.CoroConfig.Description");
    }

    @Override
    public String nextButton() {
        return Tools.getString("Dialog.Cluster.CoroConfig.NextButton");
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.configPanel.setLayout(new BoxLayout(this.configPanel, 1));
        this.configPanel.setBackground(Tools.getDefaultColor("ConfigDialog.Background"));
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean configOk = CoroConfig.this.updateOldAisConfig();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CoroConfig.this.makeConfigButton.setEnabled(false);
                    }
                });
                CoroConfig.this.enableComponents();
                if (configOk) {
                    CoroConfig.this.nextButtonSetEnabled(true);
                    if (!Tools.getConfigData().getAutoClusters().isEmpty()) {
                        Tools.sleep(1000);
                        CoroConfig.this.pressNextButton();
                    }
                }
            }
        });
        thread.start();
    }

    private void setNewConfig(String oldConfig) {
        String[] config = oldConfig.split(NEWLINE);
        Pattern totemP = Pattern.compile("\\s*totem\\s*\\{\\s*");
        Pattern interfaceP = Pattern.compile("\\s*interface\\s+\\{\\s*");
        Pattern serviceP = Pattern.compile("\\s*service\\s*\\{\\s*");
        Pattern endParenthesesP = Pattern.compile("^\\s*}\\s*");
        Pattern pattern = Pattern.compile("\\s*(\\S+):\\s*(\\S+)\\s*");
        this.aisCastAddresses.clear();
        boolean inTotem = false;
        boolean inInterface = false;
        boolean inService = false;
        String mcastaddr = null;
        String mcastport = null;
        String bindnetaddr = null;
        for (String line : config) {
            String value;
            String name;
            Matcher lineM;
            Matcher endParenthesesM;
            Matcher totemM = totemP.matcher(line);
            Matcher serviceM = serviceP.matcher(line);
            if (!inService && serviceM.matches()) {
                inService = true;
                continue;
            }
            if (!inTotem && totemM.matches()) {
                inTotem = true;
                continue;
            }
            if (inTotem && !inInterface) {
                Matcher interfaceM = interfaceP.matcher(line);
                if (interfaceM.matches()) {
                    inInterface = true;
                    continue;
                }
                Matcher endParenthesesM2 = endParenthesesP.matcher(line);
                if (!endParenthesesM2.matches()) continue;
                inTotem = false;
                continue;
            }
            if (inInterface) {
                endParenthesesM = endParenthesesP.matcher(line);
                if (endParenthesesM.matches()) {
                    this.aisCastAddresses.add(new AisCastAddress(MCAST_TYPE, bindnetaddr, mcastaddr, mcastport));
                    inInterface = false;
                    mcastaddr = null;
                    mcastport = null;
                    bindnetaddr = null;
                    continue;
                }
                lineM = pattern.matcher(line);
                if (!lineM.matches()) continue;
                name = lineM.group(1);
                value = lineM.group(2);
                if ("mcastaddr".equals(name)) {
                    mcastaddr = value;
                    continue;
                }
                if ("mcastport".equals(name)) {
                    mcastport = value;
                    continue;
                }
                if (!"bindnetaddr".equals(name)) continue;
                bindnetaddr = value;
                continue;
            }
            if (!inService) continue;
            endParenthesesM = endParenthesesP.matcher(line);
            if (endParenthesesM.matches()) {
                inService = false;
                continue;
            }
            lineM = pattern.matcher(line);
            if (!lineM.matches()) continue;
            name = lineM.group(1);
            value = lineM.group(2);
        }
        this.checkInterface();
    }

    private boolean updateOldAisConfig() {
        final Host[] hosts = this.getCluster().getHostsArray();
        boolean noConfigs = true;
        boolean configOk = false;
        SSH.ExecCommandThread[] ts = new SSH.ExecCommandThread[hosts.length];
        this.configStatus.setText(Tools.getString("Dialog.Cluster.CoroConfig.Loading"));
        int i = 0;
        String cf = "/etc/corosync/corosync.conf";
        String command = "Corosync.getAisConfig";
        if (!hosts[0].isCorosync()) {
            cf = "/etc/ais/openais.conf";
            command = "OpenAIS.getAisConfig";
        }
        final String configFile = cf;
        for (Host h : hosts) {
            final int index = i;
            ts[i] = h.execCommand(command, null, new ExecCallback(){

                @Override
                public void done(String ans) {
                    ((CoroConfig)CoroConfig.this).configs[index] = ans;
                }

                @Override
                public void doneError(String ans, int exitCode) {
                    ((CoroConfig)CoroConfig.this).configs[index] = CoroConfig.AIS_CONF_ERROR_STRING;
                }
            }, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
            ++i;
        }
        for (SSH.ExecCommandThread t : ts) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.configs[0].equals(AIS_CONF_ERROR_STRING)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CoroConfig.this.configStatus.setText(hosts[0] + Tools.getString("Dialog.Cluster.CoroConfig.NoConfigFound"));
                }
            });
            this.retry();
            if (!Tools.getConfigData().getAutoClusters().isEmpty()) {
                Tools.sleep(1000);
                this.addButton.pressButton();
            }
        } else {
            int j;
            noConfigs = false;
            for (j = 1; j < this.configs.length; ++j) {
                final Host host = hosts[j];
                if (this.configs[j].equals(AIS_CONF_ERROR_STRING)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CoroConfig.this.configStatus.setText(host + ": " + configFile + Tools.getString("Dialog.Cluster.CoroConfig.NoConfigFound"));
                        }
                    });
                    break;
                }
                if (this.configs[0].equals(this.configs[j])) continue;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CoroConfig.this.configStatus.setText(Tools.getString("Dialog.Cluster.CoroConfig.ConfigsNotTheSame"));
                    }
                });
                break;
            }
            if (j < this.configs.length) {
                this.retry();
            } else {
                boolean generated = false;
                Pattern p = Pattern.compile("## generated by (drbd-gui|LCMC).*", 32);
                Matcher m = p.matcher(this.configs[0]);
                if (m.matches()) {
                    generated = true;
                }
                final boolean editableConfig = generated;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CoroConfig.this.configStatus.setText(configFile + Tools.getString("Dialog.Cluster.CoroConfig.ais.conf.ok"));
                        CoroConfig.this.configCheckbox.setSelected(false);
                        if (editableConfig) {
                            CoroConfig.this.configCheckbox.setText(SEE_EXISTING_STRING);
                        } else {
                            CoroConfig.this.configCheckbox.setText(EDIT_CONFIG_STRING);
                        }
                        CoroConfig.this.statusPanel.setMaximumSize(CoroConfig.this.statusPanel.getPreferredSize());
                    }
                });
                this.setNewConfig(this.configs[0]);
                if (editableConfig) {
                    this.updateConfigPanelEditable(false);
                } else {
                    this.updateConfigPanelExisting();
                }
                this.hideRetryButton();
                configOk = true;
            }
        }
        if (!configOk) {
            final boolean noConfigsF = noConfigs;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (noConfigsF) {
                        CoroConfig.this.configCheckbox.setText(SEE_EXISTING_STRING);
                    } else {
                        CoroConfig.this.configCheckbox.setText(EDIT_CONFIG_STRING);
                    }
                    CoroConfig.this.configCheckbox.setSelected(false);
                    CoroConfig.this.statusPanel.setMaximumSize(CoroConfig.this.statusPanel.getPreferredSize());
                }
            });
            if (noConfigs) {
                this.updateConfigPanelEditable(false);
            } else {
                this.updateConfigPanelExisting();
            }
        }
        return configOk;
    }

    private void updateConfigPanelExisting() {
        final Host[] hosts = this.getCluster().getHostsArray();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CoroConfig.this.makeConfigButton.setEnabled(false);
                CoroConfig.this.configPanel.removeAll();
                JPanel insideConfigPanel = new JPanel(new SpringLayout());
                int cols = 0;
                for (int i = 0; i < hosts.length; ++i) {
                    if (CoroConfig.AIS_CONF_ERROR_STRING.equals(CoroConfig.this.configs[i])) {
                        ((CoroConfig)CoroConfig.this).configs[i] = Tools.getString("Dialog.Cluster.CoroConfig.NoConfigFound");
                    }
                    JLabel l = new JLabel(hosts[i].getName() + ":");
                    l.setBackground(Color.WHITE);
                    JPanel labelP = new JPanel();
                    labelP.setBackground(Tools.getDefaultColor("ConfigDialog.Background"));
                    labelP.setLayout(new BoxLayout(labelP, 1));
                    labelP.setAlignmentX(0.0f);
                    labelP.add(l);
                    insideConfigPanel.add(labelP);
                    JTextArea ta = new JTextArea(CoroConfig.this.configs[i]);
                    ta.setEditable(false);
                    insideConfigPanel.add(ta);
                    cols += 2;
                }
                if (cols > 0) {
                    SpringUtilities.makeCompactGrid(insideConfigPanel, 1, cols, 1, 1, 1, 1);
                    CoroConfig.this.configPanel.add(insideConfigPanel);
                }
                CoroConfig.this.configPanel.revalidate();
                CoroConfig.this.configPanel.repaint();
            }
        });
    }

    private void updateConfigPanelEditable(final boolean configChanged) {
        this.configChanged = configChanged;
        final Host[] hosts = this.getCluster().getHostsArray();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String[] pacemakerLines;
                String[] head;
                if (!configChanged) {
                    CoroConfig.this.makeConfigButton.setEnabled(false);
                }
                CoroConfig.this.configPanel.removeAll();
                for (String line : head = CoroConfig.this.aisConfigHead(true).toString().split(CoroConfig.NEWLINE)) {
                    CoroConfig.this.configPanel.add(new JLabel(line));
                }
                int ringnumber = 0;
                for (AisCastAddress c : CoroConfig.this.aisCastAddresses) {
                    CoroConfig.this.configPanel.add(new JLabel(""));
                    String[] interfaceLines = c.getConfigString(ringnumber++, CoroConfig.SPACE_TAB).split(CoroConfig.NEWLINE);
                    boolean firstLine = true;
                    for (String interfaceLine : interfaceLines) {
                        if (firstLine) {
                            CoroConfig.this.configPanel.add(CoroConfig.this.getComponentPanel(interfaceLine, CoroConfig.this.getRemoveButton(c)));
                            firstLine = false;
                            continue;
                        }
                        CoroConfig.this.configPanel.add(new JLabel(interfaceLine));
                    }
                }
                if (CoroConfig.this.aisCastAddresses.size() < 2) {
                    JLabel l = CoroConfig.this.aisCastAddresses.size() < 1 ? new JLabel(Tools.getString("Dialog.Cluster.CoroConfig.WarningAtLeastTwoInt")) : new JLabel(Tools.getString("Dialog.Cluster.CoroConfig.WarningAtLeastTwoInt.OneMore"));
                    l.setForeground(Color.RED);
                    CoroConfig.this.configPanel.add(l);
                    CoroConfig.this.configPanel.add(new JLabel(""));
                    final JLabel label = l;
                    label.addComponentListener(new ComponentListener(){

                        @Override
                        public void componentHidden(ComponentEvent e) {
                        }

                        @Override
                        public void componentMoved(ComponentEvent e) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (CoroConfig.this.alreadyMoved) {
                                        return;
                                    }
                                    CoroConfig.this.alreadyMoved = true;
                                    CoroConfig.this.configScrollPane.getViewport().setViewPosition(label.getBounds().getLocation());
                                }
                            });
                        }

                        @Override
                        public void componentResized(ComponentEvent e) {
                        }

                        @Override
                        public void componentShown(ComponentEvent e) {
                        }
                    });
                }
                CoroConfig.this.configPanel.add(new JLabel(""));
                CoroConfig.this.configPanel.add(CoroConfig.this.mcast);
                CoroConfig.this.configPanel.add(new JLabel("}"));
                String serviceVersion = hosts[0].getDistString("Pacemaker.Service.Ver");
                for (String line : pacemakerLines = CoroConfig.this.aisConfigPacemaker(CoroConfig.SPACE_TAB, serviceVersion).toString().split(CoroConfig.NEWLINE)) {
                    CoroConfig.this.configPanel.add(new JLabel(line));
                }
                CoroConfig.this.configPanel.revalidate();
                CoroConfig.this.configPanel.repaint();
                if (configChanged) {
                    if (CoroConfig.this.aisCastAddresses.isEmpty()) {
                        CoroConfig.this.makeConfigButton.setEnabled(false);
                    } else {
                        Tools.getGUIData().setAccessible(CoroConfig.this.makeConfigButton, ConfigData.AccessType.ADMIN);
                    }
                    if (!Tools.getConfigData().getAutoClusters().isEmpty() && !CoroConfig.this.aisCastAddresses.isEmpty()) {
                        Tools.sleep(1000);
                        CoroConfig.this.makeConfigButton.pressButton();
                    }
                }
            }
        });
    }

    private MyButton getRemoveButton(final AisCastAddress c) {
        MyButton removeButton = new MyButton(Tools.getString("Dialog.Cluster.CoroConfig.RemoveIntButton"));
        removeButton.setBackgroundColor(Tools.getDefaultColor("ConfigDialog.Button"));
        removeButton.setMaximumSize(new Dimension(100, 14));
        removeButton.setPreferredSize(new Dimension(100, 14));
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        CoroConfig.this.aisCastAddresses.remove(c);
                        CoroConfig.this.updateConfigPanelEditable(true);
                        CoroConfig.this.checkInterface();
                    }
                });
                t.start();
            }
        });
        return removeButton;
    }

    private void checkInterface() {
        String type = this.typeW.getStringValue();
        String address = "";
        String bindnetaddr = "";
        String port = "";
        if (MCAST_TYPE.equals(type)) {
            NetInterface iface = (NetInterface)this.ifaceW.getValue();
            bindnetaddr = iface.getBindnetaddr();
            address = this.addrW.getStringValue();
            port = this.portW.getStringValue();
        }
        for (AisCastAddress c : this.aisCastAddresses) {
            if (!c.equals("\t", type, bindnetaddr, address, port)) continue;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CoroConfig.this.addButton.setEnabled(false);
                }
            });
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CoroConfig.this.addButton.setEnabled(true);
            }
        });
    }

    private StringBuilder plugins(boolean fake) {
        StringBuilder config = new StringBuilder(500);
        String tab = fake ? SPACE_TAB : "\t";
        config.append("aisexec {\n");
        config.append(tab);
        config.append("user: root\n");
        config.append(tab);
        config.append("group: root\n}\n\ncorosync {\n");
        config.append(tab);
        config.append("user: root\n");
        config.append(tab);
        config.append("group: root\n}\n\namf {\n");
        config.append(tab);
        config.append("mode: disabled\n}\n\n");
        return config;
    }

    private StringBuilder aisConfigHead(boolean fake) {
        String tab;
        StringBuilder config = new StringBuilder(500);
        if (fake) {
            config.append("## to be generated by LCMC ");
            tab = SPACE_TAB;
        } else {
            config.append("## generated by LCMC ");
            tab = "\t";
        }
        config.append(Tools.getRelease());
        config.append("\n\n");
        Host[] hosts = this.getCluster().getHostsArray();
        boolean corosync2 = false;
        try {
            corosync2 = Tools.compareVersions(hosts[0].getCorosyncVersion(), "2") >= 0;
        }
        catch (Exceptions.IllegalVersionException e) {
            Tools.appWarning("cannot compare corosync version: " + hosts[0].getCorosyncVersion());
        }
        if (!corosync2) {
            config.append((CharSequence)this.plugins(fake));
        }
        config.append("logging {\n");
        if (corosync2) {
            config.append(tab);
            config.append("fileline: off\n");
            config.append(tab);
            config.append("to_logfile: yes\n");
            config.append(tab);
            config.append("logfile: /var/log/cluster/corosync.log\n");
        }
        config.append(tab);
        config.append("to_stderr: no\n");
        config.append(tab);
        config.append("debug: off\n");
        config.append(tab);
        config.append("timestamp: on\n");
        config.append(tab);
        config.append("to_syslog: yes\n");
        if (corosync2) {
            config.append(tab);
            config.append("logger_subsys {\n");
            config.append(tab);
            config.append(tab);
            config.append("subsys: QUORUM\n");
            config.append(tab);
            config.append(tab);
            config.append("debug: off\n");
            config.append(tab);
            config.append("}\n");
        } else {
            config.append(tab);
            config.append("to_file: no\n");
            config.append(tab);
            config.append("syslog_facility: daemon\n");
        }
        config.append("}\n\ntotem {\n");
        config.append(tab);
        config.append("version: 2\n");
        config.append(tab);
        config.append("token: 3000\n");
        config.append(tab);
        config.append("secauth: on\n");
        if (!corosync2) {
            config.append(tab);
            config.append("token_retransmits_before_loss_const: 10\n");
            config.append(tab);
            config.append("join: 60\n");
            config.append(tab);
            config.append("consensus: 4000\n");
            config.append(tab);
            config.append("vsftype: none\n");
            config.append(tab);
            config.append("max_messages: 20\n");
            config.append(tab);
            config.append("clear_node_high_bit: yes\n");
            config.append(tab);
            config.append("threads: 0\n");
            config.append(tab);
            config.append("# nodeid: 1234\n");
        }
        config.append(tab);
        config.append("rrp_mode: active\n");
        return config;
    }

    private StringBuilder aisConfigPacemaker(String tab, String serviceVersion) {
        StringBuilder config = new StringBuilder(120);
        Host[] hosts = this.getCluster().getHostsArray();
        boolean corosync2 = false;
        try {
            corosync2 = Tools.compareVersions(hosts[0].getCorosyncVersion(), "2") >= 0;
        }
        catch (Exceptions.IllegalVersionException e) {
            Tools.appWarning("cannot compare corosync version: " + hosts[0].getCorosyncVersion());
        }
        if (corosync2) {
            config.append("\nquorum {\n");
            config.append(tab);
            config.append("provider: corosync_votequorum\n");
            config.append(tab);
            config.append("expected_votes: ");
            config.append(hosts.length);
            config.append("\n}\n");
        } else {
            config.append("\nservice {\n");
            config.append(tab);
            config.append("ver: ");
            config.append(serviceVersion);
            config.append('\n');
            config.append(tab);
            config.append("name: pacemaker\n");
            config.append(tab);
            config.append("use_mgmtd: no\n");
            config.append("}\n");
        }
        return config;
    }

    private void addInterface(String type) {
        String bindnetaddr = "";
        String addr = "";
        String port = "";
        if (MCAST_TYPE.equals(type)) {
            NetInterface iface = (NetInterface)this.ifaceW.getValue();
            bindnetaddr = iface.getBindnetaddr();
            addr = this.addrW.getStringValue();
            port = this.portW.getStringValue();
        }
        this.aisCastAddresses.add(new AisCastAddress(type, bindnetaddr, addr, port));
        this.updateConfigPanelEditable(true);
        this.checkInterface();
    }

    @Override
    protected JComponent getInputPane() {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        Host[] hosts = this.getCluster().getHostsArray();
        Object[] types = new String[]{MCAST_TYPE};
        this.typeW = WidgetFactory.createInstance(Widget.GUESS_TYPE, MCAST_TYPE, types, Widget.NO_REGEXP, 80, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        this.typeW.setEnabled(false);
        Object[] ni = hosts[0].getNetInterfaces();
        Resource defaultNi = null;
        for (NetInterface netInterface : ni) {
            if (netInterface.isLocalHost()) continue;
            defaultNi = netInterface;
            break;
        }
        this.ifaceW = WidgetFactory.createInstance(Widget.GUESS_TYPE, defaultNi.toString(), ni, Widget.NO_REGEXP, 80, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        String regexp = "^[\\d.]+$";
        this.addrW = WidgetFactory.createInstance(Widget.GUESS_TYPE, Tools.getDefault("Dialog.Cluster.CoroConfig.DefaultMCastAddress"), Widget.NO_ITEMS, "^[\\d.]+$", 100, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        this.typeW.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                CoroConfig.this.checkInterface();
            }
        });
        this.ifaceW.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                CoroConfig.this.checkInterface();
            }
        });
        String portRegexp = "^\\d+$";
        this.portW = WidgetFactory.createInstance(Widget.GUESS_TYPE, Tools.getDefault("Dialog.Cluster.CoroConfig.DefaultMCastPort"), Widget.NO_ITEMS, "^\\d+$", 60, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        this.portW.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                CoroConfig.this.checkInterface();
            }
        });
        this.addrW.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                CoroConfig.this.checkInterface();
            }
        });
        this.addButton = new MyButton(Tools.getString("Dialog.Cluster.CoroConfig.AddIntButton"));
        this.addButton.setBackgroundColor(Tools.getDefaultColor("ConfigDialog.Button"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String type = CoroConfig.this.typeW.getStringValue();
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        CoroConfig.this.addInterface(type);
                    }
                });
                thread.start();
            }
        });
        this.configScrollPane = new JScrollPane(this.configPanel, 22, 30);
        this.configScrollPane.setPreferredSize(new Dimension(Short.MAX_VALUE, 150));
        this.statusPanel = new JPanel();
        this.statusPanel.add(this.configStatus);
        this.configCheckbox = new JCheckBox("-----", true);
        this.configCheckbox.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Light"));
        Tools.getGUIData().setAccessible(this.configCheckbox, ConfigData.AccessType.ADMIN);
        this.configCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                final String text = CoroConfig.this.configCheckbox.getText();
                if (e.getStateChange() == 1) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (EDIT_CONFIG_STRING.equals(text)) {
                                CoroConfig.this.updateConfigPanelEditable(CoroConfig.this.configChanged);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        CoroConfig.this.configCheckbox.setText(SEE_EXISTING_STRING);
                                        CoroConfig.this.configCheckbox.setSelected(false);
                                        CoroConfig.this.statusPanel.setMaximumSize(CoroConfig.this.statusPanel.getPreferredSize());
                                    }
                                });
                            } else if (SEE_EXISTING_STRING.equals(text)) {
                                CoroConfig.this.updateConfigPanelExisting();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        CoroConfig.this.configCheckbox.setText(EDIT_CONFIG_STRING);
                                        CoroConfig.this.configCheckbox.setSelected(false);
                                        CoroConfig.this.statusPanel.setMaximumSize(CoroConfig.this.statusPanel.getPreferredSize());
                                    }
                                });
                            }
                        }
                    });
                    thread.start();
                }
            }
        });
        this.statusPanel.add(this.configCheckbox);
        this.statusPanel.setAlignmentX(0.0f);
        pane.add(this.statusPanel);
        pane.add(this.configScrollPane);
        this.configScrollPane.setAlignmentX(0.0f);
        this.mcast = new JPanel(new FlowLayout(0));
        this.mcast.setBackground(Tools.getDefaultColor("ConfigDialog.Background"));
        this.mcast.add(new JLabel("# "));
        this.mcast.add(this.typeW);
        this.mcast.add(this.ifaceW);
        this.mcast.add(this.addrW);
        this.mcast.add(this.portW);
        this.mcast.add(this.addButton);
        this.mcast.setPreferredSize(this.mcast.getMinimumSize());
        this.mcast.setAlignmentX(0.0f);
        pane.add(this.makeConfigButton);
        return pane;
    }

    @Override
    protected boolean skipButtonEnabled() {
        return true;
    }
}

