/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog;

import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lcmc.gui.ProgressBar;
import lcmc.gui.dialog.ConfigDialog;
import lcmc.utilities.CancelCallback;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;

public abstract class WizardDialog
extends ConfigDialog {
    private static final long serialVersionUID = 1L;
    private WizardDialog previousDialog;
    private static final ImageIcon CANCEL_ICON = Tools.createImageIcon(Tools.getDefault("Dialog.Dialog.CancelIcon"));
    private static final ImageIcon FINISH_ICON = Tools.createImageIcon(Tools.getDefault("Dialog.Dialog.FinishIcon"));
    private static final ImageIcon NEXT_ICON = Tools.createImageIcon(Tools.getDefault("Dialog.Dialog.NextIcon"));
    private static final ImageIcon BACK_ICON = Tools.createImageIcon(Tools.getDefault("Dialog.Dialog.BackIcon"));
    private ProgressBar progressBar = null;

    protected WizardDialog(WizardDialog previousDialog) {
        this.previousDialog = previousDialog;
    }

    public WizardDialog getPreviousDialog() {
        return this.previousDialog;
    }

    protected final void setPreviousDialog(WizardDialog previousDialog) {
        this.previousDialog = previousDialog;
    }

    public String nextButton() {
        return this.buttonString("Next");
    }

    public final String backButton() {
        return this.buttonString("Back");
    }

    public String finishButton() {
        return this.buttonString("Finish");
    }

    final String retryButton() {
        return this.buttonString("Retry");
    }

    public final boolean isPressedCancelButton() {
        return this.isPressedButton(this.cancelButton());
    }

    final boolean isPressedRetryButton() {
        return this.isPressedButton(this.retryButton());
    }

    public final boolean isPressedFinishButton() {
        return this.isPressedButton(this.finishButton());
    }

    @Override
    protected final String[] buttons() {
        String[] btns = new String[]{this.retryButton(), this.backButton(), this.nextButton(), this.finishButton(), this.cancelButton()};
        return btns;
    }

    @Override
    protected final ItemListener skipButtonListener() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                WizardDialog.this.buttonClass(WizardDialog.this.nextButton()).setEnabled(true);
                WizardDialog.this.skipButtonSetEnabled(false);
            }
        };
    }

    protected final void nextButtonSetEnabled(final boolean enable) {
        if (this.skipButtonIsSelected()) {
            return;
        }
        if (enable) {
            this.skipButtonSetEnabled(false);
        } else {
            this.skipButtonSetEnabled(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WizardDialog.this.buttonClass(WizardDialog.this.nextButton()).setEnabled(enable);
                if (enable) {
                    WizardDialog.this.makeDefaultAndRequestFocus(WizardDialog.this.buttonClass(WizardDialog.this.nextButton()));
                }
            }
        });
    }

    @Override
    protected final ImageIcon[] getIcons() {
        ImageIcon[] icons = new ImageIcon[]{null, BACK_ICON, NEXT_ICON, FINISH_ICON, CANCEL_ICON};
        return icons;
    }

    @Override
    protected final String defaultButton() {
        return null;
    }

    protected final boolean checkAfterNextFinish() {
        return true;
    }

    protected void finishDialog() {
    }

    public abstract WizardDialog nextDialog();

    @Override
    protected final void enableComponents(JComponent[] componentsToDisable) {
        super.enableComponents(componentsToDisable);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (WizardDialog.this.buttonClass(WizardDialog.this.retryButton()) != null && WizardDialog.this.buttonClass(WizardDialog.this.retryButton()).isVisible() && WizardDialog.this.buttonClass(WizardDialog.this.retryButton()).isEnabled()) {
                    WizardDialog.this.makeDefaultAndRequestFocus(WizardDialog.this.buttonClass(WizardDialog.this.retryButton()));
                } else if (WizardDialog.this.buttonClass(WizardDialog.this.nextButton()) != null && WizardDialog.this.buttonClass(WizardDialog.this.nextButton()).isEnabled()) {
                    WizardDialog.this.makeDefaultAndRequestFocus(WizardDialog.this.buttonClass(WizardDialog.this.nextButton()));
                } else if (WizardDialog.this.buttonClass(WizardDialog.this.finishButton()) != null && WizardDialog.this.buttonClass(WizardDialog.this.finishButton()).isEnabled()) {
                    WizardDialog.this.makeDefaultAndRequestFocus(WizardDialog.this.buttonClass(WizardDialog.this.finishButton()));
                }
            }
        });
    }

    protected final void makeDefaultAndRequestFocus(JComponent b) {
        if (b instanceof JButton) {
            this.getDialogPanel().getRootPane().setDefaultButton((JButton)b);
        }
        b.requestFocus();
    }

    protected final void makeDefaultAndRequestFocusLater(final JComponent b) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WizardDialog.this.makeDefaultAndRequestFocus(b);
            }
        });
    }

    protected final void makeDefaultButton(JButton b) {
        this.getDialogPanel().getRootPane().setDefaultButton(b);
    }

    @Override
    protected final void enableComponents() {
        this.enableComponents(new JComponent[0]);
    }

    @Override
    protected void initDialog() {
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(2);
        if (this.buttonClass(this.cancelButton()) != null) {
            this.buttonClass(this.cancelButton()).getParent().setLayout(layout);
        }
        if (this.previousDialog == null && this.buttonClass(this.backButton()) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WizardDialog.this.buttonClass(WizardDialog.this.backButton()).setEnabled(false);
                }
            });
        }
        if (this.buttonClass(this.nextButton()) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WizardDialog.this.buttonClass(WizardDialog.this.nextButton()).setEnabled(false);
                }
            });
        }
        if (this.buttonClass(this.finishButton()) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WizardDialog.this.buttonClass(WizardDialog.this.finishButton()).setEnabled(false);
                }
            });
        }
        if (this.buttonClass(this.retryButton()) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WizardDialog.this.buttonClass(WizardDialog.this.retryButton()).setVisible(false);
                    WizardDialog.this.buttonClass(WizardDialog.this.retryButton()).setBackgroundColor(Color.RED);
                }
            });
        }
        this.disableComponents();
    }

    protected final void retryWasPressed() {
    }

    protected final void backButtonWasPressed() {
    }

    @Override
    protected final ConfigDialog checkAnswer() {
        if (this.isPressedButton(this.backButton())) {
            this.backButtonWasPressed();
            return this.getPreviousDialog();
        }
        if (this.isPressedButton(this.nextButton()) || this.isPressedButton(this.finishButton()) || this.isPressedButton(this.retryButton())) {
            if (this.checkAfterNextFinish()) {
                this.finishDialog();
                if (this.isPressedButton(this.nextButton())) {
                    return this.nextDialog();
                }
                if (this.isPressedButton(this.retryButton())) {
                    this.retryWasPressed();
                    this.setDialogPanel(null);
                    return this;
                }
                return null;
            }
            return this;
        }
        return this.dialogAfterCancel();
    }

    public void printErrorAndRetry(String text) {
        this.printErrorAndRetry(text, null, 0);
    }

    public final void printErrorAndRetry(String text, String ans, int exitCode) {
        if (ans != null) {
            text = text + "\n" + Tools.getString("Dialog.Dialog.PrintErrorAndRetry") + exitCode + "\n" + ans;
        }
        this.answerPaneSetTextError(text);
        this.addRetryButton();
        if (this.buttonClass(this.retryButton()) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WizardDialog.this.buttonClass(WizardDialog.this.retryButton()).requestFocus();
                }
            });
        }
        if (this.buttonClass(this.nextButton()) != null) {
            this.enableComponents(new JComponent[]{this.buttonClass(this.nextButton())});
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WizardDialog.this.buttonClass(WizardDialog.this.nextButton()).setEnabled(false);
                }
            });
        }
    }

    public final void retry() {
        this.addRetryButton();
        if (this.buttonClass(this.retryButton()) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WizardDialog.this.buttonClass(WizardDialog.this.retryButton()).requestFocus();
                }
            });
            if (this.buttonClass(this.nextButton()) != null) {
                this.enableComponents(new JComponent[]{this.buttonClass(this.nextButton())});
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WizardDialog.this.buttonClass(WizardDialog.this.nextButton()).setEnabled(false);
                    }
                });
            }
        }
    }

    final void addRetryButton() {
        if (this.buttonClass(this.retryButton()) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WizardDialog.this.getOptionPane().setInitialValue(WizardDialog.this.buttonClass(WizardDialog.this.retryButton()));
                }
            });
        }
        final FlowLayout layout = new FlowLayout();
        layout.setAlignment(2);
        if (this.buttonClass(this.cancelButton()) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Container parent = WizardDialog.this.buttonClass(WizardDialog.this.cancelButton()).getParent();
                    if (parent != null) {
                        WizardDialog.this.buttonClass(WizardDialog.this.cancelButton()).getParent().setLayout(layout);
                    }
                }
            });
        }
        if (this.buttonClass(this.retryButton()) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WizardDialog.this.buttonClass(WizardDialog.this.retryButton()).setVisible(true);
                    WizardDialog.this.buttonClass(WizardDialog.this.retryButton()).setEnabled(true);
                }
            });
        }
    }

    public final void hideRetryButton() {
        final MyButton rb = this.buttonClass(this.retryButton());
        if (rb != null && rb.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    rb.setVisible(false);
                }
            });
        }
    }

    final void pressRetryButton() {
        final MyButton rb = this.buttonClass(this.retryButton());
        if (rb != null && rb.isVisible() && rb.isEnabled()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    rb.pressButton();
                }
            });
        }
    }

    public final void pressNextButton() {
        final MyButton nb = this.buttonClass(this.nextButton());
        if (nb != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (nb.isVisible() && nb.isEnabled()) {
                        nb.pressButton();
                    }
                }
            });
        }
    }

    public JPanel getProgressBarPane(CancelCallback cancelCallback) {
        this.progressBar = new ProgressBar(cancelCallback);
        JPanel p = this.progressBar.getProgressBarPane();
        p.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Dark"));
        return p;
    }

    public final void progressBarDoneError() {
        this.progressBar.doneError();
    }

    public final void progressBarDone() {
        this.progressBar.done();
    }

    public final ProgressBar getProgressBar() {
        return this.progressBar;
    }

    public final JPanel getProgressBarPane(String title, CancelCallback cancelCallback) {
        this.progressBar = new ProgressBar(title, cancelCallback);
        JPanel p = this.progressBar.getProgressBarPane();
        p.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Dark"));
        return p;
    }

    protected WizardDialog dialogAfterCancel() {
        return null;
    }
}

