/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import lcmc.data.CRMXML;
import lcmc.data.Cluster;
import lcmc.data.ClusterStatus;
import lcmc.data.DRBDtestData;
import lcmc.data.DrbdXML;
import lcmc.data.Host;
import lcmc.data.PtestData;
import lcmc.data.ResourceAgent;
import lcmc.data.VMSXML;
import lcmc.data.resources.Network;
import lcmc.data.resources.Service;
import lcmc.gui.Browser;
import lcmc.gui.CRMGraph;
import lcmc.gui.ClusterViewPanel;
import lcmc.gui.DrbdGraph;
import lcmc.gui.HostBrowser;
import lcmc.gui.ResourceGraph;
import lcmc.gui.resources.AvailableServiceInfo;
import lcmc.gui.resources.AvailableServicesInfo;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.gui.resources.CRMInfo;
import lcmc.gui.resources.CategoryInfo;
import lcmc.gui.resources.ClusterHostsInfo;
import lcmc.gui.resources.CommonBlockDevInfo;
import lcmc.gui.resources.DrbdInfo;
import lcmc.gui.resources.DrbdResourceInfo;
import lcmc.gui.resources.DrbdVolumeInfo;
import lcmc.gui.resources.GroupInfo;
import lcmc.gui.resources.HbCategoryInfo;
import lcmc.gui.resources.HbConnectionInfo;
import lcmc.gui.resources.Info;
import lcmc.gui.resources.NetworkInfo;
import lcmc.gui.resources.ResourceAgentClassInfo;
import lcmc.gui.resources.RscDefaultsInfo;
import lcmc.gui.resources.ServiceInfo;
import lcmc.gui.resources.ServicesInfo;
import lcmc.gui.resources.StringInfo;
import lcmc.gui.resources.VMSHardwareInfo;
import lcmc.gui.resources.VMSInfo;
import lcmc.gui.resources.VMSVirtualDomainInfo;
import lcmc.utilities.ButtonCallback;
import lcmc.utilities.CRM;
import lcmc.utilities.ComponentWithTest;
import lcmc.utilities.DRBD;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.Heartbeat;
import lcmc.utilities.NewOutputCallback;
import lcmc.utilities.Tools;
import org.apache.commons.collections15.keyvalue.MultiKey;
import org.apache.commons.collections15.map.LinkedMap;
import org.apache.commons.collections15.map.MultiKeyMap;

public final class ClusterBrowser
extends Browser {
    private final Cluster cluster;
    private DefaultMutableTreeNode clusterHostsNode;
    private DefaultMutableTreeNode networksNode;
    private DefaultMutableTreeNode commonBlockDevicesNode;
    private DefaultMutableTreeNode availableServicesNode;
    private DefaultMutableTreeNode crmNode;
    private DefaultMutableTreeNode servicesNode;
    private DefaultMutableTreeNode drbdNode;
    private DefaultMutableTreeNode vmsNode = null;
    private String[] commonFileSystems;
    private String[] commonMountPoints;
    private final Map<String, Map<String, ServiceInfo>> nameToServiceInfoHash = new TreeMap<String, Map<String, ServiceInfo>>(String.CASE_INSENSITIVE_ORDER);
    private final Lock mNameToServiceLock = new ReentrantLock();
    private final Lock mDrbdResHashLock = new ReentrantLock();
    private final Map<String, DrbdResourceInfo> drbdResHash = new HashMap<String, DrbdResourceInfo>();
    private final Lock mDrbdDevHashLock = new ReentrantLock();
    private final Map<String, DrbdVolumeInfo> drbdDevHash = new HashMap<String, DrbdVolumeInfo>();
    private final Lock mHeartbeatIdToService = new ReentrantLock();
    private final Map<String, ServiceInfo> heartbeatIdToServiceInfo = new HashMap<String, ServiceInfo>();
    private final CRMGraph crmGraph;
    private final DrbdGraph drbdGraph;
    private ClusterStatus clusterStatus;
    private CRMXML crmXML;
    private DrbdXML drbdXML;
    private final ReadWriteLock mVMSLock = new ReentrantReadWriteLock();
    private final Lock mVMSReadLock = this.mVMSLock.readLock();
    private final Lock mVMSWriteLock = this.mVMSLock.writeLock();
    private final Lock mVMSUpdateLock = new ReentrantLock();
    private final Map<Host, VMSXML> vmsXML = new HashMap<Host, VMSXML>();
    private DRBDtestData drbdtestData;
    private boolean drbdStatusCanceled = false;
    private boolean clStatusCanceled = false;
    private final Lock mPtestLock = new ReentrantLock();
    private final Lock mDRBDtestdataLock = new ReentrantLock();
    private volatile boolean serverStatusCanceled = false;
    private Host lastDcHost = null;
    private Host realDcHost = null;
    private ClusterViewPanel clusterViewPanel = null;
    private final Map<String, ResourceAgentClassInfo> classInfoMap = new HashMap<String, ResourceAgentClassInfo>();
    private final Map<ResourceAgent, AvailableServiceInfo> availableServiceMap = new HashMap<ResourceAgent, AvailableServiceInfo>();
    private ClusterHostsInfo clusterHostsInfo;
    private ServicesInfo servicesInfo = null;
    private RscDefaultsInfo rscDefaultsInfo = null;
    private final Lock mClStatusLock = new ReentrantLock();
    public static final ImageIcon REMOVE_ICON = Tools.createImageIcon(Tools.getDefault("ClusterBrowser.RemoveIcon"));
    public static final ImageIcon REMOVE_ICON_SMALL = Tools.createImageIcon(Tools.getDefault("ClusterBrowser.RemoveIconSmall"));
    public static final Map<String, String> HB_CLASS_MENU = new HashMap<String, String>();
    public static final int SERVICE_LABEL_WIDTH;
    public static final int SERVICE_FIELD_WIDTH;
    public static final Color FILL_PAINT_STOPPED;
    public static final String IDENT_4 = "    ";
    public static final String DRBD_RES_BOOL_TYPE_NAME = "boolean";
    public static final List<String> HB_CLASSES;
    private static final String HB_OP_START = "start";
    private static final String HB_OP_STOP = "stop";
    private static final String HB_OP_STATUS = "status";
    private static final String HB_OP_MONITOR = "monitor";
    private static final String HB_OP_META_DATA = "meta-data";
    private static final String HB_OP_VALIDATE_ALL = "validate-all";
    public static final String HB_OP_PROMOTE = "promote";
    public static final String HB_OP_DEMOTE = "demote";
    private static final String HB_PAR_DESC = "description";
    private static final String HB_PAR_INTERVAL = "interval";
    private static final String HB_PAR_TIMEOUT = "timeout";
    private static final String HB_PAR_START_DELAY = "start-delay";
    private static final String HB_PAR_DISABLED = "disabled";
    private static final String HB_PAR_ROLE = "role";
    private static final String HB_PAR_PREREQ = "prereq";
    private static final String HB_PAR_ON_FAIL = "on-fail";
    public static final String[] HB_OPERATIONS;
    public static final List<String> HB_OP_IGNORE_DEFAULT;
    private final Map<String, List<String>> crmOperationParams = new LinkedHashMap<String, List<String>>();
    private final MultiKeyMap<String, Integer> hbOpNotAdvanced = MultiKeyMap.decorate(new LinkedMap());
    private final Map<Host, String> drbdParameters = new HashMap<Host, String>();
    public static final String[] HB_OPERATION_PARAM_LIST;
    public static final String STARTING_PTEST_TOOLTIP;
    private static final String CLUSTER_STATUS_ERROR = "---start---\r\nerror\r\n\r\n---done---\r\n";
    static final ImageIcon CLUSTER_ICON_SMALL;
    public static final String UNKNOWN_CLUSTER_STATUS_STRING = "unknown cluster status";
    private static final List<String> DEFAULT_OP_PARAMS;
    private static final String RESET_STRING = "---reset---\r\n";
    private static int RESET_STRING_LEN;
    private static final Pattern BY_RES_PATTERN;

    public ClusterBrowser(Cluster cluster) {
        this.cluster = cluster;
        this.crmGraph = new CRMGraph(this);
        this.drbdGraph = new DrbdGraph(this);
        this.setTreeTop();
    }

    private void initOperations() {
        this.hbOpNotAdvanced.put(HB_OP_START, HB_PAR_TIMEOUT, 1);
        this.hbOpNotAdvanced.put(HB_OP_STOP, HB_PAR_TIMEOUT, 1);
        this.hbOpNotAdvanced.put(HB_OP_MONITOR, HB_PAR_TIMEOUT, 1);
        this.hbOpNotAdvanced.put(HB_OP_MONITOR, HB_PAR_INTERVAL, 1);
        this.hbOpNotAdvanced.put(HB_OP_MONITOR, "OCF_CHECK_LEVEL", 1);
        this.crmOperationParams.put(HB_OP_START, new ArrayList<String>(Arrays.asList(HB_PAR_TIMEOUT, HB_PAR_INTERVAL)));
        this.crmOperationParams.put(HB_OP_STOP, new ArrayList<String>(Arrays.asList(HB_PAR_TIMEOUT, HB_PAR_INTERVAL)));
        this.crmOperationParams.put(HB_OP_META_DATA, new ArrayList<String>(Arrays.asList(HB_PAR_TIMEOUT, HB_PAR_INTERVAL)));
        this.crmOperationParams.put(HB_OP_VALIDATE_ALL, new ArrayList<String>(Arrays.asList(HB_PAR_TIMEOUT, HB_PAR_INTERVAL)));
        this.crmOperationParams.put(HB_OP_STATUS, new ArrayList<String>(Arrays.asList(HB_PAR_TIMEOUT, HB_PAR_INTERVAL)));
        Host dcHost = this.getDCHost();
        if (Tools.versionBeforePacemaker(dcHost)) {
            this.crmOperationParams.put(HB_OP_MONITOR, new ArrayList<String>(Arrays.asList(HB_PAR_TIMEOUT, HB_PAR_INTERVAL, "OCF_CHECK_LEVEL")));
        } else {
            this.crmOperationParams.put(HB_OP_MONITOR, new ArrayList<String>(Arrays.asList(HB_PAR_TIMEOUT, HB_PAR_INTERVAL, "OCF_CHECK_LEVEL", HB_PAR_START_DELAY)));
        }
        this.crmOperationParams.put(HB_OP_PROMOTE, new ArrayList<String>(Arrays.asList(HB_PAR_TIMEOUT, HB_PAR_INTERVAL)));
        this.crmOperationParams.put(HB_OP_DEMOTE, new ArrayList<String>(Arrays.asList(HB_PAR_TIMEOUT, HB_PAR_INTERVAL)));
    }

    public List<String> getCRMOperationParams(String op) {
        List<String> params = this.crmOperationParams.get(op);
        if (params == null) {
            return DEFAULT_OP_PARAMS;
        }
        return params;
    }

    public boolean isCRMOperationAdvanced(String op, String param) {
        if (!this.crmOperationParams.containsKey(op)) {
            return !HB_PAR_TIMEOUT.equals(param);
        }
        return !this.hbOpNotAdvanced.containsKey((K[])new String[]{op, param});
    }

    void setClusterViewPanel(ClusterViewPanel clusterViewPanel) {
        this.clusterViewPanel = clusterViewPanel;
    }

    public ClusterViewPanel getClusterViewPanel() {
        return this.clusterViewPanel;
    }

    public Host[] getClusterHosts() {
        return this.cluster.getHostsArray();
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setRightComponentInView(Info i) {
        this.clusterViewPanel.setRightComponentInView(this, i);
    }

    public void saveGraphPositions() {
        Host[] hosts;
        HashMap<String, Point2D> positions = new HashMap<String, Point2D>();
        if (this.drbdGraph != null) {
            this.drbdGraph.getPositions(positions);
        }
        if (positions.isEmpty()) {
            return;
        }
        if (this.crmGraph != null) {
            this.crmGraph.getPositions(positions);
        }
        if (positions.isEmpty()) {
            return;
        }
        for (Host host : hosts = this.getClusterHosts()) {
            host.saveGraphPositions(positions);
        }
    }

    public CRMGraph getCRMGraph() {
        return this.crmGraph;
    }

    public DrbdGraph getDrbdGraph() {
        return this.drbdGraph;
    }

    public boolean allHostsDown() {
        Host[] hosts;
        boolean hostsDown = true;
        for (Host host : hosts = this.cluster.getHostsArray()) {
            if (!host.isClStatus()) continue;
            hostsDown = false;
            break;
        }
        return hostsDown;
    }

    public boolean atLeastOneDrbddisk() {
        this.mHeartbeatIdToServiceLock();
        for (String id : this.heartbeatIdToServiceInfo.keySet()) {
            ServiceInfo si = this.heartbeatIdToServiceInfo.get(id);
            if (!si.getResourceAgent().isDrbddisk()) continue;
            this.mHeartbeatIdToServiceUnlock();
            return true;
        }
        this.mHeartbeatIdToServiceUnlock();
        return false;
    }

    public boolean isOneLinbitDrbd() {
        this.mHeartbeatIdToServiceLock();
        for (String id : this.heartbeatIdToServiceInfo.keySet()) {
            ServiceInfo si = this.heartbeatIdToServiceInfo.get(id);
            if (!si.getResourceAgent().isLinbitDrbd()) continue;
            this.mHeartbeatIdToServiceUnlock();
            return true;
        }
        this.mHeartbeatIdToServiceUnlock();
        return false;
    }

    void addVMSNode() {
        if (this.vmsNode == null) {
            this.vmsNode = new DefaultMutableTreeNode(new VMSInfo(Tools.getString("ClusterBrowser.VMs"), this));
            this.setNode(this.vmsNode);
            this.topAdd(this.vmsNode);
            this.reload(this.getTreeTop(), true);
        }
    }

    void initClusterBrowser() {
        this.clusterHostsInfo = new ClusterHostsInfo(Tools.getString("ClusterBrowser.ClusterHosts"), this);
        this.clusterHostsNode = new DefaultMutableTreeNode(this.clusterHostsInfo);
        this.setNode(this.clusterHostsNode);
        this.topAdd(this.clusterHostsNode);
        this.networksNode = new DefaultMutableTreeNode(new CategoryInfo(Tools.getString("ClusterBrowser.Networks"), this));
        this.setNode(this.networksNode);
        this.topAdd(this.networksNode);
        this.drbdNode = new DefaultMutableTreeNode(new DrbdInfo(Tools.getString("ClusterBrowser.Drbd"), this));
        this.setNode(this.drbdNode);
        this.topAdd(this.drbdNode);
        CRMInfo crmInfo = new CRMInfo(Tools.getString("ClusterBrowser.ClusterManager"), this);
        this.crmNode = new DefaultMutableTreeNode(crmInfo);
        this.setNode(this.crmNode);
        this.topAdd(this.crmNode);
        this.availableServicesNode = new DefaultMutableTreeNode(new AvailableServicesInfo(Tools.getString("ClusterBrowser.availableServices"), this));
        this.setNode(this.availableServicesNode);
        this.addNode(this.crmNode, this.availableServicesNode);
        this.commonBlockDevicesNode = new DefaultMutableTreeNode(new HbCategoryInfo(Tools.getString("ClusterBrowser.CommonBlockDevices"), this));
        this.setNode(this.commonBlockDevicesNode);
        this.rscDefaultsInfo = new RscDefaultsInfo("rsc_defaults", this);
        this.servicesInfo = new ServicesInfo(Tools.getString("ClusterBrowser.Services"), this);
        this.servicesNode = new DefaultMutableTreeNode(this.servicesInfo);
        this.setNode(this.servicesNode);
        this.addNode(this.crmNode, this.servicesNode);
        this.addVMSNode();
        this.selectPath(new Object[]{this.getTreeTop(), this.crmNode});
        this.addDrbdProxyNodes();
    }

    void addDrbdProxyNodes() {
        Set<Host> clusterHosts = this.getCluster().getHosts();
        for (Host pHost : this.getCluster().getProxyHosts()) {
            if (clusterHosts.contains(pHost)) continue;
            this.getDrbdGraph().getDrbdInfo().addProxyHostNode(pHost);
        }
    }

    void updateClusterResources(Host[] clusterHosts, String[] commonFileSystems, String[] commonMountPoints) {
        this.commonFileSystems = (String[])commonFileSystems.clone();
        this.commonMountPoints = (String[])commonMountPoints.clone();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClusterBrowser.this.clusterHostsNode.removeAllChildren();
            }
        });
        for (Host clusterHost : clusterHosts) {
            HostBrowser hostBrowser = clusterHost.getBrowser();
            DefaultMutableTreeNode resource = hostBrowser.getTreeTop();
            this.setNode(resource);
            this.addNode(this.clusterHostsNode, resource);
            this.crmGraph.addHost(hostBrowser.getHostInfo());
        }
        this.reload(this.clusterHostsNode, false);
        this.updateCommonBlockDevices();
        this.updateNetworks();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClusterBrowser.this.crmGraph.scale();
            }
        });
        this.updateHeartbeatDrbdThread();
    }

    public String[] getCommonMountPoints() {
        return (String[])this.commonMountPoints.clone();
    }

    private void updateHeartbeatDrbdThread() {
        Tools.debug(this, "load cluster", 0);
        Thread tt = new Thread(new Runnable(){

            @Override
            public void run() {
                Host[] hosts;
                for (Host host : hosts = ClusterBrowser.this.cluster.getHostsArray()) {
                    host.waitForServerStatusLatch();
                    Tools.stopProgressIndicator(host.getName(), Tools.getString("ClusterBrowser.UpdatingServerInfo"));
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ClusterBrowser.this.getClusterViewPanel().setDisabledDuringLoad(false);
                        ClusterBrowser.this.selectServices();
                    }
                });
            }
        });
        tt.start();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Host firstHost = null;
                final Host[] hosts = ClusterBrowser.this.cluster.getHostsArray();
                Tools.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        for (Host host : hosts) {
                            HostBrowser hostBrowser = host.getBrowser();
                            ClusterBrowser.this.drbdGraph.addHost(hostBrowser.getHostDrbdInfo());
                        }
                    }
                });
                int notConnectedCount = 0;
                do {
                    boolean notConnected = true;
                    for (Host host : hosts) {
                        if (!host.isConnected()) continue;
                        notConnected = false;
                        break;
                    }
                    if (notConnected) {
                        ++notConnectedCount;
                    } else {
                        firstHost = ClusterBrowser.this.getFirstHost();
                    }
                    if (firstHost != null) continue;
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                    boolean ok = ClusterBrowser.this.cluster.connect(null, notConnectedCount < 1, notConnectedCount + 1);
                    if (!ok) break;
                } while (firstHost == null);
                if (firstHost == null) {
                    return;
                }
                ClusterBrowser.this.crmXML = new CRMXML(firstHost, ClusterBrowser.this.getServicesInfo());
                ClusterBrowser.this.clusterStatus = new ClusterStatus(firstHost, ClusterBrowser.this.crmXML);
                ClusterBrowser.this.initOperations();
                DrbdXML newDrbdXML = new DrbdXML(ClusterBrowser.this.cluster.getHostsArray(), ClusterBrowser.this.drbdParameters);
                ClusterBrowser.this.drbdXML = newDrbdXML;
                String clusterName = ClusterBrowser.this.getCluster().getName();
                Tools.startProgressIndicator(clusterName, Tools.getString("ClusterBrowser.HbUpdateResources"));
                ClusterBrowser.this.updateAvailableServices();
                Tools.stopProgressIndicator(clusterName, Tools.getString("ClusterBrowser.HbUpdateResources"));
                Tools.startProgressIndicator(clusterName, Tools.getString("ClusterBrowser.DrbdUpdate"));
                Tools.stopProgressIndicator(clusterName, Tools.getString("ClusterBrowser.DrbdUpdate"));
                ClusterBrowser.this.cluster.getBrowser().startConnectionStatus();
                ClusterBrowser.this.cluster.getBrowser().startServerStatus();
                ClusterBrowser.this.cluster.getBrowser().startDrbdStatus();
                ClusterBrowser.this.cluster.getBrowser().startClStatus();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void startServerStatus() {
        Host[] hosts;
        for (final Host host : hosts = this.cluster.getHostsArray()) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    ClusterBrowser.this.startServerStatus(host);
                }
            });
            thread.start();
        }
    }

    private void startPing(Host host) {
        do {
            host.startPing();
            Tools.sleep(10000);
        } while (!this.serverStatusCanceled);
    }

    void startServerStatus(Host host) {
        String hostName = host.getName();
        CategoryInfo[] infosToUpdate = new CategoryInfo[]{this.clusterHostsInfo};
        long count = 0L;
        do {
            if (host.isServerStatusLatch()) {
                Tools.startProgressIndicator(hostName, Tools.getString("ClusterBrowser.UpdatingServerInfo"));
            }
            host.setIsLoading();
            host.startHWInfoDaemon(infosToUpdate, new ResourceGraph[]{this.drbdGraph, this.crmGraph});
            if (this.serverStatusCanceled) break;
            Tools.sleep(10000);
        } while (!this.serverStatusCanceled);
    }

    public void updateServerStatus(final Host host) {
        String hostName = host.getName();
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ClusterBrowser.this.drbdGraph.addHost(host.getBrowser().getHostDrbdInfo());
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClusterBrowser.this.drbdGraph.scale();
            }
        });
        if (host.isServerStatusLatch()) {
            Tools.debug(this, host.getName() + " loading done", 0);
        }
        host.serverStatusLatchDone();
        this.clusterHostsInfo.updateTable("main");
        for (ResourceGraph g : new ResourceGraph[]{this.drbdGraph, this.crmGraph}) {
            if (g == null) continue;
            g.repaint();
            g.updatePopupMenus();
        }
    }

    public void periodicalVMSUpdate(Host host) {
        VMSXML newVMSXML = new VMSXML(host);
        if (newVMSXML.update()) {
            this.vmsXMLPut(host, newVMSXML);
            this.updateVMS();
        }
    }

    public void periodicalVMSUpdate(Host[] hosts) {
        this.periodicalVMSUpdate(Arrays.asList(hosts));
    }

    public void periodicalVMSUpdate(List<Host> hosts) {
        boolean updated = false;
        for (Host host : hosts) {
            VMSXML newVMSXML = new VMSXML(host);
            if (!newVMSXML.update()) continue;
            this.vmsXMLPut(host, newVMSXML);
            updated = true;
        }
        if (updated) {
            this.updateVMS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vmsXMLPut(Host host, VMSXML newVMSXML) {
        this.mVMSWriteLock.lock();
        try {
            this.vmsXML.put(host, newVMSXML);
        }
        finally {
            this.mVMSWriteLock.unlock();
        }
    }

    public boolean isCancelServerStatus() {
        return this.serverStatusCanceled;
    }

    void startConnectionStatus() {
        Host[] hosts;
        for (final Host host : hosts = this.cluster.getHostsArray()) {
            Thread pingThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    ClusterBrowser.this.startPing(host);
                }
            });
            pingThread.start();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    host.startConnectionStatus();
                }
            });
            thread.start();
        }
    }

    void startDrbdStatus() {
        Host[] hosts;
        for (final Host host : hosts = this.cluster.getHostsArray()) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    ClusterBrowser.this.startDrbdStatus(host);
                }
            });
            thread.start();
        }
    }

    public void stopDrbdStatus() {
        Host[] hosts;
        this.drbdStatusCanceled = true;
        for (Host host : hosts = this.cluster.getHostsArray()) {
            host.stopDrbdStatus();
        }
        for (Host host : hosts) {
            host.waitOnDrbdStatus();
        }
    }

    void startDrbdStatus(final Host host) {
        final CountDownLatch firstTime = new CountDownLatch(1);
        host.setDrbdStatus(false);
        final String hostName = host.getName();
        Tools.startProgressIndicator(hostName, Tools.getString("ClusterBrowser.UpdatingDrbdStatus"));
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    firstTime.await();
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ClusterBrowser.this.drbdGraph.scale();
                    }
                });
                Tools.stopProgressIndicator(hostName, Tools.getString("ClusterBrowser.UpdatingDrbdStatus"));
            }
        });
        thread.start();
        this.drbdStatusCanceled = false;
        do {
            host.execDrbdStatusCommand(new ExecCallback(){

                @Override
                public void done(String ans) {
                    firstTime.countDown();
                    if (!host.isDrbdStatus()) {
                        host.setDrbdStatus(true);
                        ClusterBrowser.this.drbdGraph.repaint();
                        Tools.debug(this, "drbd status update: " + host.getName(), 1);
                        ClusterBrowser.this.clusterHostsInfo.updateTable("main");
                    }
                }

                @Override
                public void doneError(String ans, int exitCode) {
                    firstTime.countDown();
                    Tools.debug(this, "drbd status failed: " + host.getName() + " exit code: " + exitCode, 1);
                    if (exitCode != 143 && exitCode != 100) {
                        if (host.isDrbdStatus()) {
                            host.setDrbdStatus(false);
                            Tools.debug(this, "drbd status update: " + host.getName(), 1);
                            ClusterBrowser.this.drbdGraph.repaint();
                            ClusterBrowser.this.clusterHostsInfo.updateTable("main");
                        }
                        if (exitCode == 255) {
                            // empty if block
                        }
                    }
                }
            }, new NewOutputCallback(){
                private StringBuffer outputBuffer = new StringBuffer(300);

                @Override
                public void output(String output) {
                    String drbdConfig;
                    String event;
                    if ("--nm--".equals(output.trim())) {
                        if (host.isDrbdStatus()) {
                            Tools.debug(this, "drbd status update: " + host.getName(), 1);
                            host.setDrbdStatus(false);
                            ClusterBrowser.this.drbdGraph.repaint();
                            ClusterBrowser.this.clusterHostsInfo.updateTable("main");
                        }
                        firstTime.countDown();
                        return;
                    }
                    firstTime.countDown();
                    if (!host.isDrbdStatus()) {
                        Tools.debug(this, "drbd status update: " + host.getName(), 1);
                        host.setDrbdStatus(true);
                        ClusterBrowser.this.drbdGraph.repaint();
                        ClusterBrowser.this.clusterHostsInfo.updateTable("main");
                    }
                    this.outputBuffer.append(output);
                    boolean drbdUpdate = false;
                    boolean eventUpdate = false;
                    do {
                        host.drbdStatusLock();
                        drbdConfig = host.getOutput("drbd", this.outputBuffer);
                        if (drbdConfig != null) {
                            DrbdXML newDrbdXML = new DrbdXML(ClusterBrowser.this.cluster.getHostsArray(), ClusterBrowser.this.drbdParameters);
                            newDrbdXML.update(drbdConfig);
                            ClusterBrowser.this.drbdXML = newDrbdXML;
                            drbdUpdate = true;
                            firstTime.countDown();
                        }
                        host.drbdStatusUnlock();
                        event = host.getOutput("event", this.outputBuffer);
                        if (event == null || !ClusterBrowser.this.drbdXML.parseDrbdEvent(host.getName(), ClusterBrowser.this.drbdGraph, event)) continue;
                        host.setDrbdStatus(true);
                        eventUpdate = true;
                    } while (event != null || drbdConfig != null);
                    Tools.chomp(this.outputBuffer);
                    if (drbdUpdate) {
                        ClusterBrowser.this.getDrbdGraph().getDrbdInfo().setParameters();
                        ClusterBrowser.this.updateDrbdResources();
                    }
                    if (eventUpdate) {
                        ClusterBrowser.this.drbdGraph.repaint();
                        Tools.debug(this, "drbd status update: " + host.getName(), 1);
                        ClusterBrowser.this.clusterHostsInfo.updateTable("main");
                        firstTime.countDown();
                        Thread thread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                ClusterBrowser.this.repaintSplitPane();
                                ClusterBrowser.this.drbdGraph.updatePopupMenus();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ClusterBrowser.this.repaintTree();
                                    }
                                });
                            }
                        });
                        thread.start();
                    }
                }
            });
            while (!host.isConnected() || !host.isDrbdLoaded()) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            host.waitOnDrbdStatus();
        } while (!this.drbdStatusCanceled);
    }

    public void stopClStatus() {
        Host[] hosts;
        this.clStatusCanceled = true;
        for (Host host : hosts = this.cluster.getHostsArray()) {
            host.stopClStatus();
        }
    }

    public void stopServerStatus() {
        Host[] hosts;
        this.serverStatusCanceled = true;
        for (Host host : hosts = this.cluster.getHostsArray()) {
            host.stopServerStatus();
        }
    }

    public boolean clStatusFailed() {
        Host[] hosts;
        for (Host host : hosts = this.cluster.getHostsArray()) {
            if (!host.isClStatus()) continue;
            return false;
        }
        return true;
    }

    void setClStatus() {
        Host[] hosts;
        for (Host host : hosts = this.cluster.getHostsArray()) {
            String online = this.clusterStatus.isOnlineNode(host.getName());
            if ("yes".equals(online)) {
                this.setClStatus(host, true);
                continue;
            }
            this.setClStatus(host, false);
        }
    }

    void startClStatusProgressIndicator(String clusterName) {
        Tools.startProgressIndicator(clusterName, Tools.getString("ClusterBrowser.HbUpdateStatus"));
    }

    void stopClStatusProgressIndicator(String clusterName) {
        Tools.stopProgressIndicator(clusterName, Tools.getString("ClusterBrowser.HbUpdateStatus"));
    }

    private void setClStatus(Host host, boolean status) {
        boolean oldStatus = host.isClStatus();
        host.setClStatus(status);
        if (oldStatus != status) {
            this.nodeChanged(this.servicesNode);
        }
    }

    void processClusterOutput(String output, StringBuffer clusterStatusOutput, Host host, CountDownLatch firstTime, boolean testOnly) {
        ClusterStatus clStatus = this.clusterStatus;
        this.clStatusLock();
        if (this.clStatusCanceled || clStatus == null) {
            this.clStatusUnlock();
            firstTime.countDown();
            return;
        }
        if (output == null || "".equals(output)) {
            clStatus.setOnlineNode(host.getName(), "no");
            this.setClStatus(host, false);
            firstTime.countDown();
        } else {
            int i;
            String e;
            clusterStatusOutput.append(output);
            int s = clusterStatusOutput.indexOf(RESET_STRING);
            while (s >= 0) {
                clusterStatusOutput.delete(s, s + RESET_STRING_LEN);
                s = clusterStatusOutput.indexOf(RESET_STRING);
            }
            if (clusterStatusOutput.length() > 12 && (e = clusterStatusOutput.substring(clusterStatusOutput.length() - 12)).trim().equals("---done---") && (i = clusterStatusOutput.lastIndexOf("---start---")) >= 0) {
                if (clusterStatusOutput.indexOf("is stopped") < 0) {
                    String status = clusterStatusOutput.substring(i);
                    clusterStatusOutput.delete(0, clusterStatusOutput.length());
                    if (CLUSTER_STATUS_ERROR.equals(status)) {
                        boolean oldStatus = host.isClStatus();
                        clStatus.setOnlineNode(host.getName(), "no");
                        this.setClStatus(host, false);
                        if (oldStatus) {
                            this.crmGraph.repaint();
                        }
                    } else {
                        String online;
                        if (clStatus.parseStatus(status)) {
                            Tools.debug(this, "update cluster status: " + host.getName(), 1);
                            ServicesInfo ssi = this.servicesInfo;
                            this.rscDefaultsInfo.setParameters(clStatus.getRscDefaultsValuePairs());
                            ssi.setGlobalConfig(clStatus);
                            ssi.setAllResources(clStatus, testOnly);
                            if (firstTime.getCount() == 1L) {
                                ssi.setAllResources(clStatus, testOnly);
                            }
                            this.repaintTree();
                            this.clusterHostsInfo.updateTable("main");
                        }
                        if ("yes".equals(online = clStatus.isOnlineNode(host.getName()))) {
                            this.setClStatus(host, true);
                            this.setClStatus();
                        } else {
                            this.setClStatus(host, false);
                        }
                    }
                }
                firstTime.countDown();
            }
            Tools.chomp(clusterStatusOutput);
        }
        this.clStatusUnlock();
    }

    void startClStatus() {
        final CountDownLatch firstTime = new CountDownLatch(1);
        final String clusterName = this.getCluster().getName();
        this.startClStatusProgressIndicator(clusterName);
        boolean testOnly = false;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    firstTime.await();
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
                if (ClusterBrowser.this.clStatusFailed()) {
                    Tools.progressIndicatorFailed(clusterName, Tools.getString("ClusterBrowser.ClusterStatusFailed"));
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ClusterBrowser.this.crmGraph.scale();
                        }
                    });
                }
                ClusterBrowser.this.stopClStatusProgressIndicator(clusterName);
            }
        });
        thread.start();
        this.clStatusCanceled = false;
        while (true) {
            Host host;
            if ((host = this.getDCHost()) == null) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            String hostName = host.getName();
            host.execClStatusCommand(new ExecCallback(){

                @Override
                public void done(String ans) {
                    String online = ClusterBrowser.this.clusterStatus.isOnlineNode(host.getName());
                    ClusterBrowser.this.setClStatus(host, "yes".equals(online));
                    firstTime.countDown();
                }

                @Override
                public void doneError(String ans, int exitCode) {
                    if (firstTime.getCount() == 1L) {
                        Tools.debug(this, "hb status failed: " + host.getName() + ", ec: " + exitCode, 2);
                    }
                    ClusterBrowser.this.clStatusLock();
                    ClusterBrowser.this.clusterStatus.setOnlineNode(host.getName(), "no");
                    ClusterBrowser.this.setClStatus(host, false);
                    ClusterBrowser.this.clusterStatus.setDC(null);
                    ClusterBrowser.this.clStatusUnlock();
                    if (exitCode == 255) {
                        // empty if block
                    }
                    firstTime.countDown();
                }
            }, new NewOutputCallback(){
                private StringBuffer clusterStatusOutput = new StringBuffer(300);

                @Override
                public void output(String output) {
                    ClusterBrowser.this.processClusterOutput(output, this.clusterStatusOutput, host, firstTime, false);
                }
            });
            host.waitOnClStatus();
            if (this.clStatusCanceled) break;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public List<ResourceAgent> globalGetAddServiceList(String cl) {
        return this.crmXML.getServices(cl);
    }

    public void updateCommonBlockDevices() {
        if (this.commonBlockDevicesNode != null) {
            final ClusterBrowser thisBrowser = this;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    List<String> bd = ClusterBrowser.this.cluster.getCommonBlockDevices();
                    Enumeration<TreeNode> e = ClusterBrowser.this.commonBlockDevicesNode.children();
                    ArrayList<DefaultMutableTreeNode> nodesToRemove = new ArrayList<DefaultMutableTreeNode>();
                    while (e.hasMoreElements()) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                        Info cbdi = (Info)node.getUserObject();
                        if (bd.contains(cbdi.getName())) {
                            bd.remove(bd.indexOf(cbdi.getName()));
                            continue;
                        }
                        cbdi.setNode(null);
                        nodesToRemove.add(node);
                    }
                    for (DefaultMutableTreeNode node : nodesToRemove) {
                        node.removeFromParent();
                    }
                    for (String device : bd) {
                        DefaultMutableTreeNode resource = new DefaultMutableTreeNode(new CommonBlockDevInfo(device, ClusterBrowser.this.cluster.getHostBlockDevices(device), thisBrowser));
                        ClusterBrowser.this.setNode(resource);
                        ClusterBrowser.this.addNode(ClusterBrowser.this.commonBlockDevicesNode, resource);
                    }
                    if (!bd.isEmpty() || !nodesToRemove.isEmpty()) {
                        ClusterBrowser.this.reload(ClusterBrowser.this.commonBlockDevicesNode, false);
                        ClusterBrowser.this.reloadAllComboBoxes(null);
                    }
                }
            });
        }
    }

    private void updateAvailableServices() {
        Tools.debug(this, "update available services");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ClusterBrowser.this.availableServicesNode.removeAllChildren();
            }
        });
        for (String cl : HB_CLASSES) {
            ResourceAgentClassInfo raci = new ResourceAgentClassInfo(cl, this);
            this.classInfoMap.put(cl, raci);
            DefaultMutableTreeNode classNode = new DefaultMutableTreeNode(raci);
            for (ResourceAgent ra : this.crmXML.getServices(cl)) {
                AvailableServiceInfo asi = new AvailableServiceInfo(ra, (Browser)this);
                this.availableServiceMap.put(ra, asi);
                DefaultMutableTreeNode resource = new DefaultMutableTreeNode(asi);
                this.setNode(resource);
                this.addNode(classNode, resource);
            }
            this.setNode(classNode);
            this.addNode(this.availableServicesNode, classNode);
        }
    }

    public void updateVMS() {
        VMSVirtualDomainInfo vmsvdi;
        Tools.debug(this, "VM status update", 1);
        TreeSet<String> domainNames = new TreeSet<String>();
        for (Host host : this.getClusterHosts()) {
            VMSXML vxml = this.getVMSXML(host);
            if (vxml == null) continue;
            domainNames.addAll(vxml.getDomainNames());
        }
        final ArrayList<DefaultMutableTreeNode> nodesToRemove = new ArrayList<DefaultMutableTreeNode>();
        boolean nodeChanged = false;
        ArrayList<VMSVirtualDomainInfo> currentVMSVDIs = new ArrayList<VMSVirtualDomainInfo>();
        this.mVMSUpdateLock.lock();
        if (this.vmsNode != null) {
            Enumeration<TreeNode> ee = this.vmsNode.children();
            while (ee.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)ee.nextElement();
                vmsvdi = (VMSVirtualDomainInfo)node.getUserObject();
                if (domainNames.contains(vmsvdi.toString())) {
                    currentVMSVDIs.add(vmsvdi);
                    domainNames.remove(vmsvdi.toString());
                    vmsvdi.updateParameters();
                    continue;
                }
                if (vmsvdi.getResource().isNew()) continue;
                vmsvdi.setNode(null);
                nodesToRemove.add(node);
                nodeChanged = true;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (DefaultMutableTreeNode node : nodesToRemove) {
                    node.removeFromParent();
                }
            }
        });
        if (this.vmsNode == null) {
            this.mVMSUpdateLock.unlock();
            return;
        }
        for (String domainName : domainNames) {
            Enumeration<TreeNode> e = this.vmsNode.children();
            int i = 0;
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                VMSVirtualDomainInfo vmsvdi2 = (VMSVirtualDomainInfo)node.getUserObject();
                String name = vmsvdi2.getName();
                if (domainName != null && name != null && domainName.compareTo(vmsvdi2.getName()) < 0) break;
                ++i;
            }
            VMSVirtualDomainInfo vmsvdi3 = new VMSVirtualDomainInfo(domainName, this);
            currentVMSVDIs.add(vmsvdi3);
            final DefaultMutableTreeNode resource = new DefaultMutableTreeNode(vmsvdi3);
            this.setNode(resource);
            vmsvdi3.updateParameters();
            final int index = i;
            Tools.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ClusterBrowser.this.vmsNode.insert(resource, index);
                }
            });
            nodeChanged = true;
        }
        this.mVMSUpdateLock.unlock();
        if (nodeChanged) {
            this.reload(this.vmsNode, false);
        }
        for (ServiceInfo si : this.getExistingServiceList(null)) {
            vmsvdi = si.connectWithVMS();
            if (vmsvdi == null) continue;
            currentVMSVDIs.remove(vmsvdi);
        }
        for (VMSVirtualDomainInfo vmsvdi4 : currentVMSVDIs) {
            vmsvdi4.setUsedByCRM(false);
        }
        VMSInfo vmsi = (VMSInfo)this.vmsNode.getUserObject();
        if (vmsi != null) {
            vmsi.updateTable("main");
        }
    }

    public VMSInfo getVMSInfo() {
        return (VMSInfo)this.vmsNode.getUserObject();
    }

    public void updateDrbdResources() {
        boolean testOnly = false;
        final DrbdInfo drbdInfo = this.drbdGraph.getDrbdInfo();
        boolean atLeastOneAdded = false;
        this.drbdStatusLock();
        DrbdXML dxml = this.drbdXML;
        if (dxml == null) {
            this.drbdStatusUnlock();
            return;
        }
        for (Object k : dxml.getResourceDeviceMap().keySet()) {
            DrbdVolumeInfo dvi;
            String resName = (String)((MultiKey)k).getKey(0);
            String volumeNr = (String)((MultiKey)k).getKey(1);
            String drbdDev = dxml.getDrbdDevice(resName, volumeNr);
            Map<String, String> hostDiskMap = dxml.getHostDiskMap(resName, volumeNr);
            BlockDevInfo bd1 = null;
            BlockDevInfo bd2 = null;
            if (hostDiskMap == null) continue;
            for (String hostName : hostDiskMap.keySet()) {
                if (!this.cluster.contains(hostName)) continue;
                String disk = hostDiskMap.get(hostName);
                BlockDevInfo bdi = this.drbdGraph.findBlockDevInfo(hostName, disk);
                if (bdi == null) {
                    if (this.getDrbdDevHash().containsKey(disk)) {
                        this.putDrbdDevHash();
                        continue;
                    }
                    this.putDrbdDevHash();
                    Tools.appWarning("could not find disk: " + disk + " on host: " + hostName);
                    continue;
                }
                bdi.setParameters(resName);
                if (bd1 == null) {
                    bd1 = bdi;
                    continue;
                }
                bd2 = bdi;
            }
            if (bd1 == null || bd2 == null) continue;
            DrbdResourceInfo dri = this.getDrbdResHash().get(resName);
            this.putDrbdResHash();
            ArrayList<BlockDevInfo> bdis = new ArrayList<BlockDevInfo>(Arrays.asList(bd1, bd2));
            if (dri == null) {
                dri = drbdInfo.addDrbdResource(resName, DrbdVolumeInfo.getHostsFromBlockDevices(bdis), false);
                atLeastOneAdded = true;
            }
            if ((dvi = dri.getDrbdVolumeInfo(volumeNr)) == null) {
                dvi = drbdInfo.addDrbdVolume(dri, volumeNr, drbdDev, bdis, false);
                atLeastOneAdded = true;
            }
            dri.setParameters();
            dvi.setParameters();
            dri.getInfoPanel();
        }
        this.drbdStatusUnlock();
        if (atLeastOneAdded) {
            drbdInfo.getInfoPanel();
            Tools.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    drbdInfo.setAllApplyButtons();
                }
            });
            drbdInfo.reloadDRBDResourceComboBoxes();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClusterBrowser.this.drbdGraph.scale();
                }
            });
        }
    }

    private void killRemovedVolumes(MultiKeyMap<String, String> deviceMap) {
        for (DrbdVolumeInfo dvi : this.getDrbdGraph().getDrbdVolumeToEdgeMap().keySet()) {
            if (deviceMap.containsKey((K[])new String[]{dvi.getDrbdResourceInfo().getName(), dvi.getName()})) continue;
            this.getDrbdXML().removeVolume(dvi.getDrbdResourceInfo().getName(), dvi.getDevice(), dvi.getName());
            this.getDrbdGraph().removeDrbdVolume(dvi);
            boolean lastVolume = dvi.getDrbdResourceInfo().removeDrbdVolume(dvi);
            this.getDrbdDevHash().remove(dvi.getDevice());
            this.putDrbdDevHash();
            for (BlockDevInfo bdi : dvi.getBlockDevInfos()) {
                bdi.removeFromDrbd();
                bdi.removeMyself(false);
            }
            if (!lastVolume) continue;
            dvi.getDrbdResourceInfo().removeMyself(false);
        }
    }

    private void updateNetworks() {
        if (this.networksNode != null) {
            Network[] networks = this.cluster.getCommonNetworks();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ClusterBrowser.this.networksNode.removeAllChildren();
                }
            });
            for (int i = 0; i < networks.length; ++i) {
                DefaultMutableTreeNode resource = new DefaultMutableTreeNode(new NetworkInfo(networks[i].getName(), networks[i], this));
                this.setNode(resource);
                this.addNode(this.networksNode, resource);
            }
            this.reload(this.networksNode, false);
        }
    }

    Host getFirstHost() {
        Host[] hosts;
        for (Host host : hosts = this.getClusterHosts()) {
            if (!host.isConnected()) continue;
            return host;
        }
        return null;
    }

    public boolean isStandby(Host host, boolean testOnly) {
        ClusterStatus cl = this.clusterStatus;
        if (cl == null) {
            return false;
        }
        String standby = cl.getNodeParameter(host.getName().toLowerCase(Locale.US), "standby", testOnly);
        return "on".equals(standby) || "true".equals(standby);
    }

    boolean isRealDcHost(Host host) {
        return host.equals(this.realDcHost);
    }

    public Host getDCHost() {
        Host dcHost = null;
        String dc = null;
        ClusterStatus cl = this.clusterStatus;
        if (cl != null) {
            dc = cl.getDC();
        }
        ArrayList<Host> hosts = new ArrayList<Host>();
        int lastHostIndex = 0;
        int i = 0;
        for (Host host : this.getClusterHosts()) {
            if (host == this.lastDcHost) {
                lastHostIndex = i;
            }
            if (host.getName().equals(dc) && host.isClStatus() && !host.isCommLayerStarting() && !host.isCommLayerStopping() && (host.isHeartbeatRunning() || host.isCsRunning() || host.isAisRunning())) {
                dcHost = host;
                break;
            }
            hosts.add(host);
            ++i;
        }
        if (dcHost == null) {
            int ix = lastHostIndex;
            do {
                if (++ix > hosts.size() - 1) {
                    ix = 0;
                }
                if (!((Host)hosts.get(ix)).isConnected() || !((Host)hosts.get(ix)).isHeartbeatRunning() && !((Host)hosts.get(ix)).isCsRunning() && !((Host)hosts.get(ix)).isAisRunning()) continue;
                this.lastDcHost = (Host)hosts.get(ix);
                break;
            } while (ix != lastHostIndex);
            dcHost = this.lastDcHost;
            this.realDcHost = null;
            if (dcHost == null) {
                dcHost = (Host)hosts.get(0);
            }
        } else {
            this.realDcHost = dcHost;
        }
        this.lastDcHost = dcHost;
        return dcHost;
    }

    public void drbdStatusLock() {
        Host[] hosts = this.getClusterHosts();
        for (Host h : this.getClusterHosts()) {
            h.drbdStatusLock();
        }
    }

    public void drbdStatusUnlock() {
        Host[] hosts = this.getClusterHosts();
        for (int i = hosts.length - 1; i >= 0; --i) {
            hosts[i].drbdStatusUnlock();
        }
    }

    public void vmStatusLock() {
        for (Host h : this.getClusterHosts()) {
            h.vmStatusLock();
        }
    }

    public void vmStatusUnlock() {
        Host[] hosts = this.getClusterHosts();
        for (int i = hosts.length - 1; i >= 0; --i) {
            hosts[i].vmStatusUnlock();
        }
    }

    void selectDrbd() {
        this.reload(this.drbdNode, true);
    }

    public void selectServices() {
        if (this.getClusterViewPanel().isDisabledDuringLoad()) {
            return;
        }
        this.selectPath(new Object[]{this.getTreeTop(), this.crmNode, this.servicesNode});
    }

    public ServiceInfo getServiceInfoFromCRMId(String crmId) {
        this.mHeartbeatIdToServiceLock();
        ServiceInfo si = this.heartbeatIdToServiceInfo.get(crmId);
        this.mHeartbeatIdToServiceUnlock();
        return si;
    }

    public boolean isCRMId(String crmId) {
        this.mHeartbeatIdToServiceLock();
        boolean ret = this.heartbeatIdToServiceInfo.containsKey(crmId);
        this.mHeartbeatIdToServiceUnlock();
        return ret;
    }

    public void mHeartbeatIdToServiceLock() {
        this.mHeartbeatIdToService.lock();
    }

    public void mHeartbeatIdToServiceUnlock() {
        this.mHeartbeatIdToService.unlock();
    }

    public Map<String, ServiceInfo> getHeartbeatIdToServiceInfo() {
        return this.heartbeatIdToServiceInfo;
    }

    public ServiceInfo getServiceInfoFromId(String name, String id) {
        this.lockNameToServiceInfo();
        Map<String, ServiceInfo> idToInfoHash = this.nameToServiceInfoHash.get(name);
        if (idToInfoHash == null) {
            this.unlockNameToServiceInfo();
            return null;
        }
        ServiceInfo si = idToInfoHash.get(id);
        this.unlockNameToServiceInfo();
        return si;
    }

    public Map<String, Map<String, ServiceInfo>> getNameToServiceInfoHash() {
        return this.nameToServiceInfoHash;
    }

    public void lockNameToServiceInfo() {
        this.mNameToServiceLock.lock();
    }

    public void unlockNameToServiceInfo() {
        this.mNameToServiceLock.unlock();
    }

    public List<ServiceInfo> getExistingServiceList(ServiceInfo p) {
        ArrayList<ServiceInfo> existingServiceList = new ArrayList<ServiceInfo>();
        this.lockNameToServiceInfo();
        for (String name : this.nameToServiceInfoHash.keySet()) {
            Map<String, ServiceInfo> idHash = this.nameToServiceInfoHash.get(name);
            for (String id : idHash.keySet()) {
                ServiceInfo si = idHash.get(id);
                if (si.getService().isOrphaned()) continue;
                GroupInfo gi = si.getGroupInfo();
                ServiceInfo sigi = si;
                if (gi != null) {
                    sigi = gi;
                }
                if (p != null && this.getCRMGraph().existsInThePath(sigi, p)) continue;
                existingServiceList.add(si);
            }
        }
        this.unlockNameToServiceInfo();
        return existingServiceList;
    }

    public void removeFromServiceInfoHash(ServiceInfo serviceInfo) {
        Service service = serviceInfo.getService();
        this.lockNameToServiceInfo();
        Map<String, ServiceInfo> idToInfoHash = this.nameToServiceInfoHash.get(service.getName());
        if (idToInfoHash != null) {
            idToInfoHash.remove(service.getId());
            if (idToInfoHash.size() == 0) {
                this.nameToServiceInfoHash.remove(service.getName());
            }
        }
        this.unlockNameToServiceInfo();
    }

    public Map<String, ServiceInfo> getNameToServiceInfoHash(String name) {
        return this.nameToServiceInfoHash.get(name);
    }

    public void addToHeartbeatIdList(ServiceInfo si) {
        String id = si.getService().getId();
        String pmId = si.getService().getHeartbeatId();
        if (pmId == null) {
            String newPmId;
            pmId = "Group".equals(si.getService().getName()) ? "grp_" : ("Clone Set".equals(si.getService().getName()) || "Master/Slave Set".equals(si.getService().getName()) ? (si.getService().isMaster() ? "ms_" : "cl_") : (si.getResourceAgent().isStonith() ? "stonith_" + si.getService().getName() + "_" : "res_" + si.getService().getName() + "_"));
            if (id == null) {
                newPmId = pmId + "1";
                si.getService().setId("1");
            } else {
                newPmId = pmId + id;
                si.getService().setHeartbeatId(newPmId);
            }
            this.mHeartbeatIdToServiceLock();
            this.heartbeatIdToServiceInfo.put(newPmId, si);
            this.mHeartbeatIdToServiceUnlock();
        } else {
            this.mHeartbeatIdToServiceLock();
            if (this.heartbeatIdToServiceInfo.get(pmId) == null) {
                this.heartbeatIdToServiceInfo.put(pmId, si);
            }
            this.mHeartbeatIdToServiceUnlock();
        }
    }

    public void resetFilesystems() {
        this.mHeartbeatIdToServiceLock();
        for (String hbId : this.heartbeatIdToServiceInfo.keySet()) {
            ServiceInfo si = this.heartbeatIdToServiceInfo.get(hbId);
            if (!si.getName().equals("Filesystem")) continue;
            si.setInfoPanel(null);
        }
        this.mHeartbeatIdToServiceUnlock();
    }

    public void addNameToServiceInfoHash(ServiceInfo serviceInfo) {
        Service service = serviceInfo.getService();
        this.lockNameToServiceInfo();
        Map<String, ServiceInfo> idToInfoHash = this.nameToServiceInfoHash.get(service.getName());
        String csPmId = null;
        ServiceInfo cs = serviceInfo.getContainedService();
        if (cs != null) {
            csPmId = cs.getService().getName() + "_" + cs.getService().getId();
        }
        if (idToInfoHash == null) {
            idToInfoHash = new TreeMap<String, ServiceInfo>(String.CASE_INSENSITIVE_ORDER);
            if (service.getId() == null) {
                if (csPmId == null) {
                    service.setId("1");
                } else {
                    service.setIdAndCrmId(csPmId);
                }
            }
        } else if (service.getId() == null) {
            Iterator<String> it = idToInfoHash.keySet().iterator();
            int index = 0;
            while (it.hasNext()) {
                Matcher m;
                Pattern p;
                String id = idToInfoHash.get(it.next()).getService().getId();
                if (csPmId == null) {
                    p = Pattern.compile("^(\\d+)$");
                } else {
                    p = Pattern.compile("^" + csPmId + "_(\\d+)$");
                    if (csPmId.equals(id)) {
                        ++index;
                    }
                }
                if (!(m = p.matcher(id)).matches()) continue;
                try {
                    int i = Integer.parseInt(m.group(1));
                    if (i <= index) continue;
                    index = i;
                }
                catch (NumberFormatException nfe) {
                    Tools.appWarning("could not parse: " + m.group(1));
                }
            }
            if (csPmId == null) {
                service.setId(Integer.toString(index + 1));
            } else if (index == 0) {
                service.setIdAndCrmId(csPmId);
            } else {
                service.setIdAndCrmId(csPmId + "_" + Integer.toString(index + 1));
            }
        }
        idToInfoHash.put(service.getId(), serviceInfo);
        this.nameToServiceInfoHash.put(service.getName(), idToInfoHash);
        this.unlockNameToServiceInfo();
    }

    public boolean hbDrbdConfirmDialog() {
        Host dcHost = this.getDCHost();
        String hbV = dcHost.getHeartbeatVersion();
        String pmV = dcHost.getPacemakerVersion();
        return Tools.confirmDialog(Tools.getString("ClusterBrowser.confirmHbDrbd.Title"), Tools.getString("ClusterBrowser.confirmHbDrbd.Description"), Tools.getString("ClusterBrowser.confirmHbDrbd.Yes"), Tools.getString("ClusterBrowser.confirmHbDrbd.No"));
    }

    public boolean isDrbddiskPreferred() {
        return Tools.versionBeforePacemaker(this.getDCHost());
    }

    public boolean linbitDrbdConfirmDialog() {
        if (this.isDrbddiskPreferred()) {
            String desc = Tools.getString("ClusterBrowser.confirmLinbitDrbd.Description");
            Host dcHost = this.getDCHost();
            String hbV = dcHost.getHeartbeatVersion();
            return Tools.confirmDialog(Tools.getString("ClusterBrowser.confirmLinbitDrbd.Title"), desc.replaceAll("@VERSION@", hbV), Tools.getString("ClusterBrowser.confirmLinbitDrbd.Yes"), Tools.getString("ClusterBrowser.confirmLinbitDrbd.No"));
        }
        return true;
    }

    void startHeartbeats() {
        Host[] hosts;
        for (Host host : hosts = this.cluster.getHostsArray()) {
            Heartbeat.startHeartbeat(host);
        }
    }

    public StringInfo[] getCommonFileSystems(String defaultValue) {
        StringInfo[] cfs = new StringInfo[this.commonFileSystems.length + 2];
        cfs[0] = new StringInfo(defaultValue, null, this);
        int i = 1;
        for (String cf : this.commonFileSystems) {
            cfs[i] = new StringInfo(cf, cf, this);
            ++i;
        }
        cfs[i] = new StringInfo("none", "none", this);
        ++i;
        return cfs;
    }

    HbConnectionInfo getNewHbConnectionInfo() {
        HbConnectionInfo hbci = new HbConnectionInfo(this);
        return hbci;
    }

    public ClusterStatus getClusterStatus() {
        return this.clusterStatus;
    }

    public DRBDtestData getDRBDtestData() {
        this.drbdtestdataLockAcquire();
        DRBDtestData dtd = this.drbdtestData;
        this.drbdtestdataLockRelease();
        return dtd;
    }

    public void setDRBDtestData(DRBDtestData drbdtestData) {
        this.drbdtestdataLockAcquire();
        this.drbdtestData = drbdtestData;
        this.drbdtestdataLockRelease();
    }

    public void ptestLockAcquire() {
        this.mPtestLock.lock();
    }

    public void ptestLockRelease() {
        this.mPtestLock.unlock();
    }

    protected void drbdtestdataLockAcquire() {
        this.mDRBDtestdataLock.lock();
    }

    protected void drbdtestdataLockRelease() {
        this.mDRBDtestdataLock.unlock();
    }

    public CRMXML getCRMXML() {
        return this.crmXML;
    }

    public DrbdXML getDrbdXML() {
        return this.drbdXML;
    }

    public void setDrbdXML(DrbdXML drbdXML) {
        this.drbdXML = drbdXML;
    }

    public DefaultMutableTreeNode getDrbdNode() {
        return this.drbdNode;
    }

    public DefaultMutableTreeNode getCommonBlockDevicesNode() {
        return this.commonBlockDevicesNode;
    }

    public DefaultMutableTreeNode getClusterHostsNode() {
        return this.clusterHostsNode;
    }

    public DefaultMutableTreeNode getServicesNode() {
        return this.servicesNode;
    }

    public DefaultMutableTreeNode getNetworksNode() {
        return this.networksNode;
    }

    public Map<String, DrbdVolumeInfo> getDrbdDevHash() {
        this.mDrbdDevHashLock.lock();
        return this.drbdDevHash;
    }

    public void putDrbdDevHash() {
        this.mDrbdDevHashLock.unlock();
    }

    public DrbdVolumeInfo getDrbdVolumeFromDev(String dev) {
        if (dev == null) {
            return null;
        }
        Matcher m = BY_RES_PATTERN.matcher(dev);
        if (m.matches()) {
            String res = m.group(1);
            String vol = m.groupCount() > 2 ? m.group(2) : "0";
            DrbdResourceInfo dri = this.getDrbdResHash().get(res);
            this.putDrbdResHash();
            if (dri != null) {
                return dri.getDrbdVolumeInfo(vol);
            }
        }
        return null;
    }

    public Map<String, DrbdResourceInfo> getDrbdResHash() {
        this.mDrbdResHashLock.lock();
        return this.drbdResHash;
    }

    public void putDrbdResHash() {
        this.mDrbdResHashLock.unlock();
    }

    public List<DrbdResourceInfo> getDrbdResHashValues() {
        ArrayList<DrbdResourceInfo> values = new ArrayList<DrbdResourceInfo>(this.getDrbdResHash().values());
        this.putDrbdResHash();
        return values;
    }

    public void reloadAllComboBoxes(ServiceInfo exceptThisOne) {
        this.lockNameToServiceInfo();
        for (String name : this.nameToServiceInfoHash.keySet()) {
            Map<String, ServiceInfo> idToInfoHash = this.nameToServiceInfoHash.get(name);
            for (String id : idToInfoHash.keySet()) {
                ServiceInfo si = idToInfoHash.get(id);
                if (si == exceptThisOne) continue;
                si.reloadComboBoxes();
            }
        }
        this.unlockNameToServiceInfo();
    }

    public VMSXML getVMSXML(Host host) {
        this.mVMSReadLock.lock();
        VMSXML vxml = this.vmsXML.get(host);
        this.mVMSReadLock.unlock();
        return vxml;
    }

    public VMSVirtualDomainInfo findVMSVirtualDomainInfo(String name) {
        if (this.vmsNode != null && name != null) {
            Enumeration<TreeNode> e = this.vmsNode.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                VMSVirtualDomainInfo vmsvdi = (VMSVirtualDomainInfo)node.getUserObject();
                if (!name.equals(vmsvdi.getName())) continue;
                return vmsvdi;
            }
        }
        return null;
    }

    public ResourceAgentClassInfo getClassInfoMap(String cl) {
        return this.classInfoMap.get(cl);
    }

    public AvailableServiceInfo getAvailableServiceInfoMap(ResourceAgent ra) {
        return this.availableServiceMap.get(ra);
    }

    public AvailableServicesInfo getAvailableServicesInfo() {
        return (AvailableServicesInfo)this.availableServicesNode.getUserObject();
    }

    public ServicesInfo getServicesInfo() {
        return this.servicesInfo;
    }

    public RscDefaultsInfo getRscDefaultsInfo() {
        return this.rscDefaultsInfo;
    }

    public void checkAccessOfEverything() {
        this.servicesInfo.checkResourceFieldsChanged(null, this.servicesInfo.getParametersFromXML());
        this.servicesInfo.updateAdvancedPanels();
        this.rscDefaultsInfo.updateAdvancedPanels();
        Tools.getGUIData().updateGlobalItems();
        for (ServiceInfo si : this.getExistingServiceList(null)) {
            si.checkResourceFieldsChanged(null, si.getParametersFromXML());
            si.updateAdvancedPanels();
        }
        this.drbdGraph.getDrbdInfo().checkResourceFieldsChanged(null, this.drbdGraph.getDrbdInfo().getParametersFromXML());
        this.drbdGraph.getDrbdInfo().updateAdvancedPanels();
        for (DrbdResourceInfo dri : this.getDrbdResHashValues()) {
            dri.checkResourceFieldsChanged(null, dri.getParametersFromXML());
            dri.updateAdvancedPanels();
            dri.updateAllVolumes();
        }
        if (this.vmsNode != null) {
            Enumeration<TreeNode> e = this.vmsNode.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                VMSVirtualDomainInfo vmsvdi = (VMSVirtualDomainInfo)node.getUserObject();
                vmsvdi.checkResourceFieldsChanged(null, vmsvdi.getParametersFromXML());
                vmsvdi.updateAdvancedPanels();
                Enumeration<TreeNode> ce = node.children();
                while (ce.hasMoreElements()) {
                    DefaultMutableTreeNode cnode = (DefaultMutableTreeNode)ce.nextElement();
                    VMSHardwareInfo vmshi = (VMSHardwareInfo)cnode.getUserObject();
                    vmshi.checkResourceFieldsChanged(null, vmshi.getParametersFromXML());
                    vmshi.updateAdvancedPanels();
                }
            }
        }
        for (HbConnectionInfo hbci : this.crmGraph.getAllHbConnections()) {
            hbci.checkResourceFieldsChanged(null, hbci.getParametersFromXML());
            hbci.updateAdvancedPanels();
        }
        for (Host clusterHost : this.getClusterHosts()) {
            HostBrowser hostBrowser = clusterHost.getBrowser();
            hostBrowser.getHostInfo().updateAdvancedPanels();
        }
    }

    public boolean isOneMaster(List<String> rscs) {
        for (String id : rscs) {
            this.mHeartbeatIdToServiceLock();
            ServiceInfo si = this.heartbeatIdToServiceInfo.get(id);
            this.mHeartbeatIdToServiceUnlock();
            if (si == null || !si.getService().isMaster()) continue;
            return true;
        }
        return false;
    }

    public void updateHWInfo(final Host host) {
        host.setIsLoading();
        host.getHWInfo(new CategoryInfo[]{this.clusterHostsInfo}, new ResourceGraph[]{this.drbdGraph, this.crmGraph});
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                ClusterBrowser.this.drbdGraph.addHost(host.getBrowser().getHostDrbdInfo());
            }
        });
        this.updateCommonBlockDevices();
        this.drbdGraph.repaint();
    }

    public void updateProxyHWInfo(Host host) {
        host.setIsLoading();
        host.getHWInfo(new CategoryInfo[]{this.clusterHostsInfo}, new ResourceGraph[]{this.drbdGraph, this.crmGraph});
        this.updateCommonBlockDevices();
        this.drbdGraph.repaint();
    }

    public Map<Host, String> getDrbdParameters() {
        return this.drbdParameters;
    }

    public void clStatusLock() {
        this.mClStatusLock.lock();
    }

    public void clStatusUnlock() {
        this.mClStatusLock.unlock();
    }

    public static String getClassMenu(String cl) {
        String name = HB_CLASS_MENU.get(cl);
        if (name == null) {
            return Tools.ucfirst(cl) + " scripts";
        }
        return name;
    }

    static {
        HB_CLASS_MENU.put("ocf", "OCF Resource Agents");
        HB_CLASS_MENU.put("heartbeat", "Heartbeat 1 RAs (deprecated)");
        HB_CLASS_MENU.put("lsb", "LSB Init Scripts");
        HB_CLASS_MENU.put("stonith", "Stonith Devices");
        HB_CLASS_MENU.put("service", "Upstart/Systemd Scripts");
        HB_CLASS_MENU.put("systemd", "Systemd Scripts");
        HB_CLASS_MENU.put("upstart", "Upstart Scripts");
        SERVICE_LABEL_WIDTH = Tools.getDefaultSize("ClusterBrowser.ServiceLabelWidth");
        SERVICE_FIELD_WIDTH = Tools.getDefaultSize("ClusterBrowser.ServiceFieldWidth");
        FILL_PAINT_STOPPED = Tools.getDefaultColor("CRMGraph.FillPaintStopped");
        HB_CLASSES = new ArrayList<String>();
        HB_CLASSES.add("ocf");
        HB_CLASSES.add("heartbeat");
        for (String c : ResourceAgent.SERVICE_CLASSES) {
            HB_CLASSES.add(c);
        }
        HB_CLASSES.add("stonith");
        HB_OPERATIONS = new String[]{HB_OP_START, HB_OP_PROMOTE, HB_OP_DEMOTE, HB_OP_STOP, HB_OP_STATUS, HB_OP_MONITOR, HB_OP_META_DATA, HB_OP_VALIDATE_ALL};
        HB_OP_IGNORE_DEFAULT = new ArrayList<String>();
        HB_OP_IGNORE_DEFAULT.add(HB_OP_STATUS);
        HB_OP_IGNORE_DEFAULT.add(HB_OP_META_DATA);
        HB_OP_IGNORE_DEFAULT.add(HB_OP_VALIDATE_ALL);
        HB_OPERATION_PARAM_LIST = new String[]{HB_PAR_DESC, HB_PAR_INTERVAL, HB_PAR_TIMEOUT, "OCF_CHECK_LEVEL", HB_PAR_START_DELAY, HB_PAR_DISABLED, HB_PAR_ROLE, HB_PAR_PREREQ, HB_PAR_ON_FAIL};
        STARTING_PTEST_TOOLTIP = Tools.getString("ClusterBrowser.StartingPtest");
        CLUSTER_ICON_SMALL = Tools.createImageIcon(Tools.getDefault("ClusterBrowser.ClusterIconSmall"));
        DEFAULT_OP_PARAMS = new ArrayList<String>(Arrays.asList(HB_PAR_TIMEOUT, HB_PAR_INTERVAL));
        RESET_STRING_LEN = RESET_STRING.length();
        BY_RES_PATTERN = Pattern.compile("^/dev/drbd/by-res/([^/]+)(?:/(\\d+))?$");
    }

    public abstract class DRBDMenuItemCallback
    implements ButtonCallback {
        private final ComponentWithTest component;
        private final Host menuHost;
        private volatile boolean mouseStillOver = false;

        public DRBDMenuItemCallback(ComponentWithTest component, Host menuHost) {
            this.component = component;
            this.menuHost = menuHost;
        }

        @Override
        public final boolean isEnabled() {
            return true;
        }

        @Override
        public final void mouseOut() {
            if (!this.isEnabled()) {
                return;
            }
            this.mouseStillOver = false;
            ClusterBrowser.this.drbdGraph.stopTestAnimation((JComponent)((Object)this.component));
            this.component.setToolTipText(null);
        }

        @Override
        public final void mouseOver() {
            if (!this.isEnabled()) {
                return;
            }
            this.mouseStillOver = true;
            this.component.setToolTipText(Tools.getString("ClusterBrowser.StartingDRBDtest"));
            this.component.setToolTipBackground(Tools.getDefaultColor("ClusterBrowser.Test.Tooltip.Background"));
            Tools.sleep(250);
            if (!this.mouseStillOver) {
                return;
            }
            this.mouseStillOver = false;
            CountDownLatch startTestLatch = new CountDownLatch(1);
            ClusterBrowser.this.drbdGraph.startTestAnimation((JComponent)((Object)this.component), startTestLatch);
            ClusterBrowser.this.drbdtestLockAcquire();
            LinkedHashMap<Host, String> testOutput = new LinkedHashMap<Host, String>();
            if (this.menuHost == null) {
                for (Host h : ClusterBrowser.this.cluster.getHostsArray()) {
                    this.action(h);
                    testOutput.put(h, DRBD.getDRBDtest());
                }
            } else {
                this.action(this.menuHost);
                testOutput.put(this.menuHost, DRBD.getDRBDtest());
            }
            DRBDtestData dtd = new DRBDtestData(testOutput);
            this.component.setToolTipText(dtd.getToolTip());
            ClusterBrowser.this.drbdtestdataLockAcquire();
            ClusterBrowser.this.drbdtestData = dtd;
            ClusterBrowser.this.drbdtestdataLockRelease();
            ClusterBrowser.this.drbdtestLockRelease();
            startTestLatch.countDown();
        }

        protected abstract void action(Host var1);
    }

    public abstract class ClMenuItemCallback
    implements ButtonCallback {
        private final ComponentWithTest component;
        private final Host menuHost;
        private volatile boolean mouseStillOver = false;

        public ClMenuItemCallback(ComponentWithTest component, Host menuHost) {
            this.component = component;
            this.menuHost = menuHost;
        }

        @Override
        public boolean isEnabled() {
            Host h = this.menuHost == null ? ClusterBrowser.this.getDCHost() : this.menuHost;
            return !Tools.versionBeforePacemaker(h);
        }

        @Override
        public final void mouseOut() {
            if (this.isEnabled()) {
                this.mouseStillOver = false;
                ClusterBrowser.this.crmGraph.stopTestAnimation((JComponent)((Object)this.component));
                this.component.setToolTipText(null);
            }
        }

        @Override
        public final void mouseOver() {
            if (this.isEnabled()) {
                this.mouseStillOver = true;
                this.component.setToolTipText(STARTING_PTEST_TOOLTIP);
                this.component.setToolTipBackground(Tools.getDefaultColor("ClusterBrowser.Test.Tooltip.Background"));
                Tools.sleep(250);
                if (!this.mouseStillOver) {
                    return;
                }
                this.mouseStillOver = false;
                CountDownLatch startTestLatch = new CountDownLatch(1);
                ClusterBrowser.this.crmGraph.startTestAnimation((JComponent)((Object)this.component), startTestLatch);
                ClusterBrowser.this.ptestLockAcquire();
                ClusterBrowser.this.clusterStatus.setPtestData(null);
                Host h = this.menuHost == null ? ClusterBrowser.this.getDCHost() : this.menuHost;
                this.action(h);
                PtestData ptestData = new PtestData(CRM.getPtest(h));
                this.component.setToolTipText(ptestData.getToolTip());
                ClusterBrowser.this.clusterStatus.setPtestData(ptestData);
                ClusterBrowser.this.ptestLockRelease();
                startTestLatch.countDown();
            }
        }

        protected abstract void action(Host var1);
    }
}

