/*
 * Decompiled with CFR 0.152.
 */
package lcmc.data.resources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lcmc.data.resources.Resource;
import lcmc.utilities.Tools;

public final class BlockDevice
extends Resource {
    private static final long serialVersionUID = 1L;
    private String blockSize;
    private String readlink;
    private String mountedOn;
    private String fsType;
    private boolean drbd = false;
    private boolean isUsedByCRM;
    private BlockDevice metaDisk = null;
    private List<BlockDevice> metaDiskOfBlockDevices = new ArrayList<BlockDevice>();
    private boolean splitBrain = false;
    private String connectionState = null;
    private String nodeState = null;
    private String diskState = null;
    private String syncedProgress = null;
    private String drbdFlags = null;
    private int used = -1;
    private String volumeGroup = null;
    private String vgOnPhysicalVolume = null;
    private String logicalVolume = null;
    private BlockDevice drbdBlockDevice = null;
    private static final Set<String> CONNECTED_STATES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Connected", "SyncTarget", "SyncSource", "StartingSyncS", "StartingSyncT", "WFBitMapS", "WFBitMapT", "WFSyncUUID", "PausedSyncS", "PausedSyncT", "VerifyS", "VerifyT")));
    private static final Set<String> SYNCING_STATES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("SyncTarget", "SyncSource", "PausedSyncS", "PausedSyncT")));

    public BlockDevice(String line) {
        this.update(line);
    }

    public void update(String line) {
        Pattern p = Pattern.compile("([^:]+):(.*)");
        String[] cols = line.split(" ");
        if (cols.length < 2) {
            Tools.appWarning("cannot parse line: " + line);
        } else {
            String device = cols[0];
            this.setName(device);
            HashMap<String, String> tokens = new HashMap<String, String>();
            for (int i = 1; i < cols.length; ++i) {
                Matcher m = p.matcher(cols[i]);
                if (m.matches()) {
                    tokens.put(m.group(1), m.group(2));
                    continue;
                }
                Tools.appWarning("could not parse: " + line);
            }
            this.readlink = (String)tokens.get("rl");
            this.blockSize = (String)tokens.get("size");
            this.mountedOn = (String)tokens.get("mp");
            this.fsType = (String)tokens.get("fs");
            this.volumeGroup = (String)tokens.get("vg");
            this.logicalVolume = (String)tokens.get("lv");
            this.vgOnPhysicalVolume = (String)tokens.get("pv");
            String usedStr = (String)tokens.get("used");
            if (usedStr != null) {
                this.used = Integer.parseInt(usedStr);
            }
        }
    }

    public String getBlockSize() {
        return this.blockSize;
    }

    public String getMountedOn() {
        return this.mountedOn;
    }

    public String getFsType() {
        return this.fsType;
    }

    public boolean isMounted() {
        return this.mountedOn != null;
    }

    public boolean isDrbd() {
        return this.drbd;
    }

    public int getUsed() {
        return this.used;
    }

    public void resetDrbd() {
        this.splitBrain = false;
        this.connectionState = null;
        this.nodeState = null;
        this.diskState = null;
        this.syncedProgress = null;
        this.drbdFlags = null;
    }

    public boolean isUsedByCRM() {
        return this.isUsedByCRM;
    }

    public boolean isDrbdMetaDisk() {
        return !this.metaDiskOfBlockDevices.isEmpty();
    }

    public List<BlockDevice> getMetaDiskOfBlockDevices() {
        return this.metaDiskOfBlockDevices;
    }

    public boolean isAvailable() {
        return !this.isMounted() && !this.isUsedByCRM && !this.isDrbdMetaDisk() && !this.isVolumeGroupOnPhysicalVolume();
    }

    public void setDrbd(boolean drbd) {
        this.drbd = drbd;
        if (!drbd) {
            this.connectionState = null;
            this.nodeState = null;
            this.diskState = null;
            this.syncedProgress = null;
            this.drbdFlags = null;
            if (this.metaDisk != null) {
                this.metaDisk.removeMetadiskOfBlockDevice(this);
                this.metaDisk = null;
            }
            this.metaDiskOfBlockDevices = new ArrayList<BlockDevice>();
        }
    }

    public boolean isDifferent(String connectionState, String nodeState, String diskState, String drbdFlags) {
        return !Tools.areEqual(this.connectionState, connectionState) || !Tools.areEqual(this.nodeState, nodeState) || !Tools.areEqual(this.diskState, diskState) || !Tools.areEqual(this.drbdFlags, drbdFlags);
    }

    public void setUsedByCRM(boolean isUsedByCRM) {
        this.isUsedByCRM = isUsedByCRM;
    }

    void addMetaDiskOfBlockDevice(BlockDevice metaDiskOfBlockDevice) {
        if (!this.metaDiskOfBlockDevices.contains(metaDiskOfBlockDevice)) {
            this.metaDiskOfBlockDevices.add(metaDiskOfBlockDevice);
        }
    }

    public void setMetaDisk(BlockDevice metaDisk) {
        this.metaDisk = metaDisk;
        if (metaDisk != null) {
            metaDisk.addMetaDiskOfBlockDevice(this);
        }
    }

    public void removeMetadiskOfBlockDevice(BlockDevice metaDiskOfBlockDevice) {
        this.metaDiskOfBlockDevices.remove(metaDiskOfBlockDevice);
    }

    public BlockDevice getMetaDisk() {
        return this.metaDisk;
    }

    public void setConnectionState(String connectionState) {
        this.connectionState = connectionState;
    }

    public void setDrbdFlags(String drbdFlags) {
        this.drbdFlags = drbdFlags;
    }

    public void setNodeState(String nodeState) {
        this.nodeState = nodeState;
    }

    public void setDiskState(String diskState) {
        this.diskState = diskState;
    }

    public String getConnectionState() {
        return this.connectionState;
    }

    public String getNodeState() {
        return this.nodeState;
    }

    public String getDiskState() {
        return this.diskState;
    }

    public void setSyncedProgress(String syncedProgress) {
        this.syncedProgress = syncedProgress;
    }

    public String getSyncedProgress() {
        return this.syncedProgress;
    }

    public boolean isAttached() {
        if (!this.drbd) {
            return true;
        }
        if (this.diskState == null) {
            return false;
        }
        return !"Diskless".equals(this.diskState);
    }

    public boolean isDiskless() {
        if (!this.drbd) {
            return false;
        }
        if (this.diskState == null) {
            return true;
        }
        return "Diskless".equals(this.diskState);
    }

    public boolean isConnected() {
        if (this.connectionState == null) {
            return false;
        }
        if (CONNECTED_STATES.contains(this.connectionState)) {
            this.setSplitBrain(false);
            return true;
        }
        return false;
    }

    public boolean isConnectedOrWF() {
        return this.isWFConnection() || this.isConnected();
    }

    public boolean isWFConnection() {
        if (this.connectionState == null) {
            return false;
        }
        return "WFConnection".equals(this.connectionState);
    }

    public boolean isPrimary() {
        if (this.nodeState == null) {
            return false;
        }
        return "Primary".equals(this.nodeState);
    }

    public boolean isSecondary() {
        if (this.nodeState == null) {
            return false;
        }
        return "Secondary".equals(this.nodeState);
    }

    private boolean checkDrbdFlag(int flag) {
        return this.drbdFlags.indexOf(flag) >= 0;
    }

    public boolean isPausedSync() {
        if (this.drbdFlags == null) {
            return false;
        }
        return this.checkDrbdFlag(117);
    }

    public boolean isSyncing() {
        if (this.nodeState == null) {
            this.syncedProgress = null;
            return false;
        }
        if (SYNCING_STATES.contains(this.connectionState)) {
            return true;
        }
        this.syncedProgress = null;
        return false;
    }

    public boolean isVerifying() {
        if (this.nodeState == null) {
            return false;
        }
        return "VerifyS".equals(this.connectionState) || "VerifyT".equals(this.connectionState);
    }

    public boolean isSyncSource() {
        if (this.connectionState == null) {
            return false;
        }
        return "SyncSource".equals(this.connectionState);
    }

    public boolean isSyncTarget() {
        if (this.connectionState == null) {
            return false;
        }
        return "SyncTarget".equals(this.connectionState);
    }

    public void setSplitBrain(boolean splitBrain) {
        this.splitBrain = splitBrain;
    }

    public boolean isSplitBrain() {
        return this.splitBrain;
    }

    public String getMetaDiskString(String md, String mdi) {
        if (md == null || mdi == null) {
            return null;
        }
        StringBuilder metaDiskString = new StringBuilder();
        if ("Flexible".equals(mdi)) {
            metaDiskString.append("flexible-meta-disk\t");
            metaDiskString.append(md);
        } else {
            metaDiskString.append("meta-disk\t");
            metaDiskString.append(md);
            if (!"internal".equals(md)) {
                metaDiskString.append('[');
                metaDiskString.append(mdi);
                metaDiskString.append(']');
            }
        }
        return metaDiskString.toString();
    }

    String getMetaDiskString() {
        return this.getMetaDiskString(this.getValue("DrbdMetaDisk"), this.getValue("DrbdMetaDiskIndex"));
    }

    public String getSection(String parameter) {
        return Tools.getString("BlockDevice.MetaDiskSection");
    }

    public boolean isSwap() {
        return this.fsType != null && "swap".equals(this.fsType);
    }

    public String getReadlink() {
        return this.readlink;
    }

    public String getVolumeGroup() {
        return this.volumeGroup;
    }

    public boolean isPhysicalVolume() {
        return this.vgOnPhysicalVolume != null;
    }

    public String getVolumeGroupOnPhysicalVolume() {
        return this.vgOnPhysicalVolume;
    }

    public boolean isVolumeGroupOnPhysicalVolume() {
        return this.vgOnPhysicalVolume != null && !"".equals(this.vgOnPhysicalVolume);
    }

    public void setVolumeGroupOnPhysicalVolume(String vgOnPhysicalVolume) {
        this.vgOnPhysicalVolume = vgOnPhysicalVolume;
    }

    public String getLogicalVolume() {
        return this.logicalVolume;
    }

    public BlockDevice getDrbdBlockDevice() {
        return this.drbdBlockDevice;
    }

    public boolean isDrbdPhysicalVolume() {
        return this.drbdBlockDevice != null && this.drbdBlockDevice.isPhysicalVolume();
    }

    public boolean isDrbdVolumeGroupOnPhysicalVolume() {
        return this.drbdBlockDevice != null && this.drbdBlockDevice.isVolumeGroupOnPhysicalVolume();
    }

    public void setDrbdBlockDevice(BlockDevice drbdBlockDevice) {
        this.drbdBlockDevice = drbdBlockDevice;
    }
}

