/*
 * Decompiled with CFR 0.152.
 */
package lcmc.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import lcmc.utilities.Tools;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

abstract class XML {
    XML() {
    }

    protected final Node getChildNode(Node node, String tag) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            if (!n.getNodeName().equals(tag)) continue;
            return n;
        }
        return null;
    }

    final String getAttribute(Node node, String name) {
        if (node.getAttributes().getNamedItem(name) == null) {
            return null;
        }
        return node.getAttributes().getNamedItem(name).getNodeValue();
    }

    final String getCDATA(Node node) {
        Node n = this.getChildNode(node, "#cdata-section");
        return n.getNodeValue();
    }

    final String getText(Node node) {
        Node ch = this.getChildNode(node, "#text");
        if (ch == null) {
            return "";
        }
        return ch.getNodeValue();
    }

    protected final Document getXMLDocument(String xmlraw) {
        Document document;
        if (xmlraw == null) {
            return null;
        }
        String xml = xmlraw.trim();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        if (factory == null || xml.equals("") || xml.equals("no resources defined!")) {
            return null;
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(new ByteArrayInputStream(xml.getBytes()));
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            Tools.appWarning("could not parse: " + xml);
            return null;
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            return null;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        return document;
    }
}

