/*
 * Decompiled with CFR 0.152.
 */
package lcmc.data;

import java.io.File;
import java.io.IOException;
import lcmc.data.Host;
import lcmc.gui.resources.VMSHardwareInfo;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

public final class LinuxFile
extends File {
    private static final long serialVersionUID = 1L;
    static final char separatorChar = '/';
    static final String separator = "/";
    static final char pathSeparatorChar = '/';
    static final String pathSeparator = "/";
    private final Host host;
    private boolean directory = false;
    private long lastModified;
    private long fileLength;
    private Boolean existCache = null;
    private final VMSHardwareInfo vmsHardwareInfo;

    public LinuxFile(VMSHardwareInfo vmsHardwareInfo, Host host, String name, String type, long lastModified, long fileLength) {
        super(Tools.getUnixPath(name));
        this.vmsHardwareInfo = vmsHardwareInfo;
        this.host = host;
        if ("d".equals(type)) {
            this.directory = true;
        }
        this.lastModified = lastModified;
        this.fileLength = fileLength;
    }

    public void update(String type, long lastModified, long fileLength) {
        if ("d".equals(type)) {
            this.directory = true;
        }
        this.lastModified = lastModified;
        this.fileLength = fileLength;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean exists() {
        if (this.existCache != null) {
            return this.existCache;
        }
        SSH.SSHOutput out = Tools.execCommandProgressIndicator(this.host, "@DMCSUDO@stat " + Tools.getUnixPath(this.toString()) + " 2>/dev/null", null, false, "executing...", SSH.DEFAULT_COMMAND_TIMEOUT);
        this.existCache = out.getExitCode() == 0;
        return this.existCache;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canExecute() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return this.directory;
    }

    @Override
    public long lastModified() {
        return this.lastModified;
    }

    @Override
    public long length() {
        return this.fileLength;
    }

    @Override
    public File getAbsoluteFile() {
        String absPath = this.getAbsolutePath();
        return this.vmsHardwareInfo.getLinuxDir(absPath, this.host);
    }

    @Override
    public File getCanonicalFile() throws IOException {
        String canonPath = this.getCanonicalPath();
        return this.vmsHardwareInfo.getLinuxDir(canonPath, this.host);
    }

    @Override
    public File getParentFile() {
        String p = this.getParent();
        if (p == null) {
            return null;
        }
        return this.vmsHardwareInfo.getLinuxDir(p, this.host);
    }
}

