/*
 * Decompiled with CFR 0.152.
 */
package lcmc.data;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lcmc.Exceptions;
import lcmc.data.ConfigData;
import lcmc.data.DrbdProxy;
import lcmc.data.Host;
import lcmc.data.XML;
import lcmc.gui.DrbdGraph;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.gui.resources.ProxyNetInfo;
import lcmc.gui.resources.StringInfo;
import lcmc.utilities.ConvertCmdCallback;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;
import org.apache.commons.collections15.map.LinkedMap;
import org.apache.commons.collections15.map.MultiKeyMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DrbdXML
extends XML {
    private String configFile = "unknown";
    private final Map<String, String> paramDefaultMap = new HashMap<String, String>();
    private final Map<String, String> paramTypeMap = new HashMap<String, String>();
    private final Map<String, String> paramSectionMap = new LinkedHashMap<String, String>();
    private final Map<String, List<String>> sectionParamsMap = new LinkedHashMap<String, List<String>>();
    private final Map<String, String> paramUnitLongMap = new LinkedHashMap<String, String>();
    private final Map<String, String> paramDefaultUnitMap = new LinkedHashMap<String, String>();
    private final Map<String, String> paramLongDescMap = new HashMap<String, String>();
    private final Map<String, BigInteger> paramMinMap = new LinkedHashMap<String, BigInteger>();
    private final Map<String, BigInteger> paramMaxMap = new LinkedHashMap<String, BigInteger>();
    private final Map<String, Boolean> paramCorrectValueMap = new HashMap<String, Boolean>();
    private final Map<String, List<Object>> paramItemsMap = new LinkedHashMap<String, List<Object>>();
    private final List<String> parametersList = new ArrayList<String>();
    private final List<String> globalParametersList = new ArrayList<String>();
    private final List<String> requiredParametersList = new ArrayList<String>();
    private final Map<String, Map<String, String>> optionsMap = new HashMap<String, Map<String, String>>();
    private final List<String> resourceList = new ArrayList<String>();
    private final MultiKeyMap<String, String> resourceDeviceMap = MultiKeyMap.decorate(new LinkedMap());
    private final Map<String, String> deviceResourceMap = new HashMap<String, String>();
    private final Map<String, String> deviceVolumeMap = new HashMap<String, String>();
    private final MultiKeyMap<String, Map<String, String>> resourceHostDiskMap = new MultiKeyMap();
    private final Map<String, Map<String, String>> resourceHostIpMap = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> resourceHostPortMap = new HashMap<String, Map<String, String>>();
    private final MultiKeyMap<String, Map<String, String>> resourceHostMetaDiskMap = new MultiKeyMap();
    private final MultiKeyMap<String, Map<String, String>> resourceHostMetaDiskIndexMap = new MultiKeyMap();
    private final MultiKeyMap<String, HostProxy> resourceHostProxyMap = new MultiKeyMap();
    private final Set<String> proxyHostNames = new LinkedHashSet<String>();
    private final Map<String, Boolean> hostDrbdLoadedMap = new HashMap<String, Boolean>();
    boolean unknownSections = false;
    public static final String GLOBAL_SECTION = "global";
    private static final String PROTOCOL_A = "A / Asynchronous";
    private static final String PROTOCOL_C = "C / Synchronous";
    public static final String PROTOCOL_PARAM = "protocol";
    public static final String PING_TIMEOUT_PARAM = "ping-timeout";
    static final StringInfo[] PROTOCOLS = new StringInfo[]{new StringInfo("A / Asynchronous", "A", null), new StringInfo("B / Semi-Synchronous", "B", null), new StringInfo("C / Synchronous", "C", null)};
    static final List<String> NOT_ADVANCED_PARAMS = new ArrayList<String>();
    static final Map<String, ConfigData.AccessType> PARAM_ACCESS_TYPE;
    public static final String CONFIG_YES = "yes";
    public static final String CONFIG_NO = "no";
    static final Map<String, String> HARDCODED_DEFAULTS;

    public DrbdXML(Host[] hosts, Map<Host, String> drbdParameters) {
        this.addSpecialParameter("resource", "name", true);
        for (Host host : hosts) {
            String output = null;
            if (drbdParameters.get(host) == null) {
                output = this.updateDrbdParameters(host);
                drbdParameters.put(host, output);
                if (output == null) {
                    return;
                }
            } else {
                output = drbdParameters.get(host);
            }
            this.parseDrbdParameters(host, output, hosts);
        }
    }

    public String updateDrbdParameters(Host host) {
        String command = host.getDistCommand("Drbd.getParameters", (ConvertCmdCallback)null);
        SSH.SSHOutput ret = Tools.execCommand(host, command, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
        if (ret.getExitCode() != 0) {
            return null;
        }
        return ret.getOutput();
    }

    public void parseDrbdParameters(Host host, String output, Host[] hosts) {
        String[] lines = output.split("\\r?\\n");
        Pattern bp = Pattern.compile("^<command name=\"(.*?)\".*");
        Pattern ep = Pattern.compile("^</command>$");
        StringBuilder xml = new StringBuilder();
        String section = null;
        for (String line : lines) {
            Matcher m = bp.matcher(line);
            if (m.matches()) {
                section = m.group(1);
            }
            if (section == null) continue;
            xml.append(line);
            xml.append('\n');
            Matcher m2 = ep.matcher(line);
            if (!m2.matches()) continue;
            this.parseSection(section, xml.toString(), host, hosts);
            section = null;
            xml.delete(0, xml.length());
        }
        if (!this.parametersList.contains(PROTOCOL_PARAM)) {
            this.addParameter("resource", PROTOCOL_PARAM, PROTOCOL_C, PROTOCOLS, true);
        }
    }

    String getConfigFile() {
        return this.configFile;
    }

    public String getConfig(Host host) {
        if (!host.isConnected()) {
            return null;
        }
        String command2 = host.getDistCommand("Drbd.getConfig", (ConvertCmdCallback)null);
        SSH.SSHOutput ret = Tools.execCommand(host, command2, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
        if (ret.getExitCode() == 0) {
            StringBuffer confSB = new StringBuffer(ret.getOutput());
            String conf = host.getOutput("drbd", confSB);
            return conf;
        }
        return null;
    }

    public void update(String configString) {
        if (configString != null && !configString.equals("")) {
            this.parseConfig(configString);
        }
    }

    public List<String> getParameters() {
        return this.parametersList;
    }

    public String getParamShortDesc(String param) {
        StringBuilder name = new StringBuilder(param.replaceAll("\\-", " "));
        name.replace(0, 1, name.substring(0, 1).toUpperCase());
        if (this.paramUnitLongMap.containsKey(param)) {
            name.append(" (" + this.paramUnitLongMap.get(param) + ")");
        }
        return name.toString();
    }

    public String getParamLongDesc(String param) {
        return this.paramLongDescMap.get(param);
    }

    public String getUnitLong(String param) {
        return this.paramUnitLongMap.get(param);
    }

    public String getDefaultUnit(String param) {
        return this.paramDefaultUnitMap.get(param);
    }

    public boolean hasUnitPrefix(String param) {
        String unit = this.paramUnitLongMap.get(param);
        return this.paramDefaultUnitMap.containsKey(param) && (unit == null || "bytes".equals(unit) || "bytes/second".equals(unit));
    }

    public String getParamType(String param) {
        return this.paramTypeMap.get(param);
    }

    public String getParamDefault(String param) {
        String defaultValue = this.paramDefaultMap.get(param);
        if (defaultValue == null) {
            return "";
        }
        if (this.hasUnitPrefix(param)) {
            StringBuilder defaultValueBuf = new StringBuilder(defaultValue);
            String unit = this.getDefaultUnit(param);
            if (unit != null) {
                defaultValueBuf.append(unit);
            }
            return defaultValueBuf.toString();
        }
        return defaultValue;
    }

    public String getParamPreferred(String param) {
        return null;
    }

    public String getSection(String param) {
        return this.paramSectionMap.get(param);
    }

    public boolean checkParam(String param, String rawValue) {
        Pattern p;
        Matcher m;
        String type = this.paramTypeMap.get(param);
        boolean correctValue = true;
        String value = rawValue;
        String unit = null;
        if (rawValue != null && this.hasUnitPrefix(param) && (m = (p = Pattern.compile("\\d*([kmgtsKMGTS])")).matcher(rawValue)).matches()) {
            unit = m.group(1).toUpperCase();
            value = rawValue.substring(0, rawValue.length() - unit.length());
        }
        if (value == null || "".equals(value)) {
            correctValue = !this.isRequired(param);
        } else if ("boolean".equals(type)) {
            if (!value.equals(CONFIG_YES) && !value.equals(CONFIG_NO)) {
                correctValue = false;
            }
        } else if ("numeric".equals(type)) {
            p = Pattern.compile("(-?\\d+)|\\d*");
            m = p.matcher(value);
            if (!m.matches()) {
                correctValue = false;
            } else if ((unit == null || "k".equalsIgnoreCase(unit) || "m".equalsIgnoreCase(unit) || "g".equalsIgnoreCase(unit) || "t".equalsIgnoreCase(unit)) && "K".equalsIgnoreCase(this.getDefaultUnit(param))) {
                long v = unit == null ? Long.parseLong(rawValue) / 1024L : Tools.convertToKilobytes(rawValue);
                if (this.paramMaxMap.get(param) != null && v > this.paramMaxMap.get(param).longValue()) {
                    correctValue = false;
                } else if (this.paramMinMap.get(param) != null && v < this.paramMinMap.get(param).longValue()) {
                    correctValue = false;
                }
            } else if (!"s".equalsIgnoreCase(unit)) {
                long v = Tools.convertUnits(rawValue);
                if (this.paramMaxMap.get(param) != null && v > this.paramMaxMap.get(param).longValue()) {
                    correctValue = false;
                } else if (this.paramMinMap.get(param) != null && v < this.paramMinMap.get(param).longValue()) {
                    correctValue = false;
                }
            }
        } else {
            correctValue = true;
        }
        this.paramCorrectValueMap.put(param, correctValue);
        return correctValue;
    }

    public boolean isInteger(String param) {
        String type = this.paramTypeMap.get(param);
        return "numeric".equals(type);
    }

    public boolean isLabel(String param) {
        return false;
    }

    public boolean isStringType(String param) {
        String type = this.paramTypeMap.get(param);
        return "string".equals(type);
    }

    boolean checkParamCache(String param) {
        return this.paramCorrectValueMap.get(param);
    }

    private void addSpecialParameter(String section, String param, boolean required) {
        if (!this.parametersList.contains(param)) {
            this.parametersList.add(param);
            if (required) {
                this.requiredParametersList.add(param);
            }
            this.paramTypeMap.put(param, "string");
            this.paramSectionMap.put(param, section);
        }
    }

    private void addParameter(String section, String param, String defaultValue, Object[] items, boolean required) {
        this.addParameter(section, param, defaultValue, required);
        ArrayList<Object> l = new ArrayList<Object>();
        for (int i = 0; i < items.length; ++i) {
            if (l.contains(items[i])) continue;
            l.add(items[i]);
        }
        this.paramItemsMap.put(param, l);
        this.paramTypeMap.put(param, "handler");
    }

    private void addParameter(String section, String param, boolean required) {
        this.addSpecialParameter(section, param, required);
        this.sectionParamsMap.put(section, new ArrayList());
        this.sectionParamsMap.get(section).add(param);
    }

    private void addParameter(String section, String param, String defaultValue, boolean required) {
        this.addParameter(section, param, required);
        this.paramDefaultMap.put(param, defaultValue);
    }

    private void addParameter(String section, String param, String defaultValue, boolean required, String type) {
        this.addParameter(section, param, defaultValue, required);
        this.paramTypeMap.put(param, type);
    }

    public String[] getSections() {
        return this.sectionParamsMap.keySet().toArray(new String[this.sectionParamsMap.size()]);
    }

    public String[] getSectionParams(String section) {
        List<String> params = this.sectionParamsMap.get(section);
        if (params == null) {
            return new String[0];
        }
        return params.toArray(new String[params.size()]);
    }

    public List<String> getGlobalParams() {
        return this.globalParametersList;
    }

    public Object[] getPossibleChoices(String param) {
        List<Object> items = this.paramItemsMap.get(param);
        if (items == null) {
            return null;
        }
        return items.toArray(new Object[items.size()]);
    }

    public boolean isRequired(String param) {
        return this.requiredParametersList.contains(param);
    }

    public boolean isAdvanced(String param) {
        return !this.isRequired(param) && !NOT_ADVANCED_PARAMS.contains(param);
    }

    public ConfigData.AccessType getAccessType(String param) {
        ConfigData.AccessType at = PARAM_ACCESS_TYPE.get(param);
        if (at == null) {
            return ConfigData.AccessType.ADMIN;
        }
        return at;
    }

    private void parseConfigGlobalNode(Node globalNode, Map<String, String> nameValueMap) {
        NodeList options = globalNode.getChildNodes();
        for (int i = 0; i < options.getLength(); ++i) {
            String usageCount;
            Node option = options.item(i);
            String nodeName = option.getNodeName();
            if ("dialog-refresh".equals(nodeName)) {
                String dialogRefresh = this.getAttribute(option, "refresh");
                nameValueMap.put(nodeName, dialogRefresh);
                continue;
            }
            if ("minor-count".equals(nodeName)) {
                String minorCount = this.getAttribute(option, "count");
                nameValueMap.put(nodeName, minorCount);
                continue;
            }
            if ("disable-ip-verification".equals(nodeName)) {
                nameValueMap.put(nodeName, CONFIG_YES);
                continue;
            }
            if (!"usage-count".equals(nodeName) || (usageCount = this.getAttribute(option, "count")) == null) continue;
            nameValueMap.put(nodeName, usageCount);
        }
    }

    private void parseSection(String section, String xml, Host host, Host[] hosts) {
        Document document = this.getXMLDocument(xml);
        Node commandNode = this.getChildNode(document, "command");
        if (commandNode == null) {
            return;
        }
        NodeList options = commandNode.getChildNodes();
        for (int i = 0; i < options.getLength(); ++i) {
            ArrayList<String> l;
            Node optionNode = options.item(i);
            if (!optionNode.getNodeName().equals("option")) continue;
            String name = this.getAttribute(optionNode, "name");
            String type = this.getAttribute(optionNode, "type");
            if ("flag".equals(type)) continue;
            if ("handler".equals(type)) {
                ArrayList<String> items = new ArrayList<String>();
                items.add("");
                this.paramItemsMap.put(name, items);
                this.paramDefaultMap.put(name, HARDCODED_DEFAULTS.get(name));
            } else if ("boolean".equals(type)) {
                l = new ArrayList<String>();
                l.add(CONFIG_YES);
                l.add(CONFIG_NO);
                this.paramItemsMap.put(name, l);
                this.paramDefaultMap.put(name, CONFIG_NO);
            }
            if ("fence-peer".equals(name)) {
                l = new ArrayList();
                l.add("");
                if (!"".equals(host.getArch())) {
                    l.add(host.getHeartbeatLibPath() + "/drbd-peer-outdater -t 5");
                }
                l.add("/usr/lib/drbd/crm-fence-peer.sh");
                this.paramItemsMap.put(name, l);
            } else if ("after-resync-target".equals(name)) {
                l = new ArrayList();
                l.add("");
                l.add("/usr/lib/drbd/crm-unfence-peer.sh");
                this.paramItemsMap.put(name, l);
            } else if ("split-brain".equals(name)) {
                l = new ArrayList();
                l.add("");
                l.add("/usr/lib/drbd/notify-split-brain.sh root");
                this.paramItemsMap.put(name, l);
            } else if ("become-primary-on".equals(name)) {
                l = new ArrayList();
                l.add("");
                l.add("both");
                for (Host h : hosts) {
                    l.add(h.getName());
                }
                this.paramItemsMap.put(name, l);
            } else if ("verify-alg".equals(name) || "csums-alg".equals(name) || "data-integrity-alg".equals(name) || "cram-hmac-alg".equals(name)) {
                l = new ArrayList();
                l.add("");
                for (String cr : host.getCryptoModules()) {
                    l.add(cr);
                }
                this.paramItemsMap.put(name, l);
            }
            NodeList optionInfos = optionNode.getChildNodes();
            for (int j = 0; j < optionInfos.getLength(); ++j) {
                Node optionInfo = optionInfos.item(j);
                String tag = optionInfo.getNodeName();
                if ("min".equals(tag)) {
                    this.paramMinMap.put(name, new BigInteger(this.getText(optionInfo)));
                    continue;
                }
                if ("max".equals(tag)) {
                    this.paramMaxMap.put(name, new BigInteger(this.getText(optionInfo)));
                    continue;
                }
                if ("handler".equals(tag)) {
                    this.paramItemsMap.get(name).add(this.getText(optionInfo));
                    continue;
                }
                if ("default".equals(tag)) {
                    this.paramDefaultMap.put(name, this.getText(optionInfo));
                    continue;
                }
                if ("unit".equals(tag)) {
                    this.paramUnitLongMap.put(name, this.getText(optionInfo));
                    continue;
                }
                if ("unit_prefix".equals(tag)) {
                    if ("after".equals(name) || "resync-after".equals(name)) continue;
                    String option = this.getText(optionInfo);
                    if (!"s".equals(option)) {
                        option = option.toUpperCase(Locale.US);
                    }
                    if ("1".equals(option)) {
                        option = "";
                    }
                    this.paramDefaultUnitMap.put(name, option);
                    continue;
                }
                if (!"desc".equals(tag)) continue;
                this.paramLongDescMap.put(name, this.getText(optionInfo));
            }
            this.paramTypeMap.put(name, type);
            if (!GLOBAL_SECTION.equals(section) && !this.parametersList.contains(name)) {
                this.parametersList.add(name);
            }
            if (!("resource".equals(section) || this.globalParametersList.contains(name) || "syncer".equals(section) && "after".equals(name) || "resync-after".equals(name))) {
                this.globalParametersList.add(name);
            }
            this.paramSectionMap.put(name, section);
            if (!this.sectionParamsMap.containsKey(section)) {
                this.sectionParamsMap.put(section, new ArrayList());
            }
            if (this.sectionParamsMap.get(section).contains(name)) continue;
            this.sectionParamsMap.get(section).add(name);
        }
    }

    private void parseConfigSectionNode(Node sectionNode, Map<String, String> nameValueMap) {
        NodeList options = sectionNode.getChildNodes();
        for (int i = 0; i < options.getLength(); ++i) {
            String name;
            Node option = options.item(i);
            if (option.getNodeName().equals("option")) {
                Pattern p;
                Matcher m;
                name = this.getAttribute(option, "name");
                String value = this.getAttribute(option, "value");
                if (value == null) {
                    value = CONFIG_YES;
                } else if (this.hasUnitPrefix(name) && (m = (p = Pattern.compile("\\d+([kmgs])")).matcher(value)).matches()) {
                    String unit = m.group(1).toUpperCase();
                    value = value.substring(0, value.length() - unit.length()) + unit;
                }
                nameValueMap.put(name, value);
                continue;
            }
            if (!option.getNodeName().equals("section") || !"plugin".equals(name = this.getAttribute(option, "name"))) continue;
            this.parseProxyPluginNode(option.getChildNodes(), nameValueMap);
        }
    }

    private void parseProxyPluginNode(NodeList options, Map<String, String> nameValueMap) {
        for (int i = 0; i < options.getLength(); ++i) {
            String value;
            String name;
            Node option = options.item(i);
            if (!option.getNodeName().equals("option")) continue;
            String nameValues = this.getAttribute(option, "name");
            int spacePos = nameValues.indexOf(32);
            if (spacePos > 0) {
                name = "plugin-" + nameValues.substring(0, spacePos);
                value = nameValues.substring(spacePos + 1, nameValues.length());
            } else {
                name = "plugin-" + nameValues;
                value = CONFIG_YES;
            }
            nameValueMap.put(name, value);
        }
    }

    private void parseHostConfig(String resName, Node hostNode) {
        String hostName = this.getAttribute(hostNode, "name");
        this.parseVolumeConfig(hostName, resName, hostNode);
        NodeList options = hostNode.getChildNodes();
        for (int i = 0; i < options.getLength(); ++i) {
            Node option = options.item(i);
            if (option.getNodeName().equals("volume")) {
                this.parseVolumeConfig(hostName, resName, option);
                continue;
            }
            if (option.getNodeName().equals("address")) {
                String ip = this.getText(option);
                String port = this.getAttribute(option, "port");
                Map<String, String> hostIpMap = this.resourceHostIpMap.get(resName);
                if (hostIpMap == null) {
                    hostIpMap = new HashMap<String, String>();
                    this.resourceHostIpMap.put(resName, hostIpMap);
                }
                hostIpMap.put(hostName, ip);
                Map<String, String> hostPortMap = this.resourceHostPortMap.get(resName);
                if (hostPortMap == null) {
                    hostPortMap = new HashMap<String, String>();
                    this.resourceHostPortMap.put(resName, hostPortMap);
                }
                hostPortMap.put(hostName, port);
                continue;
            }
            if (!option.getNodeName().equals("proxy")) continue;
            this.parseProxyHostConfig(hostName, resName, option);
        }
    }

    private void parseVolumeConfig(String hostName, String resName, Node volumeNode) {
        String volumeNr = this.getAttribute(volumeNode, "vnr");
        if (volumeNr == null) {
            volumeNr = "0";
        }
        NodeList options = volumeNode.getChildNodes();
        for (int i = 0; i < options.getLength(); ++i) {
            Node option = options.item(i);
            if (option.getNodeName().equals("device")) {
                String device = this.getText(option);
                if (device != null && "".equals(device)) {
                    String minor = this.getAttribute(option, "minor");
                    device = "/dev/drbd" + minor;
                }
                this.resourceDeviceMap.put(resName, volumeNr, device);
                this.deviceResourceMap.put(device, resName);
                this.deviceVolumeMap.put(device, volumeNr);
                continue;
            }
            if (option.getNodeName().equals("disk")) {
                String disk = this.getText(option);
                Map<String, String> hostDiskMap = this.resourceHostDiskMap.get((K[])new String[]{resName, volumeNr});
                if (hostDiskMap == null) {
                    hostDiskMap = new HashMap<String, String>();
                    this.resourceHostDiskMap.put(resName, volumeNr, hostDiskMap);
                }
                hostDiskMap.put(hostName, disk);
                continue;
            }
            if (option.getNodeName().equals("meta-disk") || option.getNodeName().equals("flexible-meta-disk")) {
                Map<String, String> hostMetaDiskMap;
                boolean flexible = option.getNodeName().equals("flexible-meta-disk");
                String metaDisk = this.getText(option);
                String metaDiskIndex = null;
                if (!flexible) {
                    metaDiskIndex = this.getAttribute(option, "index");
                }
                if (metaDiskIndex == null) {
                    metaDiskIndex = "Flexible";
                }
                if ((hostMetaDiskMap = this.resourceHostMetaDiskMap.get((K[])new String[]{resName, volumeNr})) == null) {
                    hostMetaDiskMap = new HashMap<String, String>();
                    this.resourceHostMetaDiskMap.put(resName, volumeNr, hostMetaDiskMap);
                }
                hostMetaDiskMap.put(hostName, metaDisk);
                Map<String, String> hostMetaDiskIndexMap = this.resourceHostMetaDiskIndexMap.get((K[])new String[]{resName, volumeNr});
                if (hostMetaDiskIndexMap == null) {
                    hostMetaDiskIndexMap = new HashMap<String, String>();
                    this.resourceHostMetaDiskIndexMap.put(resName, volumeNr, hostMetaDiskIndexMap);
                }
                hostMetaDiskIndexMap.put(hostName, metaDiskIndex);
                continue;
            }
            if (option.getNodeName().equals("address")) {
                String ip = this.getText(option);
                String port = this.getAttribute(option, "port");
                Map<String, String> hostIpMap = this.resourceHostIpMap.get(resName);
                if (hostIpMap == null) {
                    hostIpMap = new HashMap<String, String>();
                    this.resourceHostIpMap.put(resName, hostIpMap);
                }
                hostIpMap.put(hostName, ip);
                Map<String, String> hostPortMap = this.resourceHostPortMap.get(resName);
                if (hostPortMap == null) {
                    hostPortMap = new HashMap<String, String>();
                    this.resourceHostPortMap.put(resName, hostPortMap);
                }
                hostPortMap.put(hostName, port);
                continue;
            }
            if (!option.getNodeName().equals("proxy")) continue;
            this.parseProxyHostConfig(hostName, resName, option);
        }
    }

    private void parseProxyHostConfig(String hostName, String resName, Node proxyNode) {
        String proxyHostName = this.getAttribute(proxyNode, "hostname");
        NodeList options = proxyNode.getChildNodes();
        String insideIp = null;
        String insidePort = null;
        String outsideIp = null;
        String outsidePort = null;
        for (int i = 0; i < options.getLength(); ++i) {
            Node option = options.item(i);
            if (option.getNodeName().equals("inside")) {
                insideIp = this.getText(option);
                insidePort = this.getAttribute(option, "port");
                continue;
            }
            if (!option.getNodeName().equals("outside")) continue;
            outsideIp = this.getText(option);
            outsidePort = this.getAttribute(option, "port");
        }
        this.resourceHostProxyMap.put(resName, hostName, new HostProxy(proxyHostName, insideIp, insidePort, outsideIp, outsidePort));
        this.proxyHostNames.add(proxyHostName);
    }

    public Map<String, String> getHostDiskMap(String resName, String volumeNr) {
        return this.resourceHostDiskMap.get((K[])new String[]{resName, volumeNr});
    }

    Map<String, String> getHostIpMap(String resName) {
        return this.resourceHostIpMap.get(resName);
    }

    public String getVirtualInterfacePort(String hostName, String resName) {
        if (this.resourceHostPortMap.containsKey(resName)) {
            return this.resourceHostPortMap.get(resName).get(hostName);
        }
        return null;
    }

    public String getVirtualInterface(String hostName, String resName) {
        if (this.resourceHostIpMap.containsKey(resName)) {
            String ip = this.resourceHostIpMap.get(resName).get(hostName);
            HostProxy hostProxy = this.getHostProxy(hostName, resName);
            if (hostProxy == null) {
                return ip;
            }
            String proxyHostName = hostProxy.getProxyHostName();
            return ProxyNetInfo.displayString(ip, hostName, proxyHostName);
        }
        return null;
    }

    public HostProxy getHostProxy(String hostName, String resName) {
        return this.resourceHostProxyMap.get((K[])new String[]{resName, hostName});
    }

    public Set<String> getProxyHostNames() {
        return this.proxyHostNames;
    }

    public boolean isHostProxy(String hostName, String resName) {
        return this.resourceHostProxyMap.containsKey((K[])new String[]{resName, hostName});
    }

    public String getMetaDisk(String hostName, String resName, String volumeNr) {
        Map<String, String> hostMetaDiskMap = this.resourceHostMetaDiskMap.get((K[])new String[]{resName, volumeNr});
        if (hostMetaDiskMap != null) {
            return hostMetaDiskMap.get(hostName);
        }
        return null;
    }

    public String getMetaDiskIndex(String hostName, String resName, String volumeNr) {
        Map<String, String> hostMetaDiskIndexMap = this.resourceHostMetaDiskIndexMap.get((K[])new String[]{resName, volumeNr});
        if (hostMetaDiskIndexMap != null) {
            return hostMetaDiskIndexMap.get(hostName);
        }
        return null;
    }

    private void parseConfigResourceNode(Node resourceNode, String resName) {
        String resProtocol = this.getAttribute(resourceNode, PROTOCOL_PARAM);
        if (resProtocol != null) {
            Map<String, String> nameValueMap = this.optionsMap.get(resName + "." + "resource");
            if (nameValueMap == null) {
                nameValueMap = new HashMap<String, String>();
            } else {
                this.optionsMap.remove(resName + "." + "resource");
            }
            nameValueMap.put(PROTOCOL_PARAM, resProtocol);
            this.optionsMap.put(resName + "." + "resource", nameValueMap);
        }
        NodeList c = resourceNode.getChildNodes();
        for (int i = 0; i < c.getLength(); ++i) {
            Map<String, String> nameValueMap;
            String secName;
            Node n = c.item(i);
            if (n.getNodeName().equals("host")) {
                this.parseHostConfig(resName, n);
                continue;
            }
            if (!n.getNodeName().equals("section") && (!n.getNodeName().equals("#text") || "".equals(n.getNodeValue().trim()))) continue;
            if (n.getNodeName().equals("#text")) {
                block14: {
                    secName = "proxy";
                    nameValueMap = this.optionsMap.get(resName + "." + secName);
                    if (nameValueMap == null) {
                        nameValueMap = new HashMap<String, String>();
                    } else {
                        this.optionsMap.remove(resName + "." + secName);
                    }
                    try {
                        boolean isProxy = DrbdProxy.parse(n.getNodeValue(), nameValueMap);
                        if (!isProxy) {
                        }
                        break block14;
                    }
                    catch (Exceptions.DrbdConfigException e) {
                        Tools.appWarning(e.getMessage());
                        Tools.appWarning(n.getNodeValue());
                    }
                    continue;
                }
                this.optionsMap.put(resName + "." + secName, nameValueMap);
            } else {
                secName = this.getAttribute(n, "name");
                nameValueMap = this.optionsMap.get(resName + "." + secName);
                if (nameValueMap == null) {
                    nameValueMap = new HashMap<String, String>();
                } else {
                    this.optionsMap.remove(resName + "." + secName);
                }
                this.parseConfigSectionNode(n, nameValueMap);
                this.optionsMap.put(resName + "." + secName, nameValueMap);
            }
            if (this.sectionParamsMap.containsKey(secName) || this.sectionParamsMap.containsKey(secName + "-options")) continue;
            Tools.appWarning("DRBD: unknown section: " + secName);
            if (this.unknownSections) continue;
            Tools.progressIndicatorFailed("DRBD: unknown section: " + secName);
            this.unknownSections = true;
        }
    }

    private void parseConfig(String configXML) {
        int start = configXML.indexOf("<config");
        if (start < 0) {
            return;
        }
        Document document = this.getXMLDocument(configXML.substring(start));
        if (document == null) {
            return;
        }
        Node configNode = this.getChildNode(document, "config");
        if (configNode == null) {
            return;
        }
        this.configFile = this.getAttribute(configNode, "file");
        NodeList resources = configNode.getChildNodes();
        Map<String, String> globalNameValueMap = this.optionsMap.get(GLOBAL_SECTION);
        if (globalNameValueMap == null) {
            globalNameValueMap = new HashMap<String, String>();
            this.optionsMap.put(GLOBAL_SECTION, globalNameValueMap);
        }
        globalNameValueMap.put("usage-count", CONFIG_YES);
        globalNameValueMap.put("disable-ip-verification", CONFIG_NO);
        for (int i = 0; i < resources.getLength(); ++i) {
            Node resourceNode = resources.item(i);
            if (resourceNode.getNodeName().equals(GLOBAL_SECTION)) {
                this.parseConfigGlobalNode(resourceNode, globalNameValueMap);
            }
            if (resourceNode.getNodeName().equals("common")) {
                this.parseConfigResourceNode(resourceNode, "Section.Common");
            }
            if (!resourceNode.getNodeName().equals("resource")) continue;
            String resName = this.getAttribute(resourceNode, "name");
            if (!this.resourceList.contains(resName)) {
                this.resourceList.add(resName);
            }
            this.parseConfigResourceNode(resourceNode, resName);
        }
    }

    public String getGlobalConfigValue(String optionName) {
        Map<String, String> option = this.optionsMap.get(GLOBAL_SECTION);
        String value = null;
        if (option != null) {
            value = option.get(optionName);
        }
        if (value == null) {
            return "";
        }
        return value;
    }

    public String getConfigValue(String res, String section, String optionName) {
        Map<String, String> option = this.optionsMap.get(res + "." + section);
        String value = null;
        if (option != null) {
            value = option.get(optionName);
        }
        if (value == null) {
            return "";
        }
        return value;
    }

    public String getCommonConfigValue(String section, String optionName) {
        String value = null;
        Map<String, String> option = this.optionsMap.get("Section.Common." + section);
        if (option != null) {
            value = option.get(optionName);
        }
        if (value == null) {
            return "";
        }
        return value;
    }

    public String[] getResources() {
        return this.resourceList.toArray(new String[this.resourceList.size()]);
    }

    public String getDrbdDevice(String res, String volumeNr) {
        return this.resourceDeviceMap.get((K[])new String[]{res, volumeNr});
    }

    public MultiKeyMap<String, String> getResourceDeviceMap() {
        return this.resourceDeviceMap;
    }

    private BlockDevInfo getBlockDevInfo(String devNr, String hostName, DrbdGraph drbdGraph) {
        String disk;
        Map<String, String> hostDiskMap;
        BlockDevInfo bdi = null;
        String device = "/dev/drbd" + devNr;
        String resName = this.deviceResourceMap.get(device);
        String volumeNr = this.deviceVolumeMap.get(device);
        if (volumeNr == null) {
            volumeNr = "0";
        }
        if (resName != null && (hostDiskMap = this.resourceHostDiskMap.get((K[])new String[]{resName, volumeNr})) != null && (disk = hostDiskMap.get(hostName)) != null) {
            bdi = drbdGraph.findBlockDevInfo(hostName, disk);
        }
        return bdi;
    }

    boolean isDrbdLoaded(String hostName) {
        Boolean l = this.hostDrbdLoadedMap.get(hostName);
        if (l != null) {
            return l;
        }
        return true;
    }

    public boolean parseDrbdEvent(String hostName, DrbdGraph drbdGraph, String rawOutput) {
        if (rawOutput == null || hostName == null) {
            return false;
        }
        String output = rawOutput.trim();
        if ("".equals(output)) {
            return false;
        }
        if ("No response from the DRBD driver! Is the module loaded?".equals(output)) {
            if (this.hostDrbdLoadedMap.get(hostName).booleanValue()) {
                this.hostDrbdLoadedMap.put(hostName, false);
                return true;
            }
            return false;
        }
        this.hostDrbdLoadedMap.put(hostName, true);
        Pattern p = Pattern.compile("^(\\d+)\\s+ST\\s+(\\S+)\\s+\\{\\s+cs:(\\S+)\\s+(?:st|ro):(\\S+)/(\\S+)\\s+ds:(\\S+)/(\\S+)\\s+(\\S+).*?");
        Matcher m = p.matcher(output);
        Pattern pDev = Pattern.compile("^(\\d+),(\\S+)\\[(\\d+)\\]$");
        if (m.matches()) {
            BlockDevInfo bdi;
            String devNrString = m.group(2);
            String cs = m.group(3);
            String ro1 = m.group(4);
            String ro2 = m.group(5);
            String ds1 = m.group(6);
            String ds2 = m.group(7);
            String flags = m.group(8);
            Matcher mDev = pDev.matcher(devNrString);
            String devNr = devNrString;
            String res = "";
            String volumeNr = "0";
            if (mDev.matches()) {
                devNr = mDev.group(1);
                res = mDev.group(2);
                volumeNr = mDev.group(3);
            }
            if ((bdi = this.getBlockDevInfo(devNr, hostName, drbdGraph)) != null) {
                if (bdi.getBlockDevice().isDifferent(cs, ro1, ds1, flags)) {
                    bdi.getBlockDevice().setConnectionState(cs);
                    bdi.getBlockDevice().setNodeState(ro1);
                    bdi.getBlockDevice().setDiskState(ds1);
                    bdi.getBlockDevice().setDrbdFlags(flags);
                    bdi.updateInfo();
                    return true;
                }
                return false;
            }
            return false;
        }
        p = Pattern.compile("^(\\d+)\\s+SP\\s+(\\S+)\\s(\\d+\\.\\d+).*");
        m = p.matcher(output);
        if (m.matches()) {
            BlockDevInfo bdi;
            String devNrString = m.group(2);
            String synced = m.group(3);
            Matcher mDev = pDev.matcher(devNrString);
            String devNr = devNrString;
            String res = "";
            String volumeNr = "0";
            if (mDev.matches()) {
                devNr = mDev.group(1);
                res = mDev.group(2);
                volumeNr = mDev.group(3);
            }
            if ((bdi = this.getBlockDevInfo(devNr, hostName, drbdGraph)) != null && bdi.getBlockDevice().isDrbd()) {
                if (Tools.areEqual(bdi.getBlockDevice().getSyncedProgress(), synced)) {
                    return false;
                }
                bdi.getBlockDevice().setSyncedProgress(synced);
                bdi.updateInfo();
                return true;
            }
            return false;
        }
        p = Pattern.compile("^(\\d+)\\s+UH\\s+(\\S+)\\s([a-z-]+).*");
        m = p.matcher(output);
        if (m.matches()) {
            BlockDevInfo bdi;
            String devNrString = m.group(2);
            String what = m.group(3);
            Matcher mDev = pDev.matcher(devNrString);
            String devNr = devNrString;
            String res = "";
            String volumeNr = "0";
            if (mDev.matches()) {
                devNr = mDev.group(1);
                res = mDev.group(2);
                volumeNr = mDev.group(3);
            }
            Tools.debug(this, "drbd event: " + devNr + " - " + what);
            if ("split-brain".equals(what) && (bdi = this.getBlockDevInfo(devNr, hostName, drbdGraph)) != null && bdi.getBlockDevice().isDrbd()) {
                if (bdi.getBlockDevice().isSplitBrain()) {
                    return false;
                }
                bdi.getBlockDevice().setSplitBrain(true);
                bdi.updateInfo();
                return true;
            }
            return false;
        }
        return false;
    }

    public void removeResource(String res) {
        this.resourceList.remove(res);
    }

    public void removeVolume(String res, String dev, String volumeNr) {
        this.resourceDeviceMap.remove((K[])new String[]{res, volumeNr});
        this.deviceResourceMap.remove(dev);
        this.deviceVolumeMap.remove(dev);
    }

    public boolean isDrbdDisabled() {
        return this.unknownSections && !Tools.getConfigData().isAdvancedMode();
    }

    static {
        NOT_ADVANCED_PARAMS.add("rate");
        NOT_ADVANCED_PARAMS.add(PROTOCOL_PARAM);
        NOT_ADVANCED_PARAMS.add(PING_TIMEOUT_PARAM);
        NOT_ADVANCED_PARAMS.add("fence-peer");
        NOT_ADVANCED_PARAMS.add("wfc-timeout");
        NOT_ADVANCED_PARAMS.add("degr-wfc-timeout");
        NOT_ADVANCED_PARAMS.add("become-primary-on");
        NOT_ADVANCED_PARAMS.add("timeout");
        NOT_ADVANCED_PARAMS.add("allow-two-primaries");
        NOT_ADVANCED_PARAMS.add("fencing");
        NOT_ADVANCED_PARAMS.add("after");
        NOT_ADVANCED_PARAMS.add("resync-after");
        NOT_ADVANCED_PARAMS.add("usage-count");
        NOT_ADVANCED_PARAMS.add("memlimit");
        NOT_ADVANCED_PARAMS.add("plugin-zlib");
        NOT_ADVANCED_PARAMS.add("plugin-lzma");
        PARAM_ACCESS_TYPE = new HashMap<String, ConfigData.AccessType>();
        PARAM_ACCESS_TYPE.put("rate", ConfigData.AccessType.OP);
        HARDCODED_DEFAULTS = new HashMap<String, String>();
        HARDCODED_DEFAULTS.put("usage-count", "");
        HARDCODED_DEFAULTS.put("disable-ip-verification", CONFIG_NO);
        HARDCODED_DEFAULTS.put(PROTOCOL_PARAM, "C");
        HARDCODED_DEFAULTS.put("after-sb-0pri", "disconnect");
        HARDCODED_DEFAULTS.put("after-sb-1pri", "disconnect");
        HARDCODED_DEFAULTS.put("after-sb-2pri", "disconnect");
        HARDCODED_DEFAULTS.put("rr-conflict", "disconnect");
        HARDCODED_DEFAULTS.put("on-io-error", "pass_on");
        HARDCODED_DEFAULTS.put("fencing", "dont-care");
        HARDCODED_DEFAULTS.put("on-no-data-accessible", "io-error");
        HARDCODED_DEFAULTS.put("on-congestion", "block");
    }

    public class HostProxy {
        private final String proxyHostName;
        private final String insideIp;
        private final String insidePort;
        private final String outsideIp;
        private final String outsidePort;

        public HostProxy(String proxyHostName, String insideIp, String insidePort, String outsideIp, String outsidePort) {
            this.proxyHostName = proxyHostName;
            this.insideIp = insideIp;
            this.insidePort = insidePort;
            this.outsideIp = outsideIp;
            this.outsidePort = outsidePort;
        }

        public String getProxyHostName() {
            return this.proxyHostName;
        }

        public String getInsideIp() {
            return this.insideIp;
        }

        public String getInsidePort() {
            return this.insidePort;
        }

        public String getOutsideIp() {
            return this.outsideIp;
        }

        public String getOutsidePort() {
            return this.outsidePort;
        }
    }
}

